/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.NameMapper;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.apiAdapters.TransportServiceWrapper;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.settings.CaptureSettingsProvider;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.GetJPDADialog;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@State(name="DebuggerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DebuggerManagerImpl
extends DebuggerManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerManagerImpl");
    public static final String LOCALHOST_ADDRESS_FALLBACK = "127.0.0.1";
    private final Project myProject;
    private final HashMap<ProcessHandler, DebuggerSession> mySessions = new HashMap();
    private final BreakpointManager myBreakpointManager;
    private final List<NameMapper> myNameMappers = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Function<DebugProcess, PositionManager>> myCustomPositionManagerFactories = new SmartList();
    private final EventDispatcher<DebuggerManagerListener> myDispatcher = EventDispatcher.create(DebuggerManagerListener.class);
    private final MyDebuggerStateManager myDebuggerStateManager = new MyDebuggerStateManager();
    private final DebuggerContextListener mySessionListener = new DebuggerContextListener(){

        @Override
        public void changeEvent(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
            if (newContext == null) {
                1.$$$reportNull$$$0(0);
            }
            DebuggerSession session2 = newContext.getDebuggerSession();
            if (event == DebuggerSession.Event.PAUSE && DebuggerManagerImpl.this.myDebuggerStateManager.myDebuggerSession != session2) {
                DebuggerManagerImpl.this.myDebuggerStateManager.setState(newContext, session2 != null ? session2.getState() : DebuggerSession.State.DISPOSED, event, null);
                return;
            }
            if (DebuggerManagerImpl.this.myDebuggerStateManager.myDebuggerSession == session2) {
                DebuggerManagerImpl.this.myDebuggerStateManager.fireStateChanged(newContext, event);
            }
            if (event == DebuggerSession.Event.ATTACHED) {
                ((DebuggerManagerListener)DebuggerManagerImpl.this.myDispatcher.getMulticaster()).sessionAttached(session2);
            } else if (event == DebuggerSession.Event.DETACHED) {
                ((DebuggerManagerListener)DebuggerManagerImpl.this.myDispatcher.getMulticaster()).sessionDetached(session2);
            } else if (event == DebuggerSession.Event.DISPOSE) {
                DebuggerManagerImpl.this.dispose(session2);
                if (DebuggerManagerImpl.this.myDebuggerStateManager.myDebuggerSession == session2) {
                    DebuggerManagerImpl.this.myDebuggerStateManager.setState(DebuggerContextImpl.EMPTY_CONTEXT, DebuggerSession.State.DISPOSED, DebuggerSession.Event.DISPOSE, null);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/impl/DebuggerManagerImpl$1", "changeEvent"));
        }
    };
    @NonNls
    private static final String DEBUG_KEY_NAME = "idea.xdebug.key";
    private static final String AGENT_FILE_NAME = "debugger-agent.jar";
    private static final String STORAGE_FILE_NAME = "debugger-agent-storage.jar";

    public void addClassNameMapper(NameMapper mapper) {
        this.myNameMappers.add(mapper);
    }

    public void removeClassNameMapper(NameMapper mapper) {
        this.myNameMappers.remove(mapper);
    }

    public String getVMClassQualifiedName(@NotNull PsiClass aClass) {
        if (aClass == null) {
            DebuggerManagerImpl.$$$reportNull$$$0(0);
        }
        for (NameMapper nameMapper : this.myNameMappers) {
            String qName = nameMapper.getQualifiedName(aClass);
            if (qName == null) continue;
            return qName;
        }
        return aClass.getQualifiedName();
    }

    @Override
    public void addDebuggerManagerListener(DebuggerManagerListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void removeDebuggerManagerListener(DebuggerManagerListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public DebuggerManagerImpl(Project project2, StartupManager startupManager) {
        this.myProject = project2;
        this.myBreakpointManager = new BreakpointManager(this.myProject, startupManager, this);
        if (!project2.isDefault()) {
            project2.getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

                public void globalSchemeChange(EditorColorsScheme scheme2) {
                    DebuggerManagerImpl.this.getBreakpointManager().updateBreakpointsUI();
                }
            });
        }
    }

    @Override
    @Nullable
    public DebuggerSession getSession(DebugProcess process2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getSessions().stream().filter(debuggerSession -> process2 == debuggerSession.getProcess()).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<DebuggerSession> getSessions() {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        // MONITORENTER : hashMap
        Collection<DebuggerSession> values = this.mySessions.values();
        ArrayList<DebuggerSession> arrayList = values.isEmpty() ? Collections.emptyList() : new ArrayList<DebuggerSession>(values);
        // MONITOREXIT : hashMap
        if (arrayList != null) return arrayList;
        DebuggerManagerImpl.$$$reportNull$$$0(1);
        return arrayList;
    }

    public void projectOpened() {
        this.myBreakpointManager.init();
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        this.myBreakpointManager.writeExternal(state);
        return state;
    }

    public void loadState(Element state) {
        this.myBreakpointManager.readExternal(state);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myBreakpointManager.writeExternal(element);
    }

    @Deprecated
    public Stream<Function<DebugProcess, PositionManager>> getCustomPositionManagerFactories() {
        return this.myCustomPositionManagerFactories.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DebuggerSession attachVirtualMachine(@NotNull DebugEnvironment environment) throws ExecutionException {
        if (environment == null) {
            DebuggerManagerImpl.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebugProcessEvents debugProcess = new DebugProcessEvents(this.myProject);
        DebuggerSession session2 = DebuggerSession.create(environment.getSessionName(), debugProcess, environment);
        ExecutionResult executionResult = session2.getProcess().getExecutionResult();
        if (executionResult == null) {
            return null;
        }
        session2.getContextManager().addListener(this.mySessionListener);
        this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(session2, session2.getContextManager().getContext().getSuspendContext()), session2.getState(), DebuggerSession.Event.CONTEXT, null);
        ProcessHandler processHandler2 = executionResult.getProcessHandler();
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            this.mySessions.put(processHandler2, session2);
        }
        if (!(processHandler2 instanceof RemoteDebugProcessHandler)) {
            processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    ProcessHandler processHandler2;
                    DebugProcessImpl debugProcess;
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if ((debugProcess = DebuggerManagerImpl.this.getDebugProcess(processHandler2 = event.getProcessHandler())) != null) {
                        debugProcess.stop(willBeDestroyed && (!(processHandler2 instanceof KillableColoredProcessHandler) || !((KillableColoredProcessHandler)processHandler2).shouldKillProcessSoftly()));
                        if (!DebuggerManagerThreadImpl.isManagerThread()) {
                            if (SwingUtilities.isEventDispatchThread()) {
                                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                                    ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                                    debugProcess.waitFor(10000L);
                                }, "Waiting For Debugger Response", false, debugProcess.getProject());
                            } else {
                                debugProcess.waitFor(10000L);
                            }
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/impl/DebuggerManagerImpl$3", "processWillTerminate"));
                }
            });
        }
        ((DebuggerManagerListener)this.myDispatcher.getMulticaster()).sessionCreated(session2);
        if (debugProcess.isDetached() || debugProcess.isDetaching()) {
            session2.dispose();
            return null;
        }
        if (environment.isRemote()) {
            debugProcess.putUserData(BatchEvaluator.REMOTE_SESSION_KEY, Boolean.TRUE);
        }
        return session2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugProcessImpl getDebugProcess(ProcessHandler processHandler2) {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            DebuggerSession session2 = this.mySessions.get(processHandler2);
            return session2 != null ? session2.getProcess() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DebuggerSession getDebugSession(ProcessHandler processHandler2) {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            return this.mySessions.get(processHandler2);
        }
    }

    public void addDebugProcessListener(final ProcessHandler processHandler2, final DebugProcessListener listener2) {
        DebugProcessImpl debugProcess = this.getDebugProcess(processHandler2);
        if (debugProcess != null) {
            debugProcess.addDebugProcessListener(listener2);
        } else {
            processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    DebugProcessImpl debugProcess;
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if ((debugProcess = DebuggerManagerImpl.this.getDebugProcess(processHandler2)) != null) {
                        debugProcess.addDebugProcessListener(listener2);
                    }
                    processHandler2.removeProcessListener((ProcessListener)this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/impl/DebuggerManagerImpl$4", "startNotified"));
                }
            });
        }
    }

    public void removeDebugProcessListener(final ProcessHandler processHandler2, final DebugProcessListener listener2) {
        DebugProcessImpl debugProcess = this.getDebugProcess(processHandler2);
        if (debugProcess != null) {
            debugProcess.removeDebugProcessListener(listener2);
        } else {
            processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    DebugProcessImpl debugProcess;
                    if (event == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if ((debugProcess = DebuggerManagerImpl.this.getDebugProcess(processHandler2)) != null) {
                        debugProcess.removeDebugProcessListener(listener2);
                    }
                    processHandler2.removeProcessListener((ProcessListener)this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/impl/DebuggerManagerImpl$5", "startNotified"));
                }
            });
        }
    }

    public boolean isDebuggerManagerThread() {
        return DebuggerManagerThreadImpl.isManagerThread();
    }

    @NotNull
    public String getComponentName() {
        if ("DebuggerManager" == null) {
            DebuggerManagerImpl.$$$reportNull$$$0(3);
        }
        return "DebuggerManager";
    }

    @Override
    @NotNull
    public BreakpointManager getBreakpointManager() {
        BreakpointManager breakpointManager = this.myBreakpointManager;
        if (breakpointManager == null) {
            DebuggerManagerImpl.$$$reportNull$$$0(4);
        }
        return breakpointManager;
    }

    @Override
    @NotNull
    public DebuggerContextImpl getContext() {
        DebuggerContextImpl debuggerContextImpl = this.getContextManager().getContext();
        if (debuggerContextImpl == null) {
            DebuggerManagerImpl.$$$reportNull$$$0(5);
        }
        return debuggerContextImpl;
    }

    @Override
    @NotNull
    public DebuggerStateManager getContextManager() {
        MyDebuggerStateManager myDebuggerStateManager = this.myDebuggerStateManager;
        if (myDebuggerStateManager == null) {
            DebuggerManagerImpl.$$$reportNull$$$0(6);
        }
        return myDebuggerStateManager;
    }

    public void registerPositionManagerFactory(Function<DebugProcess, PositionManager> factory) {
        this.myCustomPositionManagerFactories.add(factory);
    }

    public void unregisterPositionManagerFactory(Function<DebugProcess, PositionManager> factory) {
        this.myCustomPositionManagerFactories.remove(factory);
    }

    private static void checkTargetJPDAInstalled(JavaParameters parameters2) throws ExecutionException {
        Sdk jdk = parameters2.getJdk();
        if (jdk == null) {
            throw new ExecutionException(DebuggerBundle.message((String)"error.jdk.not.specified", (Object[])new Object[0]));
        }
        JavaSdkVersion version = JavaSdk.getInstance().getVersion(jdk);
        if (version == JavaSdkVersion.JDK_1_0 || version == JavaSdkVersion.JDK_1_1) {
            String versionString = jdk.getVersionString();
            throw new ExecutionException(DebuggerBundle.message((String)"error.unsupported.jdk.version", (Object[])new Object[]{versionString}));
        }
        if (SystemInfo.isWindows && version == JavaSdkVersion.JDK_1_2) {
            VirtualFile homeDirectory = jdk.getHomeDirectory();
            if (homeDirectory == null || !homeDirectory.isValid()) {
                String versionString = jdk.getVersionString();
                throw new ExecutionException(DebuggerBundle.message((String)"error.invalid.jdk.home", (Object[])new Object[]{versionString}));
            }
            File dllFile = new File(homeDirectory.getPath().replace('/', File.separatorChar) + File.separator + "bin" + File.separator + "jdwp.dll");
            if (!dllFile.exists()) {
                GetJPDADialog dialog2 = new GetJPDADialog();
                dialog2.show();
                throw new ExecutionException(DebuggerBundle.message((String)"error.debug.libraries.missing", (Object[])new Object[0]));
            }
        }
    }

    private static boolean shouldForceClassicVM(Sdk jdk) {
        if (SystemInfo.isMac) {
            return false;
        }
        if (jdk == null) {
            return false;
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null || StringUtil.compareVersionNumbers((String)version, (String)"1.4") >= 0) {
            return false;
        }
        if (version.startsWith("1.2") && SystemInfo.isWindows) {
            return true;
        }
        if ((version = version + ".0").startsWith("1.3.0") && SystemInfo.isWindows) {
            return true;
        }
        if ((version.startsWith("1.3.1_07") || version.startsWith("1.3.1_08")) && SystemInfo.isWindows) {
            return false;
        }
        return DebuggerSettings.getInstance().FORCE_CLASSIC_VM;
    }

    public static RemoteConnection createDebugParameters(JavaParameters parameters2, boolean debuggerInServerMode, int transport, String debugPort, boolean checkValidity) throws ExecutionException {
        return DebuggerManagerImpl.createDebugParameters(parameters2, debuggerInServerMode, transport, debugPort, checkValidity, true);
    }

    /*
     * Unable to fully structure code
     */
    public static RemoteConnection createDebugParameters(JavaParameters parameters, boolean debuggerInServerMode, int transport, String debugPort, boolean checkValidity, boolean addAsyncDebuggerAgent) throws ExecutionException {
        if (checkValidity) {
            DebuggerManagerImpl.checkTargetJPDAInstalled(parameters);
        }
        useSockets = transport == 0;
        address = "";
        if (StringUtil.isEmptyOrSpaces((String)debugPort)) {
            try {
                address = DebuggerUtils.getInstance().findAvailableDebugAddress(useSockets);
            }
            catch (ExecutionException e) {
                if (!checkValidity) ** GOTO lbl13
                throw e;
            }
        } else {
            address = debugPort;
        }
lbl13:
        // 3 sources

        transportService = TransportServiceWrapper.getTransportService(useSockets);
        debugAddress = debuggerInServerMode != false && useSockets != false ? "127.0.0.1:" + address : address;
        debuggeeRunProperties = "transport=" + transportService.transportId() + ",address=" + debugAddress;
        debuggeeRunProperties = debuggerInServerMode != false ? debuggeeRunProperties + ",suspend=y,server=n" : debuggeeRunProperties + ",suspend=n,server=y";
        if (StringUtil.containsWhitespaces((CharSequence)debuggeeRunProperties)) {
            debuggeeRunProperties = "\"" + debuggeeRunProperties + "\"";
        }
        _debuggeeRunProperties = debuggeeRunProperties;
        ApplicationManager.getApplication().runReadAction((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$createDebugParameters$1(com.intellij.execution.configurations.JavaParameters boolean java.lang.String ), ()V)((JavaParameters)parameters, (boolean)addAsyncDebuggerAgent, (String)_debuggeeRunProperties));
        return new RemoteConnection(useSockets, "127.0.0.1", address, debuggerInServerMode);
    }

    private static void addDebuggerAgent(JavaParameters parameters2) {
        if (StackCapturingLineBreakpoint.isAgentEnabled()) {
            String prefix = "-javaagent:";
            ParametersList parametersList = parameters2.getVMParametersList();
            if (parametersList.getParameters().stream().noneMatch(p -> p.startsWith(prefix) && p.contains(AGENT_FILE_NAME))) {
                String version;
                Sdk jdk = parameters2.getJdk();
                String string = version = jdk != null ? JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION) : null;
                if (version != null) {
                    JavaSdkVersion sdkVersion = JavaSdkVersion.fromVersionString((String)version);
                    if (sdkVersion != null && sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_6)) {
                        File classesRoot = new File(PathUtil.getJarPathForClass(DebuggerManagerImpl.class));
                        File agentFile = classesRoot.isFile() ? new File(classesRoot.getParentFile(), "rt/debugger-agent.jar") : new File(classesRoot.getParentFile().getParentFile(), "/artifacts/debugger_agent/debugger-agent.jar");
                        if (agentFile.exists()) {
                            String agentPath = DebuggerManagerImpl.handleSpacesInPath(agentFile.getAbsolutePath());
                            if (agentPath != null) {
                                parametersList.add(prefix + agentPath + "=" + DebuggerManagerImpl.generateAgentSettings());
                            }
                        } else {
                            LOG.warn("Capture agent not found: " + agentFile);
                        }
                    } else {
                        LOG.warn("Capture agent is not supported for jre " + version);
                    }
                }
            }
        }
    }

    @Nullable
    private static String handleSpacesInPath(String agentPath) {
        if (agentPath.contains(" ")) {
            File targetDir = new File(PathManager.getSystemPath(), "captureAgent");
            if (targetDir.getAbsolutePath().contains(" ")) {
                try {
                    targetDir = FileUtil.createTempDirectory((String)"capture", (String)"jars");
                    if (targetDir.getAbsolutePath().contains(" ")) {
                        LOG.info("Capture agent was not used since the agent path contained spaces: " + agentPath);
                        return null;
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    return null;
                }
            }
            try {
                targetDir.mkdirs();
                Path source = Paths.get(agentPath, new String[0]);
                Path target2 = targetDir.toPath().resolve(AGENT_FILE_NAME);
                Files.copy(source, target2, StandardCopyOption.REPLACE_EXISTING);
                Files.copy(source.getParent().resolve(STORAGE_FILE_NAME), targetDir.toPath().resolve(STORAGE_FILE_NAME), StandardCopyOption.REPLACE_EXISTING);
                return target2.toString();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        return agentPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String generateAgentSettings() {
        Properties properties = new Properties();
        properties.setProperty("asm-lib", PathUtil.getJarPathForClass(MethodVisitor.class));
        if (Registry.is((String)"debugger.capture.points.agent.debug")) {
            properties.setProperty("debug", "true");
        }
        int idx = 0;
        for (CaptureSettingsProvider.AgentPoint point : CaptureSettingsProvider.getCapturePoints()) {
            properties.setProperty("capture" + idx++, point.myClassName + " " + point.myMethodName + " " + point.myKey.asString());
        }
        idx = 0;
        for (CaptureSettingsProvider.AgentPoint point : CaptureSettingsProvider.getInsertPoints()) {
            properties.setProperty("insert" + idx++, point.myClassName + " " + point.myMethodName + " " + point.myKey.asString());
        }
        try {
            File file2 = FileUtil.createTempFile((String)"capture", (String)".props");
            try (FileOutputStream out = new FileOutputStream(file2);){
                properties.store(out, null);
                String string = file2.getAbsolutePath();
                return string;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static boolean shouldForceNoJIT(Sdk jdk) {
        String version;
        if (DebuggerSettings.getInstance().DISABLE_JIT) {
            return true;
        }
        return jdk != null && (version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION)) != null && (version.startsWith("1.2") || version.startsWith("1.3"));
    }

    private static boolean shouldAddXdebugKey(Sdk jdk) {
        if (jdk == null) {
            return true;
        }
        if (DebuggerSettings.getInstance().DISABLE_JIT) {
            return true;
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        return version == null || version.startsWith("1.4") || version.startsWith("1.3") || version.startsWith("1.2") || version.startsWith("1.1") || version.startsWith("1.0");
    }

    private static boolean isJVMTIAvailable(Sdk jdk) {
        if (jdk == null) {
            return false;
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null) {
            return false;
        }
        return !version.startsWith("1.4") && !version.startsWith("1.3") && !version.startsWith("1.2") && !version.startsWith("1.1") && !version.startsWith("1.0");
    }

    public static RemoteConnection createDebugParameters(JavaParameters parameters2, GenericDebuggerRunnerSettings settings, boolean checkValidity) throws ExecutionException {
        return DebuggerManagerImpl.createDebugParameters(parameters2, settings.LOCAL, settings.getTransport(), settings.getDebugPort(), checkValidity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(DebuggerSession session2) {
        ProcessHandler processHandler2 = session2.getProcess().getProcessHandler();
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            DebuggerSession removed = this.mySessions.remove(processHandler2);
            LOG.assertTrue(removed != null);
            ((DebuggerManagerListener)this.myDispatcher.getMulticaster()).sessionRemoved(session2);
        }
    }

    private static /* synthetic */ void lambda$createDebugParameters$1(JavaParameters parameters2, boolean addAsyncDebuggerAgent, String _debuggeeRunProperties) {
        boolean needDebugKey;
        JavaSdkUtil.addRtJar(parameters2.getClassPath());
        if (addAsyncDebuggerAgent) {
            DebuggerManagerImpl.addDebuggerAgent(parameters2);
        }
        Sdk jdk = parameters2.getJdk();
        boolean forceClassicVM = DebuggerManagerImpl.shouldForceClassicVM(jdk);
        boolean forceNoJIT = DebuggerManagerImpl.shouldForceNoJIT(jdk);
        String debugKey = System.getProperty(DEBUG_KEY_NAME, "-Xdebug");
        boolean bl = needDebugKey = DebuggerManagerImpl.shouldAddXdebugKey(jdk) || !"-Xdebug".equals(debugKey);
        if (forceClassicVM || forceNoJIT || needDebugKey || !DebuggerManagerImpl.isJVMTIAvailable(jdk)) {
            parameters2.getVMParametersList().replaceOrPrepend("-Xrunjdwp:", "-Xrunjdwp:" + _debuggeeRunProperties);
        } else {
            parameters2.getVMParametersList().replaceOrPrepend("-Xrunjdwp:", "");
            parameters2.getVMParametersList().replaceOrPrepend("-agentlib:jdwp=", "-agentlib:jdwp=" + _debuggeeRunProperties);
        }
        if (forceNoJIT) {
            parameters2.getVMParametersList().replaceOrPrepend("-Djava.compiler=", "-Djava.compiler=NONE");
            parameters2.getVMParametersList().replaceOrPrepend("-Xnoagent", "-Xnoagent");
        }
        if (needDebugKey) {
            parameters2.getVMParametersList().replaceOrPrepend(debugKey, debugKey);
        } else {
            parameters2.getVMParametersList().replaceOrPrepend("-Xdebug", "");
        }
        parameters2.getVMParametersList().replaceOrPrepend("-classic", forceClassicVM ? "-classic" : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVMClassQualifiedName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "attachVirtualMachine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDebuggerStateManager
    extends DebuggerStateManager {
        private DebuggerSession myDebuggerSession;

        private MyDebuggerStateManager() {
        }

        @Override
        @NotNull
        public DebuggerContextImpl getContext() {
            DebuggerContextImpl debuggerContextImpl = this.myDebuggerSession == null ? DebuggerContextImpl.EMPTY_CONTEXT : this.myDebuggerSession.getContextManager().getContext();
            if (debuggerContextImpl == null) {
                MyDebuggerStateManager.$$$reportNull$$$0(0);
            }
            return debuggerContextImpl;
        }

        @Override
        public void setState(@NotNull DebuggerContextImpl context, DebuggerSession.State state, DebuggerSession.Event event, String description) {
            if (context == null) {
                MyDebuggerStateManager.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myDebuggerSession = context.getDebuggerSession();
            if (this.myDebuggerSession != null) {
                this.myDebuggerSession.getContextManager().setState(context, state, event, description);
            } else {
                this.fireStateChanged(context, event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/DebuggerManagerImpl$MyDebuggerStateManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/DebuggerManagerImpl$MyDebuggerStateManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

