/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.debugger.memory.action.ShowInstancesAction;
import com.intellij.debugger.memory.ui.ClassesTable;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.debugger.memory.utils.InstancesProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.ReferenceType;

public class ShowNewInstancesAction
extends ShowInstancesAction {
    private static final String POPUP_ELEMENT_LABEL = "Show New Instances";

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        ReferenceType selectedClass = this.getSelectedClass(e);
        InstancesProvider provider = (InstancesProvider)e.getData(ClassesTable.NEW_INSTANCES_PROVIDER_KEY);
        int count = this.getInstancesCount(e);
        return super.isEnabled(e) && selectedClass != null && provider != null && count > 0;
    }

    @Override
    protected String getLabel() {
        return POPUP_ELEMENT_LABEL;
    }

    @Override
    protected int getInstancesCount(AnActionEvent e) {
        ClassesTable.ReferenceCountProvider countProvider = (ClassesTable.ReferenceCountProvider)e.getData(ClassesTable.REF_COUNT_PROVIDER_KEY);
        ReferenceType selectedClass = this.getSelectedClass(e);
        if (countProvider == null || selectedClass == null) {
            return -1;
        }
        return countProvider.getNewInstancesCount(selectedClass);
    }

    @Override
    protected void perform(AnActionEvent e) {
        XDebugSession session2;
        Project project2 = e.getProject();
        ReferenceType selectedClass = this.getSelectedClass(e);
        InstancesProvider provider = (InstancesProvider)e.getData(ClassesTable.NEW_INSTANCES_PROVIDER_KEY);
        XDebugSession xDebugSession = session2 = project2 != null ? XDebuggerManager.getInstance((Project)project2).getCurrentSession() : null;
        if (selectedClass != null && provider != null && session2 != null) {
            new InstancesWindow(session2, provider, selectedClass.name()).show();
        }
    }
}

