/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.component;

import com.intellij.debugger.memory.component.MemoryViewManagerState;
import com.intellij.debugger.memory.event.MemoryViewManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

@State(name="MemoryViewSettings", storages={@Storage(value="memory.view.xml")})
public class MemoryViewManager
implements ApplicationComponent,
PersistentStateComponent<MemoryViewManagerState> {
    public static final String MEMORY_VIEW_CONTENT = "MemoryView";
    private final EventDispatcher<MemoryViewManagerListener> myDispatcher = EventDispatcher.create(MemoryViewManagerListener.class);
    private MemoryViewManagerState myState = new MemoryViewManagerState();

    public static MemoryViewManager getInstance() {
        return (MemoryViewManager)ApplicationManager.getApplication().getComponent(MemoryViewManager.class);
    }

    @NotNull
    public MemoryViewManagerState getState() {
        MemoryViewManagerState memoryViewManagerState = new MemoryViewManagerState(this.myState);
        if (memoryViewManagerState == null) {
            MemoryViewManager.$$$reportNull$$$0(0);
        }
        return memoryViewManagerState;
    }

    public void loadState(MemoryViewManagerState state) {
        if (state == null) {
            state = new MemoryViewManagerState();
        }
        this.myState = state;
        this.fireStateChanged();
    }

    public void setShowDiffOnly(boolean value2) {
        if (this.myState.isShowWithDiffOnly != value2) {
            this.myState.isShowWithDiffOnly = value2;
            this.fireStateChanged();
        }
    }

    public void setShowWithInstancesOnly(boolean value2) {
        if (this.myState.isShowWithInstancesOnly != value2) {
            this.myState.isShowWithInstancesOnly = value2;
            this.fireStateChanged();
        }
    }

    public void setShowTrackedOnly(boolean value2) {
        if (this.myState.isShowTrackedOnly != value2) {
            this.myState.isShowTrackedOnly = value2;
            this.fireStateChanged();
        }
    }

    public boolean isNeedShowDiffOnly() {
        return this.myState.isShowWithDiffOnly;
    }

    public boolean isNeedShowInstancesOnly() {
        return this.myState.isShowWithInstancesOnly;
    }

    public boolean isNeedShowTrackedOnly() {
        return this.myState.isShowTrackedOnly;
    }

    public void addMemoryViewManagerListener(MemoryViewManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MemoryViewManager.$$$reportNull$$$0(1);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    private void fireStateChanged() {
        ((MemoryViewManagerListener)this.myDispatcher.getMulticaster()).stateChanged(new MemoryViewManagerState(this.myState));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/component/MemoryViewManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/component/MemoryViewManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addMemoryViewManagerListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

