/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.settings.CapturePoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;

public class CaptureSettingsProvider {
    private static final List<AgentCapturePoint> CAPTURE_POINTS = new ArrayList<AgentCapturePoint>();
    private static final List<AgentInsertPoint> INSERT_POINTS = new ArrayList<AgentInsertPoint>();
    private static final List<CapturePoint> IDE_INSERT_POINTS;
    private static final KeyProvider THIS_KEY;
    private static final KeyProvider FIRST_PARAM;

    public static List<AgentPoint> getCapturePoints() {
        return Collections.unmodifiableList(CAPTURE_POINTS);
    }

    public static List<AgentPoint> getInsertPoints() {
        return Collections.unmodifiableList(INSERT_POINTS);
    }

    public static List<CapturePoint> getIdeInsertPoints() {
        return Collections.unmodifiableList(IDE_INSERT_POINTS);
    }

    private static KeyProvider param(int idx) {
        return new StringKeyProvider(Integer.toString(idx));
    }

    private static void addCapture(String className, String methodName, KeyProvider key2) {
        CAPTURE_POINTS.add(new AgentCapturePoint(className, methodName, key2));
    }

    private static void addInsert(String className, String methodName, KeyProvider key2) {
        INSERT_POINTS.add(new AgentInsertPoint(className, methodName, key2));
    }

    static {
        THIS_KEY = new StringKeyProvider("this");
        FIRST_PARAM = CaptureSettingsProvider.param(0);
        CaptureSettingsProvider.addCapture("javax/swing/SwingUtilities", "invokeLater", FIRST_PARAM);
        CaptureSettingsProvider.addInsert("java/awt/event/InvocationEvent", "dispatch", new FieldKeyProvider("java/awt/event/InvocationEvent", "runnable", "Ljava/lang/Runnable;"));
        CaptureSettingsProvider.addCapture("java/lang/Thread", "start", THIS_KEY);
        CaptureSettingsProvider.addInsert("java/lang/Thread", "run", THIS_KEY);
        CaptureSettingsProvider.addCapture("java/util/concurrent/ExecutorService", "submit", FIRST_PARAM);
        CaptureSettingsProvider.addInsert("java/util/concurrent/Executors$RunnableAdapter", "call", new FieldKeyProvider("java/util/concurrent/Executors$RunnableAdapter", "task", "Ljava/lang/Runnable;"));
        CaptureSettingsProvider.addCapture("java/util/concurrent/ThreadPoolExecutor", "execute", FIRST_PARAM);
        CaptureSettingsProvider.addInsert("java/util/concurrent/FutureTask", "run", THIS_KEY);
        CaptureSettingsProvider.addCapture("java/util/concurrent/CompletableFuture", "supplyAsync", FIRST_PARAM);
        AgentInsertPoint point = new AgentInsertPoint("java/util/concurrent/CompletableFuture$AsyncSupply", "run", new FieldKeyProvider("java/util/concurrent/CompletableFuture$AsyncSupply", "fn", "Ljava/util/function/Supplier;"));
        point.myInsertPoint.myInsertMethodName = "run$$$capture";
        point.myInsertPoint.myInsertKeyExpression = "f";
        INSERT_POINTS.add(point);
        CaptureSettingsProvider.addCapture("java/util/concurrent/CompletableFuture", "runAsync", FIRST_PARAM);
        point = new AgentInsertPoint("java/util/concurrent/CompletableFuture$AsyncRun", "run", new FieldKeyProvider("java/util/concurrent/CompletableFuture$AsyncRun", "fn", "Ljava/lang/Runnable;"));
        point.myInsertPoint.myInsertMethodName = "run$$$capture";
        point.myInsertPoint.myInsertKeyExpression = "f";
        INSERT_POINTS.add(point);
        CaptureSettingsProvider.addCapture("java/util/concurrent/CompletableFuture", "thenAcceptAsync", FIRST_PARAM);
        CaptureSettingsProvider.addInsert("java/util/concurrent/CompletableFuture$UniAccept", "tryFire", new FieldKeyProvider("java/util/concurrent/CompletableFuture$UniAccept", "fn", "Ljava/util/function/Consumer;"));
        CaptureSettingsProvider.addCapture("java/util/concurrent/CompletableFuture", "thenRunAsync", FIRST_PARAM);
        CaptureSettingsProvider.addInsert("java/util/concurrent/CompletableFuture$UniRun", "tryFire", new FieldKeyProvider("java/util/concurrent/CompletableFuture$UniRun", "fn", "Ljava/lang/Runnable;"));
        CaptureSettingsProvider.addCapture("io/netty/util/concurrent/SingleThreadEventExecutor", "addTask", FIRST_PARAM);
        CaptureSettingsProvider.addInsert("io/netty/util/concurrent/AbstractEventExecutor", "safeExecute", FIRST_PARAM);
        CaptureSettingsProvider.addCapture("scala/concurrent/impl/Future$PromiseCompletingRunnable", "<init>", THIS_KEY);
        CaptureSettingsProvider.addInsert("scala/concurrent/impl/Future$PromiseCompletingRunnable", "run", THIS_KEY);
        CaptureSettingsProvider.addCapture("scala/concurrent/impl/CallbackRunnable", "<init>", THIS_KEY);
        CaptureSettingsProvider.addInsert("scala/concurrent/impl/CallbackRunnable", "run", THIS_KEY);
        CaptureSettingsProvider.addCapture("akka/actor/ScalaActorRef", "$bang", FIRST_PARAM);
        CaptureSettingsProvider.addCapture("akka/actor/RepointableActorRef", "$bang", FIRST_PARAM);
        CaptureSettingsProvider.addCapture("akka/actor/LocalActorRef", "$bang", FIRST_PARAM);
        CaptureSettingsProvider.addInsert("akka/actor/Actor$class", "aroundReceive", CaptureSettingsProvider.param(2));
        IDE_INSERT_POINTS = StreamEx.of(INSERT_POINTS).map(p -> p.myInsertPoint).nonNull().toList();
    }

    private static class FieldKeyProvider
    implements KeyProvider {
        private final String myClassName;
        private final String myFieldName;
        private final String myFieldDesc;

        public FieldKeyProvider(String className, String fieldName, String fieldDesc) {
            this.myClassName = className;
            this.myFieldName = fieldName;
            this.myFieldDesc = fieldDesc;
        }

        @Override
        public String asString() {
            return this.myClassName + " " + this.myFieldName + " " + this.myFieldDesc;
        }
    }

    private static class StringKeyProvider
    implements KeyProvider {
        private final String myValue;

        public StringKeyProvider(String value2) {
            this.myValue = value2;
        }

        @Override
        public String asString() {
            return this.myValue;
        }
    }

    public static interface KeyProvider {
        public String asString();
    }

    public static class AgentInsertPoint
    extends AgentPoint {
        public final CapturePoint myInsertPoint = new CapturePoint();

        public AgentInsertPoint(String className, String methodName, KeyProvider key2) {
            super(className, methodName, key2);
            this.myInsertPoint.myInsertClassName = className.replaceAll("/", ".");
            this.myInsertPoint.myInsertMethodName = methodName;
            if (this.myKey instanceof FieldKeyProvider) {
                this.myInsertPoint.myInsertKeyExpression = ((FieldKeyProvider)this.myKey).myFieldName;
            } else {
                String keyStr = key2.asString();
                try {
                    this.myInsertPoint.myInsertKeyExpression = "param_" + Integer.parseInt(keyStr);
                }
                catch (NumberFormatException ignored) {
                    this.myInsertPoint.myInsertKeyExpression = keyStr;
                }
            }
        }
    }

    public static class AgentCapturePoint
    extends AgentPoint {
        public AgentCapturePoint(String className, String methodName, KeyProvider key2) {
            super(className, methodName, key2);
        }
    }

    public static class AgentPoint {
        public final String myClassName;
        public final String myMethodName;
        public final KeyProvider myKey;
        public static final String SEPARATOR = " ";

        public AgentPoint(String className, String methodName, KeyProvider key2) {
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myKey = key2;
        }
    }
}

