/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugUIEnvironment;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerPanelsManager
implements ProjectComponent {
    private final Project myProject;

    public DebuggerPanelsManager(Project project2) {
        this.myProject = project2;
    }

    private DebuggerStateManager getContextManager() {
        return DebuggerManagerEx.getInstanceEx(this.myProject).getContextManager();
    }

    @Nullable
    public RunContentDescriptor attachVirtualMachine(@NotNull ExecutionEnvironment environment, RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
        if (environment == null) {
            DebuggerPanelsManager.$$$reportNull$$$0(0);
        }
        return this.attachVirtualMachine(new DefaultDebugUIEnvironment(environment, state, remoteConnection, pollConnection));
    }

    @Nullable
    public RunContentDescriptor attachVirtualMachine(DebugUIEnvironment environment) throws ExecutionException {
        DebugEnvironment modelEnvironment = environment.getEnvironment();
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(this.myProject).attachVirtualMachine(modelEnvironment);
        if (debuggerSession == null) {
            return null;
        }
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).startSessionAndShowTab(modelEnvironment.getSessionName(), environment.getReuseContent(), new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session2) {
                if (session2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                JavaDebugProcess javaDebugProcess = JavaDebugProcess.create(session2, debuggerSession);
                if (javaDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return javaDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/ui/DebuggerPanelsManager$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/ui/DebuggerPanelsManager$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return debugSession.getRunContentDescriptor();
    }

    public void projectOpened() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor2, @NotNull Executor executor) {
                if (executor == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (executor == DefaultDebugExecutor.getDebugExecutorInstance()) {
                    DebuggerSession session2;
                    DebuggerSession debuggerSession = session2 = descriptor2 == null ? null : DebuggerPanelsManager.getSession(DebuggerPanelsManager.this.myProject, descriptor2);
                    if (session2 != null) {
                        DebuggerPanelsManager.this.getContextManager().setState(session2.getContextManager().getContext(), session2.getState(), DebuggerSession.Event.CONTEXT, null);
                    } else {
                        DebuggerPanelsManager.this.getContextManager().setState(DebuggerContextImpl.EMPTY_CONTEXT, DebuggerSession.State.DISPOSED, DebuggerSession.Event.CONTEXT, null);
                    }
                }
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor2, @NotNull Executor executor) {
                if (executor == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "executor";
                objectArray2[1] = "com/intellij/debugger/ui/DebuggerPanelsManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("DebuggerPanelsManager" == null) {
            DebuggerPanelsManager.$$$reportNull$$$0(1);
        }
        return "DebuggerPanelsManager";
    }

    public static DebuggerPanelsManager getInstance(Project project2) {
        return (DebuggerPanelsManager)project2.getComponent(DebuggerPanelsManager.class);
    }

    private static DebuggerSession getSession(Project project2, RunContentDescriptor descriptor2) {
        for (JavaDebugProcess process2 : XDebuggerManager.getInstance((Project)project2).getDebugProcesses(JavaDebugProcess.class)) {
            if (!Comparing.equal((Object)process2.getProcessHandler(), (Object)descriptor2.getProcessHandler())) continue;
            return process2.getDebuggerSession();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/DebuggerPanelsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/DebuggerPanelsManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachVirtualMachine";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

