/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.GotoFrameSourceAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.ThreadsDebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTree;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ThreadsPanel
extends DebuggerTreePanel {
    @NonNls
    private static final String HELP_ID = "debugging.debugThreads";
    private final Alarm myUpdateLabelsAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private static final int LABELS_UPDATE_DELAY_MS = 200;

    public ThreadsPanel(Project project2, final DebuggerStateManager stateManager) {
        super(project2, stateManager);
        Disposable disposable = DebuggerAction.installEditAction((JTree)((Object)this.getThreadsTree()), "Debugger.EditFrameSource");
        this.registerDisposable(disposable);
        this.getThreadsTree().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && ThreadsPanel.this.getThreadsTree().getSelectionCount() == 1) {
                    GotoFrameSourceAction.doAction(DataManager.getInstance().getDataContext((Component)((Object)ThreadsPanel.this.getThreadsTree())));
                }
            }
        });
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.getThreadsTree())), "Center");
        stateManager.addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
                if (newContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (DebuggerSession.Event.ATTACHED == event || DebuggerSession.Event.RESUME == event) {
                    ThreadsPanel.this.startLabelsUpdate();
                } else if (DebuggerSession.Event.PAUSE == event || DebuggerSession.Event.DETACHED == event || DebuggerSession.Event.DISPOSE == event) {
                    ThreadsPanel.this.myUpdateLabelsAlarm.cancelAllRequests();
                }
                if (DebuggerSession.Event.DETACHED == event || DebuggerSession.Event.DISPOSE == event) {
                    stateManager.removeListener(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/ui/impl/ThreadsPanel$2", "changeEvent"));
            }
        });
        this.startLabelsUpdate();
    }

    private void startLabelsUpdate() {
        if (this.myUpdateLabelsAlarm.isDisposed()) {
            return;
        }
        this.myUpdateLabelsAlarm.cancelAllRequests();
        this.myUpdateLabelsAlarm.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean updateScheduled = false;
                try {
                    DebugProcessImpl process2;
                    ThreadsDebuggerTree tree;
                    DebuggerTreeNodeImpl root;
                    if (ThreadsPanel.this.isUpdateEnabled() && (root = (DebuggerTreeNodeImpl)(tree = ThreadsPanel.this.getThreadsTree()).getModel().getRoot()) != null && (process2 = ThreadsPanel.this.getContext().getDebugProcess()) != null) {
                        process2.getManagerThread().invoke(new DebuggerCommandImpl(){

                            @Override
                            protected void action() throws Exception {
                                try {
                                    ThreadsPanel.updateNodeLabels(root);
                                }
                                finally {
                                    this.reschedule();
                                }
                            }

                            @Override
                            protected void commandCancelled() {
                                this.reschedule();
                            }
                        });
                        updateScheduled = true;
                    }
                }
                finally {
                    if (!updateScheduled) {
                        this.reschedule();
                    }
                }
            }

            private void reschedule() {
                DebuggerSession session2 = ThreadsPanel.this.getContext().getDebuggerSession();
                if (session2 != null && session2.isAttached() && !session2.isPaused() && !ThreadsPanel.this.myUpdateLabelsAlarm.isDisposed()) {
                    ThreadsPanel.this.myUpdateLabelsAlarm.addRequest((Runnable)this, 200, ModalityState.NON_MODAL);
                }
            }
        }, 200, ModalityState.NON_MODAL);
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.myUpdateLabelsAlarm);
        super.dispose();
    }

    private static void updateNodeLabels(DebuggerTreeNodeImpl from) {
        int childCount = from.getChildCount();
        for (int idx = 0; idx < childCount; ++idx) {
            DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)from.getChildAt(idx);
            child.getDescriptor().updateRepresentation(null, child::labelChanged);
            ThreadsPanel.updateNodeLabels(child);
        }
    }

    @Override
    protected DebuggerTree createTreeView() {
        return new ThreadsDebuggerTree(this.getProject());
    }

    @Override
    protected ActionPopupMenu createPopupMenu() {
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("Debugger.ThreadsPanelPopup");
        return ActionManager.getInstance().createActionPopupMenu("Debugger.ThreadsPanelPopup", (ActionGroup)group);
    }

    @Override
    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    public ThreadsDebuggerTree getThreadsTree() {
        return (ThreadsDebuggerTree)this.getTree();
    }
}

