/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class DesignerEditorState
implements FileEditorState {
    private static final String DESIGNER_ZOOM = "ui-designer-zoom";
    private final long myModificationStamp;
    private final double myZoom;

    public DesignerEditorState(VirtualFile file2, double zoom) {
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        this.myModificationStamp = document != null ? document.getModificationStamp() : file2.getModificationStamp();
        this.myZoom = zoom;
    }

    public double getZoom() {
        return this.myZoom;
    }

    public int hashCode() {
        int A = (int)(this.myModificationStamp ^ this.myModificationStamp >>> 32);
        long B2 = Double.doubleToLongBits(this.myZoom);
        return 31 * A + (int)(B2 ^ B2 >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DesignerEditorState) {
            DesignerEditorState state = (DesignerEditorState)object;
            return this.myModificationStamp == state.myModificationStamp && this.myZoom == state.myZoom;
        }
        return false;
    }

    public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
        return otherState instanceof DesignerEditorState;
    }

    @NotNull
    public static FileEditorState readState(@NotNull Element sourceElement, @NotNull VirtualFile file2, double defaultZoom) {
        if (sourceElement == null) {
            DesignerEditorState.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            DesignerEditorState.$$$reportNull$$$0(1);
        }
        double zoom = defaultZoom;
        try {
            zoom = Double.parseDouble(sourceElement.getAttributeValue(DESIGNER_ZOOM));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DesignerEditorState designerEditorState = new DesignerEditorState(file2, zoom);
        if (designerEditorState == null) {
            DesignerEditorState.$$$reportNull$$$0(2);
        }
        return designerEditorState;
    }

    public static void writeState(@NotNull FileEditorState state, @NotNull Element targetElement) {
        if (state == null) {
            DesignerEditorState.$$$reportNull$$$0(3);
        }
        if (targetElement == null) {
            DesignerEditorState.$$$reportNull$$$0(4);
        }
        targetElement.setAttribute(DESIGNER_ZOOM, Double.toString(((DesignerEditorState)state).getZoom()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/DesignerEditorState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/DesignerEditorState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

