/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ComparatorUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class ExternalPSIChangeListener
extends PsiTreeChangeAdapter {
    private final Alarm myAlarm = new Alarm();
    protected final DesignerEditorPanel myDesigner;
    private final PsiFile myFile;
    private final int myDelayMillis;
    private final Runnable myRunnable;
    protected volatile boolean myRunState;
    private volatile boolean myInitialize;
    private String myContent;
    protected boolean myUpdateRenderer;

    public ExternalPSIChangeListener(DesignerEditorPanel designer, PsiFile file2, int delayMillis, Runnable runnable2) {
        this.myDesigner = designer;
        this.myFile = file2;
        this.myDelayMillis = delayMillis;
        this.myRunnable = runnable2;
        this.myContent = this.myDesigner.getEditorText();
        PsiManager.getInstance((Project)this.myDesigner.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)this);
    }

    public void setInitialize() {
        this.myInitialize = true;
    }

    public void start() {
        if (!this.myRunState) {
            this.myRunState = true;
        }
    }

    public void dispose() {
        PsiManager.getInstance((Project)this.myDesigner.getProject()).removePsiTreeChangeListener((PsiTreeChangeListener)this);
        this.stop();
    }

    public void stop() {
        if (this.myRunState) {
            this.myRunState = false;
            this.clear();
        }
    }

    public void activate() {
        if (!this.myRunState) {
            this.start();
            if (!ComparatorUtil.equalsNullable((Object)this.myContent, (Object)this.myDesigner.getEditorText()) || this.myDesigner.getRootComponent() == null) {
                this.myUpdateRenderer = false;
                this.addRequest();
            }
            this.myContent = null;
        }
    }

    public void deactivate() {
        if (this.myRunState) {
            this.stop();
            this.myContent = this.myDesigner.getEditorText();
        }
        this.myUpdateRenderer = false;
    }

    public void addRequest() {
        this.addRequest(this.myRunnable);
    }

    public boolean isActive() {
        return this.myRunState;
    }

    public boolean isUpdateRenderer() {
        return this.myUpdateRenderer;
    }

    public boolean ensureUpdateRenderer() {
        if (this.myRunState) {
            return this.myInitialize && !this.myDesigner.isProjectClosed();
        }
        this.myUpdateRenderer = true;
        return false;
    }

    public void addRequest(Runnable runnable2) {
        this.clear();
        this.myAlarm.addRequest(() -> {
            if (this.myRunState && this.myInitialize && !this.myDesigner.isProjectClosed()) {
                runnable2.run();
            }
        }, this.myDelayMillis, ModalityState.stateForComponent((Component)this.myDesigner));
    }

    public void clear() {
        this.myAlarm.cancelAllRequests();
    }

    protected void updatePsi(PsiTreeChangeEvent event) {
        if (this.myRunState && this.myFile == event.getFile()) {
            this.addRequest();
        }
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ExternalPSIChangeListener.$$$reportNull$$$0(0);
        }
        this.updatePsi(event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ExternalPSIChangeListener.$$$reportNull$$$0(1);
        }
        this.updatePsi(event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ExternalPSIChangeListener.$$$reportNull$$$0(2);
        }
        this.updatePsi(event);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ExternalPSIChangeListener.$$$reportNull$$$0(3);
        }
        this.updatePsi(event);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ExternalPSIChangeListener.$$$reportNull$$$0(4);
        }
        this.updatePsi(event);
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            ExternalPSIChangeListener.$$$reportNull$$$0(5);
        }
        this.updatePsi(event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/designer/designSurface/ExternalPSIChangeListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "childAdded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "childRemoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "childReplaced";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "childMoved";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "childrenChanged";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

