/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadLayout;
import java.awt.event.KeyEvent;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public abstract class TargetingTool
extends InputTool {
    protected OperationContext myContext = new OperationContext();
    protected EditOperation myTargetOperation;
    protected RadComponent myTarget;
    private boolean myShowFeedback;

    @Override
    public void deactivate() {
        this.eraseFeedback();
        this.myContext = new OperationContext();
        this.myTargetOperation = null;
        this.myTarget = null;
        super.deactivate();
    }

    protected void handleInvalidInput() {
        this.eraseFeedback();
        this.setExecuteEnabled(false);
    }

    @Override
    protected void handleDragStarted() {
        if (this.myState == 2) {
            this.myState = 3;
        }
    }

    @Override
    protected void handleAreaExited() {
        this.setTarget(null, null);
        this.setExecuteEnabled(false);
    }

    protected void showFeedback() {
        if (this.myTargetOperation != null) {
            this.myTargetOperation.showFeedback();
        }
        this.myShowFeedback = true;
    }

    protected void eraseFeedback() {
        if (this.myShowFeedback) {
            this.myShowFeedback = false;
            if (this.myTargetOperation != null) {
                this.myTargetOperation.eraseFeedback();
            }
        }
    }

    protected void executeCommand() {
        if (this.myExecuteEnabled) {
            this.myToolProvider.execute(Collections.singletonList(this.myTargetOperation), this.myContext.getMessage());
        }
    }

    protected void updateCommand() {
        this.setExecuteEnabled(this.myTargetOperation != null && this.myTargetOperation.canExecute());
    }

    protected void updateContext() {
        this.myContext.setArea(this.myArea);
        this.myContext.setInputEvent(this.myInputEvent);
        this.myContext.setModifiers(this.myInputEvent.getModifiers());
    }

    protected void setTarget(@Nullable RadComponent target2, @Nullable ContainerTargetFilter filter2) {
        if (target2 != this.myTarget) {
            if (this.myTargetOperation != null) {
                this.eraseFeedback();
            }
            this.myTarget = target2;
            this.myTargetOperation = filter2 == null ? null : filter2.getOperation();
        }
    }

    @Override
    public void keyPressed(KeyEvent event, EditableArea area) throws Exception {
        boolean changedModifiers = event.getModifiers() != this.myModifiers;
        super.keyPressed(event, area);
        if (changedModifiers) {
            this.handleKeyEvent();
        }
    }

    @Override
    public void keyReleased(KeyEvent event, EditableArea area) throws Exception {
        boolean changedModifiers = event.getModifiers() != this.myModifiers;
        super.keyReleased(event, area);
        if (changedModifiers) {
            this.handleKeyEvent();
        }
    }

    protected void handleKeyEvent() {
        if (this.myContext != null) {
            this.updateContext();
            this.showFeedback();
            this.updateCommand();
        }
    }

    protected class ContainerTargetFilter
    implements ComponentTargetFilter {
        private EditOperation myOperation;

        protected ContainerTargetFilter() {
        }

        public EditOperation getOperation() {
            return this.myOperation;
        }

        @Override
        public boolean preFilter(RadComponent component) {
            return true;
        }

        @Override
        public boolean resultFilter(RadComponent target2) {
            this.updateContext(target2);
            if (TargetingTool.this.myTarget == target2 && this.myOperation != null) {
                return true;
            }
            RadLayout layout = target2.getLayout();
            if (layout != null) {
                TargetingTool.this.myContext.setContainer(target2);
                this.myOperation = layout.processChildOperation(TargetingTool.this.myContext);
                TargetingTool.this.myContext.setContainer(null);
            }
            return this.myOperation != null;
        }

        protected void updateContext(RadComponent target2) {
        }
    }
}

