/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import com.intellij.designer.AbstractToolWindowManager;
import com.intellij.designer.DesignerCustomizations;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.palette.PalettePanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaletteToolWindowManager
extends AbstractToolWindowManager {
    private PalettePanel myToolWindowPanel;

    public PaletteToolWindowManager(Project project2, FileEditorManager fileEditorManager) {
        super(project2, fileEditorManager);
    }

    public static PalettePanel getInstance(DesignerEditorPanel designer) {
        PaletteToolWindowManager manager = PaletteToolWindowManager.getInstance(designer.getProject());
        if (manager.isEditorMode()) {
            return (PalettePanel)manager.getContent(designer);
        }
        return manager.myToolWindowPanel;
    }

    public static PaletteToolWindowManager getInstance(Project project2) {
        return (PaletteToolWindowManager)project2.getComponent(PaletteToolWindowManager.class);
    }

    @Override
    protected void initToolWindow() {
        if (this.myToolWindowPanel == null) {
            this.myToolWindowPanel = new PalettePanel();
            Disposer.register((Disposable)this, () -> this.myToolWindowPanel.dispose());
        }
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow("Palette\t", false, this.getAnchor(), (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(AllIcons.Toolwindows.ToolWindowPalette);
        this.initGearActions();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)this.myToolWindowPanel, null, false);
        content.setCloseable(false);
        content.setPreferredFocusableComponent((JComponent)this.myToolWindowPanel);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        this.myToolWindow.setAvailable(false, null);
    }

    @Override
    protected ToolWindowAnchor getAnchor() {
        DesignerCustomizations customization = PaletteToolWindowManager.getCustomizations();
        return customization != null ? customization.getPaletteAnchor() : ToolWindowAnchor.RIGHT;
    }

    @Override
    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myToolWindowPanel.loadPalette((DesignerEditorPanel)designer);
        if (designer == null) {
            this.myToolWindow.setAvailable(false, null);
        } else {
            this.myToolWindow.setAvailable(true, null);
            this.myToolWindow.show(null);
        }
    }

    @Override
    @NotNull
    public String getComponentName() {
        if ("PaletteToolWindowManager" == null) {
            PaletteToolWindowManager.$$$reportNull$$$0(0);
        }
        return "PaletteToolWindowManager";
    }

    @Override
    protected LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            PaletteToolWindowManager.$$$reportNull$$$0(1);
        }
        PalettePanel palettePanel = new PalettePanel();
        palettePanel.loadPalette((DesignerEditorPanel)designer);
        return this.createContent(designer, palettePanel, "Palette", AllIcons.Toolwindows.ToolWindowPalette, palettePanel, palettePanel, 180, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/palette/PaletteToolWindowManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/palette/PaletteToolWindowManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

