/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.OutOfMemoryDialog;
import com.intellij.diagnostic.VMOptions;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.ErrorLogger;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.MappingFailedException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class DefaultIdeaErrorLogger
implements ErrorLogger {
    private static boolean ourOomOccurred = false;
    private static boolean ourLoggerBroken = false;
    private static boolean ourMappingFailedNotificationPosted = false;
    private static final String FATAL_ERROR_NOTIFICATION_PROPERTY = "idea.fatal.error.notification";
    private static final String DISABLED_VALUE = "disabled";
    private static final String ENABLED_VALUE = "enabled";

    public boolean canHandle(IdeaLoggingEvent event) {
        if (ourLoggerBroken) {
            return false;
        }
        try {
            UpdateChecker.checkForUpdate(event);
            boolean notificationEnabled = !DISABLED_VALUE.equals(System.getProperty(FATAL_ERROR_NOTIFICATION_PROPERTY, ENABLED_VALUE));
            ErrorReportSubmitter submitter = IdeErrorsDialog.getSubmitter(event.getThrowable());
            boolean showPluginError = !(submitter instanceof ITNReporter) || ((ITNReporter)submitter).showErrorInRelease(event);
            return notificationEnabled || showPluginError || ApplicationManagerEx.getApplicationEx().isInternal() || DefaultIdeaErrorLogger.getOOMErrorKind(event.getThrowable()) != null || event.getThrowable() instanceof MappingFailedException;
        }
        catch (LinkageError e) {
            if (e.getMessage().contains("Could not initialize class com.intellij.diagnostic.IdeErrorsDialog")) {
                ourLoggerBroken = true;
            }
            throw e;
        }
    }

    public void handle(IdeaLoggingEvent event) {
        block8: {
            if (ourLoggerBroken) {
                return;
            }
            try {
                Throwable throwable = event.getThrowable();
                VMOptions.MemoryKind kind2 = DefaultIdeaErrorLogger.getOOMErrorKind(throwable);
                if (kind2 != null) {
                    ourOomOccurred = true;
                    SwingUtilities.invokeAndWait(() -> new OutOfMemoryDialog(kind2).show());
                } else if (throwable instanceof MappingFailedException) {
                    DefaultIdeaErrorLogger.processMappingFailed(event);
                } else if (!ourOomOccurred) {
                    MessagePool messagePool = MessagePool.getInstance();
                    messagePool.addIdeFatalMessage(event);
                }
            }
            catch (Throwable e) {
                String message2 = e.getMessage();
                if ((message2 == null || !message2.contains("Could not initialize class com.intellij.diagnostic.MessagePool")) && (!(e instanceof NullPointerException) || ApplicationManager.getApplication() != null)) break block8;
                ourLoggerBroken = true;
            }
        }
    }

    @Nullable
    private static VMOptions.MemoryKind getOOMErrorKind(Throwable t) {
        String message2 = t.getMessage();
        if (t instanceof OutOfMemoryError) {
            if (message2 != null && message2.contains("unable to create new native thread")) {
                return null;
            }
            if (message2 != null && message2.contains("Metaspace")) {
                return VMOptions.MemoryKind.METASPACE;
            }
            return VMOptions.MemoryKind.HEAP;
        }
        if (t instanceof VirtualMachineError && message2 != null && message2.contains("CodeCache")) {
            return VMOptions.MemoryKind.CODE_CACHE;
        }
        return null;
    }

    private static void processMappingFailed(IdeaLoggingEvent event) throws InterruptedException, InvocationTargetException {
        if (!ourMappingFailedNotificationPosted && SystemInfo.isWindows && SystemInfo.is32Bit) {
            ourMappingFailedNotificationPosted = true;
            String exceptionMessage = event.getThrowable().getMessage();
            String text2 = exceptionMessage + "<br>Possible cause: unable to allocate continuous memory chunk of necessary size.<br>Reducing JVM maximum heap size (-Xmx) may help.";
            Notifications.Bus.notify((Notification)new Notification("Memory", "Memory Mapping Failed", text2, NotificationType.WARNING), null);
        }
    }
}

