/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Developer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

class DevelopersLoader {
    private static final String DEVELOPERS_LIST_URL = "http://ea-engine.labs.intellij.net/data?category=developers";

    private DevelopersLoader() {
    }

    public static Collection<Developer> fetchDevelopers(final @NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            DevelopersLoader.$$$reportNull$$$0(0);
        }
        return (Collection)HttpRequests.request((String)DEVELOPERS_LIST_URL).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Collection<Developer>>(){

            public Collection<Developer> process(@NotNull HttpRequests.Request request) throws IOException {
                String line;
                if (request == null) {
                    1.$$$reportNull$$$0(0);
                }
                LinkedList<Developer> developers = new LinkedList<Developer>();
                developers.add(Developer.NULL);
                while ((line = request.getReader().readLine()) != null) {
                    int i = line.indexOf(9);
                    if (i == -1) {
                        throw new IOException("Protocol error");
                    }
                    int id = Integer.parseInt(line.substring(0, i));
                    String name2 = line.substring(i + 1);
                    developers.add(new Developer(id, name2));
                    indicator.checkCanceled();
                }
                return developers;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diagnostic/DevelopersLoader$1", "process"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diagnostic/DevelopersLoader", "fetchDevelopers"));
    }
}

