/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputFileUtil {
    private static final String CONSOLE_OUTPUT_FILE_MESSAGE = "Console output is saving to: ";

    private OutputFileUtil() {
    }

    public static File getOutputFile(@NotNull RunConfigurationBase configuration) {
        String outputFilePath;
        if (configuration == null) {
            OutputFileUtil.$$$reportNull$$$0(0);
        }
        if ((outputFilePath = configuration.getOutputFilePath()) != null) {
            String directory;
            String filePath = FileUtil.toSystemDependentName((String)outputFilePath);
            File file2 = new File(filePath);
            if (configuration instanceof CommonProgramRunConfigurationParameters && !FileUtil.isAbsolute((String)filePath) && (directory = ((CommonProgramRunConfigurationParameters)configuration).getWorkingDirectory()) != null) {
                file2 = new File(new File(directory), filePath);
            }
            return file2;
        }
        return null;
    }

    public static void attachDumpListener(final @NotNull RunConfigurationBase configuration, final @NotNull ProcessHandler startedProcess, @Nullable ExecutionConsole console) {
        if (configuration == null) {
            OutputFileUtil.$$$reportNull$$$0(1);
        }
        if (startedProcess == null) {
            OutputFileUtil.$$$reportNull$$$0(2);
        }
        if (!configuration.isSaveOutputToFile()) {
            return;
        }
        final File file2 = OutputFileUtil.getOutputFile(configuration);
        if (file2 != null) {
            startedProcess.addProcessListener((ProcessListener)new ProcessAdapter(){
                private PrintStream myOutput;

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (configuration.collectOutputFromProcessHandler() && this.myOutput != null && outputType != ProcessOutputTypes.SYSTEM) {
                        this.myOutput.print(event.getText());
                    }
                }

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    try {
                        this.myOutput = new PrintStream(new FileOutputStream(file2));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                    startedProcess.notifyTextAvailable(OutputFileUtil.CONSOLE_OUTPUT_FILE_MESSAGE + FileUtil.toSystemDependentName((String)file2.getAbsolutePath()) + "\n", ProcessOutputTypes.SYSTEM);
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    startedProcess.removeProcessListener((ProcessListener)this);
                    if (this.myOutput != null) {
                        this.myOutput.close();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/diagnostic/logging/OutputFileUtil$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (console instanceof ConsoleView) {
                ((ConsoleView)console).addMessageFilter((Filter)new ShowOutputFileFilter());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startedProcess";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/logging/OutputFileUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOutputFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "attachDumpListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ShowOutputFileFilter
    implements Filter {
        private ShowOutputFileFilter() {
        }

        public Filter.Result applyFilter(String line, int entireLength) {
            if (line.startsWith(OutputFileUtil.CONSOLE_OUTPUT_FILE_MESSAGE)) {
                final String filePath = StringUtil.trimEnd((String)line.substring(OutputFileUtil.CONSOLE_OUTPUT_FILE_MESSAGE.length()), (String)"\n");
                return new Filter.Result(entireLength - filePath.length() - 1, entireLength, new HyperlinkInfo(){

                    public void navigate(Project project2) {
                        VirtualFile file2 = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)filePath)));
                        if (file2 != null) {
                            file2.refresh(false, false);
                            ApplicationManager.getApplication().runReadAction(() -> FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, file2), true));
                        }
                    }
                });
            }
            return null;
        }
    }
}

