/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContentImpl;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.contents.FileDocumentContentImpl;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.LightColors;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffContentFactoryImpl
extends DiffContentFactoryEx {
    private static final Logger LOG = Logger.getInstance(DiffContentFactoryImpl.class);

    @NotNull
    public EmptyContent createEmpty() {
        EmptyContent emptyContent = new EmptyContent();
        if (emptyContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(0);
        }
        return emptyContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text2) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(1);
        }
        DocumentContent documentContent = this.create(null, text2);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(2);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text2, @Nullable FileType type2) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(3);
        }
        DocumentContent documentContent = this.create(null, text2, type2);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(4);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text2, @Nullable FileType type2, boolean respectLineSeparators) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(5);
        }
        DocumentContent documentContent = this.create(null, text2, type2, respectLineSeparators);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(6);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text2, @Nullable VirtualFile highlightFile) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(7);
        }
        DocumentContent documentContent = this.create(null, text2, highlightFile);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(8);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text2, @Nullable DocumentContent referent) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(9);
        }
        DocumentContent documentContent = this.create(null, text2, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(10);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(11);
        }
        DocumentContent documentContent = this.create(project2, text2, (FileType)null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(12);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @Nullable FileType type2) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(13);
        }
        DocumentContent documentContent = this.create(project2, text2, type2, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(14);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @Nullable FileType type2, boolean respectLineSeparators) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(15);
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text2, type2, null, null, respectLineSeparators, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(16);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @NotNull FilePath filePath) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(17);
        }
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(18);
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text2, filePath.getFileType(), filePath.getName(), filePath.getVirtualFile(), true, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(19);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @Nullable VirtualFile highlightFile) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(20);
        }
        FileType fileType = highlightFile != null ? highlightFile.getFileType() : null;
        String fileName = highlightFile != null ? highlightFile.getName() : null;
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text2, fileType, fileName, highlightFile, true, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(21);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @Nullable DocumentContent referent) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(22);
        }
        if (referent == null) {
            DocumentContent documentContent = this.create(text2);
            if (documentContent == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(23);
            }
            return documentContent;
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text2, referent.getContentType(), null, referent.getHighlightFile(), false, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(24);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull Document document, @Nullable DocumentContent referent) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(25);
        }
        DocumentContent documentContent = this.create(null, document, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(26);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(27);
        }
        DocumentContent documentContent = this.create(project2, document, (FileType)null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(28);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable FileType fileType) {
        VirtualFile file2;
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(29);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) != null) {
            FileDocumentContentImpl fileDocumentContentImpl = new FileDocumentContentImpl(project2, document, file2);
            if (fileDocumentContentImpl == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(30);
            }
            return fileDocumentContentImpl;
        }
        DocumentContentImpl documentContentImpl = new DocumentContentImpl(project2, document, fileType, null, null, null, null);
        if (documentContentImpl == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(31);
        }
        return documentContentImpl;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable VirtualFile highlightFile) {
        VirtualFile file2;
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(32);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) != null && file2.equals(highlightFile)) {
            FileDocumentContentImpl fileDocumentContentImpl = new FileDocumentContentImpl(project2, document, file2);
            if (fileDocumentContentImpl == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(33);
            }
            return fileDocumentContentImpl;
        }
        if (highlightFile == null) {
            DocumentContentImpl documentContentImpl = new DocumentContentImpl(document);
            if (documentContentImpl == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(34);
            }
            return documentContentImpl;
        }
        DocumentContentImpl documentContentImpl = new DocumentContentImpl(project2, document, highlightFile.getFileType(), highlightFile, null, null, null);
        if (documentContentImpl == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(35);
        }
        return documentContentImpl;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable DocumentContent referent) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(36);
        }
        if (referent == null) {
            DocumentContentImpl documentContentImpl = new DocumentContentImpl(document);
            if (documentContentImpl == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(37);
            }
            return documentContentImpl;
        }
        DocumentContentImpl documentContentImpl = new DocumentContentImpl(project2, document, referent.getContentType(), referent.getHighlightFile(), null, null, null);
        if (documentContentImpl == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(38);
        }
        return documentContentImpl;
    }

    @NotNull
    public DiffContent create(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(39);
        }
        DiffContent diffContent = DiffContentFactoryImpl.createContentFromFile(project2, file2);
        if (diffContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(40);
        }
        return diffContent;
    }

    @Nullable
    public DocumentContent createDocument(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(41);
        }
        return (DocumentContent)ObjectUtils.tryCast((Object)DiffContentFactoryImpl.createContentFromFile(project2, file2), DocumentContent.class);
    }

    @Nullable
    public FileContent createFile(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(42);
        }
        if (file2.isDirectory()) {
            return null;
        }
        return (FileContent)this.create(project2, file2);
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project2, @NotNull Document document, @NotNull TextRange range) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(43);
        }
        if (range == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(44);
        }
        DocumentContent content = this.create(project2, document);
        DocumentFragmentContent documentFragmentContent = new DocumentFragmentContent(project2, content, range);
        if (documentFragmentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(45);
        }
        return documentFragmentContent;
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project2, @NotNull DocumentContent content, @NotNull TextRange range) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(46);
        }
        if (range == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(47);
        }
        DocumentFragmentContent documentFragmentContent = new DocumentFragmentContent(project2, content, range);
        if (documentFragmentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(48);
        }
        return documentFragmentContent;
    }

    @NotNull
    public DiffContent createClipboardContent() {
        DocumentContent documentContent = this.createClipboardContent(null, null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(49);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable DocumentContent referent) {
        DocumentContent documentContent = this.createClipboardContent(null, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(50);
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createClipboardContent(@Nullable Project project2) {
        DocumentContent documentContent = this.createClipboardContent(project2, null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(51);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable Project project2, @Nullable DocumentContent referent) {
        String text2 = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        FileType type2 = referent != null ? referent.getContentType() : null;
        VirtualFile highlightFile = referent != null ? referent.getHighlightFile() : null;
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, StringUtil.notNullize((String)text2), type2, "Clipboard.txt", highlightFile, false, false);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(52);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull FilePath filePath) throws IOException {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(53);
        }
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(54);
        }
        if (DiffContentFactoryImpl.isBinaryContent(content, filePath.getFileType())) {
            DiffContent diffContent = DiffContentFactoryImpl.createBinaryImpl(project2, content, filePath.getFileType(), filePath.getName(), filePath.getVirtualFile());
            if (diffContent == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(55);
            }
            return diffContent;
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project2, content, filePath);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(56);
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull FileType fileType, @NotNull String fileName) throws IOException {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(57);
        }
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(58);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(59);
        }
        if (DiffContentFactoryImpl.isBinaryContent(content, fileType)) {
            DiffContent diffContent = DiffContentFactoryImpl.createBinaryImpl(project2, content, fileType, fileName, null);
            if (diffContent == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(60);
            }
            return diffContent;
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project2, content, fileType, fileName);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(61);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull VirtualFile highlightFile) throws IOException {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(62);
        }
        if (highlightFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(63);
        }
        if (DiffContentFactoryImpl.isBinaryContent(content, highlightFile.getFileType())) {
            DiffContent diffContent = DiffContentFactoryImpl.createBinaryImpl(project2, content, highlightFile.getFileType(), highlightFile.getName(), highlightFile);
            if (diffContent == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(64);
            }
            return diffContent;
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project2, content, highlightFile);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(65);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull FileType fileType, @NotNull String fileName) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(66);
        }
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(67);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(68);
        }
        EncodingManager e = project2 != null ? EncodingProjectManager.getInstance((Project)project2) : EncodingManager.getInstance();
        DocumentContent documentContent = DiffContentFactoryImpl.createFromBytesImpl(project2, content, fileType, fileName, null, e.getDefaultCharset());
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(69);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull FilePath filePath) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(70);
        }
        if (filePath == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(71);
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createFromBytesImpl(project2, content, filePath.getFileType(), filePath.getName(), filePath.getVirtualFile(), filePath.getCharset());
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(72);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull VirtualFile highlightFile) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(73);
        }
        if (highlightFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(74);
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createFromBytesImpl(project2, content, highlightFile.getFileType(), highlightFile.getName(), highlightFile, highlightFile.getCharset());
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(75);
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createBinary(@Nullable Project project2, @NotNull byte[] content, @NotNull FileType type2, @NotNull String fileName) throws IOException {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(76);
        }
        if (type2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(77);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(78);
        }
        DiffContent diffContent = DiffContentFactoryImpl.createBinaryImpl(project2, content, type2, fileName, null);
        if (diffContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(79);
        }
        return diffContent;
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(80);
        }
        DiffContent diffContent = DiffContentFactoryImpl.createContentFromFile(project2, file2, file2);
        if (diffContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(81);
        }
        return diffContent;
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project2, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(82);
        }
        if (file2.isDirectory()) {
            DirectoryContentImpl directoryContentImpl = new DirectoryContentImpl(project2, file2, highlightFile);
            if (directoryContentImpl == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(83);
            }
            return directoryContentImpl;
        }
        Document document = (Document)ReadAction.compute(() -> {
            if (file2 == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(117);
            }
            return FileDocumentManager.getInstance().getDocument(file2);
        });
        if (document != null) {
            FileDocumentContentImpl fileDocumentContentImpl = new FileDocumentContentImpl(project2, document, file2, highlightFile);
            if (fileDocumentContentImpl == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(84);
            }
            return fileDocumentContentImpl;
        }
        FileContentImpl fileContentImpl = new FileContentImpl(project2, file2, highlightFile);
        if (fileContentImpl == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(85);
        }
        return fileContentImpl;
    }

    @NotNull
    private static DiffContent createBinaryImpl(@Nullable Project project2, @NotNull byte[] content, @NotNull FileType type2, @NotNull String fileName, @Nullable VirtualFile highlightFile) throws IOException {
        VirtualFile file2;
        boolean useTemporalFile;
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(86);
        }
        if (type2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(87);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(88);
        }
        boolean bl = useTemporalFile = type2 instanceof ArchiveFileType || BinaryFileTypeDecompilers.INSTANCE.forFileType(type2) != null;
        if (useTemporalFile) {
            file2 = DiffContentFactoryImpl.createTemporalFile(project2, "tmp", fileName, content);
        } else {
            file2 = new BinaryLightVirtualFile(fileName, type2, content);
            file2.setWritable(false);
        }
        file2.putUserData(DiffUtil.TEMP_FILE_KEY, (Object)Boolean.TRUE);
        DiffContent diffContent = DiffContentFactoryImpl.createContentFromFile(project2, file2, highlightFile);
        if (diffContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(89);
        }
        return diffContent;
    }

    @NotNull
    private static DocumentContent createImpl(@Nullable Project project2, @NotNull String text2, @Nullable FileType fileType, @Nullable String fileName, @Nullable VirtualFile highlightFile, boolean respectLineSeparators, boolean readOnly) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(90);
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text2, fileType, fileName, highlightFile, null, null, respectLineSeparators, readOnly);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(91);
        }
        return documentContent;
    }

    @NotNull
    private static DocumentContent createImpl(@Nullable Project project2, @NotNull String text2, @Nullable FileType fileType, @Nullable String fileName, @Nullable VirtualFile highlightFile, @Nullable Charset charset, @Nullable Boolean bom, boolean respectLineSeparators, boolean readOnly) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(92);
        }
        if (FileTypes.UNKNOWN.equals(fileType)) {
            fileType = PlainTextFileType.INSTANCE;
        }
        LineSeparator separator = respectLineSeparators ? StringUtil.detectSeparators((CharSequence)text2) : null;
        String correctedContent = StringUtil.convertLineSeparators((String)text2);
        Document document = DiffContentFactoryImpl.createDocument(project2, correctedContent, fileType, fileName, readOnly);
        DocumentContentImpl content = new DocumentContentImpl(project2, document, (FileType)fileType, highlightFile, separator, charset, bom);
        if (fileName != null) {
            content.putUserData(DiffUserDataKeysEx.FILE_NAME, fileName);
        }
        DocumentContentImpl documentContentImpl = content;
        if (documentContentImpl == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(93);
        }
        return documentContentImpl;
    }

    @NotNull
    private static DocumentContent createFromBytesImpl(@Nullable Project project2, @NotNull byte[] content, @NotNull FileType fileType, @NotNull String fileName, @Nullable VirtualFile highlightFile, @NotNull Charset charset) {
        Charset bomCharset;
        boolean isBOM;
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(94);
        }
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(95);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(96);
        }
        if (charset == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(97);
        }
        if (fileType.isBinary()) {
            fileType = PlainTextFileType.INSTANCE;
            Charset guessedCharset = DiffContentFactoryImpl.guessCharsetFromContent(content);
            if (guessedCharset != null) {
                charset = guessedCharset;
            }
        }
        boolean bl = isBOM = (bomCharset = CharsetToolkit.guessFromBOM((byte[])content)) != null;
        if (isBOM) {
            charset = bomCharset;
        }
        boolean malformedContent = false;
        String text2 = CharsetToolkit.tryDecodeString((byte[])content, (Charset)charset);
        if (text2 == null) {
            text2 = CharsetToolkit.decodeString((byte[])content, (Charset)charset);
            malformedContent = true;
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text2, fileType, fileName, highlightFile, charset, isBOM, true, true);
        if (malformedContent) {
            String notificationText = "Content was decoded with errors (using '" + charset.name() + "' charset)";
            DiffUtil.addNotification(DiffNotifications.createNotification(notificationText, LightColors.RED), (UserDataHolder)documentContent);
        }
        DocumentContent documentContent2 = documentContent;
        if (documentContent2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(98);
        }
        return documentContent2;
    }

    @NotNull
    private static VirtualFile createTemporalFile(@Nullable Project project2, @NotNull String prefix, @NotNull String suffix, @NotNull byte[] content) throws IOException {
        VirtualFile file2;
        if (prefix == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(99);
        }
        if (suffix == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(100);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(101);
        }
        File tempFile = FileUtil.createTempFile((String)PathUtil.suggestFileName((String)(prefix + "_"), (boolean)true, (boolean)false), (String)PathUtil.suggestFileName((String)("_" + suffix), (boolean)true, (boolean)false), (boolean)true);
        if (content.length != 0) {
            FileUtil.writeToFile((File)tempFile, (byte[])content);
        }
        if (!tempFile.setWritable(false, false)) {
            LOG.warn("Can't set writable attribute of temporal file");
        }
        if ((file2 = VfsUtil.findFileByIoFile((File)tempFile, (boolean)true)) == null) {
            throw new IOException("Can't create temp file for revision content");
        }
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file2});
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(102);
        }
        return virtualFile;
    }

    @NotNull
    private static Document createDocument(@Nullable Project project2, @NotNull String content, @Nullable FileType fileType, @Nullable String fileName, boolean readOnly) {
        Document document;
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(103);
        }
        if (project2 != null && !project2.isDefault() && fileType != null && !fileType.isBinary() && Registry.is((String)"diff.enable.psi.highlighting")) {
            if (fileName == null) {
                fileName = "diff." + StringUtil.defaultIfEmpty((String)fileType.getDefaultExtension(), (String)"txt");
            }
            if ((document = DiffContentFactoryImpl.createPsiDocument(project2, content, fileType, fileName, readOnly)) != null) {
                Document document2 = document;
                if (document2 == null) {
                    DiffContentFactoryImpl.$$$reportNull$$$0(104);
                }
                return document2;
            }
        }
        document = EditorFactory.getInstance().createDocument((CharSequence)content);
        document.setReadOnly(readOnly);
        Document document3 = document;
        if (document3 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(105);
        }
        return document3;
    }

    @Nullable
    private static Document createPsiDocument(@NotNull Project project2, @NotNull String content, @NotNull FileType fileType, @NotNull String fileName, boolean readOnly) {
        if (project2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(106);
        }
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(107);
        }
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(108);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(109);
        }
        return (Document)ReadAction.compute(() -> {
            if (fileName == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(113);
            }
            if (fileType == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(114);
            }
            if (content == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(115);
            }
            if (project2 == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(116);
            }
            LightVirtualFile file2 = new LightVirtualFile(fileName, fileType, (CharSequence)content);
            file2.setWritable(!readOnly);
            OutsidersPsiFileSupport.markFile((VirtualFile)file2);
            Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)file2);
            if (document == null) {
                return null;
            }
            PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
            return document;
        });
    }

    private static boolean isBinaryContent(@NotNull byte[] content, @NotNull FileType fileType) {
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(110);
        }
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(111);
        }
        if (UnknownFileType.INSTANCE.equals(fileType)) {
            return DiffContentFactoryImpl.guessCharsetFromContent(content) == null;
        }
        return fileType.isBinary();
    }

    @Nullable
    private static Charset guessCharsetFromContent(@NotNull byte[] content) {
        CharsetToolkit toolkit;
        Charset fromBOM;
        if (content == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(112);
        }
        if ((fromBOM = (toolkit = new CharsetToolkit(content)).guessFromBOM()) != null) {
            return fromBOM;
        }
        CharsetToolkit.GuessedEncoding guessedEncoding = toolkit.guessFromContent(content.length);
        switch (guessedEncoding) {
            case SEVEN_BIT: {
                return Charset.forName("US-ASCII");
            }
            case VALID_UTF8: {
                return CharsetToolkit.UTF8_CHARSET;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 82: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 82: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 90: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: 
            case 54: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 36: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 39: 
            case 41: 
            case 42: 
            case 80: 
            case 82: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 46: 
            case 53: 
            case 57: 
            case 62: 
            case 66: 
            case 70: 
            case 73: 
            case 76: 
            case 86: 
            case 94: 
            case 101: 
            case 103: 
            case 107: 
            case 110: 
            case 112: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 58: 
            case 67: 
            case 95: 
            case 108: 
            case 111: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 59: 
            case 68: 
            case 78: 
            case 88: 
            case 96: 
            case 109: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 63: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightFile";
                break;
            }
            case 77: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 106: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmpty";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 82: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 45: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createFragment";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createClipboardContent";
                break;
            }
            case 55: 
            case 56: 
            case 60: 
            case 61: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromBytes";
                break;
            }
            case 69: 
            case 72: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocumentFromBytes";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinary";
                break;
            }
            case 81: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentFromFile";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryImpl";
                break;
            }
            case 91: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "createImpl";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromBytesImpl";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporalFile";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 36: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 41: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 43: 
            case 44: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createFragment";
                break;
            }
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createFromBytes";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createDocumentFromBytes";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "createBinary";
                break;
            }
            case 80: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "createContentFromFile";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryImpl";
                break;
            }
            case 90: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "createImpl";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "createFromBytesImpl";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "createTemporalFile";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "createPsiDocument";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryContent";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "guessCharsetFromContent";
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createPsiDocument$1";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createContentFromFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 82: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

