/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.fragmented.ChangedBlock;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffChange {
    @NotNull
    private final UnifiedDiffViewer myViewer;
    @NotNull
    private final EditorEx myEditor;
    private int myLine1;
    private int myLine2;
    @NotNull
    private final LineFragment myLineFragment;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    @NotNull
    private final List<MyGutterOperation> myOperations;

    public UnifiedDiffChange(@NotNull UnifiedDiffViewer viewer, @NotNull ChangedBlock block) {
        if (viewer == null) {
            UnifiedDiffChange.$$$reportNull$$$0(0);
        }
        if (block == null) {
            UnifiedDiffChange.$$$reportNull$$$0(1);
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myOperations = new ArrayList<MyGutterOperation>();
        this.myViewer = viewer;
        this.myEditor = viewer.getEditor();
        this.myLine1 = block.getLine1();
        this.myLine2 = block.getLine2();
        this.myLineFragment = block.getLineFragment();
        LineRange deleted = block.getRange1();
        LineRange inserted = block.getRange2();
        this.installHighlighter(deleted, inserted);
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (MyGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    private void installHighlighter(@NotNull LineRange deleted, @NotNull LineRange inserted) {
        if (deleted == null) {
            UnifiedDiffChange.$$$reportNull$$$0(2);
        }
        if (inserted == null) {
            UnifiedDiffChange.$$$reportNull$$$0(3);
        }
        assert (this.myHighlighters.isEmpty());
        this.doInstallHighlighters(deleted, inserted);
        this.doInstallActionHighlighters();
    }

    private void doInstallActionHighlighters() {
        boolean leftEditable = this.myViewer.isEditable(Side.LEFT, false);
        boolean rightEditable = this.myViewer.isEditable(Side.RIGHT, false);
        if (leftEditable && rightEditable) {
            this.myOperations.add(this.createOperation(Side.LEFT));
            this.myOperations.add(this.createOperation(Side.RIGHT));
        } else if (rightEditable) {
            this.myOperations.add(this.createOperation(Side.LEFT));
        }
    }

    private void doInstallHighlighters(@NotNull LineRange deleted, @NotNull LineRange inserted) {
        if (deleted == null) {
            UnifiedDiffChange.$$$reportNull$$$0(4);
        }
        if (inserted == null) {
            UnifiedDiffChange.$$$reportNull$$$0(5);
        }
        this.myHighlighters.addAll(DiffDrawUtil.createUnifiedChunkHighlighters(this.myEditor, deleted, inserted, this.myLineFragment.getInnerFragments()));
    }

    public int getLine1() {
        return this.myLine1;
    }

    public int getLine2() {
        return this.myLine2;
    }

    @NotNull
    public LineFragment getLineFragment() {
        LineFragment lineFragment = this.myLineFragment;
        if (lineFragment == null) {
            UnifiedDiffChange.$$$reportNull$$$0(6);
        }
        return lineFragment;
    }

    public void processChange(int oldLine1, int oldLine2, int shift) {
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(this.myLine1, this.myLine2, oldLine1, oldLine2, shift);
        this.myLine1 = newRange.startLine;
        this.myLine2 = newRange.endLine;
    }

    public void updateGutterActions() {
        for (MyGutterOperation operation : this.myOperations) {
            operation.update();
        }
    }

    @NotNull
    private MyGutterOperation createOperation(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            UnifiedDiffChange.$$$reportNull$$$0(7);
        }
        int offset = this.myEditor.getDocument().getLineStartOffset(this.myLine1);
        RangeHighlighter highlighter = this.myEditor.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        MyGutterOperation myGutterOperation = new MyGutterOperation(sourceSide, highlighter);
        if (myGutterOperation == null) {
            UnifiedDiffChange.$$$reportNull$$$0(8);
        }
        return myGutterOperation;
    }

    @Nullable
    private GutterIconRenderer createIconRenderer(final @NotNull Side sourceSide, @NotNull String tooltipText, @NotNull Icon icon) {
        if (sourceSide == null) {
            UnifiedDiffChange.$$$reportNull$$$0(9);
        }
        if (tooltipText == null) {
            UnifiedDiffChange.$$$reportNull$$$0(10);
        }
        if (icon == null) {
            UnifiedDiffChange.$$$reportNull$$$0(11);
        }
        return new DiffGutterRenderer(icon, tooltipText){

            @Override
            protected void performAction(AnActionEvent e) {
                if (UnifiedDiffChange.this.myViewer.isStateIsOutOfDate()) {
                    return;
                }
                if (!UnifiedDiffChange.this.myViewer.isEditable(sourceSide.other(), true)) {
                    return;
                }
                Project project2 = e.getProject();
                Document document = UnifiedDiffChange.this.myViewer.getDocument(sourceSide.other());
                DiffUtil.executeWriteCommand(document, project2, "Replace change", () -> {
                    if (sourceSide == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    UnifiedDiffChange.this.myViewer.replaceChange(UnifiedDiffChange.this, sourceSide);
                    UnifiedDiffChange.this.myViewer.scheduleRediff();
                });
                UnifiedDiffChange.this.myViewer.rediff();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/tools/fragmented/UnifiedDiffChange$1", "lambda$performAction$0"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inserted";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffChange";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffChange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineFragment";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installHighlighter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doInstallHighlighters";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createOperation";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createIconRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyGutterOperation {
        @NotNull
        private final Side mySide;
        @NotNull
        private final RangeHighlighter myHighlighter;

        private MyGutterOperation(@NotNull Side sourceSide, RangeHighlighter highlighter) {
            if (sourceSide == null) {
                MyGutterOperation.$$$reportNull$$$0(0);
            }
            if (highlighter == null) {
                MyGutterOperation.$$$reportNull$$$0(1);
            }
            this.mySide = sourceSide;
            this.myHighlighter = highlighter;
            this.update();
        }

        public void dispose() {
            this.myHighlighter.dispose();
        }

        public void update() {
            if (this.myHighlighter.isValid()) {
                this.myHighlighter.setGutterIconRenderer(this.createRenderer());
            }
        }

        @Nullable
        public GutterIconRenderer createRenderer() {
            if (UnifiedDiffChange.this.myViewer.isStateIsOutOfDate()) {
                return null;
            }
            if (!UnifiedDiffChange.this.myViewer.isEditable(this.mySide.other(), true)) {
                return null;
            }
            if (this.mySide.isLeft()) {
                return UnifiedDiffChange.this.createIconRenderer(this.mySide, "Revert", AllIcons.Diff.Remove);
            }
            return UnifiedDiffChange.this.createIconRenderer(this.mySide, "Accept", AllIcons.Actions.Checked);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceSide";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "highlighter";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffChange$MyGutterOperation";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

