/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.lang.DiffIgnoredRangeProvider;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.SimpleTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProviderBase;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartTextDiffProvider
extends TwosideTextDiffProviderBase
implements TwosideTextDiffProvider {
    private static final IgnorePolicy[] IGNORE_POLICIES = new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES_CHUNKS, IgnorePolicy.FORMATTING};
    private static final HighlightPolicy[] HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD, HighlightPolicy.BY_WORD_SPLIT, HighlightPolicy.DO_NOT_HIGHLIGHT};
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContent myContent1;
    @NotNull
    private final DiffContent myContent2;
    @NotNull
    private final DiffIgnoredRangeProvider myProvider;

    @Nullable
    public static TwosideTextDiffProvider create(@Nullable Project project2, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        DiffContent content2;
        DiffContent content1;
        DiffIgnoredRangeProvider ignoredRangeProvider;
        if (request == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(1);
        }
        if (rediff == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(3);
        }
        if ((ignoredRangeProvider = SmartTextDiffProvider.getIgnoredRangeProvider(project2, content1 = (DiffContent)Side.LEFT.select(request.getContents()), content2 = (DiffContent)Side.RIGHT.select(request.getContents()))) == null) {
            return null;
        }
        return new SmartTextDiffProvider(project2, content1, content2, settings, rediff, disposable, ignoredRangeProvider);
    }

    @Nullable
    public static TwosideTextDiffProvider.NoIgnore createNoIgnore(@Nullable Project project2, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        DiffContent content2;
        DiffContent content1;
        DiffIgnoredRangeProvider ignoredRangeProvider;
        if (request == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(5);
        }
        if (rediff == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(6);
        }
        if (disposable == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(7);
        }
        if ((ignoredRangeProvider = SmartTextDiffProvider.getIgnoredRangeProvider(project2, content1 = (DiffContent)Side.LEFT.select(request.getContents()), content2 = (DiffContent)Side.RIGHT.select(request.getContents()))) == null) {
            return null;
        }
        return new NoIgnore(project2, content1, content2, settings, rediff, disposable, ignoredRangeProvider);
    }

    private SmartTextDiffProvider(@Nullable Project project2, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull DiffIgnoredRangeProvider ignoredRangeProvider) {
        if (content1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(8);
        }
        if (content2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(10);
        }
        if (rediff == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(11);
        }
        if (disposable == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(12);
        }
        if (ignoredRangeProvider == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(13);
        }
        this(project2, content1, content2, settings, rediff, disposable, ignoredRangeProvider, IGNORE_POLICIES, HIGHLIGHT_POLICIES);
    }

    private SmartTextDiffProvider(@Nullable Project project2, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull DiffIgnoredRangeProvider ignoredRangeProvider, @NotNull IgnorePolicy[] ignorePolicies, @NotNull HighlightPolicy[] highlightPolicies) {
        if (content1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(14);
        }
        if (content2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(15);
        }
        if (settings == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(16);
        }
        if (rediff == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(17);
        }
        if (disposable == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(18);
        }
        if (ignoredRangeProvider == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(19);
        }
        if (ignorePolicies == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(20);
        }
        if (highlightPolicies == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(21);
        }
        super(settings, rediff, disposable, ignorePolicies, highlightPolicies);
        this.myProject = project2;
        this.myContent1 = content1;
        this.myContent2 = content2;
        this.myProvider = ignoredRangeProvider;
    }

    @Override
    @Nullable
    protected String getText(@NotNull IgnorePolicy option) {
        if (option == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(22);
        }
        if (option == IgnorePolicy.FORMATTING) {
            return this.myProvider.getDescription();
        }
        return null;
    }

    @Override
    @NotNull
    protected List<LineFragment> doCompare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull IgnorePolicy ignorePolicy, boolean innerFragments, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(23);
        }
        if (text2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(24);
        }
        if (ignorePolicy == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(25);
        }
        if (indicator == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(26);
        }
        if (ignorePolicy == IgnorePolicy.FORMATTING) {
            List<LineFragment> list2 = this.compareIgnoreFormatting(text1, text2, innerFragments, indicator);
            if (list2 == null) {
                SmartTextDiffProvider.$$$reportNull$$$0(27);
            }
            return list2;
        }
        ComparisonPolicy policy = ignorePolicy.getComparisonPolicy();
        List<LineFragment> list3 = SimpleTextDiffProvider.DEFAULT_COMPUTER.compute(text1, text2, policy, innerFragments, indicator);
        if (list3 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(28);
        }
        return list3;
    }

    @NotNull
    private List<LineFragment> compareIgnoreFormatting(@NotNull CharSequence text1, @NotNull CharSequence text2, boolean innerFragments, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(29);
        }
        if (text2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(30);
        }
        if (indicator == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(31);
        }
        List<TextRange> ranges1 = this.myProvider.getIgnoredRanges(this.myProject, text1, this.myContent1);
        List<TextRange> ranges2 = this.myProvider.getIgnoredRanges(this.myProject, text2, this.myContent2);
        ComparisonManagerImpl comparisonManager = ComparisonManagerImpl.getInstanceImpl();
        List<LineFragment> list2 = comparisonManager.compareLinesWithIgnoredRanges(text1, text2, ranges1, ranges2, innerFragments, indicator);
        if (list2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(32);
        }
        return list2;
    }

    @Nullable
    private static DiffIgnoredRangeProvider getIgnoredRangeProvider(@Nullable Project project2, @NotNull DiffContent content1, @NotNull DiffContent content2) {
        if (content1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(33);
        }
        if (content2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(34);
        }
        if (!Registry.is((String)"diff.smart.ignore.enabled")) {
            return null;
        }
        for (DiffIgnoredRangeProvider provider : (DiffIgnoredRangeProvider[])DiffIgnoredRangeProvider.EP_NAME.getExtensions()) {
            if (!provider.accepts(project2, content1) || !provider.accepts(project2, content2)) continue;
            return provider;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 28: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 28: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rediff";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 8: 
            case 14: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content1";
                break;
            }
            case 9: 
            case 15: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content2";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredRangeProvider";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePolicies";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightPolicies";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePolicy";
                break;
            }
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 27: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/text/SmartTextDiffProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/text/SmartTextDiffProvider";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompare";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "compareIgnoreFormatting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNoIgnore";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doCompare";
                break;
            }
            case 27: 
            case 28: 
            case 32: {
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "compareIgnoreFormatting";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredRangeProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 28: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NoIgnore
    extends SmartTextDiffProvider
    implements TwosideTextDiffProvider.NoIgnore {
        private NoIgnore(@Nullable Project project2, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull DiffIgnoredRangeProvider ignoredRangeProvider) {
            if (content1 == null) {
                NoIgnore.$$$reportNull$$$0(0);
            }
            if (content2 == null) {
                NoIgnore.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                NoIgnore.$$$reportNull$$$0(2);
            }
            if (rediff == null) {
                NoIgnore.$$$reportNull$$$0(3);
            }
            if (disposable == null) {
                NoIgnore.$$$reportNull$$$0(4);
            }
            if (ignoredRangeProvider == null) {
                NoIgnore.$$$reportNull$$$0(5);
            }
            super(project2, content1, content2, settings, rediff, disposable, ignoredRangeProvider, IGNORE_POLICIES, (HighlightPolicy[])ArrayUtil.remove((Object[])HIGHLIGHT_POLICIES, (Object)((Object)HighlightPolicy.DO_NOT_HIGHLIGHT)));
        }

        @Override
        @NotNull
        public List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            if (text1 == null) {
                NoIgnore.$$$reportNull$$$0(6);
            }
            if (text2 == null) {
                NoIgnore.$$$reportNull$$$0(7);
            }
            if (indicator == null) {
                NoIgnore.$$$reportNull$$$0(8);
            }
            List list2 = super.compare(text1, text2, indicator);
            if (list2 == null) {
                NoIgnore.$$$reportNull$$$0(9);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rediff";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignoredRangeProvider";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compare";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

