/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.TreeHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.TreeHashResult;
import com.intellij.dupLocator.treeHash.TreeHashingUtils;
import com.intellij.dupLocator.treeHash.TreePsiFragment;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTreeHasher
implements TreeHasher {
    protected final boolean myForIndexing;
    protected final FragmentsCollector myCallBack;

    public AbstractTreeHasher(FragmentsCollector cb, boolean forIndexing) {
        this.myCallBack = cb;
        this.myForIndexing = forIndexing;
    }

    @Override
    public final void hash(@NotNull PsiElement root, @NotNull NodeSpecificHasher hasher) {
        if (root == null) {
            AbstractTreeHasher.$$$reportNull$$$0(0);
        }
        if (hasher == null) {
            AbstractTreeHasher.$$$reportNull$$$0(1);
        }
        this.hash(root, null, hasher);
    }

    protected abstract TreeHashResult hash(@NotNull PsiElement var1, PsiFragment var2, @NotNull NodeSpecificHasher var3);

    protected TreeHashResult computeElementHash(@NotNull PsiElement root, PsiFragment upper, NodeSpecificHasher hasher) {
        if (root == null) {
            AbstractTreeHasher.$$$reportNull$$$0(2);
        }
        if (this.myForIndexing) {
            return TreeHashingUtils.computeElementHashForIndexing(this, this.myCallBack, root, upper, hasher);
        }
        ProgressManager.checkCanceled();
        List<PsiElement> children2 = hasher.getNodeChildren(root);
        int size = children2.size();
        int[] childHashes = new int[size];
        int[] childCosts = new int[size];
        TreePsiFragment fragment = this.buildFragment(hasher, root, this.getCost(root));
        if (upper != null) {
            fragment.setParent(upper);
        }
        if (size == 0 && !(root instanceof LeafElement)) {
            return new TreeHashResult(hasher.getNodeHash(root), hasher.getNodeCost(root), fragment);
        }
        for (int i = 0; i < size; ++i) {
            TreeHashResult res = this.hash(children2.get(i), fragment, hasher);
            childHashes[i] = res.getHash();
            childCosts[i] = res.getCost();
        }
        int c = hasher.getNodeCost(root) + AbstractTreeHasher.vector(childCosts);
        int h1 = hasher.getNodeHash(root);
        int discardCost = this.getDiscardCost(root);
        for (int i = 0; i < size; ++i) {
            if (childCosts[i] > discardCost || !this.ignoreChildHash(children2.get(i))) continue;
            childHashes[i] = 0;
        }
        int h = h1 + AbstractTreeHasher.vector(childHashes);
        if (this.myCallBack != null) {
            this.myCallBack.add(h, c, fragment);
        }
        return new TreeHashResult(h, c, fragment);
    }

    protected TreePsiFragment buildFragment(NodeSpecificHasher hasher, PsiElement root, int cost) {
        if (this.myForIndexing) {
            return new TreePsiFragment(hasher, root, cost){

                @Override
                protected PsiAnchor createAnchor(PsiElement element) {
                    return new PsiAnchor.HardReference(element);
                }

                @Override
                protected Language calcLanguage(PsiElement element) {
                    return null;
                }
            };
        }
        return new TreePsiFragment(hasher, root, cost);
    }

    protected TreePsiFragment buildFragment(NodeSpecificHasher hasher, List<? extends PsiElement> elements, int from, int to) {
        if (this.myForIndexing) {
            return new TreePsiFragment(hasher, elements, from, to){

                @Override
                protected PsiAnchor createAnchor(PsiElement element) {
                    return new PsiAnchor.HardReference(element);
                }

                @Override
                protected Language calcLanguage(PsiElement element) {
                    return null;
                }
            };
        }
        return new TreePsiFragment(hasher, elements, from, to);
    }

    protected abstract int getDiscardCost(PsiElement var1);

    protected boolean ignoreChildHash(PsiElement element) {
        return false;
    }

    protected TreeHashResult hashCodeBlock(List<? extends PsiElement> statements, PsiFragment upper, NodeSpecificHasher hasher) {
        return this.hashCodeBlock(statements, upper, hasher, false);
    }

    protected TreeHashResult hashCodeBlock(List<? extends PsiElement> statements, PsiFragment upper, NodeSpecificHasher hasher, boolean forceHash) {
        int statementsSize = statements.size();
        if (statementsSize == 1) {
            return this.hash(statements.get(0), upper, hasher);
        }
        if (statementsSize > 0 && (statementsSize < 20 || forceHash)) {
            PsiFragment[] frags = new PsiFragment[statementsSize];
            TreePsiFragment fragment = this.buildFragment(hasher, statements, 0, statementsSize - 1);
            fragment.setParent(upper);
            int[] hashes = new int[statementsSize];
            int[] costs = new int[statementsSize];
            for (int i = 0; i < statementsSize; ++i) {
                TreeHashResult res = this.hash(statements.get(i), null, hasher);
                hashes[i] = res.getHash();
                costs[i] = res.getCost();
                frags[i] = res.getFragment();
            }
            if (this.myCallBack != null) {
                PsiFragment[] parents2 = new PsiFragment[statementsSize];
                for (int beg = 0; beg < statementsSize; ++beg) {
                    int hash = 0;
                    int cost = 0;
                    for (int end = beg; end < statementsSize && end - beg < 20; ++end) {
                        PsiFragment curr;
                        hash = 31 * hash + hashes[end];
                        cost += costs[end];
                        PsiFragment psiFragment = beg == end ? frags[beg] : (curr = beg == 0 && end == statementsSize - 1 ? fragment : this.buildFragment(hasher, statements, beg, end));
                        if (beg > 0) {
                            curr.setParent(parents2[end]);
                        }
                        parents2[end] = curr;
                        if (end > beg) {
                            parents2[end - 1].setParent(curr);
                        }
                        this.myCallBack.add(hash, cost, curr);
                    }
                }
            }
            return new TreeHashResult(AbstractTreeHasher.vector(hashes, 31), AbstractTreeHasher.vector(costs), fragment);
        }
        return new TreeHashResult(1, 0, this.buildFragment(hasher, statements, 0, statementsSize - 1));
    }

    protected int getCost(PsiElement root) {
        return 0;
    }

    public static int vector(int[] args) {
        return AbstractTreeHasher.vector(args, 1);
    }

    public static int vector(int[] args, int mult) {
        int sum = 0;
        for (int arg : args) {
            sum = mult * sum + arg;
        }
        return sum;
    }

    public boolean shouldAnonymize(PsiElement root, NodeSpecificHasher hasher) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasher";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/treeHash/AbstractTreeHasher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hash";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "computeElementHash";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

