/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ExternalizablePath
implements JDOMExternalizable {
    @NonNls
    private static final String VALUE_ATTRIBUTE = "value";
    private String myUrl;

    public void readExternal(Element element) throws InvalidDataException {
        String value2 = element.getAttributeValue(VALUE_ATTRIBUTE);
        this.myUrl = value2 != null ? value2 : "";
        String protocol = VirtualFileManager.extractProtocol((String)this.myUrl);
        if (protocol == null) {
            this.myUrl = ExternalizablePath.urlValue(this.myUrl);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(VALUE_ATTRIBUTE, this.myUrl);
    }

    public String getLocalPath() {
        return ExternalizablePath.localPathValue(this.myUrl);
    }

    public static String urlValue(String localPath) {
        return StringUtil.isEmptyOrSpaces((String)localPath) ? "" : VirtualFileManager.constructUrl((String)"file", (String)localPath.trim().replace(File.separatorChar, '/'));
    }

    public static String localPathValue(@Nullable String url) {
        return StringUtil.isEmptyOrSpaces((String)url) ? "" : VirtualFileManager.extractPath((String)url.trim()).replace('/', File.separatorChar);
    }
}

