/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.actions.RunConfigurationTreeAction;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;

public class CopyConfigurationAction
extends RunConfigurationTreeAction {
    public CopyConfigurationAction() {
        super(ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), PlatformIcons.COPY_ICON);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CopyConfigurationAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setText(ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]) + "...");
        }
    }

    protected boolean isEnabled4(RunDashboardRunConfigurationNode node) {
        Project project2 = node.getProject();
        return !project2.isDisposed() && RunDashboardManager.getInstance((Project)project2).isShowConfigurations() && RunManager.getInstance((Project)node.getProject()).hasSettings(node.getConfigurationSettings());
    }

    protected void doActionPerformed(RunDashboardRunConfigurationNode node) {
        RunManager runManager = RunManager.getInstance((Project)node.getProject());
        RunnerAndConfigurationSettings settings = node.getConfigurationSettings();
        RunnerAndConfigurationSettingsImpl copiedSettings = ((RunnerAndConfigurationSettingsImpl)settings).clone();
        runManager.setUniqueNameIfNeed((RunnerAndConfigurationSettings)copiedSettings);
        copiedSettings.setFolderName(settings.getFolderName());
        ConfigurationFactory factory = settings.getFactory();
        if (factory instanceof ConfigurationFactoryEx) {
            ((ConfigurationFactoryEx)factory).onConfigurationCopied(settings.getConfiguration());
        }
        if (RunDialog.editConfiguration(node.getProject(), copiedSettings, ExecutionBundle.message((String)"run.dashboard.edit.configuration.dialog.title", (Object[])new Object[0]))) {
            runManager.addConfiguration((RunnerAndConfigurationSettings)copiedSettings, settings.isShared());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/dashboard/actions/CopyConfigurationAction", "update"));
    }
}

