/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.execution.jshell.JShellDiagnostic;
import com.intellij.execution.jshell.JShellHandler;
import com.intellij.execution.jshell.SnippetEditorDecorator;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJShellFile;
import com.intellij.psi.PsiJShellHolderMethod;
import com.intellij.psi.PsiJShellSyntheticElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExecuteJShellAction
extends AnAction {
    private static final AnAction ourInstance = new ExecuteJShellAction();
    private boolean myIsExecuteContextElement = false;

    private ExecuteJShellAction() {
        super(AllIcons.Toolwindows.ToolWindowRun);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor == null) {
            return;
        }
        VirtualFile vFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        if (vFile == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            JShellHandler handler2 = JShellHandler.getAssociatedHandler(vFile);
            if (handler2 == null) {
                SnippetEditorDecorator.ConfigurationPane config = SnippetEditorDecorator.getJShellConfiguration(e.getDataContext());
                Module module2 = config != null ? config.getContextModule() : null;
                Sdk sdk = config != null ? config.getRuntimeSdk() : null;
                handler2 = JShellHandler.create(project2, vFile, module2, sdk);
            }
            if (handler2 != null) {
                handler2.toFront();
                boolean hasDataToEvaluate = false;
                Document document = editor.getDocument();
                TextRange selectedRange = EditorUtil.getSelectionInAnyMode(editor);
                if (selectedRange.isEmpty()) {
                    PsiElement snippet = this.getSnippetFromContext(project2, e);
                    if (snippet instanceof PsiJShellFile) {
                        for (PsiElement element : ((PsiJShellFile)snippet).getExecutableSnippets()) {
                            hasDataToEvaluate |= ExecuteJShellAction.scheduleEval(handler2, element.getText());
                        }
                    } else if (snippet != null) {
                        hasDataToEvaluate = ExecuteJShellAction.scheduleEval(handler2, snippet.getText());
                    }
                } else {
                    hasDataToEvaluate = ExecuteJShellAction.scheduleEval(handler2, document.getText(selectedRange));
                }
                if (!hasDataToEvaluate) {
                    JShellDiagnostic.notifyInfo("Nothing to execute", project2);
                }
            }
        }
        catch (Exception ex) {
            JShellDiagnostic.notifyError(ex, project2);
        }
    }

    private static boolean scheduleEval(@NotNull JShellHandler handler2, String code2) {
        if (handler2 == null) {
            ExecuteJShellAction.$$$reportNull$$$0(0);
        }
        if (!StringUtil.isEmptyOrSpaces((String)code2)) {
            handler2.evaluate(code2.trim());
            return true;
        }
        return false;
    }

    @Nullable
    private PsiElement getSnippetFromContext(Project project2, AnActionEvent e) {
        PsiFile file2;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null && (file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument())) instanceof PsiJShellFile) {
            PsiElement element;
            PsiElement psiElement = element = this.myIsExecuteContextElement ? ExecuteJShellAction.getContextElement(file2, editor.getDocument(), editor.getCaretModel().getOffset()) : null;
            while (element != null) {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiJShellHolderMethod && element instanceof PsiEmptyStatement) {
                    element = parent.getPrevSibling();
                    if (!(element instanceof PsiJShellSyntheticElement)) continue;
                    element = element.getFirstChild();
                    break;
                }
                if (parent instanceof PsiJShellSyntheticElement || parent instanceof PsiJShellFile) break;
                element = parent;
            }
            return element != null ? element : file2;
        }
        return null;
    }

    private static PsiElement getContextElement(PsiFile file2, Document doc, int offset) {
        int begin = DocumentUtil.getLineStartOffset(offset, doc);
        PsiElement result2 = null;
        for (int off = offset; off >= begin && ((result2 = file2.findElementAt(off)) == null || result2 instanceof PsiWhiteSpace); --off) {
        }
        return result2;
    }

    public static AnAction getSharedInstance() {
        return ourInstance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/jshell/ExecuteJShellAction", "scheduleEval"));
    }
}

