/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.remote;

import com.intellij.debugger.engine.RemoteStateState;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.remote.RemoteConfigurable;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RemoteConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements RunConfigurationWithSuppressedDefaultRunAction,
RemoteRunProfile {
    public boolean USE_SOCKET_TRANSPORT;
    public boolean SERVER_MODE;
    public String SHMEM_ADDRESS;
    public String HOST;
    public String PORT;

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        String moduleName = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModuleName();
        if (!StringUtil.isEmpty((String)moduleName)) {
            this.writeModule(element);
        }
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.readModule(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public RemoteConfiguration(Project project2, ConfigurationFactory configurationFactory) {
        super((RunConfigurationModule)new JavaRunConfigurationModule(project2, true), configurationFactory);
    }

    public RemoteConnection createRemoteConnection() {
        return new RemoteConnection(this.USE_SOCKET_TRANSPORT, this.HOST, this.USE_SOCKET_TRANSPORT ? this.PORT : this.SHMEM_ADDRESS, this.SERVER_MODE);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        GenericDebuggerRunnerSettings debuggerSettings;
        if (executor == null) {
            RemoteConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            RemoteConfiguration.$$$reportNull$$$0(1);
        }
        if ((debuggerSettings = (GenericDebuggerRunnerSettings)env.getRunnerSettings()) != null) {
            debuggerSettings.LOCAL = false;
            debuggerSettings.setDebugPort(this.USE_SOCKET_TRANSPORT ? this.PORT : this.SHMEM_ADDRESS);
            debuggerSettings.setTransport(this.USE_SOCKET_TRANSPORT ? 0 : 1);
        }
        return new RemoteStateState(this.getProject(), this.createRemoteConnection());
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new RemoteConfigurable(this.getProject()));
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            RemoteConfiguration.$$$reportNull$$$0(2);
        }
        return settingsEditorGroup;
    }

    public Collection<Module> getValidModules() {
        return this.getAllModules();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/remote/RemoteConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/remote/RemoteConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

