/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentBuilder
extends RunTab {
    private static final String JAVA_RUNNER = "JavaRunner";
    private final List<AnAction> myRunnerActions;
    private final ExecutionResult myExecutionResult;

    public RunContentBuilder(@NotNull ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        if (executionResult == null) {
            RunContentBuilder.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            RunContentBuilder.$$$reportNull$$$0(1);
        }
        super(environment, RunContentBuilder.getRunnerType(executionResult.getExecutionConsole()));
        this.myRunnerActions = new SmartList();
        this.myExecutionResult = executionResult;
        this.myUi.getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
    }

    @NotNull
    public static ExecutionEnvironment fix(@NotNull ExecutionEnvironment environment, @Nullable ProgramRunner runner) {
        if (environment == null) {
            RunContentBuilder.$$$reportNull$$$0(2);
        }
        if (runner == null || runner.equals(environment.getRunner())) {
            ExecutionEnvironment executionEnvironment = environment;
            if (executionEnvironment == null) {
                RunContentBuilder.$$$reportNull$$$0(3);
            }
            return executionEnvironment;
        }
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironmentBuilder(environment).runner(runner).build();
        if (executionEnvironment == null) {
            RunContentBuilder.$$$reportNull$$$0(4);
        }
        return executionEnvironment;
    }

    public void addAction(@NotNull AnAction action) {
        if (action == null) {
            RunContentBuilder.$$$reportNull$$$0(5);
        }
        this.myRunnerActions.add(action);
    }

    @NotNull
    private RunContentDescriptor createDescriptor() {
        RunProfile profile2 = this.myEnvironment.getRunProfile();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            RunContentDescriptor runContentDescriptor = new RunContentDescriptor(profile2, this.myExecutionResult, this.myUi);
            if (runContentDescriptor == null) {
                RunContentBuilder.$$$reportNull$$$0(6);
            }
            return runContentDescriptor;
        }
        ExecutionConsole console = this.myExecutionResult.getExecutionConsole();
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(profile2, this.myExecutionResult, this.myUi);
        if (console != null) {
            if (console instanceof ExecutionConsoleEx) {
                ((ExecutionConsoleEx)console).buildUi(this.myUi);
            } else {
                RunContentBuilder.buildConsoleUiDefault(this.myUi, console);
            }
            this.initLogConsoles(profile2, contentDescriptor, console);
        }
        this.myUi.getOptions().setLeftToolbar(this.createActionToolbar(contentDescriptor), "RunnerToolbar");
        if (profile2 instanceof RunConfigurationBase && console instanceof ObservableConsoleView && !ApplicationManager.getApplication().isUnitTestMode()) {
            ((ObservableConsoleView)console).addChangeListener((ObservableConsoleView.ChangeListener)new ConsoleToFrontListener((RunConfigurationBase)profile2, this.myProject, this.myEnvironment.getExecutor(), contentDescriptor, this.myUi), (Disposable)this);
        }
        RunContentDescriptor runContentDescriptor = contentDescriptor;
        if (runContentDescriptor == null) {
            RunContentBuilder.$$$reportNull$$$0(7);
        }
        return runContentDescriptor;
    }

    @NotNull
    private static String getRunnerType(@Nullable ExecutionConsole console) {
        String id;
        if (console instanceof ExecutionConsoleEx && (id = ((ExecutionConsoleEx)console).getExecutionConsoleId()) != null) {
            String string = "JavaRunner." + id;
            if (string == null) {
                RunContentBuilder.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (JAVA_RUNNER == null) {
            RunContentBuilder.$$$reportNull$$$0(9);
        }
        return JAVA_RUNNER;
    }

    public static void buildConsoleUiDefault(RunnerLayoutUi ui, ExecutionConsole console) {
        Content consoleContent = ui.createContent("ConsoleContent", console.getComponent(), "Console", AllIcons.Debugger.Console, console.getPreferredFocusableComponent());
        consoleContent.setCloseable(false);
        RunContentBuilder.addAdditionalConsoleEditorActions(console, consoleContent);
        ui.addContent(consoleContent, 0, PlaceInGrid.bottom, false);
    }

    public static void addAdditionalConsoleEditorActions(ExecutionConsole console, Content consoleContent) {
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        if (console instanceof ConsoleView) {
            for (AnAction action : ((ConsoleView)console).createConsoleActions()) {
                consoleActions.add(action);
            }
        }
        consoleContent.setActions((ActionGroup)consoleActions, "RunnerToolbar", console.getComponent());
    }

    @NotNull
    private ActionGroup createActionToolbar(@NotNull RunContentDescriptor contentDescriptor) {
        if (contentDescriptor == null) {
            RunContentBuilder.$$$reportNull$$$0(10);
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("Rerun"));
        AnAction[] actions = contentDescriptor.getRestartActions();
        actionGroup.addAll(actions);
        if (actions.length > 0) {
            actionGroup.addSeparator();
        }
        actionGroup.add(ActionManager.getInstance().getAction("Stop"));
        actionGroup.addAll(this.myExecutionResult.getActions());
        for (AnAction anAction : this.myRunnerActions) {
            if (anAction != null) {
                actionGroup.add(anAction);
                continue;
            }
            actionGroup.addSeparator();
        }
        actionGroup.addSeparator();
        actionGroup.add(this.myUi.getOptions().getLayoutActions());
        actionGroup.addSeparator();
        actionGroup.add(PinToolwindowTabAction.getPinAction());
        actionGroup.add((AnAction)new CloseAction(this.myEnvironment.getExecutor(), contentDescriptor, this.myProject));
        String helpId = contentDescriptor.getHelpId();
        actionGroup.add((AnAction)new ContextHelpAction(helpId != null ? helpId : this.myEnvironment.getExecutor().getHelpId()));
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            RunContentBuilder.$$$reportNull$$$0(11);
        }
        return defaultActionGroup;
    }

    public RunContentDescriptor showRunContent(@Nullable RunContentDescriptor reuseContent) {
        RunContentDescriptor descriptor2 = this.createDescriptor();
        Disposer.register((Disposable)descriptor2, (Disposable)this);
        Disposer.register((Disposable)this.myProject, (Disposable)descriptor2);
        RunContentManagerImpl.copyContentAndBehavior(descriptor2, reuseContent);
        this.myRunContentDescriptor = descriptor2;
        return descriptor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/runners/RunContentBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/runners/RunContentBuilder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fix";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createActionToolbar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConsoleToFrontListener
    implements ObservableConsoleView.ChangeListener {
        @NotNull
        private final RunConfigurationBase myRunConfigurationBase;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Executor myExecutor;
        @NotNull
        private final RunContentDescriptor myRunContentDescriptor;
        @NotNull
        private final RunnerLayoutUi myUi;

        public ConsoleToFrontListener(@NotNull RunConfigurationBase runConfigurationBase, @NotNull Project project2, @NotNull Executor executor, @NotNull RunContentDescriptor runContentDescriptor, @NotNull RunnerLayoutUi ui) {
            if (runConfigurationBase == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(0);
            }
            if (project2 == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(1);
            }
            if (executor == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(2);
            }
            if (runContentDescriptor == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(3);
            }
            if (ui == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(4);
            }
            this.myRunConfigurationBase = runConfigurationBase;
            this.myProject = project2;
            this.myExecutor = executor;
            this.myRunContentDescriptor = runContentDescriptor;
            this.myUi = ui;
        }

        public void contentAdded(Collection<ConsoleViewContentType> types) {
            if (this.myProject.isDisposed() || this.myUi.isDisposed()) {
                return;
            }
            for (ConsoleViewContentType type2 : types) {
                if ((type2 != ConsoleViewContentType.NORMAL_OUTPUT || !this.myRunConfigurationBase.isShowConsoleOnStdOut()) && (type2 != ConsoleViewContentType.ERROR_OUTPUT || !this.myRunConfigurationBase.isShowConsoleOnStdErr())) continue;
                ExecutionManager.getInstance((Project)this.myProject).getContentManager().toFrontRunContent(this.myExecutor, this.myRunContentDescriptor);
                this.myUi.selectAndFocus(this.myUi.findContent("ConsoleContent"), false, false);
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runConfigurationBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runContentDescriptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ui";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/runners/RunContentBuilder$ConsoleToFrontListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

