/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryExtension;
import com.intellij.execution.testDiscovery.TestInfoHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PathKt;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiscoveryIndex
implements Disposable {
    static final Logger LOG = Logger.getInstance(TestDiscoveryIndex.class);
    private final TestDataController myLocalTestRunDataController;
    private final TestDataController myRemoteTestRunDataController;

    public TestDiscoveryIndex(Project project2) {
        this(project2, TestDiscoveryExtension.baseTestDiscoveryPathForProject(project2));
    }

    public TestDiscoveryIndex(Project project2, @NotNull Path basePath) {
        if (basePath == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(0);
        }
        this.myLocalTestRunDataController = new TestDataController(basePath, false);
        this.myRemoteTestRunDataController = new TestDataController(null, true);
        if (Files.exists(basePath, new LinkOption[0])) {
            StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> this.myLocalTestRunDataController.getHolder()));
        }
    }

    public boolean hasTestTrace(@NotNull String testName) throws IOException {
        Boolean result2;
        if (testName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(1);
        }
        return (result2 = (Boolean)this.myLocalTestRunDataController.withTestDataHolder(localHolder -> {
            int testNameId;
            if (testName == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(12);
            }
            if ((testNameId = localHolder.myTestNameEnumerator.tryEnumerate((Object)testName)) == 0) {
                return this.myRemoteTestRunDataController.withTestDataHolder(remoteHolder -> {
                    int testNameId1;
                    if (testName == null) {
                        TestDiscoveryIndex.$$$reportNull$$$0(13);
                    }
                    return (testNameId1 = remoteHolder.myTestNameEnumerator.tryEnumerate((Object)testName)) != 0 && remoteHolder.myTestNameToUsedClassesAndMethodMap.get((Object)testNameId1) != null;
                }) != null;
            }
            return localHolder.myTestNameToUsedClassesAndMethodMap.get((Object)testNameId) != null;
        })) == Boolean.TRUE;
    }

    public void removeTestTrace(@NotNull String testName) throws IOException {
        if (testName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(2);
        }
        this.myLocalTestRunDataController.withTestDataHolder(localHolder -> {
            int testNameId;
            if (testName == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(11);
            }
            if ((testNameId = localHolder.myTestNameEnumerator.tryEnumerate((Object)testName)) != 0) {
                localHolder.doUpdateFromDiff(testNameId, null, (TIntObjectHashMap<TIntArrayList>)((TIntObjectHashMap)localHolder.myTestNameToUsedClassesAndMethodMap.get((Object)testNameId)), null);
            }
            return null;
        });
    }

    public void setRemoteTestRunDataPath(@NotNull Path path) {
        if (path == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(3);
        }
        if (!TestInfoHolder.isValidPath(path)) {
            path = null;
        }
        this.myRemoteTestRunDataController.init(path);
    }

    public Collection<String> getTestsByMethodName(final @NotNull String classFQName, final @NotNull String methodName) throws IOException {
        if (classFQName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(4);
        }
        if (methodName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(5);
        }
        return this.myLocalTestRunDataController.withTestDataHolder(new ThrowableConvertor<TestInfoHolder, Collection<String>, IOException>(){

            public Collection<String> convert(TestInfoHolder localHolder) throws IOException {
                TIntArrayList remoteList = (TIntArrayList)TestDiscoveryIndex.this.myRemoteTestRunDataController.withTestDataHolder(remoteHolder -> {
                    if (classFQName == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (methodName == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return (TIntArrayList)remoteHolder.myMethodQNameToTestNames.get((Object)TestInfoHolder.createKey(remoteHolder.myClassEnumerator.enumerate(classFQName), remoteHolder.myMethodEnumerator.enumerate(methodName)));
                });
                TIntArrayList localList = (TIntArrayList)localHolder.myMethodQNameToTestNames.get((Object)TestInfoHolder.createKey(localHolder.myClassEnumerator.enumerate(classFQName), localHolder.myMethodEnumerator.enumerate(methodName)));
                if (remoteList == null) {
                    return this.testIdsToTestNames(localList, localHolder);
                }
                Collection testsFromRemote = (Collection)TestDiscoveryIndex.this.myRemoteTestRunDataController.withTestDataHolder(remoteHolder -> this.testIdsToTestNames(remoteList, (TestInfoHolder)remoteHolder));
                if (localList == null) {
                    return testsFromRemote;
                }
                THashSet setOfStrings = new THashSet(testsFromRemote);
                for (int testNameId : localList.toNativeArray()) {
                    if (testNameId < 0) {
                        setOfStrings.remove((Object)localHolder.myTestNameEnumerator.valueOf(-testNameId));
                        continue;
                    }
                    setOfStrings.add((Object)localHolder.myTestNameEnumerator.valueOf(testNameId));
                }
                return setOfStrings;
            }

            private Collection<String> testIdsToTestNames(TIntArrayList localList, TestInfoHolder localHolder) throws IOException {
                if (localList == null) {
                    return Collections.emptyList();
                }
                ArrayList<String> result2 = new ArrayList<String>(localList.size());
                for (int testNameId : localList.toNativeArray()) {
                    if (testNameId < 0) {
                        boolean a = true;
                        continue;
                    }
                    result2.add(localHolder.myTestNameEnumerator.valueOf(testNameId));
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "classFQName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "methodName";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/testDiscovery/TestDiscoveryIndex$1";
                objectArray[2] = "lambda$convert$0";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public Collection<String> getTestModulesByMethodName(final @NotNull String classFQName, final @NotNull String methodName, final String prefix) throws IOException {
        if (classFQName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(6);
        }
        if (methodName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(7);
        }
        return this.myLocalTestRunDataController.withTestDataHolder(new ThrowableConvertor<TestInfoHolder, Collection<String>, IOException>(){

            public Collection<String> convert(TestInfoHolder localHolder) throws IOException {
                List<String> modules = this.getTestModules(localHolder);
                List modulesFromRemote = (List)TestDiscoveryIndex.this.myRemoteTestRunDataController.withTestDataHolder(this::getTestModules);
                THashSet modulesSet = new THashSet(modules);
                if (modulesFromRemote != null) {
                    modulesSet.addAll((Collection)modulesFromRemote);
                }
                return modulesSet;
            }

            private List<String> getTestModules(TestInfoHolder holder) throws IOException {
                TIntArrayList list2 = (TIntArrayList)holder.myTestNameToNearestModule.get((Object)TestInfoHolder.createKey(holder.myClassEnumerator.enumerate(classFQName), holder.myMethodEnumerator.enumerate(methodName)));
                if (list2 == null) {
                    return Collections.emptyList();
                }
                ArrayList<String> result2 = new ArrayList<String>(list2.size());
                for (int moduleNameId : list2.toNativeArray()) {
                    String moduleNameWithPrefix = holder.myModuleNameEnumerator.valueOf(moduleNameId);
                    if (moduleNameWithPrefix == null || !moduleNameWithPrefix.startsWith(prefix)) continue;
                    result2.add(moduleNameWithPrefix.substring(prefix.length()));
                }
                return result2;
            }
        });
    }

    public static TestDiscoveryIndex getInstance(Project project2) {
        return (TestDiscoveryIndex)project2.getComponent(TestDiscoveryIndex.class);
    }

    public void dispose() {
        this.myLocalTestRunDataController.dispose();
        this.myRemoteTestRunDataController.dispose();
    }

    public void updateFromTestTrace(@NotNull File file2, @Nullable String moduleName, @NotNull String frameworkPrefix) throws IOException {
        int fileNameDotIndex;
        if (file2 == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(8);
        }
        if (frameworkPrefix == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(9);
        }
        String testName = (fileNameDotIndex = file2.getName().lastIndexOf(46)) != -1 ? file2.getName().substring(0, fileNameDotIndex) : file2.getName();
        this.doUpdateFromTestTrace(file2, testName, moduleName != null ? frameworkPrefix + moduleName : null);
    }

    private void doUpdateFromTestTrace(File file2, String testName, @Nullable String moduleName) throws IOException {
        this.myLocalTestRunDataController.withTestDataHolder(localHolder -> {
            int testNameId = localHolder.myTestNameEnumerator.enumerate(testName);
            TIntObjectHashMap<TIntArrayList> classData = TestDiscoveryIndex.loadClassAndMethodsMap(file2, localHolder);
            TIntObjectHashMap previousClassData = (TIntObjectHashMap)localHolder.myTestNameToUsedClassesAndMethodMap.get((Object)testNameId);
            if (previousClassData == null) {
                previousClassData = (TIntObjectHashMap)this.myRemoteTestRunDataController.withTestDataHolder(remoteDataHolder -> {
                    Ref exceptionRef;
                    TIntObjectHashMap remoteClassData = (TIntObjectHashMap)remoteDataHolder.myTestNameToUsedClassesAndMethodMap.get((Object)testNameId);
                    if (remoteClassData == null) {
                        return null;
                    }
                    TIntObjectHashMap result2 = new TIntObjectHashMap(remoteClassData.size());
                    boolean processingResult = remoteClassData.forEachEntry((arg_0, arg_1) -> TestDiscoveryIndex.lambda$null$5(localHolder, remoteDataHolder, result2, exceptionRef = new Ref(), arg_0, arg_1));
                    if (!processingResult) {
                        throw (IOException)exceptionRef.get();
                    }
                    return result2;
                });
            }
            localHolder.doUpdateFromDiff(testNameId, classData, (TIntObjectHashMap<TIntArrayList>)previousClassData, moduleName != null ? Integer.valueOf(localHolder.myModuleNameEnumerator.enumerate(moduleName)) : null);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static TIntObjectHashMap<TIntArrayList> loadClassAndMethodsMap(File file2, TestInfoHolder holder) throws IOException {
        DataInputStream inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file2), 65536));
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        int numberOfClasses = DataInputOutputUtil.readINT((DataInput)inputStream);
        TIntObjectHashMap classData = new TIntObjectHashMap(numberOfClasses);
        while (numberOfClasses-- > 0) {
            String classQName = IOUtil.readUTFFast((byte[])buffer, (DataInput)inputStream);
            int classId = holder.myClassEnumeratorCache.enumerate((Object)classQName);
            int numberOfMethods = DataInputOutputUtil.readINT((DataInput)inputStream);
            TIntArrayList methodsList = new TIntArrayList(numberOfMethods);
            while (numberOfMethods-- > 0) {
                String methodName = IOUtil.readUTFFast((byte[])buffer, (DataInput)inputStream);
                methodsList.add(holder.myMethodEnumeratorCache.enumerate((Object)methodName));
            }
            classData.put(classId, (Object)methodsList);
        }
        TIntObjectHashMap tIntObjectHashMap = classData;
        TIntObjectHashMap tIntObjectHashMap2 = tIntObjectHashMap;
        if (tIntObjectHashMap2 == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(10);
        }
        return tIntObjectHashMap2;
        finally {
            inputStream.close();
        }
    }

    private static /* synthetic */ boolean lambda$null$5(TestInfoHolder localHolder, TestInfoHolder remoteDataHolder, TIntObjectHashMap result2, Ref exceptionRef, int remoteClassKey, TIntArrayList remoteClassMethodIds) {
        try {
            int localClassKey = localHolder.myClassEnumeratorCache.enumerate(remoteDataHolder.myClassEnumeratorCache.valueOf(remoteClassKey));
            TIntArrayList localClassIds = new TIntArrayList(remoteClassMethodIds.size());
            for (int methodId : remoteClassMethodIds.toNativeArray()) {
                localClassIds.add(localHolder.myMethodEnumeratorCache.enumerate(remoteDataHolder.myMethodEnumeratorCache.valueOf(methodId)));
            }
            result2.put(localClassKey, (Object)localClassIds);
            return true;
        }
        catch (IOException ex) {
            exceptionRef.set((Object)ex);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQName";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkPrefix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/TestDiscoveryIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoveryIndex";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadClassAndMethodsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasTestTrace";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeTestTrace";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setRemoteTestRunDataPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTestsByMethodName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTestModulesByMethodName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateFromTestTrace";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeTestTrace$4";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasTestTrace$3";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class TestDataController {
        private final Object myLock = new Object();
        private Path myBasePath;
        private final boolean myReadOnly;
        private volatile TestInfoHolder myHolder;

        TestDataController(Path basePath, boolean readonly) {
            this.myReadOnly = readonly;
            this.init(basePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init(Path basePath) {
            if (this.myHolder != null) {
                this.dispose();
            }
            Object object = this.myLock;
            synchronized (object) {
                this.myBasePath = basePath;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TestInfoHolder getHolder() {
            TestInfoHolder holder = this.myHolder;
            if (holder == null) {
                Object object = this.myLock;
                synchronized (object) {
                    holder = this.myHolder;
                    if (holder == null && this.myBasePath != null) {
                        this.myHolder = holder = new TestInfoHolder(this.myBasePath, this.myReadOnly, this.myLock);
                    }
                }
            }
            return holder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            Object object = this.myLock;
            synchronized (object) {
                TestInfoHolder holder = this.myHolder;
                if (holder != null) {
                    holder.dispose();
                    this.myHolder = null;
                }
            }
        }

        private void thingsWentWrongLetsReinitialize(@Nullable TestInfoHolder holder, Throwable throwable) throws IOException {
            LOG.error("Unexpected problem", throwable);
            if (holder != null) {
                holder.dispose();
            }
            PathKt.delete((Path)TestInfoHolder.getVersionFile(this.myBasePath));
            this.myHolder = null;
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> R withTestDataHolder(ThrowableConvertor<TestInfoHolder, R, IOException> action) throws IOException {
            Object object = this.myLock;
            synchronized (object) {
                TestInfoHolder holder = this.getHolder();
                if (holder == null || holder.isDisposed()) {
                    return null;
                }
                try {
                    return (R)action.convert((Object)holder);
                }
                catch (Throwable throwable) {
                    if (!this.myReadOnly) {
                        this.thingsWentWrongLetsReinitialize(holder, throwable);
                    } else {
                        LOG.error(throwable);
                    }
                    return null;
                }
            }
        }
    }
}

