/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.util.io.CachingEnumerator;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentStringEnumerator;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TestInfoHolder {
    final PersistentHashMap<Long, TIntArrayList> myMethodQNameToTestNames;
    final PersistentHashMap<Integer, TIntObjectHashMap<TIntArrayList>> myTestNameToUsedClassesAndMethodMap;
    final PersistentHashMap<Long, TIntArrayList> myTestNameToNearestModule;
    final PersistentStringEnumerator myClassEnumerator;
    final CachingEnumerator<String> myClassEnumeratorCache;
    final PersistentStringEnumerator myMethodEnumerator;
    final CachingEnumerator<String> myMethodEnumeratorCache;
    final PersistentStringEnumerator myTestNameEnumerator;
    final PersistentStringEnumerator myModuleNameEnumerator;
    final List<PersistentEnumeratorDelegate> myConstructedDataFiles;
    private ScheduledFuture<?> myFlushingFuture;
    private boolean myDisposed;
    private final Object myLock;
    private static final int VERSION = 4;
    private static final int REMOVED_MARKER = -1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TestInfoHolder(@NotNull Path basePath, final boolean readOnly, Object lock) {
        if (basePath == null) {
            TestInfoHolder.$$$reportNull$$$0(0);
        }
        this.myConstructedDataFiles = new ArrayList<PersistentEnumeratorDelegate>(6);
        this.myLock = lock;
        Path versionFile = TestInfoHolder.getVersionFile(basePath);
        PathKt.createDirectories((Path)basePath);
        File methodQNameToTestNameFile = basePath.resolve("methodQNameToTestName.data").toFile();
        File testNameToUsedClassesAndMethodMapFile = basePath.resolve("testToCalledMethodNames.data").toFile();
        File classNameEnumeratorFile = basePath.resolve("classNameEnumerator.data").toFile();
        File methodNameEnumeratorFile = basePath.resolve("methodNameEnumerator.data").toFile();
        File testNameEnumeratorFile = basePath.resolve("testNameEnumerator.data").toFile();
        File moduleNameEnumeratorFile = basePath.resolve("moduleNameEnumerator.data").toFile();
        File testNameToNearestModuleFile = basePath.resolve("testNameToNearestModule.data").toFile();
        try {
            PersistentStringEnumerator testNameEnumerator;
            PersistentStringEnumerator moduleNameEnumerator;
            PersistentStringEnumerator methodNameEnumerator;
            PersistentStringEnumerator classNameEnumerator;
            PersistentHashMap testNameToNearestModule;
            PersistentHashMap<Integer, TIntObjectHashMap<TIntArrayList>> testNameToUsedClassesAndMethodMap;
            PersistentHashMap<Long, TIntArrayList> methodQNameToTestNames;
            int version = TestInfoHolder.readVersion(versionFile);
            if (version != 4) {
                assert (!readOnly);
                TestDiscoveryIndex.LOG.info("TestDiscoveryIndex was rewritten due to version change");
                TestInfoHolder.deleteAllIndexDataFiles(methodQNameToTestNameFile, testNameToUsedClassesAndMethodMapFile, classNameEnumeratorFile, methodNameEnumeratorFile, testNameEnumeratorFile, moduleNameEnumeratorFile, testNameToNearestModuleFile);
                TestInfoHolder.writeVersion(versionFile);
            }
            int iterations = 0;
            while (true) {
                ++iterations;
                try {
                    methodQNameToTestNames = new PersistentHashMap<Long, TIntArrayList>(methodQNameToTestNameFile, (KeyDescriptor)MethodQNameSerializer.INSTANCE, (DataExternalizer)new TestNamesExternalizer()){

                        protected boolean isReadOnly() {
                            return readOnly;
                        }
                    };
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)methodQNameToTestNames);
                    testNameToUsedClassesAndMethodMap = new PersistentHashMap<Integer, TIntObjectHashMap<TIntArrayList>>(testNameToUsedClassesAndMethodMapFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new ClassesAndMethodsMapDataExternalizer()){

                        protected boolean isReadOnly() {
                            return readOnly;
                        }
                    };
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)testNameToUsedClassesAndMethodMap);
                    testNameToNearestModule = new PersistentHashMap(testNameToNearestModuleFile, (KeyDescriptor)MethodQNameSerializer.INSTANCE, (DataExternalizer)new TestNamesExternalizer());
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)testNameToNearestModule);
                    classNameEnumerator = new PersistentStringEnumerator(classNameEnumeratorFile);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)classNameEnumerator);
                    methodNameEnumerator = new PersistentStringEnumerator(methodNameEnumeratorFile);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)methodNameEnumerator);
                    moduleNameEnumerator = new PersistentStringEnumerator(moduleNameEnumeratorFile);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)moduleNameEnumerator);
                    testNameEnumerator = new PersistentStringEnumerator(testNameEnumeratorFile);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)testNameEnumerator);
                }
                catch (Throwable throwable) {
                    TestDiscoveryIndex.LOG.info("TestDiscoveryIndex problem", throwable);
                    this.closeAllConstructedFiles(true);
                    this.myConstructedDataFiles.clear();
                    TestInfoHolder.deleteAllIndexDataFiles(methodQNameToTestNameFile, testNameToUsedClassesAndMethodMapFile, classNameEnumeratorFile, methodNameEnumeratorFile, testNameEnumeratorFile, moduleNameEnumeratorFile, testNameToNearestModuleFile);
                    if (iterations < 3) continue;
                    TestDiscoveryIndex.LOG.error("Unexpected circular initialization problem");
                    assert (false);
                    continue;
                }
                break;
            }
            this.myMethodQNameToTestNames = methodQNameToTestNames;
            this.myTestNameToUsedClassesAndMethodMap = testNameToUsedClassesAndMethodMap;
            this.myTestNameToNearestModule = testNameToNearestModule;
            this.myClassEnumerator = classNameEnumerator;
            this.myMethodEnumerator = methodNameEnumerator;
            this.myTestNameEnumerator = testNameEnumerator;
            this.myModuleNameEnumerator = moduleNameEnumerator;
            this.myMethodEnumeratorCache = new CachingEnumerator((DataEnumerator)methodNameEnumerator, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE);
            this.myClassEnumeratorCache = new CachingEnumerator((DataEnumerator)classNameEnumerator, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE);
            this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(() -> {
                Object object = this.myLock;
                synchronized (object) {
                    if (this.myDisposed) {
                        this.myFlushingFuture.cancel(false);
                        return;
                    }
                    for (PersistentEnumeratorDelegate dataFile : this.myConstructedDataFiles) {
                        if (!dataFile.isDirty()) continue;
                        dataFile.force();
                    }
                    this.myClassEnumeratorCache.clear();
                    this.myMethodEnumeratorCache.clear();
                }
            });
            return;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void closeAllConstructedFiles(boolean ignoreCloseProblem) {
        for (Closeable closeable : this.myConstructedDataFiles) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                if (ignoreCloseProblem) continue;
                throw new RuntimeException(throwable);
            }
        }
    }

    private static void deleteAllIndexDataFiles(File ... files) {
        for (File file2 : files) {
            IOUtil.deleteAllFilesStartingWith((File)file2);
        }
    }

    private static void writeVersion(@NotNull Path versionFile) throws IOException {
        if (versionFile == null) {
            TestInfoHolder.$$$reportNull$$$0(1);
        }
        try (DataOutputStream versionOut = new DataOutputStream(PathKt.outputStream((Path)versionFile));){
            DataInputOutputUtil.writeINT((DataOutput)versionOut, (int)4);
        }
    }

    private static int readVersion(@NotNull Path versionFile) throws IOException {
        InputStream inputStream;
        if (versionFile == null) {
            TestInfoHolder.$$$reportNull$$$0(2);
        }
        if ((inputStream = PathKt.inputStreamIfExists((Path)versionFile)) == null) {
            return 0;
        }
        try (DataInputStream versionInput = new DataInputStream(inputStream);){
            int n = DataInputOutputUtil.readINT((DataInput)versionInput);
            return n;
        }
    }

    void dispose() {
        assert (Thread.holdsLock(this.myLock));
        try {
            this.closeAllConstructedFiles(false);
        }
        finally {
            this.myDisposed = true;
        }
    }

    void doUpdateFromDiff(int testNameId, @Nullable TIntObjectHashMap<TIntArrayList> classData, @Nullable TIntObjectHashMap<TIntArrayList> previousClassData, @Nullable Integer moduleId) throws IOException {
        ValueDiff valueDiff = new ValueDiff(classData, previousClassData);
        if (valueDiff.hasRemovedDelta()) {
            for (int classQName : valueDiff.myRemovedClassData.keys()) {
                for (int methodName : ((TIntArrayList)valueDiff.myRemovedClassData.get(classQName)).toNativeArray()) {
                    this.myMethodQNameToTestNames.appendData((Object)TestInfoHolder.createKey(classQName, methodName), dataOutput -> {
                        DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)-1);
                        DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)testNameId);
                    });
                }
            }
        }
        if (valueDiff.hasAddedDelta()) {
            for (int classQName : valueDiff.myAddedOrChangedClassData.keys()) {
                for (int methodName : ((TIntArrayList)valueDiff.myAddedOrChangedClassData.get(classQName)).toNativeArray()) {
                    this.myMethodQNameToTestNames.appendData((Object)TestInfoHolder.createKey(classQName, methodName), dataOutput -> DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)testNameId));
                    if (moduleId == null) continue;
                    this.myTestNameToNearestModule.appendData((Object)TestInfoHolder.createKey(classQName, methodName), dataOutput -> DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)moduleId));
                }
            }
        }
        if (valueDiff.hasAddedDelta() || valueDiff.hasRemovedDelta()) {
            if (classData != null) {
                this.myTestNameToUsedClassesAndMethodMap.put((Object)testNameId, classData);
            } else {
                this.myTestNameToUsedClassesAndMethodMap.remove((Object)testNameId);
            }
        }
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public static boolean isValidPath(@NotNull Path path) {
        if (path == null) {
            TestInfoHolder.$$$reportNull$$$0(3);
        }
        try {
            return TestInfoHolder.readVersion(TestInfoHolder.getVersionFile(path)) == 4;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @NotNull
    static Path getVersionFile(Path path) {
        Path path2 = path.resolve("index.version");
        if (path2 == null) {
            TestInfoHolder.$$$reportNull$$$0(4);
        }
        return path2;
    }

    static long createKey(int classQName, int methodName) {
        return (long)classQName << 32 | (long)methodName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/TestInfoHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/TestInfoHolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeVersion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readVersion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidPath";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ValueDiff {
        final TIntObjectHashMap<TIntArrayList> myAddedOrChangedClassData;
        final TIntObjectHashMap<TIntArrayList> myRemovedClassData;

        ValueDiff(@Nullable TIntObjectHashMap<TIntArrayList> classData, @Nullable TIntObjectHashMap<TIntArrayList> previousClassData) {
            TIntObjectHashMap addedOrChangedClassData = classData;
            TIntObjectHashMap removedClassData = previousClassData;
            if (previousClassData != null && !previousClassData.isEmpty()) {
                removedClassData = new TIntObjectHashMap();
                addedOrChangedClassData = new TIntObjectHashMap();
                if (classData != null) {
                    for (int classQName : classData.keys()) {
                        TIntArrayList currentMethods = (TIntArrayList)classData.get(classQName);
                        TIntArrayList previousMethods = (TIntArrayList)previousClassData.get(classQName);
                        if (previousMethods == null) {
                            addedOrChangedClassData.put(classQName, (Object)currentMethods);
                            continue;
                        }
                        int[] previousMethodIds = previousMethods.toNativeArray();
                        TIntHashSet previousMethodsSet = new TIntHashSet(previousMethodIds);
                        int[] currentMethodIds = currentMethods.toNativeArray();
                        TIntHashSet currentMethodsSet = new TIntHashSet(currentMethodIds);
                        currentMethodsSet.removeAll(previousMethodIds);
                        previousMethodsSet.removeAll(currentMethodIds);
                        if (!currentMethodsSet.isEmpty()) {
                            addedOrChangedClassData.put(classQName, (Object)new TIntArrayList(currentMethodsSet.toArray()));
                        }
                        if (previousMethodsSet.isEmpty()) continue;
                        removedClassData.put(classQName, (Object)new TIntArrayList(previousMethodsSet.toArray()));
                    }
                }
                if (classData != null) {
                    for (int classQName : previousClassData.keys()) {
                        if (classData.containsKey(classQName)) continue;
                        TIntArrayList previousMethods = (TIntArrayList)previousClassData.get(classQName);
                        removedClassData.put(classQName, (Object)previousMethods);
                    }
                }
            }
            this.myAddedOrChangedClassData = addedOrChangedClassData;
            this.myRemovedClassData = removedClassData;
        }

        public boolean hasRemovedDelta() {
            return this.myRemovedClassData != null && !this.myRemovedClassData.isEmpty();
        }

        public boolean hasAddedDelta() {
            return this.myAddedOrChangedClassData != null && !this.myAddedOrChangedClassData.isEmpty();
        }
    }

    private static class MethodQNameSerializer
    implements KeyDescriptor<Long> {
        public static final MethodQNameSerializer INSTANCE = new MethodQNameSerializer();

        private MethodQNameSerializer() {
        }

        public void save(@NotNull DataOutput out, Long value2) throws IOException {
            if (out == null) {
                MethodQNameSerializer.$$$reportNull$$$0(0);
            }
            out.writeLong(value2);
        }

        public Long read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MethodQNameSerializer.$$$reportNull$$$0(1);
            }
            return in.readLong();
        }

        public int getHashCode(Long value2) {
            return value2.hashCode();
        }

        public boolean isEqual(Long val1, Long val2) {
            return val1.equals(val2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/testDiscovery/TestInfoHolder$MethodQNameSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClassesAndMethodsMapDataExternalizer
    implements DataExternalizer<TIntObjectHashMap<TIntArrayList>> {
        private ClassesAndMethodsMapDataExternalizer() {
        }

        public void save(@NotNull DataOutput dataOutput, TIntObjectHashMap<TIntArrayList> classAndMethodsMap) throws IOException {
            if (dataOutput == null) {
                ClassesAndMethodsMapDataExternalizer.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)classAndMethodsMap.size());
            int[] classNameIds = classAndMethodsMap.keys();
            Arrays.sort(classNameIds);
            int prevClassNameId = 0;
            for (int classNameId : classNameIds) {
                DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)(classNameId - prevClassNameId));
                TIntArrayList value2 = (TIntArrayList)classAndMethodsMap.get(classNameId);
                DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)value2.size());
                int[] methodNameIds = value2.toNativeArray();
                Arrays.sort(methodNameIds);
                int prevMethodNameId = 0;
                for (int methodNameId : methodNameIds) {
                    DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)(methodNameId - prevMethodNameId));
                    prevMethodNameId = methodNameId;
                }
                prevClassNameId = classNameId;
            }
        }

        public TIntObjectHashMap<TIntArrayList> read(@NotNull DataInput dataInput) throws IOException {
            if (dataInput == null) {
                ClassesAndMethodsMapDataExternalizer.$$$reportNull$$$0(1);
            }
            int numberOfClasses = DataInputOutputUtil.readINT((DataInput)dataInput);
            TIntObjectHashMap result2 = new TIntObjectHashMap();
            int prevClassNameId = 0;
            while (numberOfClasses-- > 0) {
                int classNameId = DataInputOutputUtil.readINT((DataInput)dataInput) + prevClassNameId;
                int numberOfMethods = DataInputOutputUtil.readINT((DataInput)dataInput);
                TIntArrayList methodNameIds = new TIntArrayList(numberOfMethods);
                int prevMethodNameId = 0;
                while (numberOfMethods-- > 0) {
                    int methodNameId = DataInputOutputUtil.readINT((DataInput)dataInput) + prevMethodNameId;
                    methodNameIds.add(methodNameId);
                    prevMethodNameId = methodNameId;
                }
                result2.put(classNameId, (Object)methodNameIds);
                prevClassNameId = classNameId;
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataOutput";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataInput";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/testDiscovery/TestInfoHolder$ClassesAndMethodsMapDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TestNamesExternalizer
    implements DataExternalizer<TIntArrayList> {
        private TestNamesExternalizer() {
        }

        public void save(@NotNull DataOutput dataOutput, TIntArrayList testNameIds) throws IOException {
            if (dataOutput == null) {
                TestNamesExternalizer.$$$reportNull$$$0(0);
            }
            for (int testNameId : testNameIds.toNativeArray()) {
                DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)testNameId);
            }
        }

        public TIntArrayList read(@NotNull DataInput dataInput) throws IOException {
            if (dataInput == null) {
                TestNamesExternalizer.$$$reportNull$$$0(1);
            }
            TIntHashSet result2 = new TIntHashSet();
            while (((InputStream)((Object)dataInput)).available() > 0) {
                int id = DataInputOutputUtil.readINT((DataInput)dataInput);
                if (-1 == id) {
                    id = DataInputOutputUtil.readINT((DataInput)dataInput);
                    if (result2.remove(id)) continue;
                    result2.add(-id);
                    continue;
                }
                result2.add(id);
            }
            return new TIntArrayList(result2.toArray());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataOutput";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataInput";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/testDiscovery/TestInfoHolder$TestNamesExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

