/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestProxyRoot;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ui.BaseTestProxyNodeDescriptor;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestTreeView
extends Tree
implements DataProvider,
CopyProvider {
    public static final DataKey<TestFrameworkRunningModel> MODEL_DATA_KEY = DataKey.create((String)"testFrameworkModel.dataId");
    private TestFrameworkRunningModel myModel;

    protected abstract TreeCellRenderer getRenderer(TestConsoleProperties var1);

    public abstract AbstractTestProxy getSelectedTest(@NotNull TreePath var1);

    protected TestFrameworkRunningModel getTestFrameworkRunningModel() {
        return this.myModel;
    }

    @Nullable
    public AbstractTestProxy getSelectedTest() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null && paths.length > 1) {
            return null;
        }
        TreePath selectionPath = this.getSelectionPath();
        return selectionPath != null ? this.getSelectedTest(selectionPath) : null;
    }

    public void attachToModel(TestFrameworkRunningModel model) {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(model.getRoot())));
        this.getSelectionModel().setSelectionMode(model.getProperties().getSelectionMode());
        this.myModel = model;
        Disposer.register((Disposable)this.myModel, (Disposable)this.myModel.getRoot());
        Disposer.register((Disposable)this.myModel, (Disposable)new Disposable(){

            public void dispose() {
                TestTreeView.this.setModel(null);
                TestTreeView.this.myModel = null;
            }
        });
        this.installHandlers();
        this.setCellRenderer(this.getRenderer(this.myModel.getProperties()));
    }

    public void setUI(TreeUI ui) {
        super.setUI(ui);
        int fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        int iconHeight = PoolOfTestIcons.PASSED_ICON.getIconHeight();
        this.setRowHeight(Math.max(fontHeight, iconHeight) + 2);
        this.setLargeModel(true);
    }

    public Object getData(String dataId) {
        TreePath[] paths;
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId) && (paths = this.getSelectionPaths()) != null && paths.length > 1) {
            ArrayList<PsiElement> els = new ArrayList<PsiElement>(paths.length);
            for (TreePath path : paths) {
                PsiElement psiElement;
                AbstractTestProxy test;
                if (this.isPathSelected(path.getParentPath()) || (test = this.getSelectedTest(path)) == null || (psiElement = (PsiElement)TestsUIUtil.getData(test, CommonDataKeys.PSI_ELEMENT.getName(), this.myModel)) == null) continue;
                els.add(psiElement);
            }
            return els.isEmpty() ? null : els.toArray(new PsiElement[els.size()]);
        }
        if (Location.DATA_KEYS.is(dataId) && (paths = this.getSelectionPaths()) != null && paths.length > 1) {
            ArrayList<Location> locations = new ArrayList<Location>(paths.length);
            for (TreePath path : paths) {
                Location location;
                AbstractTestProxy test;
                if (this.isPathSelected(path.getParentPath()) || (test = this.getSelectedTest(path)) == null || (location = (Location)TestsUIUtil.getData(test, Location.DATA_KEY.getName(), this.myModel)) == null) continue;
                locations.add(location);
            }
            return locations.isEmpty() ? null : locations.toArray(new Location[locations.size()]);
        }
        if (MODEL_DATA_KEY.is(dataId)) {
            return this.myModel;
        }
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        AbstractTestProxy testProxy = this.getSelectedTest(selectionPath);
        if (testProxy == null) {
            return null;
        }
        try {
            return TestsUIUtil.getData(testProxy, dataId, this.myModel);
        }
        catch (IndexNotReadyException ignore) {
            return null;
        }
    }

    public void performCopy(@NotNull DataContext dataContext) {
        AbstractTestProxy selectedTest;
        PsiElement element;
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(0);
        }
        String fqn = (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) != null ? CopyReferenceAction.elementToFqn(element) : ((selectedTest = this.getSelectedTest()) instanceof TestProxyRoot ? ((TestProxyRoot)((Object)selectedTest)).getRootLocation() : (selectedTest != null ? selectedTest.getLocationUrl() : null));
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(fqn));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        AbstractTestProxy test;
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(1);
        }
        if ((test = this.getSelectedTest()) instanceof TestProxyRoot) {
            return ((TestProxyRoot)((Object)test)).getRootLocation() != null;
        }
        return test != null && test.getLocationUrl() != null;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(2);
        }
        return true;
    }

    protected void installHandlers() {
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
        new TreeSpeedSearch(this, (Convertor<TreePath, String>)((Convertor)path -> {
            AbstractTestProxy testProxy = this.getSelectedTest((TreePath)path);
            if (testProxy == null) {
                return null;
            }
            return testProxy.getName();
        }));
        TreeUtil.installActions((JTree)((Object)this));
        PopupHandler.installPopupHandler((JComponent)((Object)this), (String)"TestTreePopupMenu", (String)"TestTreeViewPopup");
    }

    public boolean isExpandableHandlerVisibleForCurrentRow(int row) {
        ExpandableItemsHandler handler2 = this.getExpandableItemsHandler();
        Collection items = handler2.getExpandedItems();
        return items.size() == 1 && row == (Integer)items.iterator().next();
    }

    public void paint(Graphics g) {
        super.paint(g);
        TestFrameworkRunningModel model = this.myModel;
        if (model == null) {
            return;
        }
        TestConsoleProperties properties = model.getProperties();
        if (TestConsoleProperties.SHOW_INLINE_STATISTICS.value((AbstractProperty.AbstractPropertyContainer)properties)) {
            int firstRow;
            Rectangle visibleRect = this.getVisibleRect();
            Rectangle clip = g.getClipBounds();
            int visibleRowCount = TreeUtil.getVisibleRowCountForFixedRowHeight((JTree)((Object)this));
            for (int row = firstRow = this.getClosestRowForLocation(0, visibleRect.y); row < Math.min(firstRow + visibleRowCount + 1, this.getRowCount()); ++row) {
                Object testProxy;
                String durationString;
                Object data;
                Object node;
                if (this.isExpandableHandlerVisibleForCurrentRow(row) || !((node = this.getPathForRow(row).getLastPathComponent()) instanceof DefaultMutableTreeNode) || !((data = ((DefaultMutableTreeNode)node).getUserObject()) instanceof BaseTestProxyNodeDescriptor) || (durationString = ((AbstractTestProxy)(testProxy = ((BaseTestProxyNodeDescriptor)((Object)data)).getElement())).getDurationString(properties)) == null) continue;
                Rectangle rowBounds = this.getRowBounds(row);
                rowBounds.x = 0;
                rowBounds.width = Integer.MAX_VALUE;
                if (!rowBounds.intersects(clip)) continue;
                Rectangle fullRowRect = new Rectangle(visibleRect.x, rowBounds.y, visibleRect.width, rowBounds.height);
                boolean rowSelected = this.isRowSelected(row);
                boolean hasTreeFocus = this.hasFocus();
                TestTreeView.paintRowData(this, durationString, fullRowRect, (Graphics2D)g, rowSelected, hasTreeFocus);
            }
        }
    }

    private static void paintRowData(Tree tree, String duration, Rectangle bounds, Graphics2D g, boolean isSelected, boolean hasFocus) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        g.setFont(tree.getFont().deriveFont(0, UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL)));
        FontMetrics metrics = tree.getFontMetrics(g.getFont());
        int totalWidth = metrics.stringWidth(duration) + 2;
        int x = bounds.x + bounds.width - totalWidth;
        g.setColor(isSelected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : UIUtil.getTreeBackground());
        int leftOffset = 5;
        g.fillRect(x - 5, bounds.y, totalWidth + 5, bounds.height);
        g.translate(0, bounds.y - 1);
        if (isSelected) {
            if (!hasFocus && UIUtil.isUnderAquaBasedLookAndFeel()) {
                g.setColor(UIUtil.getTreeForeground());
            } else {
                g.setColor(UIUtil.getTreeSelectionForeground());
            }
        } else {
            g.setColor((Color)new JBColor(0x808080, 0x808080));
        }
        g.drawString(duration, x, SimpleColoredComponent.getTextBaseLine((FontMetrics)tree.getFontMetrics(tree.getFont()), (int)bounds.height) + 1);
        g.translate(0, -bounds.y + 1);
        config.restore();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataContext";
        objectArray2[1] = "com/intellij/execution/testframework/TestTreeView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "performCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyVisible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

