/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.ui.ComputableIcon;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiElement2UsageTargetAdapter
implements PsiElementUsageTarget,
TypeSafeDataProvider,
PsiElementNavigationItem,
ItemPresentation,
ConfigurableUsageTarget {
    private final SmartPsiElementPointer myPointer;
    @NotNull
    protected final FindUsagesOptions myOptions;
    private String myPresentableText;
    private ComputableIcon myIconOpen;
    private ComputableIcon myIconClosed;

    public PsiElement2UsageTargetAdapter(@NotNull PsiElement element, @NotNull FindUsagesOptions options) {
        if (element == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(0);
        }
        if (options == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(1);
        }
        this.myOptions = options;
        this.myPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        if (!(element instanceof NavigationItem)) {
            throw new IllegalArgumentException("Element is not a navigation item: " + element);
        }
        this.update(element);
    }

    public PsiElement2UsageTargetAdapter(@NotNull PsiElement element) {
        if (element == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(2);
        }
        this(element, new FindUsagesOptions(element.getProject()));
    }

    public String getName() {
        PsiElement element = this.getElement();
        return element instanceof NavigationItem ? ((NavigationItem)element).getName() : null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        PsiElement2UsageTargetAdapter psiElement2UsageTargetAdapter = this;
        if (psiElement2UsageTargetAdapter == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(3);
        }
        return psiElement2UsageTargetAdapter;
    }

    public void navigate(boolean requestFocus) {
        PsiElement element = this.getElement();
        if (element instanceof Navigatable && ((Navigatable)element).canNavigate()) {
            ((Navigatable)element).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        PsiElement element = this.getElement();
        return element instanceof Navigatable && ((Navigatable)element).canNavigate();
    }

    public boolean canNavigateToSource() {
        PsiElement element = this.getElement();
        return element instanceof Navigatable && ((Navigatable)element).canNavigateToSource();
    }

    public PsiElement getTargetElement() {
        return this.getElement();
    }

    public String toString() {
        return this.getPresentableText();
    }

    public void findUsages() {
        PsiElement element = this.getElement();
        if (element == null) {
            return;
        }
        ((FindManagerImpl)FindManager.getInstance((Project)element.getProject())).getFindUsagesManager().startFindUsages(element, this.myOptions, null, null);
    }

    public PsiElement getElement() {
        return this.myPointer.getElement();
    }

    public void findUsagesInEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(4);
        }
        PsiElement element = this.getElement();
        FindManager.getInstance((Project)element.getProject()).findUsagesInEditor(element, editor);
    }

    public void highlightUsages(@NotNull PsiFile file2, @NotNull Editor editor, boolean clearHighlights) {
        if (file2 == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(6);
        }
        PsiElement target2 = this.getElement();
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        Project project2 = target2.getProject();
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager();
        FindUsagesHandler handler2 = findUsagesManager.getFindUsagesHandler(target2, true);
        PsiFile context = InjectedLanguageManager.getInstance((Project)project2).getTopLevelFile((PsiElement)file2);
        LocalSearchScope searchScope = new LocalSearchScope((PsiElement)context);
        Collection refs = handler2 == null ? ReferencesSearch.search((PsiElement)target2, (SearchScope)searchScope, (boolean)false).findAll() : handler2.findReferencesToHighlight(target2, (SearchScope)searchScope);
        new HighlightUsagesHandler.DoHighlightRunnable(new ArrayList<PsiReference>(refs), project2, target2, editor, context, clearHighlights).run();
    }

    public boolean isValid() {
        return this.getElement() != null;
    }

    public boolean isReadOnly() {
        return this.isValid() && !this.getElement().isWritable();
    }

    public VirtualFile[] getFiles() {
        VirtualFile[] virtualFileArray;
        if (!this.isValid()) {
            return null;
        }
        PsiFile psiFile = this.getElement().getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            virtualFileArray = null;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = virtualFile;
        }
        return virtualFileArray;
    }

    @NotNull
    public static PsiElement2UsageTargetAdapter[] convert(@NotNull PsiElement[] psiElements) {
        if (psiElements == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(7);
        }
        PsiElement2UsageTargetAdapter[] targets = new PsiElement2UsageTargetAdapter[psiElements.length];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = new PsiElement2UsageTargetAdapter(psiElements[i]);
        }
        if (targets == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(8);
        }
        return targets;
    }

    @NotNull
    public static PsiElement[] convertToPsiElements(PsiElement2UsageTargetAdapter[] adapters) {
        PsiElement[] targets = new PsiElement[adapters.length];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = adapters[i].getElement();
        }
        if (targets == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(9);
        }
        return targets;
    }

    public void calcData(DataKey key2, DataSink sink) {
        if (key2 == UsageView.USAGE_INFO_KEY) {
            PsiElement element = this.getElement();
            if (element != null && element.getTextRange() != null) {
                sink.put(UsageView.USAGE_INFO_KEY, (Object)new UsageInfo(element));
            }
        } else if (key2 == UsageView.USAGE_SCOPE) {
            sink.put(UsageView.USAGE_SCOPE, (Object)this.myOptions.searchScope);
        }
    }

    public KeyboardShortcut getShortcut() {
        return UsageViewImpl.getShowUsagesWithSettingsShortcut();
    }

    @NotNull
    public String getLongDescriptiveName() {
        SearchScope searchScope = this.myOptions.searchScope;
        String scopeString = searchScope.getDisplayName();
        PsiElement psiElement = this.getElement();
        String string = psiElement == null ? UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) : FindBundle.message("recent.find.usages.action.popup", StringUtil.capitalize((String)UsageViewUtil.getType(psiElement)), DescriptiveNameUtil.getDescriptiveName((PsiElement)psiElement), scopeString);
        if (string == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void showSettings() {
        PsiElement element = this.getElement();
        if (element != null) {
            FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)this.myPointer.getProject())).getFindUsagesManager();
            findUsagesManager.findUsages(element, null, null, true, null);
        }
    }

    public void update() {
        this.update(this.getElement());
    }

    private void update(PsiElement element) {
        if (element != null && element.isValid()) {
            ItemPresentation presentation = ((NavigationItem)element).getPresentation();
            this.myIconOpen = presentation == null ? null : ComputableIcon.create((ItemPresentation)presentation, (boolean)true);
            this.myIconClosed = presentation == null ? null : ComputableIcon.create((ItemPresentation)presentation, (boolean)false);
            String string = this.myPresentableText = presentation == null ? UsageViewUtil.createNodeText(element) : presentation.getPresentableText();
            if (this.myIconOpen == null || this.myIconClosed == null) {
                PsiFile psiFile;
                VirtualFile virtualFile;
                if (element instanceof PsiMetaOwner) {
                    PsiMetaOwner psiMetaOwner = (PsiMetaOwner)element;
                    PsiMetaData metaData = psiMetaOwner.getMetaData();
                    if (metaData instanceof PsiPresentableMetaData) {
                        PsiPresentableMetaData psiPresentableMetaData = (PsiPresentableMetaData)metaData;
                        if (this.myIconOpen == null) {
                            this.myIconOpen = ComputableIcon.create((PsiPresentableMetaData)psiPresentableMetaData);
                        }
                        if (this.myIconClosed == null) {
                            this.myIconClosed = ComputableIcon.create((PsiPresentableMetaData)psiPresentableMetaData);
                        }
                    }
                } else if (element instanceof PsiFile && (virtualFile = (psiFile = (PsiFile)element).getVirtualFile()) != null) {
                    this.myIconOpen = ComputableIcon.create((VirtualFile)virtualFile);
                    this.myIconClosed = ComputableIcon.create((VirtualFile)virtualFile);
                }
            }
        }
    }

    public String getPresentableText() {
        return this.myPresentableText;
    }

    public String getLocationString() {
        return null;
    }

    public Icon getIcon(boolean open2) {
        ComputableIcon computableIcon = open2 ? this.myIconOpen : this.myIconClosed;
        return computableIcon == null ? null : computableIcon.getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/PsiElement2UsageTargetAdapter";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/PsiElement2UsageTargetAdapter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToPsiElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongDescriptiveName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findUsagesInEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "highlightUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

