/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetBasedDetectedFrameworkDescription<F extends Facet, C extends FacetConfiguration>
extends DetectedFrameworkDescription {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.framework.detection.impl.FacetBasedDetectedFrameworkDescription");
    private final FacetBasedFrameworkDetector<F, C> myDetector;
    private final C myConfiguration;
    private final Set<VirtualFile> myRelatedFiles;
    private final FacetType<F, C> myFacetType;

    public FacetBasedDetectedFrameworkDescription(FacetBasedFrameworkDetector<F, C> detector, @NotNull C configuration, Set<VirtualFile> files) {
        if (configuration == null) {
            FacetBasedDetectedFrameworkDescription.$$$reportNull$$$0(0);
        }
        this.myDetector = detector;
        this.myConfiguration = configuration;
        this.myRelatedFiles = files;
        this.myFacetType = detector.getFacetType();
    }

    @NotNull
    public Collection<? extends VirtualFile> getRelatedFiles() {
        Set<VirtualFile> set2 = this.myRelatedFiles;
        if (set2 == null) {
            FacetBasedDetectedFrameworkDescription.$$$reportNull$$$0(1);
        }
        return set2;
    }

    public C getConfiguration() {
        return this.myConfiguration;
    }

    @NotNull
    public String getSetupText() {
        String string = "'" + this.myFacetType.getPresentableName() + "' facet will be added to '" + this.getModuleName() + "' module";
        if (string == null) {
            FacetBasedDetectedFrameworkDescription.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public FrameworkDetector getDetector() {
        FacetBasedFrameworkDetector<F, C> facetBasedFrameworkDetector = this.myDetector;
        if (facetBasedFrameworkDetector == null) {
            FacetBasedDetectedFrameworkDescription.$$$reportNull$$$0(3);
        }
        return facetBasedFrameworkDetector;
    }

    protected abstract String getModuleName();

    public boolean canSetupFramework(@NotNull Collection<? extends DetectedFrameworkDescription> allDetectedFrameworks) {
        FacetTypeId underlyingId;
        if (allDetectedFrameworks == null) {
            FacetBasedDetectedFrameworkDescription.$$$reportNull$$$0(4);
        }
        if ((underlyingId = this.myFacetType.getUnderlyingFacetType()) == null) {
            return true;
        }
        Collection<Facet> facets = this.getExistentFacets(underlyingId);
        for (Facet facet : facets) {
            if (!this.myDetector.isSuitableUnderlyingFacetConfiguration(facet.getConfiguration(), this.myConfiguration, this.myRelatedFiles)) continue;
            return true;
        }
        for (DetectedFrameworkDescription detectedFrameworkDescription : allDetectedFrameworks) {
            if (!(detectedFrameworkDescription instanceof FacetBasedDetectedFrameworkDescription)) continue;
            FacetBasedDetectedFrameworkDescription description = (FacetBasedDetectedFrameworkDescription)detectedFrameworkDescription;
            if (!underlyingId.equals(description.myFacetType.getId()) || !this.myDetector.isSuitableUnderlyingFacetConfiguration(description.getConfiguration(), this.myConfiguration, this.myRelatedFiles)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract Collection<? extends Facet> getExistentFacets(FacetTypeId<?> var1);

    protected void doSetup(ModifiableModelsProvider modifiableModelsProvider, Module module2) {
        ModifiableFacetModel model = modifiableModelsProvider.getFacetModifiableModel(module2);
        String name2 = UniqueNameGenerator.generateUniqueName((String)this.myFacetType.getDefaultFacetName(), s -> FacetManager.getInstance((Module)module2).findFacet(this.myFacetType.getId(), s) == null);
        Facet facet = FacetManager.getInstance((Module)module2).createFacet(this.myFacetType, name2, this.myConfiguration, this.findUnderlyingFacet(module2));
        model.addFacet(facet);
        modifiableModelsProvider.commitFacetModifiableModel(module2, model);
        ModifiableRootModel rootModel = modifiableModelsProvider.getModuleModifiableModel(module2);
        this.myDetector.setupFacet(facet, rootModel);
        modifiableModelsProvider.commitModuleModifiableModel(rootModel);
    }

    @Nullable
    private Facet findUnderlyingFacet(Module module2) {
        FacetTypeId underlyingTypeId = this.myFacetType.getUnderlyingFacetType();
        if (underlyingTypeId == null) {
            return null;
        }
        Collection parentFacets = FacetManager.getInstance((Module)module2).getFacetsByType(underlyingTypeId);
        for (Facet facet : parentFacets) {
            if (!this.myDetector.isSuitableUnderlyingFacetConfiguration(facet.getConfiguration(), this.myConfiguration, this.myRelatedFiles)) continue;
            return facet;
        }
        LOG.error("Cannot find suitable underlying facet in " + parentFacets);
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FacetBasedDetectedFrameworkDescription)) {
            return false;
        }
        FacetBasedDetectedFrameworkDescription other = (FacetBasedDetectedFrameworkDescription)((Object)obj);
        return this.getModuleName().equals(other.getModuleName()) && this.myFacetType.equals(other.myFacetType) && this.myRelatedFiles.equals(other.myRelatedFiles);
    }

    public int hashCode() {
        return this.getModuleName().hashCode() + 31 * this.myFacetType.hashCode() + 239 * this.myRelatedFiles.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/FacetBasedDetectedFrameworkDescription";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDetectedFrameworks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/FacetBasedDetectedFrameworkDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetupText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canSetupFramework";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

