/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenFileAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            OpenFileAction.$$$reportNull$$$0(0);
        }
        boolean showFiles = (project2 = e.getProject()) != null || PlatformProjectOpenProcessor.getInstanceIfItExists() != null;
        OpenProjectFileChooserDescriptor descriptor2 = showFiles ? new ProjectOrFileChooserDescriptor() : new ProjectOnlyFileChooserDescriptor();
        descriptor2.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, showFiles);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project2, (VirtualFile)this.getPathToSelect(), files -> {
            for (VirtualFile file2 : files) {
                if (descriptor2.isFileSelectable(file2)) continue;
                String message2 = IdeBundle.message((String)"error.dir.contains.no.project", (Object[])new Object[]{file2.getPresentableUrl()});
                Messages.showInfoMessage((Project)project2, (String)message2, (String)IdeBundle.message((String)"title.cannot.open.project", (Object[])new Object[0]));
                return;
            }
            OpenFileAction.doOpenFile(project2, files);
        });
    }

    @Nullable
    protected VirtualFile getPathToSelect() {
        return VfsUtil.getUserHomeDir();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenFileAction.$$$reportNull$$$0(1);
        }
        if (NewWelcomeScreen.isNewWelcomeScreen(e)) {
            e.getPresentation().setIcon(AllIcons.Welcome.OpenProject);
        }
    }

    private static void doOpenFile(@Nullable Project project2, @NotNull List<VirtualFile> result2) {
        if (result2 == null) {
            OpenFileAction.$$$reportNull$$$0(2);
        }
        for (VirtualFile file2 : result2) {
            FileType type2;
            if (file2.isDirectory()) {
                Project openedProject;
                if (ProjectAttachProcessor.canAttachToProject()) {
                    EnumSet<PlatformProjectOpenProcessor.Option> options = EnumSet.noneOf(PlatformProjectOpenProcessor.Option.class);
                    openedProject = PlatformProjectOpenProcessor.doOpenProject(file2, project2, -1, null, options);
                } else {
                    openedProject = ProjectUtil.openOrImport(file2.getPath(), project2, false);
                }
                FileChooserUtil.setLastOpenedFile(openedProject, file2);
                return;
            }
            if ((project2 == null || !file2.equals(project2.getProjectFile())) && OpenProjectFileChooserDescriptor.isProjectFile(file2)) {
                int answer;
                int n = answer = file2.getFileType() instanceof ProjectFileType ? 0 : Messages.showYesNoCancelDialog((Project)project2, (String)IdeBundle.message((String)"message.open.file.is.project", (Object[])new Object[]{file2.getName()}), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"message.open.file.is.project.open.as.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"message.open.file.is.project.open.as.file", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (answer == 2) {
                    return;
                }
                if (answer == 0) {
                    Project openedProject = ProjectUtil.openOrImport(file2.getPath(), project2, false);
                    if (openedProject != null) {
                        FileChooserUtil.setLastOpenedFile(openedProject, file2);
                    }
                    return;
                }
            }
            if ((type2 = FileTypeChooser.getKnownFileTypeOrAssociate(file2, project2)) == null) {
                return;
            }
            if (project2 != null) {
                OpenFileAction.openFile(file2, project2);
                continue;
            }
            PlatformProjectOpenProcessor processor2 = PlatformProjectOpenProcessor.getInstanceIfItExists();
            if (processor2 == null) continue;
            processor2.doOpenProject(file2, null, false);
        }
    }

    public static void openFile(String filePath, @NotNull Project project2) {
        VirtualFile file2;
        if (project2 == null) {
            OpenFileAction.$$$reportNull$$$0(3);
        }
        if ((file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath)) != null && file2.isValid()) {
            OpenFileAction.openFile(file2, project2);
        }
    }

    public static void openFile(VirtualFile file2, @NotNull Project project2) {
        FileEditorProvider[] providers2;
        if (project2 == null) {
            OpenFileAction.$$$reportNull$$$0(4);
        }
        if ((providers2 = FileEditorProviderManager.getInstance().getProviders(project2, file2)).length == 0) {
            String message2 = IdeBundle.message((String)"error.files.of.this.type.cannot.be.opened", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
            Messages.showErrorDialog((Project)project2, (String)message2, (String)IdeBundle.message((String)"title.cannot.open.file", (Object[])new Object[0]));
            return;
        }
        NonProjectFileWritingAccessProvider.allowWriting(file2);
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project2, file2);
        FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor2, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/OpenFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doOpenFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "openFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProjectOrFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        private final FileChooserDescriptor myStandardDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withHideIgnored(false);

        public ProjectOrFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.file.or.project", (Object[])new Object[0]));
        }

        @Override
        public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
            return file2.isDirectory() ? super.isFileVisible(file2, showHiddenFiles) : this.myStandardDescriptor.isFileVisible(file2, showHiddenFiles);
        }

        @Override
        public boolean isFileSelectable(VirtualFile file2) {
            return file2.isDirectory() ? super.isFileSelectable(file2) : this.myStandardDescriptor.isFileSelectable(file2);
        }

        public boolean isChooseMultiple() {
            return true;
        }
    }

    private static class ProjectOnlyFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        public ProjectOnlyFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.project", (Object[])new Object[0]));
        }
    }
}

