/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.util.FileStructurePopup;
import com.intellij.ide.util.StructureViewCompositeModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.PlaceHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewStructureAction
extends DumbAwareAction {
    public ViewStructureAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile virtualFile;
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        if (fileEditor == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        } else {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (psiFile == null) {
                return;
            }
            virtualFile = psiFile.getVirtualFile();
        }
        String title = virtualFile == null ? fileEditor.getName() : virtualFile.getName();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.file.structure");
        FileStructurePopup popup2 = ViewStructureAction.createPopup(project2, fileEditor);
        if (popup2 == null) {
            return;
        }
        popup2.setTitle(title);
        popup2.show();
    }

    @Nullable
    public static FileStructurePopup createPopup(@NotNull Project project2, @NotNull FileEditor fileEditor) {
        StructureViewModel treeModel;
        StructureView structureView;
        if (project2 == null) {
            ViewStructureAction.$$$reportNull$$$0(0);
        }
        if (fileEditor == null) {
            ViewStructureAction.$$$reportNull$$$0(1);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        StructureViewBuilder builder = fileEditor.getStructureViewBuilder();
        if (builder == null) {
            return null;
        }
        if (builder instanceof TreeBasedStructureViewBuilder && fileEditor instanceof TextEditor) {
            structureView = null;
            treeModel = ((TreeBasedStructureViewBuilder)builder).createStructureViewModel(((TextEditor)fileEditor).getEditor());
        } else {
            structureView = builder.createStructureView(fileEditor, project2);
            treeModel = ViewStructureAction.createStructureViewModel(project2, fileEditor, structureView);
        }
        if (treeModel instanceof PlaceHolder) {
            ((PlaceHolder)treeModel).setPlace((Object)"StructureViewPopup");
        }
        FileStructurePopup popup2 = new FileStructurePopup(project2, fileEditor, treeModel);
        if (structureView != null) {
            Disposer.register((Disposable)popup2, (Disposable)structureView);
        }
        return popup2;
    }

    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        e.getPresentation().setEnabled(fileEditor != null && fileEditor.getStructureViewBuilder() != null);
    }

    @NotNull
    public static StructureViewModel createStructureViewModel(@NotNull Project project2, @NotNull FileEditor fileEditor, @NotNull StructureView structureView) {
        Object treeModel;
        if (project2 == null) {
            ViewStructureAction.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            ViewStructureAction.$$$reportNull$$$0(3);
        }
        if (structureView == null) {
            ViewStructureAction.$$$reportNull$$$0(4);
        }
        VirtualFile virtualFile = fileEditor.getFile();
        if (structureView instanceof StructureViewComposite && virtualFile != null) {
            StructureViewComposite.StructureViewDescriptor[] views = ((StructureViewComposite)structureView).getStructureViews();
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
            treeModel = new StructureViewCompositeModel(psiFile, fileEditor, views);
            Disposer.register((Disposable)structureView, (Disposable)((Disposable)treeModel));
        } else {
            treeModel = structureView.getTreeModel();
        }
        StructureViewModel structureViewModel = treeModel;
        if (structureViewModel == null) {
            ViewStructureAction.$$$reportNull$$$0(5);
        }
        return structureViewModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ViewStructureAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ViewStructureAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureViewModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStructureViewModel";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

