/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.commander;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.commander.AbstractListBuilder;
import com.intellij.ide.commander.CommanderHistoryListener;
import com.intellij.ide.commander.TopLevelNode;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RightAlignedLabelUI;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommanderPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.commander.CommanderPanel");
    private static final Color DARK_BLUE = new Color(55, 85, 134);
    private static final Color DARK_BLUE_BRIGHTER = new Color(58, 92, 149);
    private static final Color DARK_BLUE_DARKER = new Color(38, 64, 106);
    private Project myProject;
    private AbstractListBuilder myBuilder;
    private JPanel myTitlePanel;
    private JLabel myParentTitle;
    protected final JBList myList;
    private final MyModel myModel;
    private CopyPasteDelegator myCopyPasteDelegator;
    protected final ListSpeedSearch myListSpeedSearch;
    private final IdeView myIdeView = new MyIdeView();
    private final MyDeleteElementProvider myDeleteElementProvider = new MyDeleteElementProvider();
    @NonNls
    private static final String ACTION_DRILL_DOWN = "DrillDown";
    @NonNls
    private static final String ACTION_GO_UP = "GoUp";
    private ProjectAbstractTreeStructureBase myProjectTreeStructure;
    private boolean myActive = true;
    private final List<CommanderHistoryListener> myHistoryListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myMoveFocus = false;
    private final boolean myEnableSearchHighlighting;

    public CommanderPanel(Project project2, boolean enablePopupMenu, boolean enableSearchHighlighting) {
        super(new BorderLayout());
        this.myProject = project2;
        this.myEnableSearchHighlighting = enableSearchHighlighting;
        this.myModel = new MyModel();
        this.myList = new JBList((ListModel)this.myModel);
        this.myList.setSelectionMode(2);
        if (enablePopupMenu) {
            this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, (JComponent)this.myList){

                @Override
                @NotNull
                protected PsiElement[] getSelectedElements() {
                    PsiElement[] psiElementArray = CommanderPanel.this.getSelectedElements();
                    if (psiElementArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return psiElementArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/commander/CommanderPanel$1", "getSelectedElements"));
                }
            };
        }
        this.myListSpeedSearch = new ListSpeedSearch(this.myList);
        this.myListSpeedSearch.setClearSearchOnNavigateNoMatch(true);
        ScrollingUtil.installActions((JList)this.myList);
        this.myList.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CommanderPanel.this.myBuilder == null) {
                    return;
                }
                CommanderPanel.this.myBuilder.buildRoot();
            }
        }, KeyStroke.getKeyStroke(92, SystemInfo.isMac ? 4 : 2), 0);
        this.myList.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), ACTION_DRILL_DOWN);
        this.myList.getInputMap(0).put(KeyStroke.getKeyStroke(34, SystemInfo.isMac ? 4 : 2), ACTION_DRILL_DOWN);
        this.myList.getActionMap().put(ACTION_DRILL_DOWN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommanderPanel.this.drillDown();
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                CommanderPanel.this.drillDown();
                return true;
            }
        }.installOn((Component)this.myList);
        this.myList.getInputMap(0).put(KeyStroke.getKeyStroke(33, SystemInfo.isMac ? 4 : 2), ACTION_GO_UP);
        this.myList.getInputMap(0).put(KeyStroke.getKeyStroke(8, 0), ACTION_GO_UP);
        this.myList.getActionMap().put(ACTION_GO_UP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommanderPanel.this.goUp();
            }
        });
        this.myList.getActionMap().put("selectAll", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        if (enablePopupMenu) {
            this.myList.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(Component comp, int x, int y) {
                    CommanderPanel.this.invokePopup(comp, x, y);
                }
            });
        }
        this.myList.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CommanderPanel.this.setActive(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                CommanderPanel.this.setActive(false);
            }
        });
    }

    public boolean isEnableSearchHighlighting() {
        return this.myEnableSearchHighlighting;
    }

    public void addHistoryListener(@NotNull CommanderHistoryListener listener2) {
        if (listener2 == null) {
            CommanderPanel.$$$reportNull$$$0(0);
        }
        this.myHistoryListeners.add(listener2);
    }

    private void removeHistoryListener(CommanderHistoryListener listener2) {
        this.myHistoryListeners.remove(listener2);
    }

    private void updateHistory(boolean elementExpanded) {
        for (CommanderHistoryListener listener2 : this.myHistoryListeners) {
            listener2.historyChanged(this.getSelectedElement(), elementExpanded);
        }
    }

    public final JList getList() {
        return this.myList;
    }

    public final AbstractListBuilder.Model getModel() {
        return this.myModel;
    }

    public void setMoveFocus(boolean moveFocus) {
        this.myMoveFocus = moveFocus;
    }

    public void goUp() {
        if (this.myBuilder == null) {
            return;
        }
        this.updateHistory(true);
        this.myBuilder.goUp();
        this.updateHistory(false);
    }

    public void drillDown() {
        if (this.topElementIsSelected()) {
            this.goUp();
            return;
        }
        if (this.getSelectedValue() == null) {
            return;
        }
        AbstractTreeNode element = this.getSelectedNode();
        if (element.getChildren().isEmpty() && !this.shouldDrillDownOnEmptyElement(element)) {
            this.navigateSelectedElement();
            return;
        }
        if (this.myBuilder == null) {
            return;
        }
        this.updateHistory(false);
        this.myBuilder.drillDown();
        this.updateHistory(true);
    }

    public boolean navigateSelectedElement() {
        AbstractTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null && selectedNode.canNavigateToSource()) {
            selectedNode.navigate(true);
            return true;
        }
        return false;
    }

    protected boolean shouldDrillDownOnEmptyElement(AbstractTreeNode node) {
        return node instanceof ProjectViewNode && ((ProjectViewNode)node).shouldDrillDownOnEmptyElement();
    }

    private boolean topElementIsSelected() {
        int[] selectedIndices = this.myList.getSelectedIndices();
        return selectedIndices.length == 1 && selectedIndices[0] == 0 && this.myModel.getElementAt(selectedIndices[0]) instanceof TopLevelNode;
    }

    public final void setBuilder(AbstractListBuilder builder) {
        this.myBuilder = builder;
        this.removeAll();
        this.myTitlePanel = new JPanel(new BorderLayout());
        this.myTitlePanel.setBackground(UIUtil.getControlColor());
        this.myTitlePanel.setOpaque(true);
        this.myParentTitle = new MyTitleLabel(this.myTitlePanel);
        this.myParentTitle.setText(" ");
        this.myParentTitle.setFont(UIUtil.getLabelFont().deriveFont(1));
        this.myParentTitle.setForeground(JBColor.foreground());
        this.myParentTitle.setUI((LabelUI)new RightAlignedLabelUI());
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.setOpaque(false);
        panel1.add(Box.createHorizontalStrut(10), "West");
        panel1.add((Component)this.myParentTitle, "Center");
        this.myTitlePanel.add((Component)panel1, "Center");
        this.add((Component)this.myTitlePanel, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myList);
        scrollPane.setBorder(null);
        scrollPane.getVerticalScrollBar().setFocusable(false);
        scrollPane.getHorizontalScrollBar().setFocusable(false);
        this.add((Component)scrollPane, "Center");
        this.myBuilder.setParentTitle(this.myParentTitle);
        this.myTitlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)CommanderPanel.this.myList, true));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)CommanderPanel.this.myList, true));
            }
        });
    }

    public final AbstractListBuilder getBuilder() {
        return this.myBuilder;
    }

    public final PsiElement getSelectedElement() {
        Object value2 = CommanderPanel.getValueAtIndex(this.getSelectedNode());
        return (PsiElement)(value2 instanceof PsiElement ? value2 : null);
    }

    public final PsiElement getSelectedElement(int index) {
        Object elementAtIndex = this.myModel.getElementAt(index);
        Object value2 = CommanderPanel.getValueAtIndex(elementAtIndex instanceof AbstractTreeNode ? (AbstractTreeNode)elementAtIndex : null);
        return (PsiElement)(value2 instanceof PsiElement ? value2 : null);
    }

    public AbstractTreeNode getSelectedNode() {
        if (this.myBuilder == null) {
            return null;
        }
        int[] indices2 = this.myList.getSelectedIndices();
        if (indices2.length != 1) {
            return null;
        }
        int index = indices2[0];
        if (index >= this.myModel.getSize()) {
            return null;
        }
        Object elementAtIndex = this.myModel.getElementAt(index);
        return elementAtIndex instanceof AbstractTreeNode ? (AbstractTreeNode)elementAtIndex : null;
    }

    @NotNull
    private List<AbstractTreeNode> getSelectedNodes() {
        if (this.myBuilder == null) {
            List<AbstractTreeNode> list2 = Collections.emptyList();
            if (list2 == null) {
                CommanderPanel.$$$reportNull$$$0(1);
            }
            return list2;
        }
        int[] indices2 = this.myList.getSelectedIndices();
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        for (int index : indices2) {
            AbstractTreeNode node;
            if (index >= this.myModel.getSize()) continue;
            Object elementAtIndex = this.myModel.getElementAt(index);
            AbstractTreeNode abstractTreeNode = node = elementAtIndex instanceof AbstractTreeNode ? (AbstractTreeNode)elementAtIndex : null;
            if (node == null) continue;
            result2.add(node);
        }
        ArrayList<AbstractTreeNode> arrayList = result2;
        if (arrayList == null) {
            CommanderPanel.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public Object getSelectedValue() {
        return CommanderPanel.getValueAtIndex(this.getSelectedNode());
    }

    private PsiElement[] getSelectedElements() {
        if (this.myBuilder == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        int[] indices2 = this.myList.getSelectedIndices();
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (int index : indices2) {
            PsiElement element = this.getSelectedElement(index);
            if (element == null) continue;
            elements.add(element);
        }
        return PsiUtilCore.toPsiElementArray(elements);
    }

    private static Object getValueAtIndex(AbstractTreeNode node) {
        if (node == null) {
            return null;
        }
        Object value2 = node.getValue();
        if (value2 instanceof StructureViewTreeElement) {
            return ((StructureViewTreeElement)value2).getValue();
        }
        return value2;
    }

    public final void setActive(boolean active) {
        this.myActive = active;
        if (active) {
            this.myTitlePanel.setBackground(DARK_BLUE);
            this.myTitlePanel.setBorder(BorderFactory.createBevelBorder(0, DARK_BLUE_BRIGHTER, DARK_BLUE_DARKER));
            this.myParentTitle.setForeground(Color.white);
        } else {
            Color color = UIUtil.getPanelBackground();
            LOG.assertTrue(color != null);
            this.myTitlePanel.setBackground(color);
            this.myTitlePanel.setBorder(BorderFactory.createBevelBorder(1, color.brighter(), color.darker()));
            this.myParentTitle.setForeground(JBColor.foreground());
        }
        int[] selectedIndices = this.myList.getSelectedIndices();
        if (selectedIndices.length == 0 && this.myList.getModel().getSize() > 0) {
            this.myList.setSelectedIndex(0);
            if (!this.myList.hasFocus()) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myList, true));
            }
        } else if (this.myList.getModel().getSize() > 0) {
            this.myList.setSelectedIndices(selectedIndices);
        }
    }

    public boolean isActive() {
        return this.myActive;
    }

    private void invokePopup(Component c, int x, int y) {
        int popupIndex;
        if (this.myBuilder == null) {
            return;
        }
        if (this.myList.getSelectedIndices().length <= 1 && (popupIndex = this.myList.locationToIndex(new Point(x, y))) >= 0) {
            this.myList.setSelectedIndex(popupIndex);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myList, true));
        }
        ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("CommanderPopupMenu");
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("CommanderPopup", group);
        popupMenu.getComponent().show(c, x, y);
    }

    public final void dispose() {
        if (this.myBuilder != null) {
            this.myBuilder.dispose();
            this.myBuilder = null;
        }
        this.myProject = null;
    }

    public final void setTitlePanelVisible(boolean flag) {
        this.myTitlePanel.setVisible(flag);
    }

    public final Object getDataImpl(String dataId) {
        if (this.myBuilder == null) {
            return null;
        }
        Object selectedValue = this.getSelectedValue();
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement selectedElement = this.getSelectedElement();
            return selectedElement != null && selectedElement.isValid() ? selectedElement : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return CommanderPanel.filterInvalidElements(this.getSelectedElements());
        }
        if (LangDataKeys.PASTE_TARGET_PSI_ELEMENT.is(dataId)) {
            AbstractTreeNode parentNode = this.myBuilder.getParentNode();
            Object element = parentNode != null ? parentNode.getValue() : null;
            return element instanceof PsiElement && ((PsiElement)element).isValid() ? element : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getNavigatables();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator != null ? this.myCopyPasteDelegator.getCopyProvider() : null;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator != null ? this.myCopyPasteDelegator.getCutProvider() : null;
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator != null ? this.myCopyPasteDelegator.getPasteProvider() : null;
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myDeleteElementProvider;
        }
        if (LangDataKeys.MODULE.is(dataId)) {
            return selectedValue instanceof Module ? selectedValue : null;
        }
        if (ModuleGroup.ARRAY_DATA_KEY.is(dataId)) {
            ModuleGroup[] moduleGroupArray;
            if (selectedValue instanceof ModuleGroup) {
                ModuleGroup[] moduleGroupArray2 = new ModuleGroup[1];
                moduleGroupArray = moduleGroupArray2;
                moduleGroupArray2[0] = (ModuleGroup)selectedValue;
            } else {
                moduleGroupArray = null;
            }
            return moduleGroupArray;
        }
        if (LibraryGroupElement.ARRAY_DATA_KEY.is(dataId)) {
            LibraryGroupElement[] libraryGroupElementArray;
            if (selectedValue instanceof LibraryGroupElement) {
                LibraryGroupElement[] libraryGroupElementArray2 = new LibraryGroupElement[1];
                libraryGroupElementArray = libraryGroupElementArray2;
                libraryGroupElementArray2[0] = (LibraryGroupElement)selectedValue;
            } else {
                libraryGroupElementArray = null;
            }
            return libraryGroupElementArray;
        }
        if (NamedLibraryElement.ARRAY_DATA_KEY.is(dataId)) {
            NamedLibraryElement[] namedLibraryElementArray;
            if (selectedValue instanceof NamedLibraryElement) {
                NamedLibraryElement[] namedLibraryElementArray2 = new NamedLibraryElement[1];
                namedLibraryElementArray = namedLibraryElementArray2;
                namedLibraryElementArray2[0] = (NamedLibraryElement)selectedValue;
            } else {
                namedLibraryElementArray = null;
            }
            return namedLibraryElementArray;
        }
        if (this.myProjectTreeStructure != null) {
            return this.myProjectTreeStructure.getDataFromProviders(this.getSelectedNodes(), dataId);
        }
        return null;
    }

    private Navigatable[] getNavigatables() {
        if (this.myBuilder == null) {
            return null;
        }
        int[] indices2 = this.myList.getSelectedIndices();
        if (indices2 == null || indices2.length == 0) {
            return null;
        }
        ArrayList<Navigatable> elements = new ArrayList<Navigatable>();
        for (int index : indices2) {
            Object element = this.myModel.getElementAt(index);
            if (!(element instanceof AbstractTreeNode)) continue;
            elements.add((Navigatable)element);
        }
        return elements.toArray(new Navigatable[elements.size()]);
    }

    @Nullable
    private static PsiElement[] filterInvalidElements(PsiElement[] elements) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        ArrayList<PsiElement> validElements = new ArrayList<PsiElement>(elements.length);
        for (PsiElement element : elements) {
            if (!element.isValid()) continue;
            validElements.add(element);
        }
        return validElements.size() == elements.length ? elements : PsiUtilCore.toPsiElementArray(validElements);
    }

    protected final Navigatable createEditSourceDescriptor() {
        return EditSourceUtil.getDescriptor((PsiElement)this.getSelectedElement());
    }

    public void setProjectTreeStructure(ProjectAbstractTreeStructureBase projectTreeStructure) {
        this.myProjectTreeStructure = projectTreeStructure;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/commander/CommanderPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/commander/CommanderPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addHistoryListener";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class MyModel
    extends AbstractListModel
    implements AbstractListBuilder.Model {
        final List myElements = new ArrayList();

        @Override
        public void removeAllElements() {
            int index1 = this.myElements.size() - 1;
            this.myElements.clear();
            if (index1 >= 0) {
                this.fireIntervalRemoved(this, 0, index1);
            }
        }

        @Override
        public void addElement(Object obj) {
            int index = this.myElements.size();
            this.myElements.add(obj);
            this.fireIntervalAdded(this, index, index);
        }

        @Override
        public void replaceElements(List newElements) {
            this.removeAllElements();
            this.myElements.addAll(newElements);
            this.fireIntervalAdded(this, 0, newElements.size());
        }

        @Override
        public Object[] toArray() {
            return ArrayUtil.toObjectArray((Collection)this.myElements);
        }

        @Override
        public int indexOf(Object o) {
            return this.myElements.indexOf(o);
        }

        @Override
        public int getSize() {
            return this.myElements.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.myElements.get(index);
        }
    }

    private final class MyIdeView
    implements IdeView {
        private MyIdeView() {
        }

        public void selectElement(PsiElement element) {
            boolean isDirectory = element instanceof PsiDirectory;
            if (!isDirectory) {
                EditorHelper.openInEditor(element);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                CommanderPanel.this.myBuilder.selectElement(element, PsiUtilCore.getVirtualFile((PsiElement)element));
                if (!isDirectory) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (CommanderPanel.this.myMoveFocus) {
                            ToolWindowManager.getInstance((Project)CommanderPanel.this.myProject).activateEditorComponent();
                        }
                    });
                }
            }, ModalityState.NON_MODAL);
        }

        private PsiDirectory getDirectory() {
            if (CommanderPanel.this.myBuilder == null) {
                return null;
            }
            AbstractTreeNode parentElement = CommanderPanel.this.myBuilder.getParentNode();
            if (parentElement instanceof AbstractTreeNode) {
                AbstractTreeNode parentNode = parentElement;
                if (!(parentNode.getValue() instanceof PsiDirectory)) {
                    return null;
                }
                return (PsiDirectory)parentNode.getValue();
            }
            return null;
        }

        @NotNull
        public PsiDirectory[] getDirectories() {
            PsiDirectory[] psiDirectoryArray;
            PsiDirectory directory = this.getDirectory();
            if (directory == null) {
                psiDirectoryArray = PsiDirectory.EMPTY_ARRAY;
            } else {
                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                psiDirectoryArray = psiDirectoryArray2;
                psiDirectoryArray2[0] = directory;
            }
            if (psiDirectoryArray == null) {
                MyIdeView.$$$reportNull$$$0(0);
            }
            return psiDirectoryArray;
        }

        public PsiDirectory getOrChooseDirectory() {
            return DirectoryChooserUtil.getOrChooseDirectory(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/commander/CommanderPanel$MyIdeView", "getDirectories"));
        }
    }

    private final class MyDeleteElementProvider
    implements DeleteProvider {
        private MyDeleteElementProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeleteElementProvider.$$$reportNull$$$0(0);
            }
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                PsiElement[] elements = CommanderPanel.this.getSelectedElements();
                DeleteHandler.deletePsiElement(elements, CommanderPanel.this.myProject);
            }
            finally {
                a.finish();
            }
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeleteElementProvider.$$$reportNull$$$0(1);
            }
            PsiElement[] elements = CommanderPanel.this.getSelectedElements();
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/ide/commander/CommanderPanel$MyDeleteElementProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyTitleLabel
    extends JLabel {
        private final JPanel myPanel;

        public MyTitleLabel(JPanel panel2) {
            this.myPanel = panel2;
        }

        @Override
        public void setText(String text2) {
            if (text2 == null || text2.isEmpty()) {
                text2 = " ";
            }
            super.setText(text2);
            if (this.myPanel != null) {
                this.myPanel.setToolTipText(text2.trim().isEmpty() ? null : text2);
            }
        }
    }
}

