/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ui.ErrorTreeView;
import javax.swing.JComponent;

public abstract class TestErrorViewAction
extends AnAction {
    private static final int MESSAGE_COUNT = 1000;
    private long myMillis = 0L;
    private int myMessageCount = 0;

    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        final ErrorTreeView view = this.createView(project2);
        this.openView(project2, view.getComponent());
        this.myMillis = 0L;
        this.myMessageCount = 0;
        new Thread("test error view"){

            @Override
            public void run() {
                for (int idx = 0; idx < 1000; ++idx) {
                    TestErrorViewAction.this.addMessage(view, new String[]{"This is a warning test message" + idx + " line1", "This is a warning test message" + idx + " line2"}, 5);
                }
                while (TestErrorViewAction.this.getMessageCount() < 1000) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                String statistics = "Duration = " + TestErrorViewAction.this.myMillis;
                TestErrorViewAction.this.addMessage(view, new String[]{statistics}, 2);
                System.out.println(statistics);
                while (TestErrorViewAction.this.getMessageCount() < 1001) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                System.out.println("Expected 1001 messages;");
                Disposer.dispose((Disposable)view);
            }
        }.start();
    }

    public synchronized int getMessageCount() {
        return this.myMessageCount;
    }

    public synchronized void incMessageCount() {
        ++this.myMessageCount;
    }

    private void addMessage(ErrorTreeView view, String[] message2, int type2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            long start = System.currentTimeMillis();
            view.addMessage(type2, message2, null, -1, -1, null);
            long duration = System.currentTimeMillis() - start;
            this.myMillis += duration;
            this.incMessageCount();
        }, ModalityState.NON_MODAL);
    }

    protected abstract ErrorTreeView createView(Project var1);

    protected abstract String getContentName();

    protected void openView(Project project2, JComponent component) {
        MessageView messageView = MessageView.SERVICE.getInstance(project2);
        Content content = ContentFactory.SERVICE.getInstance().createContent(component, this.getContentName(), true);
        messageView.getContentManager().addContent(content);
        messageView.getContentManager().setSelectedContent(content);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
        if (toolWindow != null) {
            toolWindow.activate(null);
        }
    }
}

