/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.smartPointerPsiNodes.ClassSmartPointerNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiClassFavoriteNodeProvider
extends FavoriteNodeProvider {
    public Collection<AbstractTreeNode> getFavoriteNodes(DataContext context, ViewSettings viewSettings) {
        PsiElement element;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project2 == null) {
            return null;
        }
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        if (elements == null && (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context)) != null) {
            elements = new PsiElement[]{element};
        }
        if (elements != null) {
            ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
            for (PsiElement element2 : elements) {
                if (!(element2 instanceof PsiClass) || !this.checkClassUnderSources(element2, project2)) continue;
                result2.add((AbstractTreeNode)new ClassSmartPointerNode(project2, element2, viewSettings));
            }
            return result2.isEmpty() ? null : result2;
        }
        return null;
    }

    private boolean checkClassUnderSources(PsiElement element, Project project2) {
        PsiFile file2 = element.getContainingFile();
        if (file2 != null && file2.getVirtualFile() != null) {
            VirtualFile vf;
            FileIndexFacade indexFacade = FileIndexFacade.getInstance((Project)project2);
            return indexFacade.isInSource(vf = file2.getVirtualFile()) || indexFacade.isInSourceContent(vf);
        }
        return false;
    }

    public AbstractTreeNode createNode(Project project2, Object element, ViewSettings viewSettings) {
        if (element instanceof PsiClass && this.checkClassUnderSources((PsiElement)element, project2)) {
            return new ClassSmartPointerNode(project2, element, viewSettings);
        }
        return super.createNode(project2, element, viewSettings);
    }

    public boolean elementContainsFile(Object element, VirtualFile vFile) {
        PsiFile file2;
        return element instanceof PsiClass && (file2 = ((PsiClass)element).getContainingFile()) != null && Comparing.equal((Object)file2.getVirtualFile(), (Object)vFile);
    }

    public int getElementWeight(Object value2, boolean isSortByType) {
        if (value2 instanceof PsiClass) {
            return isSortByType ? ClassTreeNode.getClassPosition((PsiClass)value2) : 3;
        }
        return -1;
    }

    public String getElementLocation(Object element) {
        if (element instanceof PsiClass) {
            return ClassPresentationUtil.getNameForClass((PsiClass)element, true);
        }
        return null;
    }

    public boolean isInvalidElement(Object element) {
        return element instanceof PsiClass && !((PsiClass)element).isValid();
    }

    @NotNull
    public String getFavoriteTypeId() {
        if ("class" == null) {
            PsiClassFavoriteNodeProvider.$$$reportNull$$$0(0);
        }
        return "class";
    }

    public String getElementUrl(Object element) {
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            return aClass.getQualifiedName();
        }
        return null;
    }

    public String getElementModuleName(Object element) {
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            return module2 != null ? module2.getName() : null;
        }
        return null;
    }

    public Object[] createPathFromUrl(Project project2, String url, String moduleName) {
        PsiClass aClass;
        Module module2;
        if (DumbService.isDumb((Project)project2)) {
            return null;
        }
        GlobalSearchScope scope = null;
        if (moduleName != null && (module2 = ModuleManager.getInstance((Project)project2).findModuleByName(moduleName)) != null) {
            scope = GlobalSearchScope.moduleScope((Module)module2);
        }
        if (scope == null) {
            scope = GlobalSearchScope.allScope((Project)project2);
        }
        if ((aClass = JavaPsiFacade.getInstance((Project)project2).findClass(url, scope)) == null) {
            return null;
        }
        return new Object[]{aClass};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/PsiClassFavoriteNodeProvider", "getFavoriteTypeId"));
    }
}

