/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DefaultCreateFromTemplateHandler
implements CreateFromTemplateHandler {
    @Override
    public boolean handlesTemplate(FileTemplate template) {
        return true;
    }

    @Override
    @NotNull
    public PsiElement createFromTemplate(Project project2, PsiDirectory directory, String fileName, FileTemplate template, String templateText, @NotNull Map<String, Object> props) throws IncorrectOperationException {
        if (props == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(0);
        }
        fileName = this.checkAppendExtension(fileName, template);
        if (FileTypeManager.getInstance().isFileIgnored(fileName)) {
            throw new IncorrectOperationException("This filename is ignored (Settings | Editor | File Types | Ignore files and folders)");
        }
        directory.checkCreateFile(fileName);
        FileType type2 = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
        PsiFile file2 = PsiFileFactory.getInstance((Project)project2).createFileFromText(fileName, type2, (CharSequence)templateText);
        if (template.isReformatCode()) {
            CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)file2);
        }
        PsiFile psiFile = file2 = (PsiFile)directory.add((PsiElement)file2);
        if (psiFile == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(1);
        }
        return psiFile;
    }

    protected String checkAppendExtension(String fileName, FileTemplate template) {
        String suggestedFileNameEnd = "." + template.getExtension();
        if (!fileName.endsWith(suggestedFileNameEnd)) {
            fileName = fileName + suggestedFileNameEnd;
        }
        return fileName;
    }

    @Override
    public boolean canCreate(PsiDirectory[] dirs) {
        return true;
    }

    @Override
    public boolean isNameRequired() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]);
    }

    @Override
    public void prepareProperties(Map<String, Object> props) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/DefaultCreateFromTemplateHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/DefaultCreateFromTemplateHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromTemplate";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

