/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.file.JavaDirectoryServiceImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaCreateFromTemplateHandler
implements CreateFromTemplateHandler {
    public static PsiClass createClassOrInterface(Project project2, PsiDirectory directory, String content, boolean reformat, String extension) throws IncorrectOperationException {
        PsiElement addedElement;
        if (extension == null) {
            extension = StdFileTypes.JAVA.getDefaultExtension();
        }
        String name2 = "myClass." + extension;
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project2).createFileFromText(name2, (FileType)StdFileTypes.JAVA, (CharSequence)content);
        if (!(psiFile instanceof PsiJavaFile)) {
            throw new IncorrectOperationException("This template did not produce a Java class or an interface\n" + psiFile.getText());
        }
        PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
        PsiClass[] classes2 = psiJavaFile.getClasses();
        if (classes2.length == 0) {
            throw new IncorrectOperationException("This template did not produce a Java class or an interface\n" + psiFile.getText());
        }
        PsiClass createdClass = classes2[0];
        if (reformat) {
            CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)psiJavaFile);
        }
        String className = createdClass.getName();
        JavaDirectoryServiceImpl.checkCreateClassOrInterface(directory, className);
        LanguageLevel ll = JavaDirectoryService.getInstance().getLanguageLevel(directory);
        if (ll.compareTo((Enum)LanguageLevel.JDK_1_5) < 0) {
            if (createdClass.isAnnotationType()) {
                throw new IncorrectOperationException("Annotations only supported at language level 1.5 and higher");
            }
            if (createdClass.isEnum()) {
                throw new IncorrectOperationException("Enums only supported at language level 1.5 and higher");
            }
        }
        if ((addedElement = directory.add((PsiElement)(psiJavaFile = (PsiJavaFile)psiJavaFile.setName(className + "." + extension)))) instanceof PsiJavaFile) {
            psiJavaFile = (PsiJavaFile)addedElement;
            return psiJavaFile.getClasses()[0];
        }
        PsiFile containingFile = addedElement.getContainingFile();
        throw new IncorrectOperationException("Selected class file name '" + containingFile.getName() + "' mapped to not java file type '" + containingFile.getFileType().getDescription() + "'");
    }

    static void hackAwayEmptyPackage(PsiJavaFile file2, FileTemplate template, Map<String, Object> props) throws IncorrectOperationException {
        PsiPackageStatement packageStatement;
        if (!template.isTemplateOfType((FileType)StdFileTypes.JAVA)) {
            return;
        }
        String packageName = (String)props.get("PACKAGE_NAME");
        if ((packageName == null || packageName.length() == 0 || packageName.equals("PACKAGE_NAME")) && (packageStatement = file2.getPackageStatement()) != null) {
            packageStatement.delete();
        }
    }

    @Override
    public boolean handlesTemplate(@NotNull FileTemplate template) {
        FileType fileType;
        if (template == null) {
            JavaCreateFromTemplateHandler.$$$reportNull$$$0(0);
        }
        return (fileType = FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(template.getExtension())).equals(StdFileTypes.JAVA) && !ArrayUtil.contains((String)template.getName(), (String[])JavaTemplateUtil.INTERNAL_FILE_TEMPLATES);
    }

    @Override
    @NotNull
    public PsiElement createFromTemplate(Project project2, PsiDirectory directory, String fileName, FileTemplate template, String templateText, @NotNull Map<String, Object> props) throws IncorrectOperationException {
        if (props == null) {
            JavaCreateFromTemplateHandler.$$$reportNull$$$0(1);
        }
        String extension = template.getExtension();
        PsiClass result2 = JavaCreateFromTemplateHandler.createClassOrInterface(project2, directory, templateText, template.isReformatCode(), extension);
        JavaCreateFromTemplateHandler.hackAwayEmptyPackage((PsiJavaFile)result2.getContainingFile(), template, props);
        PsiClass psiClass = result2;
        if (psiClass == null) {
            JavaCreateFromTemplateHandler.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    @Override
    public boolean canCreate(PsiDirectory[] dirs) {
        for (PsiDirectory dir : dirs) {
            if (!JavaCreateFromTemplateHandler.canCreate(dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNameRequired() {
        return false;
    }

    @Override
    public String getErrorMessage() {
        return IdeBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]);
    }

    @Override
    public void prepareProperties(Map<String, Object> props) {
        String packageName = (String)props.get("PACKAGE_NAME");
        if (packageName == null || packageName.length() == 0) {
            props.put("PACKAGE_NAME", "PACKAGE_NAME");
        }
    }

    @Override
    @NotNull
    public String commandName(@NotNull FileTemplate template) {
        if (template == null) {
            JavaCreateFromTemplateHandler.$$$reportNull$$$0(3);
        }
        String string = IdeBundle.message((String)"command.create.class.from.template", (Object[])new Object[0]);
        if (string == null) {
            JavaCreateFromTemplateHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean canCreate(PsiDirectory dir) {
        return JavaDirectoryService.getInstance().getPackage(dir) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/JavaCreateFromTemplateHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/JavaCreateFromTemplateHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromTemplate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "commandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handlesTemplate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFromTemplate";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "commandName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

