/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallReferenceProcessor;
import com.intellij.ide.hierarchy.call.JavaCallHierarchyData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class CallerMethodsTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public CallerMethodsTreeStructure(@NotNull Project project2, @NotNull PsiMethod method, String scopeType) {
        if (project2 == null) {
            CallerMethodsTreeStructure.$$$reportNull$$$0(0);
        }
        if (method == null) {
            CallerMethodsTreeStructure.$$$reportNull$$$0(1);
        }
        super(project2, new CallHierarchyNodeDescriptor(project2, null, (PsiElement)method, true, false));
        this.myScopeType = scopeType;
    }

    @Override
    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor2) {
        PsiClass clazz;
        if (descriptor2 == null) {
            CallerMethodsTreeStructure.$$$reportNull$$$0(2);
        }
        PsiMember enclosingElement = ((CallHierarchyNodeDescriptor)descriptor2).getEnclosingElement();
        HierarchyNodeDescriptor nodeDescriptor = this.getBaseDescriptor();
        if (enclosingElement instanceof PsiMethod && CallerMethodsTreeStructure.isLocalOrAnonymousClass((PsiMember)(clazz = enclosingElement.getContainingClass()))) {
            PsiElement grandParent;
            PsiElement parent = clazz.getParent();
            PsiElement psiElement = grandParent = parent instanceof PsiNewExpression ? parent.getParent() : null;
            if (grandParent instanceof PsiExpressionList) {
                enclosingElement = CallHierarchyNodeDescriptor.getEnclosingElement(grandParent);
            }
        }
        if (!(enclosingElement instanceof PsiMethod) || nodeDescriptor == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                CallerMethodsTreeStructure.$$$reportNull$$$0(3);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        PsiMethod baseMethod = (PsiMethod)((CallHierarchyNodeDescriptor)nodeDescriptor).getTargetElement();
        if (baseMethod == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                CallerMethodsTreeStructure.$$$reportNull$$$0(4);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        SearchScope searchScope = this.getSearchScope(this.myScopeType, (PsiElement)baseMethod.getContainingClass());
        PsiMethod method = (PsiMethod)enclosingElement;
        PsiClass originalClass = method.getContainingClass();
        assert (originalClass != null);
        PsiClassType originalType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(originalClass);
        HashSet<PsiMethod> methodsToFind = new HashSet<PsiMethod>();
        methodsToFind.add(method);
        ContainerUtil.addAll(methodsToFind, (Object[])method.findDeepestSuperMethods());
        HashMap methodToDescriptorMap = new HashMap();
        for (PsiMethod methodToFind : methodsToFind) {
            JavaCallHierarchyData data = new JavaCallHierarchyData(originalClass, methodToFind, originalType, method, methodsToFind, (NodeDescriptor)descriptor2, (Map)methodToDescriptorMap, this.myProject);
            MethodReferencesSearch.search((PsiMethod)methodToFind, (SearchScope)searchScope, (boolean)true).forEach(reference -> {
                for (CallReferenceProcessor processor2 : (CallReferenceProcessor[])CallReferenceProcessor.EP_NAME.getExtensions()) {
                    if (!processor2.process(reference, data)) break;
                }
                return true;
            });
        }
        Object[] objectArray = methodToDescriptorMap.values().toArray(new Object[methodToDescriptorMap.size()]);
        if (objectArray == null) {
            CallerMethodsTreeStructure.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    private static boolean isLocalOrAnonymousClass(PsiMember enclosingElement) {
        return enclosingElement instanceof PsiClass && ((PsiClass)enclosingElement).getQualifiedName() == null;
    }

    @Override
    public boolean isAlwaysShowPlus() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/call/CallerMethodsTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/call/CallerMethodsTreeStructure";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

