/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.impl.ShowModulesAction;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class FlattenModulesToggleAction
extends ToggleAction
implements DumbAware {
    private final BooleanSupplier myIsEnabled;
    private final BooleanSupplier myIsSelected;
    private final Consumer<Boolean> mySetSelected;
    private Project myProject;

    public FlattenModulesToggleAction(Project project2, BooleanSupplier isEnabled, BooleanSupplier isSelected, Consumer<Boolean> setSelected) {
        super(ProjectBundle.message((String)"project.roots.flatten.modules.action.text", (Object[])new Object[0]), ProjectBundle.message((String)"project.roots.flatten.modules.action.description", (Object[])new Object[0]), AllIcons.ObjectBrowser.FlattenModules);
        this.myIsEnabled = isEnabled;
        this.myIsSelected = isSelected;
        this.mySetSelected = setSelected;
        this.myProject = project2;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FlattenModulesToggleAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)this.myProject) && ShowModulesAction.hasModules());
        if (!this.myIsEnabled.getAsBoolean()) {
            presentation.setEnabled(false);
            if (ActionPlaces.isPopupPlace((String)e.getPlace()) || "ToolwindowPopup".equals(e.getPlace())) {
                presentation.setVisible(false);
            }
        }
    }

    public boolean isSelected(AnActionEvent e) {
        return this.myIsSelected.getAsBoolean();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        this.mySetSelected.accept(state);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/impl/FlattenModulesToggleAction", "update"));
    }
}

