/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkRootActionBase
extends DumbAwareAction {
    public MarkRootActionBase() {
    }

    public MarkRootActionBase(@Nullable String text2) {
        super(text2);
    }

    public MarkRootActionBase(@Nullable String text2, @Nullable String description, @Nullable Icon icon) {
        super(text2, description, icon);
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Module module2 = MarkRootActionBase.getModule(e, files);
        if (module2 == null) {
            return;
        }
        this.modifyRoots(e, module2, files);
    }

    protected void modifyRoots(@NotNull AnActionEvent e, @NotNull Module module2, @NotNull VirtualFile[] files) {
        if (e == null) {
            MarkRootActionBase.$$$reportNull$$$0(0);
        }
        if (module2 == null) {
            MarkRootActionBase.$$$reportNull$$$0(1);
        }
        if (files == null) {
            MarkRootActionBase.$$$reportNull$$$0(2);
        }
        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
        for (VirtualFile file2 : files) {
            SourceFolder[] sourceFolders;
            ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, file2);
            if (entry == null) continue;
            for (SourceFolder sourceFolder : sourceFolders = entry.getSourceFolders()) {
                if (!Comparing.equal((Object)sourceFolder.getFile(), (Object)file2)) continue;
                entry.removeSourceFolder(sourceFolder);
                break;
            }
            this.modifyRoots(file2, entry);
        }
        MarkRootActionBase.commitModel(module2, model);
    }

    static void commitModel(@NotNull Module module2, ModifiableRootModel model) {
        if (module2 == null) {
            MarkRootActionBase.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (module2 == null) {
                MarkRootActionBase.$$$reportNull$$$0(10);
            }
            model.commit();
            module2.getProject().save();
        });
    }

    protected abstract void modifyRoots(VirtualFile var1, ContentEntry var2);

    @Nullable
    public static ContentEntry findContentEntry(@NotNull ModuleRootModel model, @NotNull VirtualFile vFile) {
        ContentEntry[] contentEntries;
        if (model == null) {
            MarkRootActionBase.$$$reportNull$$$0(4);
        }
        if (vFile == null) {
            MarkRootActionBase.$$$reportNull$$$0(5);
        }
        for (ContentEntry contentEntry : contentEntries = model.getContentEntries()) {
            VirtualFile contentEntryFile = contentEntry.getFile();
            if (contentEntryFile == null || !VfsUtilCore.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)vFile, (boolean)false)) continue;
            return contentEntry;
        }
        return null;
    }

    public void update(AnActionEvent e) {
        RootsSelection selection = MarkRootActionBase.getSelection(e);
        this.doUpdate(e, selection.myModule, selection);
    }

    protected void doUpdate(@NotNull AnActionEvent e, @Nullable Module module2, @NotNull RootsSelection selection) {
        if (e == null) {
            MarkRootActionBase.$$$reportNull$$$0(6);
        }
        if (selection == null) {
            MarkRootActionBase.$$$reportNull$$$0(7);
        }
        boolean enabled = module2 != null && (!selection.mySelectedRoots.isEmpty() || !selection.mySelectedDirectories.isEmpty()) && selection.mySelectedExcludeRoots.isEmpty() && this.isEnabled(selection, module2);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    protected abstract boolean isEnabled(@NotNull RootsSelection var1, @NotNull Module var2);

    protected static RootsSelection getSelection(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Module module2 = MarkRootActionBase.getModule(e, files);
        if (module2 == null) {
            return RootsSelection.EMPTY;
        }
        RootsSelection selection = new RootsSelection(module2);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module2.getProject()).getFileIndex();
        for (VirtualFile file2 : files) {
            if (!file2.isDirectory()) {
                return RootsSelection.EMPTY;
            }
            ExcludeFolder excludeFolder = ProjectRootsUtil.findExcludeFolder(module2, file2);
            if (excludeFolder != null) {
                selection.mySelectedExcludeRoots.add(excludeFolder);
                continue;
            }
            SourceFolder folder = ProjectRootsUtil.findSourceFolder(module2, file2);
            if (folder != null) {
                selection.mySelectedRoots.add(folder);
                continue;
            }
            selection.mySelectedDirectories.add(file2);
            if (!fileIndex.isInSourceContent(file2)) continue;
            selection.myHaveSelectedFilesUnderSourceRoots = true;
        }
        return selection;
    }

    @Nullable
    static Module getModule(@NotNull AnActionEvent e, @Nullable VirtualFile[] files) {
        if (e == null) {
            MarkRootActionBase.$$$reportNull$$$0(8);
        }
        if (files == null) {
            return null;
        }
        Module module2 = (Module)e.getData(LangDataKeys.MODULE);
        if (module2 == null) {
            module2 = MarkRootActionBase.findParentModule(e.getProject(), files);
        }
        return module2;
    }

    @Nullable
    private static Module findParentModule(@Nullable Project project2, @NotNull VirtualFile[] files) {
        if (files == null) {
            MarkRootActionBase.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            return null;
        }
        Module result2 = null;
        DirectoryIndex index = DirectoryIndex.getInstance(project2);
        for (VirtualFile file2 : files) {
            Module module2 = index.getInfoForFile(file2).getModule();
            if (module2 == null) {
                return null;
            }
            if (result2 == null) {
                result2 = module2;
                continue;
            }
            if (result2.equals(module2)) continue;
            return null;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/actions/MarkRootActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "commitModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findContentEntry";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getModule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findParentModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$commitModel$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RootsSelection {
        public static final RootsSelection EMPTY = new RootsSelection(null);
        public final Module myModule;
        public List<SourceFolder> mySelectedRoots = new ArrayList<SourceFolder>();
        public List<ExcludeFolder> mySelectedExcludeRoots = new ArrayList<ExcludeFolder>();
        public List<VirtualFile> mySelectedDirectories = new ArrayList<VirtualFile>();
        public boolean myHaveSelectedFilesUnderSourceRoots;

        public RootsSelection(Module module2) {
            this.myModule = module2;
        }
    }
}

