/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.projectView.ProjectViewPsiTreeChangeListener;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewFileVisitor;
import com.intellij.ide.projectView.impl.ProjectViewNodeVisitor;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promises;

class AsyncProjectViewSupport {
    private static final Logger LOG = Logger.getInstance(AsyncProjectViewSupport.class);
    private final StructureTreeModel myStructureTreeModel = new StructureTreeModel(true);
    private final AsyncTreeModel myAsyncTreeModel;

    public AsyncProjectViewSupport(Disposable parent, Project project2, JTree tree, final AbstractTreeStructure structure, Comparator<NodeDescriptor> comparator2) {
        this.myStructureTreeModel.setStructure(structure);
        this.myStructureTreeModel.setComparator(comparator2);
        this.myAsyncTreeModel = new AsyncTreeModel((TreeModel)((Object)this.myStructureTreeModel), true);
        this.myAsyncTreeModel.setRootImmediately(this.myStructureTreeModel.getRootImmediately());
        AsyncProjectViewSupport.setModel(tree, this.myAsyncTreeModel);
        Disposer.register((Disposable)parent, (Disposable)this.myAsyncTreeModel);
        MessageBusConnection connection = project2.getMessageBus().connect(parent);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                AsyncProjectViewSupport.this.updateAll(null);
            }
        });
        connection.subscribe(BookmarksListener.TOPIC, (Object)new BookmarksListener(){

            @Override
            public void bookmarkAdded(@NotNull Bookmark bookmark) {
                if (bookmark == null) {
                    2.$$$reportNull$$$0(0);
                }
                AsyncProjectViewSupport.this.updateByFile(bookmark.getFile(), false);
            }

            @Override
            public void bookmarkRemoved(@NotNull Bookmark bookmark) {
                if (bookmark == null) {
                    2.$$$reportNull$$$0(1);
                }
                AsyncProjectViewSupport.this.updateByFile(bookmark.getFile(), false);
            }

            @Override
            public void bookmarkChanged(@NotNull Bookmark bookmark) {
                if (bookmark == null) {
                    2.$$$reportNull$$$0(2);
                }
                AsyncProjectViewSupport.this.updateByFile(bookmark.getFile(), false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "bookmark";
                objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bookmarkAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bookmarkRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bookmarkChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        PsiManager.getInstance((Project)project2).addPsiTreeChangeListener((PsiTreeChangeListener)new ProjectViewPsiTreeChangeListener(project2){

            @Override
            protected boolean isFlattenPackages() {
                return structure instanceof AbstractProjectTreeStructure && ((AbstractProjectTreeStructure)structure).isFlattenPackages();
            }

            @Override
            protected AbstractTreeUpdater getUpdater() {
                return null;
            }

            @Override
            protected DefaultMutableTreeNode getRootNode() {
                return null;
            }

            @Override
            protected void addSubtreeToUpdateByRoot() {
                AsyncProjectViewSupport.this.updateAll(null);
            }

            @Override
            protected boolean addSubtreeToUpdateByElement(PsiElement element) {
                AsyncProjectViewSupport.this.updateByElement(element, true);
                return true;
            }
        }, parent);
        FileStatusManager.getInstance((Project)project2).addFileStatusListener(new FileStatusListener(){

            public void fileStatusesChanged() {
                AsyncProjectViewSupport.this.updateAllPresentations();
            }

            public void fileStatusChanged(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                AsyncProjectViewSupport.this.updateByFile(file2, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$4", "fileStatusChanged"));
            }
        }, parent);
        CopyPasteManager.getInstance().addContentChangedListener((CopyPasteManager.ContentChangedListener)new CopyPasteUtil.DefaultCopyPasteListener(element -> this.updateByElement((PsiElement)element, true)), parent);
        WolfTheProblemSolver.getInstance((Project)project2).addProblemListener(new WolfTheProblemSolver.ProblemListener(){

            public void problemsAppeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                AsyncProjectViewSupport.this.updatePresentationsFromRootTo(file2);
            }

            public void problemsDisappeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                AsyncProjectViewSupport.this.updatePresentationsFromRootTo(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsAppeared";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsDisappeared";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parent);
    }

    public void setComparator(Comparator<NodeDescriptor> comparator2) {
        this.myStructureTreeModel.setComparator(comparator2);
    }

    public void select(JTree tree, Object object, VirtualFile file2) {
        PsiElement element;
        TreeVisitor visitor;
        if (object instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)object;
            object = node.getValue();
            LOG.debug("select AbstractTreeNode");
        }
        if ((visitor = AsyncProjectViewSupport.createVisitor(element = object instanceof PsiElement ? (PsiElement)object : null, file2, null)) != null) {
            TreeState.expand((JTree)tree, promise2 -> this.myAsyncTreeModel.accept(visitor).processed(path -> {
                if (path != null) {
                    TreeUtil.selectPath((JTree)tree, (TreePath)path);
                    promise2.setResult(null);
                } else if (element == null || file2 == null || Registry.is((String)"async.project.view.support.extra.select.disabled")) {
                    promise2.setResult(null);
                } else {
                    this.myAsyncTreeModel.accept(AsyncProjectViewSupport.createVisitor(null, file2, null)).processed(path2 -> {
                        if (path2 != null) {
                            TreeUtil.selectPath((JTree)tree, (TreePath)path2);
                        }
                        promise2.setResult(null);
                    });
                }
            }));
        }
    }

    public void updateAll(Runnable onDone) {
        LOG.debug((Throwable)new RuntimeException("reload a whole tree"));
        this.myStructureTreeModel.invalidate(onDone == null ? null : () -> this.myAsyncTreeModel.onValidThread(onDone));
    }

    public void update(@NotNull TreePath path, boolean structure) {
        if (path == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(0);
        }
        this.myStructureTreeModel.invalidate(path, structure);
    }

    public void update(@NotNull List<TreePath> list2, boolean structure) {
        if (list2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(1);
        }
        for (TreePath path : list2) {
            this.update(path, structure);
        }
    }

    public void updateByFile(@NotNull VirtualFile file2, boolean structure) {
        if (file2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(2);
        }
        LOG.debug(structure ? "updateChildrenByFile: " : "updatePresentationByFile: ", new Object[]{file2});
        this.update(null, file2, structure);
    }

    public void updateByElement(@NotNull PsiElement element, boolean structure) {
        if (element == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(3);
        }
        LOG.debug(structure ? "updateChildrenByElement: " : "updatePresentationByElement: ", new Object[]{element});
        this.update(element, null, structure);
    }

    private void update(PsiElement element, VirtualFile file2, boolean structure) {
        SmartList list2 = new SmartList();
        this.acceptAndUpdate(AsyncProjectViewSupport.createVisitor(element, file2, path -> !list2.add(path)), (List<TreePath>)list2, structure);
    }

    private void acceptAndUpdate(TreeVisitor visitor, List<TreePath> list2, boolean structure) {
        if (visitor != null) {
            this.myAsyncTreeModel.accept(visitor, false).done(path -> this.update(list2, structure));
        }
    }

    private void updatePresentationsFromRootTo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(4);
        }
        final SmartList list2 = new SmartList();
        this.acceptAndUpdate(new ProjectViewFileVisitor(file2, null){

            @Override
            @NotNull
            protected TreeVisitor.Action visit(@NotNull TreePath path, @NotNull AbstractTreeNode node, @NotNull VirtualFile element) {
                TreeVisitor.Action action;
                if (path == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (node == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    6.$$$reportNull$$$0(2);
                }
                if ((action = super.visit(path, node, element)) != TreeVisitor.Action.SKIP_CHILDREN) {
                    list2.add((Object)path);
                }
                TreeVisitor.Action action2 = action;
                if (action2 == null) {
                    6.$$$reportNull$$$0(3);
                }
                return action2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$6";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visit";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visit";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, (List<TreePath>)list2, false);
    }

    private void updateAllPresentations() {
        final SmartList list2 = new SmartList();
        this.acceptAndUpdate(new TreeVisitor(){

            @NotNull
            public TreeVisitor.Action visit(@NotNull TreePath path) {
                if (path == null) {
                    7.$$$reportNull$$$0(0);
                }
                list2.add((Object)path);
                TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
                if (action == null) {
                    7.$$$reportNull$$$0(1);
                }
                return action;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport$7";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visit";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visit";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, (List<TreePath>)list2, false);
    }

    void accept(List<TreeVisitor> visitors, Consumer<List<TreePath>> consumer) {
        int size;
        int n = size = visitors == null ? 0 : visitors.size();
        if (visitors != null && !visitors.isEmpty()) {
            this.myStructureTreeModel.getInvoker().invokeLater(() -> {
                if (1 == visitors.size()) {
                    this.myAsyncTreeModel.accept((TreeVisitor)visitors.get(0)).done(path -> {
                        if (path != null) {
                            consumer.consume(Collections.singletonList(path));
                        }
                    });
                } else if (size > 1) {
                    this.myStructureTreeModel.getInvoker().invokeLater(() -> {
                        List promises = visitors.stream().map(visitor -> this.myAsyncTreeModel.accept((TreeVisitor)visitor)).collect(Collectors.toList());
                        Promises.collectResults(promises, (boolean)true).done(list2 -> {
                            if (list2 != null && !list2.isEmpty()) {
                                consumer.consume(list2);
                            }
                        });
                    });
                }
            });
        }
    }

    static TreeVisitor createVisitor(Object object) {
        if (object instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)object;
            object = node.getValue();
        }
        return object instanceof PsiElement ? AsyncProjectViewSupport.createVisitor((PsiElement)object, null, null) : null;
    }

    static List<TreeVisitor> createVisitors(Iterable<Object> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        SmartList visitors = new SmartList();
        for (Object object : iterable) {
            TreeVisitor visitor = AsyncProjectViewSupport.createVisitor(object);
            if (visitor == null) continue;
            visitors.add(visitor);
        }
        return visitors;
    }

    private static TreeVisitor createVisitor(PsiElement element, VirtualFile file2, Predicate<TreePath> predicate) {
        if (element != null) {
            return new ProjectViewNodeVisitor(element, file2, predicate);
        }
        if (file2 != null) {
            return new ProjectViewFileVisitor(file2, predicate);
        }
        LOG.warn("cannot create visitor without element and/or file");
        return null;
    }

    private static void setModel(@NotNull JTree tree, @NotNull AsyncTreeModel model) {
        if (tree == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(5);
        }
        if (model == null) {
            AsyncProjectViewSupport.$$$reportNull$$$0(6);
        }
        tree.setModel((TreeModel)((Object)model));
        Disposer.register((Disposable)model, () -> {
            if (tree == null) {
                AsyncProjectViewSupport.$$$reportNull$$$0(7);
            }
            tree.setModel(null);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/impl/AsyncProjectViewSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateByFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateByElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePresentationsFromRootTo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setModel$12";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

