/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.PackagesPaneSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.ShowModulesAction;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PackageViewProjectNode;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageViewPane
extends AbstractProjectViewPSIPane {
    @NonNls
    public static final String ID = "PackagesPane";
    private final MyDeletePSIElementProvider myDeletePSIElementProvider = new MyDeletePSIElementProvider();

    public PackageViewPane(Project project2) {
        super(project2);
    }

    @Override
    public String getTitle() {
        return IdeBundle.message((String)"title.packages", (Object[])new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return AllIcons.General.PackagesTab;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            PackageViewPane.$$$reportNull$$$0(0);
        }
        return ID;
    }

    public AbstractTreeStructure getTreeStructure() {
        return this.myTreeStructure;
    }

    @Override
    protected PsiElement getPSIElement(@Nullable Object element) {
        if (element instanceof PackageElement) {
            PsiPackage aPackage = ((PackageElement)element).getPackage();
            return aPackage != null && aPackage.isValid() ? aPackage : null;
        }
        return super.getPSIElement(element);
    }

    @Override
    protected Module getNodeModule(@Nullable Object element) {
        if (element instanceof PackageElement) {
            return ((PackageElement)element).getModule();
        }
        return super.getNodeModule(element);
    }

    @Override
    public Object getData(String dataId) {
        PackageElement packageElement;
        PackageElement selectedPackageElement;
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) && (selectedPackageElement = this.getSelectedPackageElement()) != null) {
            return this.myDeletePSIElementProvider;
        }
        if (PackageElement.DATA_KEY.is(dataId)) {
            selectedPackageElement = this.getSelectedPackageElement();
        }
        if (LangDataKeys.MODULE.is(dataId) && (packageElement = this.getSelectedPackageElement()) != null) {
            return packageElement.getModule();
        }
        return super.getData(dataId);
    }

    @Nullable
    private PackageElement getSelectedPackageElement() {
        Object o;
        PackageElement result2 = null;
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null && (o = selectedNode.getUserObject()) instanceof AbstractTreeNode) {
            Object selected = ((AbstractTreeNode)o).getValue();
            result2 = selected instanceof PackageElement ? (PackageElement)selected : null;
        }
        return result2;
    }

    @Override
    @NotNull
    public PsiDirectory[] getSelectedDirectories() {
        ArrayList directories = ContainerUtil.newArrayList();
        for (PackageElementNode node : this.getSelectedNodes(PackageElementNode.class)) {
            PsiPackage parentNodePackage;
            Module module2;
            PackageElement packageElement = (PackageElement)node.getValue();
            PsiPackage aPackage = packageElement != null ? packageElement.getPackage() : null;
            Module module3 = module2 = packageElement != null ? packageElement.getModule() : null;
            if (aPackage == null || module2 == null) continue;
            GlobalSearchScope scope = GlobalSearchScope.moduleScope((Module)module2);
            Collections.addAll(directories, aPackage.getDirectories(scope));
            if (!Registry.is((String)"projectView.choose.directory.on.compacted.middle.packages")) continue;
            Object parentValue = node.getParent().getValue();
            PsiPackage psiPackage = parentNodePackage = parentValue instanceof PackageElement ? ((PackageElement)parentValue).getPackage() : null;
            while ((aPackage = aPackage.getParentPackage()) != null && !aPackage.getQualifiedName().isEmpty() && !aPackage.equals(parentNodePackage)) {
                Collections.addAll(directories, aPackage.getDirectories(scope));
            }
        }
        if (!directories.isEmpty()) {
            PsiDirectory[] psiDirectoryArray = directories.toArray(new PsiDirectory[directories.size()]);
            if (psiDirectoryArray == null) {
                PackageViewPane.$$$reportNull$$$0(1);
            }
            return psiDirectoryArray;
        }
        PsiDirectory[] psiDirectoryArray = super.getSelectedDirectories();
        if (psiDirectoryArray == null) {
            PackageViewPane.$$$reportNull$$$0(2);
        }
        return psiDirectoryArray;
    }

    @Override
    public void addToolbarActions(DefaultActionGroup actionGroup) {
        actionGroup.addAction((AnAction)new ShowModulesAction(this.myProject){

            @Override
            @NotNull
            protected String getId() {
                String string = PackageViewPane.this.getId();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/PackageViewPane$1", "getId"));
            }
        }).setAsSecondary(true);
        actionGroup.addAction((AnAction)this.createFlattenModulesAction(() -> true)).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ShowLibraryContentsAction()).setAsSecondary(true);
    }

    @Override
    protected AbstractTreeUpdater createTreeUpdater(AbstractTreeBuilder treeBuilder) {
        return new PackageViewTreeUpdater(treeBuilder);
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new PackagesPaneSelectInTarget(this.myProject);
    }

    @Override
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectTreeStructure(this.myProject, ID){

            @Override
            protected AbstractTreeNode createRoot(Project project2, ViewSettings settings) {
                return new PackageViewProjectNode(project2, settings);
            }

            public boolean isToBuildChildrenInBackground(Object element) {
                return Registry.is((String)"ide.projectView.PackageViewTreeStructure.BuildChildrenInBackground");
            }
        };
    }

    @Override
    protected ProjectViewTree createTree(DefaultTreeModel treeModel) {
        return new ProjectViewTree(this.myProject, treeModel){

            public String toString() {
                return PackageViewPane.this.getTitle() + " " + super.toString();
            }
        };
    }

    @NotNull
    public String getComponentName() {
        if (ID == null) {
            PackageViewPane.$$$reportNull$$$0(3);
        }
        return ID;
    }

    @Override
    public int getWeight() {
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/projectView/impl/PackageViewPane";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectories";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private final class MyDeletePSIElementProvider
    implements DeleteProvider {
        private MyDeletePSIElementProvider() {
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeletePSIElementProvider.$$$reportNull$$$0(0);
            }
            for (PsiDirectory directory : PackageViewPane.this.getSelectedDirectories()) {
                if (directory.getManager().isInProject((PsiElement)directory)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeletePSIElementProvider.$$$reportNull$$$0(1);
            }
            List<PsiDirectory> allElements = Arrays.asList(PackageViewPane.this.getSelectedDirectories());
            ArrayList<PsiElement> validElements = new ArrayList<PsiElement>();
            for (PsiElement psiElement : allElements) {
                if (psiElement == null || !psiElement.isValid()) continue;
                validElements.add(psiElement);
            }
            PsiElement[] elements = PsiUtilCore.toPsiElementArray(validElements);
            LocalHistoryAction localHistoryAction = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, PackageViewPane.this.myProject);
            }
            finally {
                localHistoryAction.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/ide/projectView/impl/PackageViewPane$MyDeletePSIElementProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class PackageViewTreeUpdater
    extends AbstractTreeUpdater {
        private PackageViewTreeUpdater(AbstractTreeBuilder treeBuilder) {
            super(treeBuilder);
        }

        public boolean addSubtreeToUpdateByElement(Object element) {
            if (element instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)element;
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(dir);
                if (ProjectView.getInstance(PackageViewPane.this.myProject).isShowModules(PackageViewPane.this.getId())) {
                    Module[] modules = this.getModulesFor(dir);
                    boolean rv = false;
                    for (Module module2 : modules) {
                        rv |= this.addPackageElementToUpdate(aPackage, module2);
                    }
                    return rv;
                }
                return this.addPackageElementToUpdate(aPackage, null);
            }
            return super.addSubtreeToUpdateByElement(element);
        }

        private boolean addPackageElementToUpdate(PsiPackage aPackage, Module module2) {
            boolean addedOk;
            PsiPackage packageToUpdateFrom;
            ProjectTreeStructure packageTreeStructure = (ProjectTreeStructure)PackageViewPane.this.myTreeStructure;
            if (!packageTreeStructure.isFlattenPackages() && packageTreeStructure.isHideEmptyMiddlePackages()) {
                for (packageToUpdateFrom = aPackage; packageToUpdateFrom != null && packageToUpdateFrom.isValid() && PackageUtil.isPackageEmpty(packageToUpdateFrom, module2, true, false); packageToUpdateFrom = packageToUpdateFrom.getParentPackage()) {
                }
            }
            while (!(addedOk = super.addSubtreeToUpdateByElement(this.getTreeElementToUpdateFrom(packageToUpdateFrom, module2))) && packageToUpdateFrom != null) {
                packageToUpdateFrom = packageToUpdateFrom.getParentPackage();
            }
            return addedOk;
        }

        private Object getTreeElementToUpdateFrom(PsiPackage packageToUpdateFrom, Module module2) {
            if (packageToUpdateFrom == null || !packageToUpdateFrom.isValid() || "".equals(packageToUpdateFrom.getQualifiedName())) {
                return module2 == null ? PackageViewPane.this.myTreeStructure.getRootElement() : module2;
            }
            return new PackageElement(module2, packageToUpdateFrom, false);
        }

        private Module[] getModulesFor(PsiDirectory dir) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)PackageViewPane.this.myProject).getFileIndex();
            VirtualFile vFile = dir.getVirtualFile();
            HashSet<Module> modules = new HashSet<Module>();
            Module module2 = fileIndex.getModuleForFile(vFile);
            if (module2 != null) {
                modules.add(module2);
            }
            if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
                List orderEntries = fileIndex.getOrderEntriesForFile(vFile);
                if (orderEntries.isEmpty()) {
                    return Module.EMPTY_ARRAY;
                }
                for (OrderEntry entry : orderEntries) {
                    modules.add(entry.getOwnerModule());
                }
            }
            return modules.toArray(new Module[modules.size()]);
        }
    }

    private final class ShowLibraryContentsAction
    extends ToggleAction {
        private ShowLibraryContentsAction() {
            super(IdeBundle.message((String)"action.show.libraries.contents", (Object[])new Object[0]), IdeBundle.message((String)"action.show.hide.library.contents", (Object[])new Object[0]), AllIcons.ObjectBrowser.ShowLibraryContents);
        }

        public boolean isSelected(AnActionEvent event) {
            return ProjectView.getInstance(PackageViewPane.this.myProject).isShowLibraryContents(PackageViewPane.this.getId());
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            ProjectViewImpl projectView = (ProjectViewImpl)ProjectView.getInstance(PackageViewPane.this.myProject);
            projectView.setShowLibraryContents(flag, PackageViewPane.this.getId());
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            ProjectViewImpl projectView = (ProjectViewImpl)ProjectView.getInstance(PackageViewPane.this.myProject);
            presentation.setVisible(projectView.getCurrentProjectViewPane() == PackageViewPane.this);
        }
    }
}

