/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ProjectTopics;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.SmartSelectInContext;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.AsyncProjectViewSupport;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.ProjectViewSharedSettings;
import com.intellij.ide.projectView.impl.ProjectViewStatistics;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.components.JBList;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ProjectViewImpl
extends ProjectView
implements PersistentStateComponent<Element>,
Disposable,
QuickActionProvider,
BusyObject {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.impl.ProjectViewImpl");
    private static final Key<String> ID_KEY = Key.create((String)"pane-id");
    private static final Key<String> SUB_ID_KEY = Key.create((String)"pane-sub-id");
    private final CopyPasteDelegator myCopyPasteDelegator;
    private boolean isInitialized;
    private boolean myExtensionsLoaded;
    @NotNull
    private final Project myProject;
    private final Map<String, Boolean> myFlattenPackages;
    private static final boolean ourFlattenPackagesDefaults = false;
    private final Map<String, Boolean> myShowMembers;
    private static final boolean ourShowMembersDefaults = false;
    private final Map<String, Boolean> myManualOrder;
    private static final boolean ourManualOrderDefaults = false;
    private final Map<String, Boolean> mySortByType;
    private static final boolean ourSortByTypeDefaults = false;
    private final Map<String, Boolean> myShowModules;
    private static final boolean ourShowModulesDefaults = true;
    private final Map<String, Boolean> myFlattenModules;
    private static final boolean ourFlattenModulesDefaults = false;
    private final Map<String, Boolean> myShowLibraryContents;
    private static final boolean ourShowLibraryContentsDefaults = true;
    private final Map<String, Boolean> myHideEmptyPackages;
    private static final boolean ourHideEmptyPackagesDefaults = true;
    private final Map<String, Boolean> myAbbreviatePackageNames;
    private static final boolean ourAbbreviatePackagesDefaults = false;
    private final Map<String, Boolean> myAutoscrollToSource;
    private final Map<String, Boolean> myAutoscrollFromSource;
    private static final boolean ourAutoscrollFromSourceDefaults = false;
    private boolean myFoldersAlwaysOnTop;
    private String myCurrentViewId;
    private String myCurrentViewSubId;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final MyAutoScrollFromSourceHandler myAutoScrollFromSourceHandler;
    private final IdeView myIdeView;
    private final MyDeletePSIElementProvider myDeletePSIElementProvider;
    private final ModuleDeleteProvider myDeleteModuleProvider;
    private SimpleToolWindowPanel myPanel;
    private final Map<String, AbstractProjectViewPane> myId2Pane;
    private final Collection<AbstractProjectViewPane> myUninitializedPanes;
    private static final DataKey<ProjectViewImpl> DATA_KEY = DataKey.create((String)"com.intellij.ide.projectView.impl.ProjectViewImpl");
    private DefaultActionGroup myActionGroup;
    private String mySavedPaneId;
    private String mySavedPaneSubId;
    @NonNls
    private static final String ELEMENT_NAVIGATOR = "navigator";
    @NonNls
    private static final String ELEMENT_PANES = "panes";
    @NonNls
    private static final String ELEMENT_PANE = "pane";
    @NonNls
    private static final String ATTRIBUTE_CURRENT_VIEW = "currentView";
    @NonNls
    private static final String ATTRIBUTE_CURRENT_SUBVIEW = "currentSubView";
    @NonNls
    private static final String ELEMENT_FLATTEN_PACKAGES = "flattenPackages";
    @NonNls
    private static final String ELEMENT_SHOW_MEMBERS = "showMembers";
    @NonNls
    private static final String ELEMENT_SHOW_MODULES = "showModules";
    @NonNls
    private static final String ELEMENT_SHOW_LIBRARY_CONTENTS = "showLibraryContents";
    @NonNls
    private static final String ELEMENT_HIDE_EMPTY_PACKAGES = "hideEmptyPackages";
    @NonNls
    private static final String ELEMENT_ABBREVIATE_PACKAGE_NAMES = "abbreviatePackageNames";
    @NonNls
    private static final String ELEMENT_AUTOSCROLL_TO_SOURCE = "autoscrollToSource";
    @NonNls
    private static final String ELEMENT_AUTOSCROLL_FROM_SOURCE = "autoscrollFromSource";
    @NonNls
    private static final String ELEMENT_SORT_BY_TYPE = "sortByType";
    @NonNls
    private static final String ELEMENT_FOLDERS_ALWAYS_ON_TOP = "foldersAlwaysOnTop";
    @NonNls
    private static final String ELEMENT_MANUAL_ORDER = "manualOrder";
    private static final String ATTRIBUTE_ID = "id";
    private JPanel myViewContentPanel;
    private static final Comparator<AbstractProjectViewPane> PANE_WEIGHT_COMPARATOR = (o1, o2) -> o1.getWeight() - o2.getWeight();
    private final FileEditorManager myFileEditorManager;
    private final MyPanel myDataProvider;
    private final SplitterProportionsData splitterProportions;
    private final MessageBusConnection myConnection;
    private final Map<String, Element> myUninitializedPaneState;
    private final Map<String, SelectInTarget> mySelectInTargets;
    private ContentManager myContentManager;

    public ProjectViewImpl(@NotNull Project project2, FileEditorManager fileEditorManager, final ToolWindowManagerEx toolWindowManager) {
        if (project2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(0);
        }
        this.myExtensionsLoaded = false;
        this.myFlattenPackages = new THashMap();
        this.myShowMembers = new THashMap();
        this.myManualOrder = new THashMap();
        this.mySortByType = new THashMap();
        this.myShowModules = new THashMap();
        this.myFlattenModules = new THashMap();
        this.myShowLibraryContents = new THashMap();
        this.myHideEmptyPackages = new THashMap();
        this.myAbbreviatePackageNames = new THashMap();
        this.myAutoscrollToSource = new THashMap();
        this.myAutoscrollFromSource = new THashMap();
        this.myFoldersAlwaysOnTop = true;
        this.myIdeView = new MyIdeView();
        this.myDeletePSIElementProvider = new MyDeletePSIElementProvider();
        this.myDeleteModuleProvider = new ModuleDeleteProvider();
        this.myId2Pane = new LinkedHashMap<String, AbstractProjectViewPane>();
        this.myUninitializedPanes = new THashSet();
        this.mySavedPaneId = "ProjectPane";
        this.splitterProportions = new SplitterProportionsDataImpl();
        this.myUninitializedPaneState = new HashMap<String, Element>();
        this.mySelectInTargets = new LinkedHashMap<String, SelectInTarget>();
        this.myProject = project2;
        this.constructUi();
        this.myFileEditorManager = fileEditorManager;
        this.myConnection = project2.getMessageBus().connect();
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ProjectViewImpl.this.refresh();
            }
        });
        this.myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler();
        this.myDataProvider = new MyPanel();
        this.myDataProvider.add((Component)this.myPanel, "Center");
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, (JComponent)this.myPanel){

            @Override
            @NotNull
            protected PsiElement[] getSelectedElements() {
                AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
                PsiElement[] psiElementArray = viewPane == null ? PsiElement.EMPTY_ARRAY : viewPane.getSelectedPSIElements();
                if (psiElementArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewImpl$2", "getSelectedElements"));
            }
        };
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return ProjectViewImpl.this.isAutoscrollToSource(ProjectViewImpl.this.myCurrentViewId);
            }

            protected void setAutoScrollMode(boolean state) {
                ProjectViewImpl.this.setAutoscrollToSource(state, ProjectViewImpl.this.myCurrentViewId);
            }
        };
        toolWindowManager.addToolWindowManagerListener(new ToolWindowManagerAdapter(){
            private boolean toolWindowVisible;

            @Override
            public void stateChanged() {
                ToolWindow window = toolWindowManager.getToolWindow(ToolWindowId.PROJECT_VIEW);
                if (window == null) {
                    return;
                }
                if (window.isVisible() && !this.toolWindowVisible) {
                    AbstractProjectViewPane currentProjectViewPane;
                    String id = ProjectViewImpl.this.getCurrentViewId();
                    if (ProjectViewImpl.this.isAutoscrollToSource(id) && (currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane()) != null) {
                        ProjectViewImpl.this.myAutoScrollToSourceHandler.onMouseClicked((Component)currentProjectViewPane.getTree());
                    }
                    if (ProjectViewImpl.this.isAutoscrollFromSource(id)) {
                        ProjectViewImpl.this.myAutoScrollFromSourceHandler.setAutoScrollEnabled(true);
                    }
                }
                this.toolWindowVisible = window.isVisible();
            }
        });
    }

    private void constructUi() {
        this.myViewContentPanel = new JPanel();
        this.myPanel = new SimpleToolWindowPanel(true).setProvideQuickActions(false);
        this.myPanel.setContent((JComponent)this.myViewContentPanel);
    }

    @NotNull
    public String getName() {
        if ("Project" == null) {
            ProjectViewImpl.$$$reportNull$$$0(1);
        }
        return "Project";
    }

    @NotNull
    public List<AnAction> getActions(boolean originalProvider) {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        DefaultActionGroup views = new DefaultActionGroup("Change View", true);
        ChangeViewAction lastHeader = null;
        for (int i = 0; i < this.myContentManager.getContentCount(); ++i) {
            Content each = this.myContentManager.getContent(i);
            if (each == null) continue;
            String id = (String)each.getUserData(ID_KEY);
            String subId = (String)each.getUserData(SUB_ID_KEY);
            ChangeViewAction newHeader = new ChangeViewAction(id, subId);
            if (lastHeader != null) {
                boolean newHasKids;
                boolean lastHasKids = lastHeader.mySubId != null;
                boolean bl = newHasKids = newHeader.mySubId != null;
                if (lastHasKids != newHasKids || lastHasKids && lastHeader.myId != newHeader.myId) {
                    views.add((AnAction)Separator.getInstance());
                }
            }
            views.add((AnAction)newHeader);
            lastHeader = newHeader;
        }
        result2.add((AnAction)views);
        result2.add((AnAction)Separator.getInstance());
        if (this.myActionGroup != null) {
            ArrayList<AnAction> secondary = new ArrayList<AnAction>();
            for (AnAction each : this.myActionGroup.getChildren(null)) {
                if (this.myActionGroup.isPrimary(each)) {
                    result2.add(each);
                    continue;
                }
                secondary.add(each);
            }
            result2.add((AnAction)Separator.getInstance());
            result2.addAll(secondary);
        }
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            ProjectViewImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    public synchronized void addProjectPane(@NotNull AbstractProjectViewPane pane) {
        if (pane == null) {
            ProjectViewImpl.$$$reportNull$$$0(3);
        }
        this.myUninitializedPanes.add(pane);
        SelectInTarget selectInTarget = pane.createSelectInTarget();
        if (selectInTarget != null) {
            this.mySelectInTargets.put(pane.getId(), selectInTarget);
        }
        if (this.isInitialized) {
            this.doAddUninitializedPanes();
        }
    }

    @Override
    public synchronized void removeProjectPane(@NotNull AbstractProjectViewPane pane) {
        if (pane == null) {
            ProjectViewImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUninitializedPanes.remove(pane);
        String idToRemove = pane.getId();
        if (!this.myId2Pane.containsKey(idToRemove)) {
            return;
        }
        pane.removeTreeChangeListener();
        for (int i = this.getContentManager().getContentCount() - 1; i >= 0; --i) {
            String id;
            Content content = this.getContentManager().getContent(i);
            String string = id = content != null ? (String)content.getUserData(ID_KEY) : null;
            if (id == null || !id.equals(idToRemove)) continue;
            this.getContentManager().removeContent(content, true);
        }
        this.myId2Pane.remove(idToRemove);
        this.mySelectInTargets.remove(idToRemove);
        this.viewSelectionChanged();
    }

    private synchronized void doAddUninitializedPanes() {
        for (AbstractProjectViewPane pane : this.myUninitializedPanes) {
            this.doAddPane(pane);
        }
        Content contents = this.getContentManager().getContents();
        for (int i = 1; i < ((Content[])contents).length; ++i) {
            Content content = contents[i];
            Content prev = contents[i - 1];
            if (StringUtil.equals((CharSequence)((CharSequence)content.getUserData(ID_KEY)), (CharSequence)((CharSequence)prev.getUserData(ID_KEY))) || prev.getUserData(SUB_ID_KEY) == null || content.getSeparator() != null) continue;
            content.setSeparator("");
        }
        String selectID = null;
        String selectSubID = null;
        for (Content content : contents) {
            String id = (String)content.getUserData(ID_KEY);
            String subId = (String)content.getUserData(SUB_ID_KEY);
            if (id == null || !id.equals(this.mySavedPaneId) || !StringUtil.equals((CharSequence)subId, (CharSequence)this.mySavedPaneSubId)) continue;
            selectID = id;
            selectSubID = subId;
            this.mySavedPaneId = null;
            this.mySavedPaneSubId = null;
            break;
        }
        if (selectID == null && ((Content)contents).length > 0 && this.myCurrentViewId == null) {
            Content content = contents[0];
            selectID = (String)content.getUserData(ID_KEY);
            selectSubID = (String)content.getUserData(SUB_ID_KEY);
        }
        if (selectID != null) {
            this.changeView(selectID, selectSubID);
        }
        this.myUninitializedPanes.clear();
    }

    private void doAddPane(@NotNull AbstractProjectViewPane newPane) {
        String[] stringArray;
        int index;
        if (newPane == null) {
            ProjectViewImpl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ContentManager manager = this.getContentManager();
        for (index = 0; index < manager.getContentCount(); ++index) {
            Content content = manager.getContent(index);
            String id = (String)content.getUserData(ID_KEY);
            AbstractProjectViewPane pane = this.myId2Pane.get(id);
            int comp = PANE_WEIGHT_COMPARATOR.compare(pane, newPane);
            LOG.assertTrue(comp != 0, (Object)("Project view pane " + newPane + " has the same weight as " + pane + ". Please make sure that you overload getWeight() and return a distinct weight value."));
            if (comp > 0) break;
        }
        String id = newPane.getId();
        this.myId2Pane.put(id, newPane);
        String[] subIds = newPane.getSubIds();
        if (subIds.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = null;
        } else {
            stringArray = subIds;
        }
        subIds = stringArray;
        boolean first = true;
        for (String subId : subIds) {
            String title = subId != null ? newPane.getPresentableSubIdName(subId) : newPane.getTitle();
            Content content = this.getContentManager().getFactory().createContent(this.getComponent(), title, false);
            content.setTabName(title);
            content.putUserData(ID_KEY, (Object)id);
            content.putUserData(SUB_ID_KEY, (Object)subId);
            content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            content.setIcon(newPane.getIcon());
            content.setPopupIcon(subId != null ? AllIcons.General.Bullet : newPane.getIcon());
            content.setPreferredFocusedComponent(() -> {
                AbstractProjectViewPane current = this.getCurrentProjectViewPane();
                return current != null ? current.getComponentToFocus() : null;
            });
            content.setBusyObject((BusyObject)this);
            if (first && subId != null) {
                content.setSeparator(newPane.getTitle());
            }
            manager.addContent(content, index++);
            first = false;
        }
    }

    private void showPane(@NotNull AbstractProjectViewPane newPane) {
        if (newPane == null) {
            ProjectViewImpl.$$$reportNull$$$0(6);
        }
        AbstractProjectViewPane currentPane = this.getCurrentProjectViewPane();
        PsiElement selectedPsiElement = null;
        if (currentPane != null) {
            PsiElement[] elements;
            if (currentPane != newPane) {
                currentPane.saveExpandedPaths();
            }
            if ((elements = currentPane.getSelectedPSIElements()).length > 0) {
                selectedPsiElement = elements[0];
            }
        }
        this.myViewContentPanel.removeAll();
        JComponent component = newPane.createComponent();
        UIUtil.removeScrollBorder((Component)component);
        this.myViewContentPanel.setLayout(new BorderLayout());
        this.myViewContentPanel.add((Component)component, "Center");
        this.myCurrentViewId = newPane.getId();
        String newSubId = this.myCurrentViewSubId = newPane.getSubId();
        this.myViewContentPanel.revalidate();
        this.myViewContentPanel.repaint();
        this.createToolbarActions();
        this.myAutoScrollToSourceHandler.install((JTree)((Object)newPane.myTree));
        IdeFocusManager.getInstance((Project)this.myProject).requestFocusInProject((Component)newPane.getComponentToFocus(), this.myProject);
        newPane.restoreExpandedPaths();
        if (selectedPsiElement != null && newSubId != null) {
            ProjectViewSelectInTarget target2;
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)selectedPsiElement);
            ProjectViewSelectInTarget projectViewSelectInTarget = target2 = virtualFile == null ? null : this.getProjectViewSelectInTarget(newPane);
            if (target2 != null && target2.isSubIdSelectable(newSubId, (SelectInContext)new FileSelectInContext(this.myProject, virtualFile, null))) {
                newPane.select(selectedPsiElement, virtualFile, true);
            }
        }
        this.myAutoScrollToSourceHandler.onMouseClicked((Component)((Object)newPane.myTree));
    }

    public synchronized void setupImpl(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            ProjectViewImpl.$$$reportNull$$$0(7);
        }
        this.setupImpl(toolWindow, true);
    }

    public synchronized void setupImpl(@NotNull ToolWindow toolWindow, boolean loadPaneExtensions) {
        if (toolWindow == null) {
            ProjectViewImpl.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myActionGroup = new DefaultActionGroup();
        this.myAutoScrollFromSourceHandler.install();
        this.myContentManager = toolWindow.getContentManager();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            toolWindow.setDefaultContentUiType(ToolWindowContentUiType.COMBO);
            ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)this.myActionGroup);
            toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        }
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        SwingUtilities.invokeLater(() -> this.splitterProportions.restoreSplitterProportions((Component)this.myPanel));
        if (loadPaneExtensions) {
            this.ensurePanesLoaded();
        }
        this.isInitialized = true;
        this.doAddUninitializedPanes();
        this.getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    ProjectViewImpl.this.viewSelectionChanged(true);
                }
            }
        });
        this.viewSelectionChanged();
    }

    private void ensurePanesLoaded() {
        if (this.myExtensionsLoaded) {
            return;
        }
        this.myExtensionsLoaded = true;
        AbstractProjectViewPane[] extensions = (AbstractProjectViewPane[])Extensions.getExtensions(AbstractProjectViewPane.EP_NAME, (AreaInstance)this.myProject);
        Arrays.sort(extensions, PANE_WEIGHT_COMPARATOR);
        for (AbstractProjectViewPane pane : extensions) {
            if (this.myUninitializedPaneState.containsKey(pane.getId())) {
                try {
                    pane.readExternal(this.myUninitializedPaneState.get(pane.getId()));
                }
                catch (InvalidDataException invalidDataException) {
                    // empty catch block
                }
                this.myUninitializedPaneState.remove(pane.getId());
            }
            if (!pane.isInitiallyVisible() || this.myId2Pane.containsKey(pane.getId())) continue;
            this.addProjectPane(pane);
        }
    }

    private boolean viewSelectionChanged() {
        return this.viewSelectionChanged(false);
    }

    private boolean viewSelectionChanged(boolean fromContentManager) {
        ProjectViewSelectInTarget target2;
        Content content = this.getContentManager().getSelectedContent();
        if (content == null) {
            return false;
        }
        String id = (String)content.getUserData(ID_KEY);
        String subId = (String)content.getUserData(SUB_ID_KEY);
        if (content.equals(Pair.create((Object)this.myCurrentViewId, (Object)this.myCurrentViewSubId))) {
            return false;
        }
        AbstractProjectViewPane newPane = this.getProjectViewPaneById(id);
        if (newPane == null) {
            return false;
        }
        newPane.setSubId(subId);
        this.showPane(newPane);
        if (fromContentManager) {
            ProjectViewStatistics.recordProjectViewPaneUsage(this.myCurrentViewId, this.myCurrentViewSubId);
        }
        if ((target2 = this.getProjectViewSelectInTarget(newPane)) != null) {
            target2.setSubId(subId);
        }
        if (this.isAutoscrollFromSource(id)) {
            this.myAutoScrollFromSourceHandler.scrollFromSource();
        }
        return true;
    }

    private void createToolbarActions() {
        if (this.myActionGroup == null) {
            return;
        }
        List titleActions = ContainerUtil.newSmartList();
        this.myActionGroup.removeAll();
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsFlattenPackages()) {
            this.myActionGroup.addAction((AnAction)new PaneOptionAction((Map)this.myFlattenPackages, IdeBundle.message((String)"action.flatten.packages", (Object[])new Object[0]), IdeBundle.message((String)"action.flatten.packages", (Object[])new Object[0]), PlatformIcons.FLATTEN_PACKAGES_ICON, false){

                @Override
                public void setSelected(AnActionEvent event, boolean flag) {
                    AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
                    SelectionInfo selectionInfo = SelectionInfo.create(viewPane);
                    if (ProjectViewImpl.this.isGlobalOptions()) {
                        ProjectViewImpl.this.setFlattenPackages(flag, viewPane.getId());
                    }
                    super.setSelected(event, flag);
                    selectionInfo.apply(viewPane);
                }

                @Override
                public boolean isSelected(AnActionEvent event) {
                    if (ProjectViewImpl.this.isGlobalOptions()) {
                        return ProjectViewImpl.this.getGlobalOptions().getFlattenPackages();
                    }
                    return super.isSelected(event);
                }
            }).setAsSecondary(true);
        }
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsHideEmptyMiddlePackages()) {
            this.myActionGroup.addAction((AnAction)new HideEmptyMiddlePackagesAction()).setAsSecondary(true);
        }
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsFlattenPackages()) {
            class FlattenPackagesDependableAction
            extends PaneOptionAction {
                FlattenPackagesDependableAction(@NotNull Map<String, Boolean> optionsMap, @NotNull String text2, @NotNull String description, Icon icon, boolean optionDefaultValue) {
                    if (optionsMap == null) {
                        FlattenPackagesDependableAction.$$$reportNull$$$0(0);
                    }
                    if (text2 == null) {
                        FlattenPackagesDependableAction.$$$reportNull$$$0(1);
                    }
                    if (description == null) {
                        FlattenPackagesDependableAction.$$$reportNull$$$0(2);
                    }
                    if (icon == null) {
                        FlattenPackagesDependableAction.$$$reportNull$$$0(3);
                    }
                    super(optionsMap, text2, description, icon, optionDefaultValue);
                }

                @Override
                public void setSelected(AnActionEvent event, boolean flag) {
                    if (ProjectViewImpl.this.isGlobalOptions()) {
                        ProjectViewImpl.this.getGlobalOptions().setFlattenPackages(flag);
                    }
                    super.setSelected(event, flag);
                }

                public void update(AnActionEvent e) {
                    super.update(e);
                    Presentation presentation = e.getPresentation();
                    presentation.setVisible(ProjectViewImpl.this.isFlattenPackages(ProjectViewImpl.this.myCurrentViewId));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "optionsMap";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "text";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "description";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[0] = "icon";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$1FlattenPackagesDependableAction";
                    objectArray[2] = "<init>";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            this.myActionGroup.addAction((AnAction)new FlattenPackagesDependableAction((Map)this.myAbbreviatePackageNames, IdeBundle.message((String)"action.abbreviate.qualified.package.names", (Object[])new Object[0]), IdeBundle.message((String)"action.abbreviate.qualified.package.names", (Object[])new Object[0]), AllIcons.ObjectBrowser.AbbreviatePackageNames, false){
                {
                    super(optionsMap, text2, description, icon, optionDefaultValue);
                }

                @Override
                public boolean isSelected(AnActionEvent event) {
                    return ProjectViewImpl.this.isFlattenPackages(ProjectViewImpl.this.myCurrentViewId) && ProjectViewImpl.this.isAbbreviatePackageNames(ProjectViewImpl.this.myCurrentViewId);
                }

                @Override
                public void setSelected(AnActionEvent event, boolean flag) {
                    if (ProjectViewImpl.this.isGlobalOptions()) {
                        ProjectViewImpl.this.setAbbreviatePackageNames(flag, ProjectViewImpl.this.myCurrentViewId);
                    }
                    ProjectViewImpl.this.setPaneOption(this.myOptionsMap, flag, ProjectViewImpl.this.myCurrentViewId, true);
                }

                @Override
                public void update(AnActionEvent e) {
                    super.update(e);
                    if ("Scope".equals(ProjectViewImpl.this.myCurrentViewId)) {
                        e.getPresentation().setEnabled(false);
                    }
                }
            }).setAsSecondary(true);
        }
        if (this.isShowMembersOptionSupported()) {
            this.myActionGroup.addAction((AnAction)new PaneOptionAction((Map)this.myShowMembers, IdeBundle.message((String)"action.show.members", (Object[])new Object[0]), IdeBundle.message((String)"action.show.hide.members", (Object[])new Object[0]), AllIcons.ObjectBrowser.ShowMembers, false){

                @Override
                public boolean isSelected(AnActionEvent event) {
                    if (ProjectViewImpl.this.isGlobalOptions()) {
                        return ProjectViewImpl.this.getGlobalOptions().getShowMembers();
                    }
                    return super.isSelected(event);
                }

                @Override
                public void setSelected(AnActionEvent event, boolean flag) {
                    if (ProjectViewImpl.this.isGlobalOptions()) {
                        ProjectViewImpl.this.getGlobalOptions().setShowMembers(flag);
                    }
                    super.setSelected(event, flag);
                }
            }).setAsSecondary(true);
        }
        this.myActionGroup.addAction((AnAction)this.myAutoScrollToSourceHandler.createToggleAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)this.myAutoScrollFromSourceHandler.createToggleAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)new ManualOrderAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)new SortByTypeAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)new FoldersAlwaysOnTopAction()).setAsSecondary(true);
        if (!this.myAutoScrollFromSourceHandler.isAutoScrollEnabled()) {
            titleActions.add(new ScrollFromSourceAction());
        }
        AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction(new TreeExpander(){

            public void expandAll() {
            }

            public boolean canExpand() {
                return false;
            }

            public void collapseAll() {
                AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
                DnDAwareTree tree = pane.myTree;
                if (tree != null) {
                    TreeUtil.collapseAll((JTree)((Object)tree), (int)0);
                }
            }

            public boolean canCollapse() {
                return true;
            }
        }, this.getComponent());
        collapseAllAction.getTemplatePresentation().setIcon(AllIcons.General.CollapseAll);
        collapseAllAction.getTemplatePresentation().setHoveredIcon(AllIcons.General.CollapseAllHover);
        titleActions.add(collapseAllAction);
        this.getCurrentProjectViewPane().addToolbarActions(this.myActionGroup);
        ToolWindowEx window = (ToolWindowEx)ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.PROJECT_VIEW);
        if (window != null) {
            window.setTitleActions(titleActions.toArray(new AnAction[titleActions.size()]));
        }
    }

    protected boolean isShowMembersOptionSupported() {
        return true;
    }

    @Override
    public AbstractProjectViewPane getProjectViewPaneById(String id) {
        AbstractProjectViewPane pane;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.ensurePanesLoaded();
        }
        if ((pane = this.myId2Pane.get(id)) != null) {
            return pane;
        }
        for (AbstractProjectViewPane viewPane : this.myUninitializedPanes) {
            if (!viewPane.getId().equals(id)) continue;
            return viewPane;
        }
        return null;
    }

    @Override
    public AbstractProjectViewPane getCurrentProjectViewPane() {
        return this.getProjectViewPaneById(this.myCurrentViewId);
    }

    @Override
    public void refresh() {
        AbstractProjectViewPane currentProjectViewPane = this.getCurrentProjectViewPane();
        if (currentProjectViewPane != null) {
            currentProjectViewPane.updateFromRoot(false);
        }
    }

    @Override
    public void select(Object element, VirtualFile file2, boolean requestFocus) {
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane != null) {
            viewPane.select(element, file2, requestFocus);
        }
    }

    @Override
    @NotNull
    public ActionCallback selectCB(Object element, VirtualFile file2, boolean requestFocus) {
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane != null && viewPane instanceof AbstractProjectViewPSIPane) {
            ActionCallback actionCallback = ((AbstractProjectViewPSIPane)viewPane).selectCB(element, file2, requestFocus);
            if (actionCallback == null) {
                ProjectViewImpl.$$$reportNull$$$0(9);
            }
            return actionCallback;
        }
        this.select(element, file2, requestFocus);
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            ProjectViewImpl.$$$reportNull$$$0(10);
        }
        return actionCallback;
    }

    public void dispose() {
        this.myConnection.disconnect();
    }

    public JComponent getComponent() {
        return this.myDataProvider;
    }

    @Override
    public String getCurrentViewId() {
        return this.myCurrentViewId;
    }

    private SelectInTarget getCurrentSelectInTarget() {
        return this.getSelectInTarget(this.getCurrentViewId());
    }

    private SelectInTarget getSelectInTarget(String id) {
        return this.mySelectInTargets.get(id);
    }

    private ProjectViewSelectInTarget getProjectViewSelectInTarget(AbstractProjectViewPane pane) {
        SelectInTarget target2 = this.getSelectInTarget(pane.getId());
        return target2 instanceof ProjectViewSelectInTarget ? (ProjectViewSelectInTarget)target2 : null;
    }

    @Override
    public PsiElement getParentOfCurrentSelection() {
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane == null) {
            return null;
        }
        TreePath path = viewPane.getSelectedPath();
        if (path == null) {
            return null;
        }
        if ((path = path.getParentPath()) == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (userObject instanceof ProjectViewNode) {
            ProjectViewNode descriptor2 = (ProjectViewNode)userObject;
            Object element = descriptor2.getValue();
            if (element instanceof PsiElement) {
                PsiElement psiElement = (PsiElement)element;
                if (!psiElement.isValid()) {
                    return null;
                }
                return psiElement;
            }
            return null;
        }
        return null;
    }

    public ContentManager getContentManager() {
        if (this.myContentManager == null) {
            ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.PROJECT_VIEW).getContentManager();
        }
        return this.myContentManager;
    }

    @Override
    public void changeView() {
        ArrayList<AbstractProjectViewPane> views = new ArrayList<AbstractProjectViewPane>(this.myId2Pane.values());
        views.remove(this.getCurrentProjectViewPane());
        Collections.sort(views, PANE_WEIGHT_COMPARATOR);
        JBList list2 = new JBList(ArrayUtil.toObjectArray(views));
        list2.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                AbstractProjectViewPane pane = (AbstractProjectViewPane)value2;
                this.setText(pane.getTitle());
                return this;
            }
        });
        if (!views.isEmpty()) {
            list2.setSelectedValue(views.get(0), true);
        }
        Runnable runnable2 = () -> this.lambda$changeView$3((JList)list2);
        new PopupChooserBuilder((JList)list2).setTitle(IdeBundle.message((String)"title.popup.views", (Object[])new Object[0])).setItemChoosenCallback(runnable2).createPopup().showInCenterOf((Component)this.getComponent());
    }

    @Override
    public void changeView(@NotNull String viewId) {
        if (viewId == null) {
            ProjectViewImpl.$$$reportNull$$$0(11);
        }
        this.changeView(viewId, null);
    }

    @Override
    public void changeView(@NotNull String viewId, @Nullable String subId) {
        if (viewId == null) {
            ProjectViewImpl.$$$reportNull$$$0(12);
        }
        this.changeViewCB(viewId, subId);
    }

    @Override
    @NotNull
    public ActionCallback changeViewCB(@NotNull String viewId, @Nullable String subId) {
        boolean hasSubViews;
        AbstractProjectViewPane pane;
        if (viewId == null) {
            ProjectViewImpl.$$$reportNull$$$0(13);
        }
        LOG.assertTrue((pane = this.getProjectViewPaneById(viewId)) != null, (Object)("Project view pane not found: " + viewId + "; subId:" + subId + "; project: " + this.myProject));
        boolean bl = hasSubViews = pane.getSubIds().length > 0;
        if (hasSubViews) {
            if (subId == null) {
                subId = pane.getSubId();
            }
        } else if (subId != null) {
            LOG.error("View doesn't have subviews: " + viewId + "; subId:" + subId + "; project: " + this.myProject);
        }
        if (viewId.equals(this.myCurrentViewId) && Objects.equals(subId, this.myCurrentViewSubId)) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                ProjectViewImpl.$$$reportNull$$$0(14);
            }
            return actionCallback;
        }
        for (Content content : this.getContentManager().getContents()) {
            if (!viewId.equals(content.getUserData(ID_KEY)) || subId != null && !subId.equals(content.getUserData(SUB_ID_KEY))) continue;
            ActionCallback actionCallback = this.getContentManager().setSelectedContentCB(content);
            if (actionCallback == null) {
                ProjectViewImpl.$$$reportNull$$$0(15);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.REJECTED;
        if (actionCallback == null) {
            ProjectViewImpl.$$$reportNull$$$0(16);
        }
        return actionCallback;
    }

    @Nullable
    private Module moduleBySingleContentRoot(@NotNull VirtualFile file2) {
        Module module2;
        if (file2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(17);
        }
        if (ProjectRootsUtil.isModuleContentRoot(file2, this.myProject) && (module2 = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file2)) != null && !module2.isDisposed() && ModuleRootManager.getInstance((Module)module2).getContentRoots().length == 1) {
            return module2;
        }
        return null;
    }

    @Nullable
    private UnloadedModuleDescription getUnloadedModuleByContentRoot(@NotNull VirtualFile file2) {
        String moduleName;
        if (file2 == null) {
            ProjectViewImpl.$$$reportNull$$$0(18);
        }
        if ((moduleName = ProjectRootsUtil.findUnloadedModuleByContentRoot(file2, this.myProject)) != null) {
            return ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescription(moduleName);
        }
        return null;
    }

    @NotNull
    private <T> List<T> getSelectedElements(@NotNull Class<T> klass) {
        Object[] elements;
        if (klass == null) {
            ProjectViewImpl.$$$reportNull$$$0(19);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane == null) {
            ArrayList<Object> arrayList = result2;
            if (arrayList == null) {
                ProjectViewImpl.$$$reportNull$$$0(20);
            }
            return arrayList;
        }
        for (Object element : elements = viewPane.getSelectedElements()) {
            if (element == null || !klass.isAssignableFrom(element.getClass())) continue;
            result2.add(element);
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            ProjectViewImpl.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @Override
    public void selectPsiElement(PsiElement element, boolean requestFocus) {
        if (element == null) {
            return;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        this.select(element, virtualFile, requestFocus);
    }

    private static void readOption(Element node, @NotNull Map<String, Boolean> options) {
        if (options == null) {
            ProjectViewImpl.$$$reportNull$$$0(22);
        }
        if (node == null) {
            return;
        }
        for (Attribute attribute : node.getAttributes()) {
            options.put(attribute.getName(), Boolean.TRUE.toString().equals(attribute.getValue()) ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private static void writeOption(@NotNull Element parentNode, @NotNull Map<String, Boolean> optionsForPanes, @NotNull String optionName) {
        if (parentNode == null) {
            ProjectViewImpl.$$$reportNull$$$0(23);
        }
        if (optionsForPanes == null) {
            ProjectViewImpl.$$$reportNull$$$0(24);
        }
        if (optionName == null) {
            ProjectViewImpl.$$$reportNull$$$0(25);
        }
        Element e = new Element(optionName);
        for (Map.Entry<String, Boolean> entry : optionsForPanes.entrySet()) {
            String key2 = entry.getKey();
            if (key2 == null) continue;
            e.setAttribute(key2, Boolean.toString(entry.getValue()));
        }
        parentNode.addContent(e);
    }

    public void loadState(Element parentNode) {
        Element panesElement;
        Element navigatorElement = parentNode.getChild(ELEMENT_NAVIGATOR);
        if (navigatorElement != null) {
            this.mySavedPaneId = navigatorElement.getAttributeValue(ATTRIBUTE_CURRENT_VIEW);
            this.mySavedPaneSubId = navigatorElement.getAttributeValue(ATTRIBUTE_CURRENT_SUBVIEW);
            if (this.mySavedPaneId == null) {
                this.mySavedPaneId = "ProjectPane";
                this.mySavedPaneSubId = null;
            }
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_FLATTEN_PACKAGES), this.myFlattenPackages);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SHOW_MEMBERS), this.myShowMembers);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SHOW_MODULES), this.myShowModules);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SHOW_LIBRARY_CONTENTS), this.myShowLibraryContents);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_HIDE_EMPTY_PACKAGES), this.myHideEmptyPackages);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_ABBREVIATE_PACKAGE_NAMES), this.myAbbreviatePackageNames);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_AUTOSCROLL_TO_SOURCE), this.myAutoscrollToSource);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_AUTOSCROLL_FROM_SOURCE), this.myAutoscrollFromSource);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SORT_BY_TYPE), this.mySortByType);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_MANUAL_ORDER), this.myManualOrder);
            Element foldersElement = navigatorElement.getChild(ELEMENT_FOLDERS_ALWAYS_ON_TOP);
            if (foldersElement != null) {
                this.myFoldersAlwaysOnTop = Boolean.valueOf(foldersElement.getAttributeValue("value"));
            }
            try {
                this.splitterProportions.readExternal(navigatorElement);
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
        }
        if ((panesElement = parentNode.getChild(ELEMENT_PANES)) != null) {
            this.readPaneState(panesElement);
        }
    }

    private void readPaneState(@NotNull Element panesElement) {
        if (panesElement == null) {
            ProjectViewImpl.$$$reportNull$$$0(26);
        }
        List paneElements = panesElement.getChildren(ELEMENT_PANE);
        for (Element paneElement : paneElements) {
            String paneId = paneElement.getAttributeValue(ATTRIBUTE_ID);
            AbstractProjectViewPane pane = this.myId2Pane.get(paneId);
            if (pane != null) {
                try {
                    pane.readExternal(paneElement);
                }
                catch (InvalidDataException invalidDataException) {}
                continue;
            }
            this.myUninitializedPaneState.put(paneId, paneElement);
        }
    }

    public Element getState() {
        Element parentNode = new Element("projectView");
        Element navigatorElement = new Element(ELEMENT_NAVIGATOR);
        AbstractProjectViewPane currentPane = this.getCurrentProjectViewPane();
        if (currentPane != null) {
            navigatorElement.setAttribute(ATTRIBUTE_CURRENT_VIEW, currentPane.getId());
            String subId = currentPane.getSubId();
            if (subId != null) {
                navigatorElement.setAttribute(ATTRIBUTE_CURRENT_SUBVIEW, subId);
            }
        }
        ProjectViewImpl.writeOption(navigatorElement, this.myFlattenPackages, ELEMENT_FLATTEN_PACKAGES);
        ProjectViewImpl.writeOption(navigatorElement, this.myShowMembers, ELEMENT_SHOW_MEMBERS);
        ProjectViewImpl.writeOption(navigatorElement, this.myShowModules, ELEMENT_SHOW_MODULES);
        ProjectViewImpl.writeOption(navigatorElement, this.myShowLibraryContents, ELEMENT_SHOW_LIBRARY_CONTENTS);
        ProjectViewImpl.writeOption(navigatorElement, this.myHideEmptyPackages, ELEMENT_HIDE_EMPTY_PACKAGES);
        ProjectViewImpl.writeOption(navigatorElement, this.myAbbreviatePackageNames, ELEMENT_ABBREVIATE_PACKAGE_NAMES);
        ProjectViewImpl.writeOption(navigatorElement, this.myAutoscrollToSource, ELEMENT_AUTOSCROLL_TO_SOURCE);
        ProjectViewImpl.writeOption(navigatorElement, this.myAutoscrollFromSource, ELEMENT_AUTOSCROLL_FROM_SOURCE);
        ProjectViewImpl.writeOption(navigatorElement, this.mySortByType, ELEMENT_SORT_BY_TYPE);
        ProjectViewImpl.writeOption(navigatorElement, this.myManualOrder, ELEMENT_MANUAL_ORDER);
        Element foldersElement = new Element(ELEMENT_FOLDERS_ALWAYS_ON_TOP);
        foldersElement.setAttribute("value", Boolean.toString(this.myFoldersAlwaysOnTop));
        navigatorElement.addContent(foldersElement);
        this.splitterProportions.saveSplitterProportions((Component)this.myPanel);
        try {
            this.splitterProportions.writeExternal(navigatorElement);
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        parentNode.addContent(navigatorElement);
        Element panesElement = new Element(ELEMENT_PANES);
        this.writePaneState(panesElement);
        parentNode.addContent(panesElement);
        return parentNode;
    }

    private void writePaneState(@NotNull Element panesElement) {
        if (panesElement == null) {
            ProjectViewImpl.$$$reportNull$$$0(27);
        }
        for (AbstractProjectViewPane pane : this.myId2Pane.values()) {
            Element paneElement = new Element(ELEMENT_PANE);
            paneElement.setAttribute(ATTRIBUTE_ID, pane.getId());
            try {
                pane.writeExternal(paneElement);
            }
            catch (WriteExternalException e) {
                continue;
            }
            panesElement.addContent(paneElement);
        }
        for (Element element : this.myUninitializedPaneState.values()) {
            panesElement.addContent(element.clone());
        }
    }

    boolean isGlobalOptions() {
        return Registry.is((String)"ide.projectView.globalOptions");
    }

    ProjectViewSharedSettings getGlobalOptions() {
        return ProjectViewSharedSettings.Companion.getInstance();
    }

    @Override
    public boolean isAutoscrollToSource(String paneId) {
        if (this.isGlobalOptions()) {
            return this.getGlobalOptions().getAutoscrollToSource();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myAutoscrollToSource, paneId, UISettings.getInstance().getDefaultAutoScrollToSource());
    }

    public void setAutoscrollToSource(boolean autoscrollMode, String paneId) {
        if (this.isGlobalOptions()) {
            this.getGlobalOptions().setAutoscrollToSource(autoscrollMode);
        }
        this.myAutoscrollToSource.put(paneId, autoscrollMode);
    }

    @Override
    public boolean isAutoscrollFromSource(String paneId) {
        if (this.isGlobalOptions()) {
            return this.getGlobalOptions().getAutoscrollFromSource();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myAutoscrollFromSource, paneId, false);
    }

    public void setAutoscrollFromSource(boolean autoscrollMode, String paneId) {
        if (this.isGlobalOptions()) {
            this.getGlobalOptions().setAutoscrollFromSource(autoscrollMode);
        }
        this.setPaneOption(this.myAutoscrollFromSource, autoscrollMode, paneId, false);
    }

    @Override
    public boolean isFlattenPackages(String paneId) {
        if (this.isGlobalOptions()) {
            return this.getGlobalOptions().getFlattenPackages();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myFlattenPackages, paneId, false);
    }

    public void setFlattenPackages(boolean flattenPackages, String paneId) {
        if (this.isGlobalOptions()) {
            this.getGlobalOptions().setFlattenPackages(flattenPackages);
            for (String pane : this.myFlattenPackages.keySet()) {
                this.setPaneOption(this.myFlattenPackages, flattenPackages, pane, true);
            }
        }
        this.setPaneOption(this.myFlattenPackages, flattenPackages, paneId, true);
    }

    public boolean isFoldersAlwaysOnTop() {
        if (this.isGlobalOptions()) {
            return this.getGlobalOptions().getFoldersAlwaysOnTop();
        }
        return this.myFoldersAlwaysOnTop;
    }

    public void setFoldersAlwaysOnTop(boolean foldersAlwaysOnTop) {
        if (this.isGlobalOptions()) {
            this.getGlobalOptions().setFoldersAlwaysOnTop(foldersAlwaysOnTop);
        }
        if (this.myFoldersAlwaysOnTop != foldersAlwaysOnTop) {
            this.myFoldersAlwaysOnTop = foldersAlwaysOnTop;
            for (AbstractProjectViewPane pane : this.myId2Pane.values()) {
                if (pane.getTree() == null) continue;
                pane.updateFromRoot(false);
            }
        }
    }

    @Override
    public boolean isShowMembers(String paneId) {
        if (this.isGlobalOptions()) {
            return this.getGlobalOptions().getShowMembers();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myShowMembers, paneId, false);
    }

    public void setShowMembers(boolean showMembers, String paneId) {
        this.setPaneOption(this.myShowMembers, showMembers, paneId, true);
    }

    @Override
    public boolean isHideEmptyMiddlePackages(String paneId) {
        if (this.isGlobalOptions()) {
            return this.getGlobalOptions().getHideEmptyPackages();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myHideEmptyPackages, paneId, true);
    }

    @Override
    public boolean isAbbreviatePackageNames(String paneId) {
        if (this.isGlobalOptions()) {
            return this.getGlobalOptions().getAbbreviatePackages();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myAbbreviatePackageNames, paneId, false);
    }

    @Override
    public boolean isShowLibraryContents(String paneId) {
        if (this.isGlobalOptions()) {
            return this.getGlobalOptions().getShowLibraryContents();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myShowLibraryContents, paneId, true);
    }

    @Override
    public void setShowLibraryContents(boolean showLibraryContents, @NotNull String paneId) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(28);
        }
        if (this.isGlobalOptions()) {
            this.getGlobalOptions().setShowLibraryContents(showLibraryContents);
        }
        this.setPaneOption(this.myShowLibraryContents, showLibraryContents, paneId, true);
    }

    @NotNull
    public ActionCallback setShowLibraryContentsCB(boolean showLibraryContents, String paneId) {
        ActionCallback actionCallback = this.setPaneOption(this.myShowLibraryContents, showLibraryContents, paneId, true);
        if (actionCallback == null) {
            ProjectViewImpl.$$$reportNull$$$0(29);
        }
        return actionCallback;
    }

    @Override
    public boolean isShowModules(String paneId) {
        if (this.isGlobalOptions()) {
            return this.getGlobalOptions().getShowModules();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myShowModules, paneId, true);
    }

    @Override
    public void setShowModules(boolean showModules, @NotNull String paneId) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(30);
        }
        if (this.isGlobalOptions()) {
            this.getGlobalOptions().setShowModules(showModules);
        }
        this.setPaneOption(this.myShowModules, showModules, paneId, true);
    }

    @Override
    public boolean isFlattenModules(String paneId) {
        if (this.isGlobalOptions()) {
            return this.getGlobalOptions().getFlattenModules();
        }
        return ProjectViewImpl.getPaneOptionValue(this.myFlattenModules, paneId, false);
    }

    @Override
    public void setFlattenModules(boolean flattenModules, @NotNull String paneId) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(31);
        }
        if (this.isGlobalOptions()) {
            this.getGlobalOptions().setFlattenModules(flattenModules);
        }
        this.setPaneOption(this.myFlattenModules, flattenModules, paneId, true);
    }

    @Override
    public void setHideEmptyPackages(boolean hideEmptyPackages, @NotNull String paneId) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(32);
        }
        if (this.isGlobalOptions()) {
            this.getGlobalOptions().setHideEmptyPackages(hideEmptyPackages);
            for (String pane : this.myHideEmptyPackages.keySet()) {
                this.setPaneOption(this.myHideEmptyPackages, hideEmptyPackages, pane, true);
            }
        }
        this.setPaneOption(this.myHideEmptyPackages, hideEmptyPackages, paneId, true);
    }

    @Override
    public void setAbbreviatePackageNames(boolean abbreviatePackageNames, @NotNull String paneId) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(33);
        }
        if (this.isGlobalOptions()) {
            this.getGlobalOptions().setAbbreviatePackages(abbreviatePackageNames);
        }
        this.setPaneOption(this.myAbbreviatePackageNames, abbreviatePackageNames, paneId, true);
    }

    @NotNull
    private ActionCallback setPaneOption(@NotNull Map<String, Boolean> optionsMap, boolean value2, String paneId, boolean updatePane) {
        if (optionsMap == null) {
            ProjectViewImpl.$$$reportNull$$$0(34);
        }
        if (paneId != null) {
            AbstractProjectViewPane pane;
            optionsMap.put(paneId, value2);
            if (updatePane && (pane = this.getProjectViewPaneById(paneId)) != null) {
                ActionCallback actionCallback = pane.updateFromRoot(false);
                if (actionCallback == null) {
                    ProjectViewImpl.$$$reportNull$$$0(35);
                }
                return actionCallback;
            }
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            ProjectViewImpl.$$$reportNull$$$0(36);
        }
        return actionCallback;
    }

    private static boolean getPaneOptionValue(@NotNull Map<String, Boolean> optionsMap, String paneId, boolean defaultValue) {
        Boolean value2;
        if (optionsMap == null) {
            ProjectViewImpl.$$$reportNull$$$0(37);
        }
        return (value2 = optionsMap.get(paneId)) == null ? defaultValue : value2;
    }

    @Override
    public boolean isManualOrder(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myManualOrder, paneId, false);
    }

    @Override
    public void setManualOrder(@NotNull String paneId, boolean enabled) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(38);
        }
        this.setPaneOption(this.myManualOrder, enabled, paneId, false);
        AbstractProjectViewPane pane = this.getProjectViewPaneById(paneId);
        pane.installComparator();
    }

    @Override
    public boolean isSortByType(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.mySortByType, paneId, false);
    }

    @Override
    public void setSortByType(@NotNull String paneId, boolean sortByType) {
        if (paneId == null) {
            ProjectViewImpl.$$$reportNull$$$0(39);
        }
        this.setPaneOption(this.mySortByType, sortByType, paneId, false);
        AbstractProjectViewPane pane = this.getProjectViewPaneById(paneId);
        pane.installComparator();
    }

    @Override
    @NotNull
    public Collection<String> getPaneIds() {
        Collection<String> collection = Collections.unmodifiableCollection(this.myId2Pane.keySet());
        if (collection == null) {
            ProjectViewImpl.$$$reportNull$$$0(40);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<SelectInTarget> getSelectInTargets() {
        this.ensurePanesLoaded();
        Collection<SelectInTarget> collection = this.mySelectInTargets.values();
        if (collection == null) {
            ProjectViewImpl.$$$reportNull$$$0(41);
        }
        return collection;
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        AbstractProjectViewPane pane;
        if (requestor == null) {
            ProjectViewImpl.$$$reportNull$$$0(42);
        }
        if ((pane = this.myId2Pane.get(this.myCurrentViewSubId)) == null) {
            pane = this.myId2Pane.get(this.myCurrentViewId);
        }
        ActionCallback actionCallback = pane != null ? pane.getReady(requestor) : ActionCallback.DONE;
        if (actionCallback == null) {
            ProjectViewImpl.$$$reportNull$$$0(43);
        }
        return actionCallback;
    }

    private /* synthetic */ void lambda$changeView$3(JList list2) {
        if (list2.getSelectedIndex() < 0) {
            return;
        }
        AbstractProjectViewPane pane = (AbstractProjectViewPane)list2.getSelectedValue();
        this.changeView(pane.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_PANE;
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPane";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewId";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsForPanes";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panesElement";
                break;
            }
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paneId";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsMap";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "selectCB";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "changeViewCB";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "setShowLibraryContentsCB";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "setPaneOption";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaneIds";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectInTargets";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addProjectPane";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectPane";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doAddPane";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showPane";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "changeView";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "changeViewCB";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "moduleBySingleContentRoot";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getUnloadedModuleByContentRoot";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "readOption";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeOption";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "readPaneState";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "writePaneState";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setShowLibraryContents";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setShowModules";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setFlattenModules";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setHideEmptyPackages";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setAbbreviatePackageNames";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setPaneOption";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPaneOptionValue";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setManualOrder";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setSortByType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 29: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ScrollFromSourceAction
    extends AnAction
    implements DumbAware {
        private ScrollFromSourceAction() {
            super("Scroll from Source", "Select the file open in the active editor", AllIcons.General.Locate);
            this.getTemplatePresentation().setHoveredIcon(AllIcons.General.LocateHover);
        }

        public void actionPerformed(AnActionEvent e) {
            ProjectViewImpl.this.myAutoScrollFromSourceHandler.scrollFromSource();
        }
    }

    private class FoldersAlwaysOnTopAction
    extends ToggleAction
    implements DumbAware {
        private FoldersAlwaysOnTopAction() {
            super("Folders Always on Top");
        }

        public boolean isSelected(AnActionEvent event) {
            return ProjectViewImpl.this.isFoldersAlwaysOnTop();
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            ProjectViewImpl.this.setFoldersAlwaysOnTop(flag);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
            presentation.setEnabledAndVisible(pane != null && pane.supportsFoldersAlwaysOnTop());
        }
    }

    private class SortByTypeAction
    extends ToggleAction
    implements DumbAware {
        private SortByTypeAction() {
            super(IdeBundle.message((String)"action.sort.by.type", (Object[])new Object[0]), IdeBundle.message((String)"action.sort.by.type", (Object[])new Object[0]), AllIcons.ObjectBrowser.SortByType);
        }

        public boolean isSelected(AnActionEvent event) {
            return ProjectViewImpl.this.isSortByType(ProjectViewImpl.this.getCurrentViewId());
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            ProjectViewImpl.this.setSortByType(ProjectViewImpl.this.getCurrentViewId(), flag);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
            presentation.setVisible(pane != null && pane.supportsSortByType());
        }
    }

    private class ManualOrderAction
    extends ToggleAction
    implements DumbAware {
        private ManualOrderAction() {
            super(IdeBundle.message((String)"action.manual.order", (Object[])new Object[0]), IdeBundle.message((String)"action.manual.order", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted);
        }

        public boolean isSelected(AnActionEvent event) {
            return ProjectViewImpl.this.isManualOrder(ProjectViewImpl.this.getCurrentViewId());
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            ProjectViewImpl.this.setManualOrder(ProjectViewImpl.this.getCurrentViewId(), flag);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
            presentation.setEnabledAndVisible(pane != null && pane.supportsManualOrder());
        }
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        private MyAutoScrollFromSourceHandler() {
            super(ProjectViewImpl.this.myProject, (JComponent)ProjectViewImpl.this.myViewContentPanel, (Disposable)ProjectViewImpl.this);
        }

        protected void selectElementFromEditor(@NotNull FileEditor fileEditor) {
            if (fileEditor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(0);
            }
            if (this.myProject.isDisposed() || !ProjectViewImpl.this.myViewContentPanel.isShowing()) {
                return;
            }
            if (ProjectViewImpl.this.isAutoscrollFromSource(ProjectViewImpl.this.getCurrentViewId())) {
                if (fileEditor instanceof TextEditor) {
                    Editor editor = ((TextEditor)fileEditor).getEditor();
                    this.selectElementAtCaretNotLosingFocus(editor);
                } else {
                    MySelectInContext selectInContext;
                    PsiFile psiFile;
                    VirtualFile file2;
                    SelectInTarget target2 = ProjectViewImpl.this.getCurrentSelectInTarget();
                    if (target2 != null && (file2 = FileEditorManagerEx.getInstanceEx(this.myProject).getFile(fileEditor)) != null && file2.isValid() && (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2)) != null && target2.canSelect((SelectInContext)(selectInContext = new MySelectInContext(psiFile, null){

                        @Override
                        public Object getSelectorInFile() {
                            return psiFile;
                        }
                    }))) {
                        target2.selectIn((SelectInContext)selectInContext, false);
                    }
                }
            }
        }

        public void scrollFromSource() {
            PsiFile file2;
            FileEditor[] editors;
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
            Editor selectedTextEditor = fileEditorManager.getSelectedTextEditor();
            if (selectedTextEditor != null) {
                this.selectElementAtCaret(selectedTextEditor);
                return;
            }
            for (FileEditor fileEditor : editors = fileEditorManager.getSelectedEditors()) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Editor editor = ((TextEditor)fileEditor).getEditor();
                this.selectElementAtCaret(editor);
                return;
            }
            VirtualFile[] selectedFiles = fileEditorManager.getSelectedFiles();
            if (selectedFiles.length > 0 && (file2 = PsiManager.getInstance((Project)this.myProject).findFile(selectedFiles[0])) != null) {
                this.scrollFromFile(file2, null);
            }
        }

        private void selectElementAtCaretNotLosingFocus(@NotNull Editor editor) {
            AbstractProjectViewPane pane;
            if (editor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(1);
            }
            if ((pane = ProjectViewImpl.this.getCurrentProjectViewPane()) != null && !IJSwingUtilities.hasFocus(pane.getComponentToFocus())) {
                this.selectElementAtCaret(editor);
            }
        }

        private void selectElementAtCaret(@NotNull Editor editor) {
            PsiFile file2;
            if (editor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(2);
            }
            if ((file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument())) == null) {
                return;
            }
            this.scrollFromFile(file2, editor);
        }

        private void scrollFromFile(@NotNull PsiFile file2, @Nullable Editor editor) {
            if (file2 == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(3);
            }
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)file2);
            PsiDocumentManager.getInstance((Project)this.myProject).performLaterWhenAllCommitted(() -> {
                SelectInTarget target2 = ProjectViewImpl.this.getCurrentSelectInTarget();
                if (target2 == null) {
                    return;
                }
                PsiFile restoredPsi = (PsiFile)pointer.getElement();
                if (restoredPsi == null) {
                    return;
                }
                MySelectInContext selectInContext = new MySelectInContext(restoredPsi, editor);
                if (target2.canSelect((SelectInContext)selectInContext)) {
                    target2.selectIn((SelectInContext)selectInContext, false);
                }
            });
        }

        protected boolean isAutoScrollEnabled() {
            return ProjectViewImpl.this.isAutoscrollFromSource(ProjectViewImpl.this.myCurrentViewId);
        }

        protected void setAutoScrollEnabled(boolean state) {
            Editor editor;
            ProjectViewImpl.this.setAutoscrollFromSource(state, ProjectViewImpl.this.myCurrentViewId);
            if (state && (editor = ProjectViewImpl.this.myFileEditorManager.getSelectedTextEditor()) != null) {
                this.selectElementAtCaretNotLosingFocus(editor);
            }
            ProjectViewImpl.this.createToolbarActions();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileEditor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyAutoScrollFromSourceHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementAtCaretNotLosingFocus";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementAtCaret";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "scrollFromFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MySelectInContext
        extends SmartSelectInContext {
            @Nullable
            private final Editor myEditor;

            private MySelectInContext(@Nullable PsiFile psiFile, Editor editor) {
                if (psiFile == null) {
                    MySelectInContext.$$$reportNull$$$0(0);
                }
                super(psiFile, (PsiElement)psiFile);
                this.myEditor = editor;
            }

            @NotNull
            public FileEditorProvider getFileEditorProvider() {
                FileEditorProvider fileEditorProvider = new FileEditorProvider(){

                    public FileEditor openFileEditor() {
                        return (FileEditor)ArrayUtil.getFirstElement((Object[])ProjectViewImpl.this.myFileEditorManager.openFile(MySelectInContext.this.getVirtualFile(), false));
                    }
                };
                if (fileEditorProvider == null) {
                    MySelectInContext.$$$reportNull$$$0(1);
                }
                return fileEditorProvider;
            }

            public Object getSelectorInFile() {
                PsiFile file2 = this.getPsiFile();
                if (file2 != null && this.myEditor != null) {
                    PsiElement element;
                    int offset = this.myEditor.getCaretModel().getOffset();
                    PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.getProject());
                    if (manager.hasUncommitedDocuments()) {
                        manager.commitAllDocuments();
                    }
                    if ((element = file2.findElementAt(offset)) != null) {
                        return element;
                    }
                }
                return file2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyAutoScrollFromSourceHandler$MySelectInContext";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyAutoScrollFromSourceHandler$MySelectInContext";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFileEditorProvider";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class SelectionInfo {
        private final Object[] myElements;

        private SelectionInfo(@NotNull Object[] elements) {
            if (elements == null) {
                SelectionInfo.$$$reportNull$$$0(0);
            }
            this.myElements = elements;
        }

        public void apply(AbstractProjectViewPane viewPane) {
            if (viewPane == null) {
                return;
            }
            AsyncProjectViewSupport support = viewPane.getAsyncSupport();
            if (support != null) {
                List<TreeVisitor> visitors = AsyncProjectViewSupport.createVisitors(Arrays.asList(this.myElements));
                if (!visitors.isEmpty()) {
                    support.accept(visitors, (Consumer<List<TreePath>>)((Consumer)paths -> TreeUtil.selectPaths((JTree)((Object)viewPane.myTree), (Collection)paths)));
                }
                return;
            }
            AbstractTreeBuilder treeBuilder = viewPane.getTreeBuilder();
            DnDAwareTree tree = viewPane.myTree;
            DefaultTreeModel treeModel = (DefaultTreeModel)((JTree)((Object)tree)).getModel();
            ArrayList<TreePath> paths2 = new ArrayList<TreePath>(this.myElements.length);
            for (Object element : this.myElements) {
                DefaultMutableTreeNode node = treeBuilder.getNodeForElement(element);
                if (node == null) {
                    treeBuilder.buildNodeForElement(element);
                    node = treeBuilder.getNodeForElement(element);
                }
                if (node == null) continue;
                paths2.add(new TreePath(treeModel.getPathToRoot(node)));
            }
            if (!paths2.isEmpty()) {
                ((JTree)((Object)tree)).setSelectionPaths(paths2.toArray(new TreePath[paths2.size()]));
            }
        }

        @NotNull
        public static SelectionInfo create(AbstractProjectViewPane viewPane) {
            TreePath[] selectionPaths;
            List selectedElements = Collections.emptyList();
            if (viewPane != null && (selectionPaths = viewPane.getSelectionPaths()) != null) {
                selectedElements = new ArrayList();
                for (TreePath path : selectionPaths) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    Object userObject = node.getUserObject();
                    if (!(userObject instanceof NodeDescriptor)) continue;
                    selectedElements.add(((NodeDescriptor)userObject).getElement());
                }
            }
            SelectionInfo selectionInfo = new SelectionInfo(selectedElements.toArray());
            if (selectionInfo == null) {
                SelectionInfo.$$$reportNull$$$0(1);
            }
            return selectionInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl$SelectionInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$SelectionInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class HideEmptyMiddlePackagesAction
    extends PaneOptionAction {
        private HideEmptyMiddlePackagesAction() {
            super(ProjectViewImpl.this.myHideEmptyPackages, "", "", null, true);
        }

        @Override
        public void setSelected(AnActionEvent event, boolean flag) {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            SelectionInfo selectionInfo = SelectionInfo.create(viewPane);
            if (ProjectViewImpl.this.isGlobalOptions()) {
                ProjectViewImpl.this.getGlobalOptions().setHideEmptyPackages(flag);
            }
            super.setSelected(event, flag);
            selectionInfo.apply(viewPane);
        }

        @Override
        public boolean isSelected(AnActionEvent event) {
            if (ProjectViewImpl.this.isGlobalOptions()) {
                return ProjectViewImpl.this.getGlobalOptions().getHideEmptyPackages();
            }
            return super.isSelected(event);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            if (ProjectViewImpl.this.isHideEmptyMiddlePackages(ProjectViewImpl.this.myCurrentViewId)) {
                presentation.setText(IdeBundle.message((String)"action.hide.empty.middle.packages", (Object[])new Object[0]));
                presentation.setDescription(IdeBundle.message((String)"action.show.hide.empty.middle.packages", (Object[])new Object[0]));
            } else {
                presentation.setText(IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]));
                presentation.setDescription(IdeBundle.message((String)"action.show.compact.empty.middle.packages", (Object[])new Object[0]));
            }
        }
    }

    private final class MyIdeView
    implements IdeView {
        private MyIdeView() {
        }

        public void selectElement(PsiElement element) {
            FileEditor editor;
            boolean isDirectory;
            ProjectViewImpl.this.selectPsiElement(element, false);
            boolean requestFocus = true;
            if (element != null && !(isDirectory = element instanceof PsiDirectory) && (editor = EditorHelper.openInEditor(element, false)) != null) {
                ToolWindowManager.getInstance((Project)ProjectViewImpl.this.myProject).activateEditorComponent();
                requestFocus = false;
            }
            if (requestFocus) {
                ProjectViewImpl.this.selectPsiElement(element, true);
            }
        }

        @NotNull
        public PsiDirectory[] getDirectories() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (viewPane != null) {
                PsiDirectory[] psiDirectoryArray = viewPane.getSelectedDirectories();
                if (psiDirectoryArray == null) {
                    MyIdeView.$$$reportNull$$$0(0);
                }
                return psiDirectoryArray;
            }
            if (PsiDirectory.EMPTY_ARRAY == null) {
                MyIdeView.$$$reportNull$$$0(1);
            }
            return PsiDirectory.EMPTY_ARRAY;
        }

        public PsiDirectory getOrChooseDirectory() {
            return DirectoryChooserUtil.getOrChooseDirectory(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewImpl$MyIdeView", "getDirectories"));
        }
    }

    private final class MyPanel
    extends JPanel
    implements DataProvider {
        MyPanel() {
            super(new BorderLayout());
            UIUtil.putClientProperty((JComponent)this, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)new Iterable<JComponent>(){

                @Override
                public Iterator<JComponent> iterator() {
                    return JBIterable.from(ProjectViewImpl.this.myId2Pane.values()).map(pane -> {
                        JComponent last = null;
                        for (Component c : UIUtil.uiParents((Component)pane.getComponentToFocus(), (boolean)false)) {
                            if (c == MyPanel.this || !(c instanceof JComponent)) {
                                return null;
                            }
                            last = (JComponent)c;
                        }
                        return last;
                    }).filter(Conditions.notNull()).iterator();
                }
            });
        }

        @Nullable
        private Object getSelectedNodeElement() {
            AbstractProjectViewPane currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (currentProjectViewPane == null) {
                return null;
            }
            DefaultMutableTreeNode node = currentProjectViewPane.getSelectedNode();
            if (node == null) {
                return null;
            }
            Object userObject = node.getUserObject();
            if (userObject instanceof AbstractTreeNode) {
                return ((AbstractTreeNode)userObject).getValue();
            }
            if (!(userObject instanceof NodeDescriptor)) {
                return null;
            }
            return ((NodeDescriptor)userObject).getElement();
        }

        public Object getData(String dataId) {
            List selectedElements;
            Object selected;
            PsiElement[] elements;
            Object paneSpecificData;
            AbstractProjectViewPane currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (currentProjectViewPane != null && (paneSpecificData = currentProjectViewPane.getData(dataId)) != null) {
                return paneSpecificData;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                if (currentProjectViewPane == null) {
                    return null;
                }
                elements = currentProjectViewPane.getSelectedPSIElements();
                return elements.length == 1 ? elements[0] : null;
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                if (currentProjectViewPane == null) {
                    return null;
                }
                elements = currentProjectViewPane.getSelectedPSIElements();
                return elements.length == 0 ? null : elements;
            }
            if (LangDataKeys.MODULE.is(dataId)) {
                VirtualFile[] virtualFiles = (VirtualFile[])this.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY.getName());
                if (virtualFiles == null || virtualFiles.length <= 1) {
                    return null;
                }
                HashSet<Module> modules = new HashSet<Module>();
                for (VirtualFile virtualFile : virtualFiles) {
                    modules.add(ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)ProjectViewImpl.this.myProject));
                }
                return modules.size() == 1 ? modules.iterator().next() : null;
            }
            if (LangDataKeys.TARGET_PSI_ELEMENT.is(dataId)) {
                return null;
            }
            if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getCutProvider();
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getCopyProvider();
            }
            if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getPasteProvider();
            }
            if (LangDataKeys.IDE_VIEW.is(dataId)) {
                return ProjectViewImpl.this.myIdeView;
            }
            if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                Module[] modules = this.getSelectedModules();
                if (modules != null || !this.getSelectedUnloadedModules().isEmpty()) {
                    return ProjectViewImpl.this.myDeleteModuleProvider;
                }
                final LibraryOrderEntry orderEntry = this.getSelectedLibrary();
                if (orderEntry != null) {
                    return new DeleteProvider(){

                        public void deleteElement(@NotNull DataContext dataContext) {
                            if (dataContext == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            MyPanel.this.detachLibrary(orderEntry, ProjectViewImpl.this.myProject);
                        }

                        public boolean canDeleteElement(@NotNull DataContext dataContext) {
                            if (dataContext == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            objectArray2[0] = "dataContext";
                            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyPanel$2";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "deleteElement";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "canDeleteElement";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                }
                return ProjectViewImpl.this.myDeletePSIElementProvider;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return "viewingStructure.projectViews";
            }
            if (DATA_KEY.is(dataId)) {
                return ProjectViewImpl.this;
            }
            if (PlatformDataKeys.PROJECT_CONTEXT.is(dataId)) {
                selected = this.getSelectedNodeElement();
                return selected instanceof Project ? selected : null;
            }
            if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                selected = this.getSelectedNodeElement();
                if (selected instanceof Module) {
                    return !((Module)selected).isDisposed() ? selected : null;
                }
                if (selected instanceof PsiDirectory) {
                    return ProjectViewImpl.this.moduleBySingleContentRoot(((PsiDirectory)selected).getVirtualFile());
                }
                if (selected instanceof VirtualFile) {
                    return ProjectViewImpl.this.moduleBySingleContentRoot((VirtualFile)selected);
                }
                return null;
            }
            if (LangDataKeys.MODULE_CONTEXT_ARRAY.is(dataId)) {
                return this.getSelectedModules();
            }
            if (ProjectView.UNLOADED_MODULES_CONTEXT_KEY.is(dataId)) {
                return Collections.unmodifiableList(this.getSelectedUnloadedModules());
            }
            if (ModuleGroup.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(ModuleGroup.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new ModuleGroup[selectedElements.size()]);
            }
            if (LibraryGroupElement.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(LibraryGroupElement.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new LibraryGroupElement[selectedElements.size()]);
            }
            if (NamedLibraryElement.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(NamedLibraryElement.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new NamedLibraryElement[selectedElements.size()]);
            }
            if (QuickActionProvider.KEY.is(dataId)) {
                return ProjectViewImpl.this;
            }
            return null;
        }

        @Nullable
        private LibraryOrderEntry getSelectedLibrary() {
            DefaultMutableTreeNode node;
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            DefaultMutableTreeNode defaultMutableTreeNode = node = viewPane != null ? viewPane.getSelectedNode() : null;
            if (node == null) {
                return null;
            }
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            if (parent == null) {
                return null;
            }
            Object userObject = parent.getUserObject();
            if (userObject instanceof LibraryGroupNode) {
                userObject = node.getUserObject();
                if (userObject instanceof NamedLibraryElementNode) {
                    NamedLibraryElement element = (NamedLibraryElement)((NamedLibraryElementNode)((Object)userObject)).getValue();
                    LibraryOrSdkOrderEntry orderEntry = element.getOrderEntry();
                    return orderEntry instanceof LibraryOrderEntry ? (LibraryOrderEntry)orderEntry : null;
                }
                PsiDirectory directory = (PsiDirectory)((PsiDirectoryNode)((Object)userObject)).getValue();
                VirtualFile virtualFile = directory.getVirtualFile();
                Module module2 = (Module)((AbstractTreeNode)((DefaultMutableTreeNode)parent.getParent()).getUserObject()).getValue();
                if (module2 == null) {
                    return null;
                }
                ModuleFileIndex index = ModuleRootManager.getInstance((Module)module2).getFileIndex();
                OrderEntry entry = index.getOrderEntryForFile(virtualFile);
                if (entry instanceof LibraryOrderEntry) {
                    return (LibraryOrderEntry)entry;
                }
            }
            return null;
        }

        private void detachLibrary(@NotNull LibraryOrderEntry orderEntry, @NotNull Project project2) {
            String title;
            if (orderEntry == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            if (project2 == null) {
                MyPanel.$$$reportNull$$$0(1);
            }
            Module module2 = orderEntry.getOwnerModule();
            String message2 = IdeBundle.message((String)"detach.library.from.module", (Object[])new Object[]{orderEntry.getPresentableName(), module2.getName()});
            int ret = Messages.showOkCancelDialog((Project)project2, (String)message2, (String)(title = IdeBundle.message((String)"detach.library", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon());
            if (ret != 0) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(module2.getProject(), () -> {
                if (orderEntry == null) {
                    MyPanel.$$$reportNull$$$0(2);
                }
                Runnable action = () -> {
                    if (orderEntry == null) {
                        MyPanel.$$$reportNull$$$0(3);
                    }
                    ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
                    OrderEntry[] orderEntries = rootManager.getOrderEntries();
                    ModifiableRootModel model = rootManager.getModifiableModel();
                    OrderEntry[] modifiableEntries = model.getOrderEntries();
                    for (int i = 0; i < orderEntries.length; ++i) {
                        OrderEntry entry = orderEntries[i];
                        if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).getLibrary() != orderEntry.getLibrary()) continue;
                        model.removeOrderEntry(modifiableEntries[i]);
                    }
                    model.commit();
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }, title, null);
        }

        @Nullable
        private Module[] getSelectedModules() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (viewPane == null) {
                return null;
            }
            Object[] elements = viewPane.getSelectedElements();
            ArrayList<Module> result2 = new ArrayList<Module>();
            for (Object element : elements) {
                Module module2;
                if (element instanceof Module) {
                    module2 = (Module)element;
                    if (module2.isDisposed()) continue;
                    result2.add(module2);
                    continue;
                }
                if (element instanceof ModuleGroup) {
                    Collection<Module> modules = ((ModuleGroup)element).modulesInGroup(ProjectViewImpl.this.myProject, true);
                    result2.addAll(modules);
                    continue;
                }
                if (element instanceof PsiDirectory) {
                    module2 = ProjectViewImpl.this.moduleBySingleContentRoot(((PsiDirectory)element).getVirtualFile());
                    if (module2 == null) continue;
                    result2.add(module2);
                    continue;
                }
                if (!(element instanceof VirtualFile) || (module2 = ProjectViewImpl.this.moduleBySingleContentRoot((VirtualFile)element)) == null) continue;
                result2.add(module2);
            }
            if (result2.isEmpty()) {
                return null;
            }
            return result2.toArray(new Module[result2.size()]);
        }

        private List<UnloadedModuleDescription> getSelectedUnloadedModules() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (viewPane == null) {
                return Collections.emptyList();
            }
            SmartList result2 = new SmartList();
            for (Object element : viewPane.getSelectedElements()) {
                if (element instanceof PsiDirectory) {
                    ContainerUtil.addIfNotNull((Collection)result2, (Object)ProjectViewImpl.this.getUnloadedModuleByContentRoot(((PsiDirectory)element).getVirtualFile()));
                    continue;
                }
                if (!(element instanceof VirtualFile)) continue;
                ContainerUtil.addIfNotNull((Collection)result2, (Object)ProjectViewImpl.this.getUnloadedModuleByContentRoot((VirtualFile)element));
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orderEntry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "detachLibrary";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$detachLibrary$1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyDeletePSIElementProvider
    implements DeleteProvider {
        private MyDeletePSIElementProvider() {
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeletePSIElementProvider.$$$reportNull$$$0(0);
            }
            PsiElement[] elements = this.getElementsToDelete();
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeletePSIElementProvider.$$$reportNull$$$0(1);
            }
            List<PsiElement> allElements = Arrays.asList(this.getElementsToDelete());
            ArrayList<PsiElement> validElements = new ArrayList<PsiElement>();
            for (PsiElement psiElement : allElements) {
                if (psiElement == null || !psiElement.isValid()) continue;
                validElements.add(psiElement);
            }
            PsiElement[] elements = PsiUtilCore.toPsiElementArray(validElements);
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, ProjectViewImpl.this.myProject);
            }
            finally {
                a.finish();
            }
        }

        @NotNull
        private PsiElement[] getElementsToDelete() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            PsiElement[] elements = viewPane.getSelectedPSIElements();
            for (int idx = 0; idx < elements.length; ++idx) {
                PsiFile psiFile;
                VirtualFile vFile;
                VirtualFile virtualFile;
                String path;
                PsiElement element = elements[idx];
                if (!(element instanceof PsiDirectory)) continue;
                PsiDirectory directory = (PsiDirectory)element;
                ProjectViewDirectoryHelper directoryHelper = ProjectViewDirectoryHelper.getInstance(ProjectViewImpl.this.myProject);
                if (ProjectViewImpl.this.isHideEmptyMiddlePackages(viewPane.getId()) && directory.getChildren().length == 0 && !directoryHelper.skipDirectory(directory)) {
                    PsiElement[] children2;
                    PsiDirectory parent;
                    while ((parent = directory.getParentDirectory()) != null && !directoryHelper.skipDirectory(parent) && PsiDirectoryFactory.getInstance(ProjectViewImpl.this.myProject).getQualifiedName(parent, false).length() != 0 && ((children2 = parent.getChildren()).length == 0 || children2.length == 1 && children2[0] == directory)) {
                        directory = parent;
                    }
                    elements[idx] = directory;
                }
                if (!(path = (virtualFile = directory.getVirtualFile()).getPath()).endsWith("!/") || (vFile = LocalFileSystem.getInstance().findFileByPath(path.substring(0, path.length() - "!/".length()))) == null || (psiFile = PsiManager.getInstance((Project)ProjectViewImpl.this.myProject).findFile(vFile)) == null) continue;
                elements[idx] = psiFile;
            }
            if (elements == null) {
                MyDeletePSIElementProvider.$$$reportNull$$$0(2);
            }
            return elements;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyDeletePSIElementProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$MyDeletePSIElementProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsToDelete";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class PaneOptionAction
    extends ToggleAction
    implements DumbAware {
        final Map<String, Boolean> myOptionsMap;
        private final boolean myOptionDefaultValue;

        PaneOptionAction(@NotNull Map<String, Boolean> optionsMap, @NotNull String text2, String description, Icon icon, boolean optionDefaultValue) {
            if (optionsMap == null) {
                PaneOptionAction.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                PaneOptionAction.$$$reportNull$$$0(1);
            }
            if (description == null) {
                PaneOptionAction.$$$reportNull$$$0(2);
            }
            super(text2, description, icon);
            this.myOptionsMap = optionsMap;
            this.myOptionDefaultValue = optionDefaultValue;
        }

        public boolean isSelected(AnActionEvent event) {
            return ProjectViewImpl.getPaneOptionValue(this.myOptionsMap, ProjectViewImpl.this.myCurrentViewId, this.myOptionDefaultValue);
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            ProjectViewImpl.this.setPaneOption(this.myOptionsMap, flag, ProjectViewImpl.this.myCurrentViewId, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "optionsMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/projectView/impl/ProjectViewImpl$PaneOptionAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ChangeViewAction
    extends AnAction {
        @NotNull
        private final String myId;
        @Nullable
        private final String mySubId;

        private ChangeViewAction(@Nullable String id, String subId) {
            if (id == null) {
                ChangeViewAction.$$$reportNull$$$0(0);
            }
            this.myId = id;
            this.mySubId = subId;
        }

        public void update(AnActionEvent e) {
            AbstractProjectViewPane pane = ProjectViewImpl.this.getProjectViewPaneById(this.myId);
            e.getPresentation().setText(pane.getTitle() + (this.mySubId != null ? " - " + pane.getPresentableSubIdName(this.mySubId) : ""));
        }

        public void actionPerformed(AnActionEvent e) {
            ProjectViewImpl.this.changeView(this.myId, this.mySubId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectViewImpl.ATTRIBUTE_ID, "com/intellij/ide/projectView/impl/ProjectViewImpl$ChangeViewAction", "<init>"));
        }
    }
}

