/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.scopeView.ScopeViewPane;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopePaneSelectInTarget
extends ProjectViewSelectInTarget {
    public ScopePaneSelectInTarget(Project project2) {
        super(project2);
    }

    @Override
    public String toString() {
        return SelectInManager.SCOPE;
    }

    @Override
    public boolean canSelect(PsiFileSystemItem fileSystemItem) {
        if (!super.canSelect(fileSystemItem)) {
            return false;
        }
        if (!(fileSystemItem instanceof PsiFile)) {
            return false;
        }
        return this.getContainingScope((PsiFile)fileSystemItem) != null;
    }

    @Nullable
    private NamedScope getContainingScope(@Nullable PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        if (ScratchUtil.isScratch(file2.getVirtualFile())) {
            return null;
        }
        DependencyValidationManager scopesHolder = DependencyValidationManager.getInstance((Project)this.myProject);
        for (NamedScope scope : ScopeViewPane.getShownScopes(this.myProject)) {
            PackageSet packageSet = scope.getValue();
            if (packageSet == null || !packageSet.contains(file2, (NamedScopesHolder)scopesHolder)) continue;
            return scope;
        }
        return null;
    }

    @Override
    public void select(PsiElement element, boolean requestFocus) {
        if (this.getSubId() == null) {
            NamedScope scope = this.getContainingScope(element.getContainingFile());
            if (scope == null) {
                return;
            }
            this.setSubId(scope.getName());
        }
        super.select(element, requestFocus);
    }

    public String getMinorViewId() {
        return "Scope";
    }

    public float getWeight() {
        return 6.5f;
    }

    @Override
    public boolean isSubIdSelectable(@NotNull String subId, @NotNull SelectInContext context) {
        PackageSet packageSet;
        PsiFileSystemItem file2;
        if (subId == null) {
            ScopePaneSelectInTarget.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ScopePaneSelectInTarget.$$$reportNull$$$0(1);
        }
        if (!((file2 = this.getContextPsiFile(context)) instanceof PsiFile)) {
            return false;
        }
        NamedScope scope = NamedScopesHolder.getScope((Project)this.myProject, (String)subId);
        PackageSet packageSet2 = packageSet = scope != null ? scope.getValue() : null;
        if (packageSet == null) {
            return false;
        }
        NamedScopesHolder holder = NamedScopesHolder.getHolder((Project)this.myProject, (String)subId, (NamedScopesHolder)DependencyValidationManager.getInstance((Project)this.myProject));
        return packageSet.contains((PsiFile)file2, holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "subId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/scopeView/ScopePaneSelectInTarget";
        objectArray[2] = "isSubIdSelectable";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

