/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.ui.AppearanceOptionsTopHitProvider;
import com.intellij.ide.ui.DaemonCodeAnalyzerOptionDescription;
import com.intellij.ide.ui.EditorOptionsTopHitProvider;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;

public class UISimpleSettingsProvider
implements SearchTopHitProvider,
OptionsTopHitProvider.CoveredByToggleActions {
    private static OptionDescription CYCLING_SCROLLING = AppearanceOptionsTopHitProvider.appearance("Cyclic scrolling", "cycleScrolling");
    private static OptionDescription MEMORY_INDICATOR = AppearanceOptionsTopHitProvider.appearance("Show Memory Indicator", "showMemoryIndicator");
    private static OptionDescription SHOW_MAIN_TOOLBAR = AppearanceOptionsTopHitProvider.appearance("Show Main Toolbar", "showMainToolbar");
    private static OptionDescription SHOW_NAVIGATION_BAR = AppearanceOptionsTopHitProvider.appearance("Show Navigation Bar", "showNavigationBar");
    private static OptionDescription HIDE_TOOL_STRIPES = AppearanceOptionsTopHitProvider.appearance("Hide Tool Window Bars", "hideToolStripes");
    private static OptionDescription SHOW_STATUS_BAR = AppearanceOptionsTopHitProvider.appearance("Show Status Bar", "showStatusBar");
    private static OptionDescription IS_BLOCK_CURSOR = EditorOptionsTopHitProvider.editor("Show Block Cursor", "IS_BLOCK_CURSOR");
    private static OptionDescription IS_WHITESPACES_SHOWN = EditorOptionsTopHitProvider.editor("Show Whitespaces", "IS_WHITESPACES_SHOWN");
    private static OptionDescription ARE_LINE_NUMBERS_SHOWN = EditorOptionsTopHitProvider.editor("Show Line Numbers", "ARE_LINE_NUMBERS_SHOWN");
    private static OptionDescription SHOW_METHOD_SEPARATORS = new DaemonCodeAnalyzerOptionDescription("SHOW_METHOD_SEPARATORS", "Show Method Separators", "appearance");

    public void consumeTopHits(String pattern, Consumer<Object> collector, Project project2) {
        if (StringUtil.isBetween((String)(pattern = pattern.trim().toLowerCase()), (String)"cyc", (String)"cyclic ") || StringUtil.isBetween((String)pattern, (String)"scr", (String)"scroll ")) {
            collector.consume((Object)CYCLING_SCROLLING);
        } else if (UISimpleSettingsProvider.patternContains(pattern, "memo")) {
            collector.consume((Object)MEMORY_INDICATOR);
        } else if (StringUtil.isBetween((String)pattern, (String)"nav", (String)"navigation bar ") || StringUtil.isBetween((String)pattern, (String)"navb", (String)"navbar ")) {
            collector.consume((Object)SHOW_NAVIGATION_BAR);
        } else if (StringUtil.isBetween((String)pattern, (String)"tool", (String)"toolbar ")) {
            collector.consume((Object)SHOW_MAIN_TOOLBAR);
        } else if (StringUtil.isBetween((String)pattern, (String)"tool w", (String)"tool window bars") || StringUtil.isBetween((String)pattern, (String)"toolw", (String)"toolwindow ")) {
            collector.consume((Object)HIDE_TOOL_STRIPES);
        } else if (StringUtil.isBetween((String)pattern, (String)"stat", (String)"status bar ")) {
            collector.consume((Object)SHOW_STATUS_BAR);
        } else if (StringUtil.isBetween((String)pattern, (String)"curs", (String)"cursor ") || StringUtil.isBetween((String)pattern, (String)"block ", (String)"block cursor ") || StringUtil.isBetween((String)pattern, (String)"caret", (String)"caret ") || StringUtil.isBetween((String)pattern, (String)"block ", (String)"block caret ")) {
            collector.consume((Object)IS_BLOCK_CURSOR);
        } else if (StringUtil.isBetween((String)pattern, (String)"whites", (String)"whitespaces ") || StringUtil.isBetween((String)pattern, (String)"show whi", (String)"show whitespaces ")) {
            collector.consume((Object)IS_WHITESPACES_SHOWN);
        } else if (StringUtil.isBetween((String)pattern, (String)"line ", (String)"line numbers ") || StringUtil.isBetween((String)pattern, (String)"show li", (String)"show line numbers ")) {
            collector.consume((Object)ARE_LINE_NUMBERS_SHOWN);
        } else if (StringUtil.isBetween((String)pattern, (String)"separa ", (String)"separators ") || StringUtil.isBetween((String)pattern, (String)"method s", (String)"method separators ")) {
            collector.consume((Object)SHOW_METHOD_SEPARATORS);
        }
    }

    private static boolean patternContains(String pattern, String search2) {
        for (String s : pattern.split(" ")) {
            if (!s.contains(search2)) continue;
            return true;
        }
        return false;
    }
}

