/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Path2D;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import sun.swing.DefaultLookup;

public class DarculaComboBoxUI
extends BasicComboBoxUI
implements Border,
ErrorBorderCapable {
    private Dimension myDisplaySizeCache = JBUI.emptySize();
    private Insets myPadding;
    protected KeyListener editorKeyListener;
    protected FocusListener editorFocusListener;

    public DarculaComboBoxUI() {
    }

    public DarculaComboBoxUI(JComboBox ignored) {
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarculaComboBoxUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.comboBox.setBorder(this);
        this.myPadding = UIManager.getInsets("ComboBox.padding");
    }

    @Override
    protected JButton createArrowButton() {
        Color bg = this.comboBox.getBackground();
        Color fg = this.comboBox.getForeground();
        BasicArrowButton button = new BasicArrowButton(5, bg, fg, fg, fg){

            @Override
            public void paint(Graphics g2) {
                Graphics2D g = (Graphics2D)g2;
                GraphicsConfig config = new GraphicsConfig((Graphics)g);
                int w = this.getWidth();
                int h = this.getHeight();
                if (!DarculaComboBoxUI.isTableCellEditor(DarculaComboBoxUI.this.comboBox)) {
                    g.setColor(DarculaComboBoxUI.this.getArrowButtonFillColor(UIUtil.getControlColor()));
                    g.fillRect(0, 0, w, h);
                }
                g.setColor((Color)new JBColor((Color)Gray._255, DarculaComboBoxUI.this.comboBox.isEnabled() ? this.getForeground() : DarculaComboBoxUI.this.getBorderColor()));
                config.setupRoundedBorderAntialiasing();
                int tW = JBUI.scale((int)8);
                int tH = JBUI.scale((int)6);
                int xU = (w - tW) / 2;
                int yU = (h - tH) / 2;
                g.translate(JBUI.scale((int)2), JBUI.scale((int)1));
                Path2D.Double path = new Path2D.Double();
                path.moveTo(xU, yU);
                path.lineTo(xU + tW, yU);
                path.lineTo(xU + tW / 2, yU + tH);
                path.lineTo(xU, yU);
                path.closePath();
                g.fill(path);
                g.translate(-JBUI.scale((int)2), -JBUI.scale((int)1));
                if (!DarculaComboBoxUI.isTableCellEditor(DarculaComboBoxUI.this.comboBox)) {
                    g.setColor(DarculaComboBoxUI.this.getArrowButtonFillColor(DarculaComboBoxUI.this.getBorderColor()));
                    g.drawLine(0, -1, 0, h);
                }
                config.restore();
            }

            @Override
            public Dimension getPreferredSize() {
                int size = this.getFont().getSize() + 4;
                if (size % 2 == 1) {
                    ++size;
                }
                return new DimensionUIResource(size, size);
            }
        };
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(false);
        return button;
    }

    protected Color getArrowButtonFillColor(Color defaultColor) {
        Color color = UIManager.getColor(this.comboBox.hasFocus() ? "ComboBox.darcula.arrowFocusedFillColor" : "ComboBox.darcula.arrowFillColor");
        return color == null ? defaultColor : (this.comboBox != null && !this.comboBox.isEnabled() ? new JBColor(this.getBorderColor(), UIUtil.getControlColor()) : color);
    }

    @Override
    protected Insets getInsets() {
        return JBUI.insets((int)4, (int)7, (int)4, (int)5).asUIResource();
    }

    @Override
    protected Dimension getDisplaySize() {
        Dimension display = new Dimension();
        DefaultListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
        }
        boolean sameBaseline = true;
        Object prototypeValue = this.comboBox.getPrototypeDisplayValue();
        if (prototypeValue != null) {
            display = this.getSizeForComponent(renderer.getListCellRendererComponent(this.listBox, prototypeValue, -1, false, false));
        } else {
            ComboBoxModel model = this.comboBox.getModel();
            int baseline = -1;
            if (model.getSize() > 0) {
                for (int i = 0; i < model.getSize(); ++i) {
                    Object value2 = model.getElementAt(i);
                    Component rendererComponent = renderer.getListCellRendererComponent(this.listBox, value2, -1, false, false);
                    Dimension d = this.getSizeForComponent(rendererComponent);
                    if (!(!sameBaseline || value2 == null || value2 instanceof String && "".equals(value2))) {
                        int newBaseline = rendererComponent.getBaseline(d.width, d.height);
                        if (newBaseline == -1) {
                            sameBaseline = false;
                        } else if (baseline == -1) {
                            baseline = newBaseline;
                        } else if (baseline != newBaseline) {
                            sameBaseline = false;
                        }
                    }
                    display.width = Math.max(display.width, d.width);
                    display.height = Math.max(display.height, d.height);
                }
            } else {
                display = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    display.width = JBUI.scale((int)100);
                }
            }
        }
        JBInsets.addTo((Dimension)display, (Insets)this.myPadding);
        this.myDisplaySizeCache.setSize(display.width, display.height);
        return display;
    }

    @Override
    protected Dimension getSizeForComponent(Component comp) {
        this.currentValuePane.add(comp);
        comp.setFont(this.comboBox.getFont());
        Dimension d = comp.getPreferredSize();
        this.currentValuePane.remove(comp);
        return d;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Container parent = c.getParent();
        if (parent != null) {
            g.setColor(DarculaComboBoxUI.isTableCellEditor(c) && this.editor != null ? this.editor.getBackground() : parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Rectangle r = this.rectangleForCurrentValue();
        if (!DarculaComboBoxUI.isTableCellEditor(c)) {
            this.hasFocus = this.comboBox.hasFocus();
            this.paintCurrentValueBackground(g, r, this.hasFocus);
        }
        this.paintCurrentValue(g, r, this.hasFocus);
    }

    protected static boolean isTableCellEditor(JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty("JComboBox.isTableCellEditor")) || c.getParent() instanceof JTable;
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        Rectangle r = super.rectangleForCurrentValue();
        r.x -= JBUI.scale((int)2);
        return r;
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        boolean changeOpaque;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        if (!hasFocus || this.isPopupVisible(this.comboBox)) {
            c.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c.setForeground(this.listBox.getForeground());
            c.setBackground(this.listBox.getBackground());
        } else if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledForeground", null));
            c.setBackground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledBackground", null));
        }
        boolean bl = changeOpaque = c instanceof JComponent && DarculaComboBoxUI.isTableCellEditor(this.comboBox) && c.isOpaque();
        if (changeOpaque) {
            ((JComponent)c).setOpaque(false);
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        Rectangle r = new Rectangle(bounds);
        JBInsets.removeFrom((Rectangle)r, (Insets)this.myPadding);
        this.currentValuePane.paintComponent(g, c, this.comboBox, r.x, r.y, r.width, r.height, shouldValidate);
        if (changeOpaque) {
            ((JComponent)c).setOpaque(true);
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor comboBoxEditor = super.createEditor();
        this.installEditorKeyListener(comboBoxEditor);
        return comboBoxEditor;
    }

    protected void installEditorKeyListener(@NotNull ComboBoxEditor cbe) {
        Component ec;
        if (cbe == null) {
            DarculaComboBoxUI.$$$reportNull$$$0(0);
        }
        if ((ec = cbe.getEditorComponent()) != null) {
            this.editorKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    this.process(e);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    this.process(e);
                }

                private void process(KeyEvent e) {
                    int code2 = e.getKeyCode();
                    if ((code2 == 38 || code2 == 40) && e.getModifiers() == 0) {
                        DarculaComboBoxUI.this.comboBox.dispatchEvent(e);
                    }
                }
            };
            ec.addKeyListener(this.editorKeyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.comboBox == null || this.arrowButton == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            this.checkFocus();
            Rectangle arrowButtonBounds = this.arrowButton.getBounds();
            int xxx = arrowButtonBounds.x - JBUI.scale((int)5);
            int H = height - JBUI.scale((int)2);
            int W = width - JBUI.scale((int)2);
            Shape clip = g2.getClip();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            int R = JBUI.scale((int)5);
            if (this.hasFocus) {
                g2.clipRect(JBUI.scale((int)2), JBUI.scale((int)2), this.comboBox.getWidth() - JBUI.scale((int)4), this.comboBox.getHeight() - JBUI.scale((int)4));
            }
            Color background = this.editor != null && this.comboBox.isEditable() ? this.editor.getBackground() : UIUtil.getPanelBackground();
            g2.setColor(background);
            g2.fillRoundRect(x + JBUI.scale((int)1), y + JBUI.scale((int)1), W, H, R, R);
            g2.setColor(this.getArrowButtonFillColor(this.arrowButton.getBackground()));
            g2.fillRoundRect(xxx, y + JBUI.scale((int)1), width - xxx, H, R, R);
            g2.setColor(background);
            g2.fillRect(xxx, y + JBUI.scale((int)1), JBUI.scale((int)5), H);
            Color borderColor = this.getBorderColor();
            g2.setColor(this.getArrowButtonFillColor(borderColor));
            int off = JBUI.scale((int)(this.hasFocus ? 1 : 0));
            g2.drawLine(xxx + JBUI.scale((int)5), y + JBUI.scale((int)1) + off, xxx + JBUI.scale((int)5), height - JBUI.scale((int)2));
            Rectangle r = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(g2, r, this.hasFocus);
            this.paintCurrentValue(g2, r, false);
            Object op = this.comboBox.getClientProperty("JComponent.outline");
            if (this.hasFocus) {
                g2.setClip(clip);
                if (op != null) {
                    DarculaUIUtil.paintOutlineBorder(g2, width, height, 0.0f, true, true, DarculaUIUtil.Outline.valueOf(op.toString()));
                } else {
                    DarculaUIUtil.paintFocusRing(g2, new Rectangle(JBUI.scale((int)2), JBUI.scale((int)2), width - JBUI.scale((int)4), height - JBUI.scale((int)4)));
                }
            } else if (op != null) {
                DarculaUIUtil.paintOutlineBorder(g2, width, height, 0.0f, true, false, DarculaUIUtil.Outline.valueOf(op.toString()));
            } else {
                g2.setColor(borderColor);
                g2.drawRoundRect(JBUI.scale((int)1), JBUI.scale((int)1), width - JBUI.scale((int)2), height - JBUI.scale((int)2), R, R);
                if (!UIUtil.isUnderDarcula() && this.comboBox.isEnabled()) {
                    g2.setColor(this.getArrowButtonFillColor(this.getBorderColor()));
                    int offX = xxx + JBUI.scale((int)5);
                    g2.clipRect(offX, y, width - offX, height);
                    g2.drawRoundRect(JBUI.scale((int)1), JBUI.scale((int)1), width - JBUI.scale((int)2), height - JBUI.scale((int)2), R, R);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected void checkFocus() {
        this.hasFocus = false;
        if (!this.comboBox.isEnabled()) {
            this.hasFocus = false;
            return;
        }
        this.hasFocus = DarculaComboBoxUI.hasFocus(this.comboBox);
        if (this.hasFocus) {
            return;
        }
        ComboBoxEditor ed = this.comboBox.getEditor();
        if (ed != null) {
            this.hasFocus = DarculaComboBoxUI.hasFocus(ed.getEditorComponent());
        }
    }

    protected static boolean hasFocus(Component c) {
        Component owner2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return owner2 != null && SwingUtilities.isDescendingFrom(owner2, c);
    }

    private Color getBorderColor() {
        if (this.comboBox != null && this.comboBox.isEnabled()) {
            return new JBColor((Color)Gray._150, (Color)Gray._100);
        }
        return new JBColor((Color)Gray._150, (Color)Gray._88);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new InsetsUIResource(4, 7, 4, 5);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    protected Dimension getSizeWithButton(Dimension d) {
        Insets i = this.getInsets();
        Dimension abSize = this.arrowButton.getPreferredSize();
        int editorHeight = this.editor != null ? this.editor.getPreferredSize().height + i.top + i.bottom : 0;
        return new Dimension(Math.max(d.width, abSize.width + i.left + JBUI.scale((int)10)), Math.max(editorHeight, Math.max(abSize.height, d.height)));
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getSizeWithButton(super.getPreferredSize(c));
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getSizeWithButton(super.getMinimumSize(c));
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        if (this.editor != null) {
            this.editorFocusListener = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    this.update();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.update();
                }

                private void update() {
                    if (DarculaComboBoxUI.this.comboBox != null) {
                        DarculaComboBoxUI.this.comboBox.repaint();
                    }
                }
            };
            if (this.editor instanceof JTextComponent) {
                this.editor.addFocusListener(this.editorFocusListener);
            } else {
                EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
                if (etf != null) {
                    etf.addFocusListener(this.editorFocusListener);
                }
            }
        }
        if (this.editor instanceof JComponent) {
            ((JComponent)this.editor).setBorder((Border)JBUI.Borders.empty());
        }
        if (Registry.is((String)"ide.ui.composite.editor.for.combobox") && this.editor instanceof JPanel) {
            this.editor.setFocusable(false);
        }
    }

    @Override
    protected void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.editorKeyListener != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
        }
        if (this.editor instanceof JTextComponent) {
            if (this.editorFocusListener != null) {
                this.editor.removeFocusListener(this.editorFocusListener);
            }
        } else {
            EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
            if (etf != null && this.editorFocusListener != null) {
                etf.removeFocusListener(this.editorFocusListener);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cbe", "com/intellij/ide/ui/laf/darcula/ui/DarculaComboBoxUI", "installEditorKeyListener"));
    }
}

