/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaSpinnerUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import org.jetbrains.annotations.NotNull;

public class WinIntelliJSpinnerUI
extends DarculaSpinnerUI {
    static final String HOVER_PROPERTY = "JSpinner.hover";
    static final int BUTTON_WIDTH = 21;
    static final int SPINNER_HEIGHT = 24;
    static final int EDITOR_OFFSET = 5;
    private MouseListener editorMouseListener;

    public static ComponentUI createUI(JComponent c) {
        return new WinIntelliJSpinnerUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.spinner.setOpaque(false);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.editorMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.setHover(Boolean.TRUE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.setHover(Boolean.FALSE);
            }

            private void setHover(Boolean value2) {
                if (WinIntelliJSpinnerUI.this.spinner.isEnabled()) {
                    WinIntelliJSpinnerUI.this.spinner.putClientProperty(WinIntelliJSpinnerUI.HOVER_PROPERTY, value2);
                    WinIntelliJSpinnerUI.this.spinner.repaint();
                }
            }
        };
        this.spinner.addMouseListener(this.editorMouseListener);
        WinIntelliJSpinnerUI.getEditorFocusOwner(this.spinner).addMouseListener(this.editorMouseListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.editorMouseListener != null) {
            this.spinner.removeMouseListener(this.editorMouseListener);
            WinIntelliJSpinnerUI.getEditorFocusOwner(this.spinner).removeMouseListener(this.editorMouseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component getEditorFocusOwner(JSpinner spinner) {
        Object object = spinner.getEditor().getTreeLock();
        synchronized (object) {
            return spinner.getEditor().getComponent(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle r = new Rectangle(c.getWidth(), c.getHeight());
            Container parent = c.getParent();
            if (c.isOpaque() && parent != null) {
                g2.setColor(parent.getBackground());
                g2.fill(r);
            }
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)2, (int)2, (int)2, (int)21));
            g2.setColor(c.isEnabled() ? c.getBackground() : UIManager.getColor("Button.background"));
            if (!c.isEnabled()) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.35f));
            }
            g2.fill(r);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    protected JButton createButton(int direction, String name2) {
        BasicArrowButton button = new BasicArrowButton(direction){
            private final String iconName;
            {
                this.iconName = "spinner" + (this.getDirection() == 1 ? "Up" : "Down") + "Triangle";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    int bw = JBUI.scale((int)1);
                    ButtonModel bm = this.getModel();
                    Area clip = new Area(g2.getClip());
                    if (!bm.isRollover() && !bm.isPressed()) {
                        clip.subtract(new Area(new Rectangle2D.Double(0.0, 0.0, bw, this.getHeight())));
                    }
                    if (this.getDirection() == 1 && WinIntelliJSpinnerUI.this.prevButton.getModel().isRollover()) {
                        clip.subtract(new Area(new Rectangle(0, this.getHeight() - bw, this.getWidth() - bw, bw)));
                    } else if (this.getDirection() == 5 && WinIntelliJSpinnerUI.this.nextButton.getModel().isRollover()) {
                        clip.subtract(new Area(new Rectangle(0, 0, this.getWidth() - bw, bw)));
                    }
                    g2.setClip(clip);
                    Rectangle outerRect = new Rectangle(0, this.getDirection() == 1 ? bw : 0, this.getWidth() - bw, this.getHeight() - bw);
                    if (WinIntelliJSpinnerUI.this.spinner.isEnabled()) {
                        if (bm.isPressed()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.pressedBackgroundColor"));
                        } else if (bm.isRollover()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.focusedBackgroundColor"));
                        } else {
                            g2.setColor(UIManager.getColor("Button.background"));
                        }
                    } else {
                        g2.setColor(UIManager.getColor("Button.background"));
                        g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
                    }
                    g2.fill(outerRect);
                    Icon icon = MacIntelliJIconCache.getIcon(this.iconName, false, false, this.isEnabled());
                    icon.paintIcon(this, g2, JBUI.scale((int)5), JBUI.scale((int)3));
                    if (WinIntelliJSpinnerUI.this.spinner.isEnabled()) {
                        if (bm.isPressed()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.pressedBorderColor"));
                        } else if (bm.isRollover()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.focusedBorderColor"));
                        } else {
                            g2.setColor(UIManager.getColor("Button.intellij.native.borderColor"));
                        }
                    } else {
                        g2.setColor(UIManager.getColor("Button.intellij.native.borderColor"));
                    }
                    Path2D.Double border = new Path2D.Double(0);
                    border.append(outerRect, false);
                    Rectangle innerRect = new Rectangle(outerRect);
                    JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)1));
                    border.append(innerRect, false);
                    g2.fill(border);
                }
                finally {
                    g2.dispose();
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return new JBDimension(21, this.getDirection() == 1 ? 13 : 12);
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        button.setName(name2);
        button.setRolloverEnabled(true);
        button.setOpaque(false);
        if (direction == 1) {
            this.installNextButtonListeners(button);
            button.setBorder((Border)JBUI.Borders.empty((int)2, (int)1, (int)1, (int)2));
        } else {
            this.installPreviousButtonListeners(button);
            button.setBorder((Border)JBUI.Borders.empty((int)1, (int)1, (int)2, (int)2));
        }
        return button;
    }

    @Override
    protected LayoutManager createLayout() {
        return new DarculaSpinnerUI.LayoutManagerDelegate(super.createLayout()){

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Dimension d = super.preferredLayoutSize(parent);
                if (d == null) {
                    return null;
                }
                Insets i = parent.getInsets();
                int iw = i.left + i.right;
                return new JBDimension(Math.max(46 - iw, d.width), 24);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                Dimension d = super.minimumLayoutSize(parent);
                if (d == null) {
                    return null;
                }
                Insets i = parent.getInsets();
                int iw = i.left + i.right;
                return new JBDimension(Math.max(36 - iw, d.width), 24);
            }

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                Rectangle bounds = parent.getBounds();
                Dimension nextButtonSize = WinIntelliJSpinnerUI.this.nextButton.getPreferredSize();
                Dimension prevButtonSize = WinIntelliJSpinnerUI.this.prevButton.getPreferredSize();
                nextButtonSize.height = bounds.height * nextButtonSize.height / (nextButtonSize.height + prevButtonSize.height - JBUI.scale((int)1));
                WinIntelliJSpinnerUI.this.nextButton.setBounds(bounds.width - nextButtonSize.width, 0, nextButtonSize.width, nextButtonSize.height);
                WinIntelliJSpinnerUI.this.prevButton.setBounds(bounds.width - prevButtonSize.width, nextButtonSize.height - JBUI.scale((int)1), prevButtonSize.width, bounds.height - nextButtonSize.height + JBUI.scale((int)1));
                JComponent editor = WinIntelliJSpinnerUI.this.spinner.getEditor();
                if (editor != null) {
                    WinIntelliJSpinnerUI.this.layoutEditor(bounds, editor);
                }
            }
        };
    }

    @Override
    protected JComponent createEditor() {
        JComponent editor = super.createEditor();
        editor.setBorder((Border)JBUI.Borders.empty((int)1, (int)0));
        editor.setOpaque(false);
        return editor;
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        super.replaceEditor(oldEditor, newEditor);
        newEditor.setBorder((Border)JBUI.Borders.empty((int)1, (int)0));
        newEditor.setOpaque(false);
    }

    private void layoutEditor(Rectangle pBounds, @NotNull JComponent editor) {
        if (editor == null) {
            WinIntelliJSpinnerUI.$$$reportNull$$$0(0);
        }
        Rectangle bounds = editor.getBounds();
        Insets i = this.spinner.getInsets();
        int offset = JBUI.scale((int)5) - i.left;
        editor.setBounds(bounds.x + offset, bounds.y, bounds.width - offset, pBounds.height - (i.top + i.bottom));
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return WinIntelliJSpinnerUI.getSizeWithButton(super.getPreferredSize(c));
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return WinIntelliJSpinnerUI.getSizeWithButton(super.getMinimumSize(c));
    }

    private static Dimension getSizeWithButton(Dimension d) {
        if (d == null) {
            return null;
        }
        return new JBDimension(Math.max(d.width + 7, 21), 24);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ide/ui/laf/intellij/WinIntelliJSpinnerUI", "layoutEditor"));
    }
}

