/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import org.jetbrains.annotations.NotNull;

class IndexedCharsInterner {
    private int[] idToIndex = new int[10];
    private final OpenTHashSet<CharSequence> mySet = new OpenTHashSet<CharSequence>(10, 0.9f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_SENSITIVE){

        protected void rehash(int newCapacity) {
            Object[] oldSet = this._set;
            int oldSize = IndexedCharsInterner.this.mySet.size();
            super.rehash(newCapacity);
            for (int i = 0; i < oldSize - 1; ++i) {
                int oldIndex = IndexedCharsInterner.this.idToIndex[i];
                CharSequence oldString = (CharSequence)oldSet[oldIndex];
                int newIndex = this.index(oldString);
                assert (newIndex != -1);
                ((IndexedCharsInterner)IndexedCharsInterner.this).idToIndex[i] = newIndex;
            }
        }
    };

    IndexedCharsInterner() {
    }

    public int toId(@NotNull String name2) {
        int id;
        CharSequence seq;
        int index;
        if (name2 == null) {
            IndexedCharsInterner.$$$reportNull$$$0(0);
        }
        if ((index = this.mySet.index((Object)(seq = ByteArrayCharSequence.convertToBytesIfAsciiString((String)name2)))) == -1) {
            id = this.mySet.size();
            this.mySet.add((Object)seq);
            index = this.mySet.index((Object)seq);
            assert (index != -1);
            if (id >= this.idToIndex.length) {
                this.idToIndex = ArrayUtil.realloc((int[])this.idToIndex, (int)(this.idToIndex.length * 3 / 2));
            }
            this.idToIndex[id] = index;
            assert (ArrayUtil.indexOf((int[])this.idToIndex, (int)index) == id);
            assert (this.toId(name2) == id);
        } else {
            id = ArrayUtil.indexOf((int[])this.idToIndex, (int)index);
        }
        assert (StringUtil.equals((CharSequence)this.fromId(id), (CharSequence)name2));
        return id;
    }

    @NotNull
    public CharSequence fromId(int id) {
        assert (id >= 0 && id < this.mySet.size());
        CharSequence charSequence = (CharSequence)this.mySet.get(this.idToIndex[id]);
        if (charSequence == null) {
            IndexedCharsInterner.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/search/IndexedCharsInterner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/search/IndexedCharsInterner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fromId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toId";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

