/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.DirectoryChooserModuleTreeView;
import com.intellij.ide.util.DirectoryChooserView;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryChooser
extends DialogWrapper {
    @NonNls
    private static final String FILTER_NON_EXISTING = "filter_non_existing";
    private static final String DEFAULT_SELECTION = "last_directory_selection";
    private final DirectoryChooserView myView;
    private boolean myFilterExisting;
    private PsiDirectory myDefaultSelection;
    private final List<ItemWrapper> myItems;
    private PsiElement mySelection;
    private final TabbedPaneWrapper myTabbedPaneWrapper;
    private final ChooseByNamePanel myChooseByNamePanel;

    public DirectoryChooser(@NotNull Project project2) {
        if (project2 == null) {
            DirectoryChooser.$$$reportNull$$$0(0);
        }
        this(project2, new DirectoryChooserModuleTreeView(project2));
    }

    public DirectoryChooser(@NotNull Project project2, @NotNull DirectoryChooserView view) {
        if (project2 == null) {
            DirectoryChooser.$$$reportNull$$$0(1);
        }
        if (view == null) {
            DirectoryChooser.$$$reportNull$$$0(2);
        }
        super(project2, true);
        this.myItems = new ArrayList<ItemWrapper>();
        this.myView = view;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        this.myFilterExisting = propertiesComponent.isTrueValue(FILTER_NON_EXISTING);
        this.myTabbedPaneWrapper = new TabbedPaneWrapper(this.getDisposable());
        this.myChooseByNamePanel = new ChooseByNamePanel(project2, new GotoClassModel2(project2){

            @Override
            @NotNull
            public String[] getNames(boolean checkBoxState) {
                String[] stringArray = super.getNames(false);
                if (stringArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return stringArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/DirectoryChooser$1", "getNames"));
            }
        }, "", false, null){

            @Override
            protected void showTextFieldPanel() {
            }

            @Override
            protected void close(boolean isOk) {
                super.close(isOk);
                if (isOk) {
                    List<Object> elements = this.getChosenElements();
                    if (elements != null && elements.size() > 0) {
                        this.myActionListener.elementChosen(elements.get(0));
                    }
                    DirectoryChooser.this.doOKAction();
                } else {
                    DirectoryChooser.this.doCancelAction();
                }
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myChooseByNamePanel);
        this.init();
    }

    protected void doOKAction() {
        PsiDirectory directory;
        ItemWrapper item;
        PropertiesComponent.getInstance().setValue(FILTER_NON_EXISTING, this.myFilterExisting);
        if (this.myTabbedPaneWrapper.getSelectedIndex() == 1) {
            this.setSelection(this.myChooseByNamePanel.getChosenElement());
        }
        if ((item = this.myView.getSelectedItem()) != null && (directory = item.getDirectory()) != null) {
            PropertiesComponent.getInstance((Project)directory.getProject()).setValue(DEFAULT_SELECTION, directory.getVirtualFile().getPath());
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new FilterExistentAction());
        JComponent toolbarComponent = ActionManager.getInstance().createActionToolbar("DirectoryChooser", (ActionGroup)actionGroup, true).getComponent();
        toolbarComponent.setBorder(null);
        panel2.add((Component)toolbarComponent, "North");
        Runnable runnable2 = () -> this.enableButtons();
        this.myView.onSelectionChange(runnable2);
        JComponent component = this.myView.getComponent();
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)component);
        int prototypeWidth = component.getFontMetrics(component.getFont()).stringWidth("X:\\1234567890\\1234567890\\com\\company\\system\\subsystem");
        jScrollPane.setPreferredSize(new Dimension(Math.max(300, prototypeWidth), 300));
        jScrollPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 15);
        this.installEnterAction(component);
        panel2.add((Component)jScrollPane, "Center");
        this.myTabbedPaneWrapper.addTab("Directory Structure", panel2);
        this.myChooseByNamePanel.invoke(new ChooseByNamePopupComponent.Callback(){

            public void elementChosen(Object element) {
                DirectoryChooser.this.setSelection(element);
            }
        }, ModalityState.stateForComponent((Component)this.getRootPane()), false);
        this.myTabbedPaneWrapper.addTab("Choose By Neighbor Class", this.myChooseByNamePanel.getPanel());
        return this.myTabbedPaneWrapper.getComponent();
    }

    private void setSelection(Object element) {
        if (element instanceof PsiElement) {
            this.mySelection = (PsiElement)element;
        }
    }

    private void installEnterAction(JComponent component) {
        KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        InputMap inputMap = component.getInputMap();
        ActionMap actionMap = component.getActionMap();
        Object oldActionKey = inputMap.get(enterKeyStroke);
        final Action oldAction = oldActionKey != null ? actionMap.get(oldActionKey) : null;
        inputMap.put(enterKeyStroke, "clickButton");
        actionMap.put("clickButton", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DirectoryChooser.this.isOKActionEnabled()) {
                    DirectoryChooser.this.doOKAction();
                } else if (oldAction != null) {
                    oldAction.actionPerformed(e);
                }
            }
        });
    }

    protected String getDimensionServiceKey() {
        return "chooseDestDirectoryDialog";
    }

    private void buildFragments() {
        ArrayList<String[]> pathes = new ArrayList<String[]>();
        for (int i = 0; i < this.myView.getItemsSize(); ++i) {
            ItemWrapper item = this.myView.getItemByIndex(i);
            pathes.add(ArrayUtil.toStringArray((Collection)FileUtil.splitPath((String)item.getPresentableUrl())));
        }
        FragmentBuilder headBuilder = new FragmentBuilder(pathes){

            @Override
            protected void append(String fragment, StringBuffer buffer) {
                buffer.append(this.mySeparator);
                buffer.append(fragment);
            }

            @Override
            protected int getFragmentIndex(String[] path, int index) {
                return path.length > index ? index : -1;
            }
        };
        String commonHead = headBuilder.execute();
        final int headLimit = headBuilder.getIndex();
        FragmentBuilder tailBuilder = new FragmentBuilder(pathes){

            @Override
            protected void append(String fragment, StringBuffer buffer) {
                buffer.insert(0, fragment + this.mySeparator);
            }

            @Override
            protected int getFragmentIndex(String[] path, int index) {
                int result2 = path.length - 1 - index;
                return result2 > headLimit ? result2 : -1;
            }
        };
        String commonTail = tailBuilder.execute();
        int tailLimit = tailBuilder.getIndex();
        for (int i = 0; i < this.myView.getItemsSize(); ++i) {
            ItemWrapper item = this.myView.getItemByIndex(i);
            String special = DirectoryChooser.concat((String[])pathes.get(i), headLimit, tailLimit);
            item.setFragments(DirectoryChooser.createFragments(commonHead, special, commonTail));
        }
    }

    @Nullable
    private static String concat(String[] strings, int headLimit, int tailLimit) {
        if (strings.length <= headLimit + tailLimit) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String separator = "";
        for (int i = headLimit; i < strings.length - tailLimit; ++i) {
            buffer.append(separator);
            buffer.append(strings[i]);
            separator = File.separator;
        }
        return buffer.toString();
    }

    private static PathFragment[] createFragments(String head, String special, String tail) {
        ArrayList<PathFragment> list2 = new ArrayList<PathFragment>(3);
        if (head != null) {
            if (special != null || tail != null) {
                list2.add(new PathFragment(head + File.separatorChar, true));
            } else {
                return new PathFragment[]{new PathFragment(head, true)};
            }
        }
        if (special != null) {
            if (tail != null) {
                list2.add(new PathFragment(special + File.separatorChar, false));
            } else {
                list2.add(new PathFragment(special, false));
            }
        }
        if (tail != null) {
            list2.add(new PathFragment(tail, true));
        }
        return list2.toArray(new PathFragment[list2.size()]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myView.getComponent();
    }

    public void fillList(PsiDirectory[] directories, @Nullable PsiDirectory defaultSelection, Project project2, String postfixToShow) {
        this.fillList(directories, defaultSelection, project2, postfixToShow, null);
    }

    public void fillList(PsiDirectory[] directories, @Nullable PsiDirectory defaultSelection, Project project2, Map<PsiDirectory, String> postfixes) {
        this.fillList(directories, defaultSelection, project2, null, postfixes);
    }

    private void fillList(PsiDirectory[] directories, @Nullable PsiDirectory defaultSelection, Project project2, String postfixToShow, Map<PsiDirectory, String> postfixes) {
        if (this.myView.getItemsSize() > 0) {
            this.myView.clearItems();
        }
        if (defaultSelection == null && (defaultSelection = DirectoryChooser.getDefaultSelection(directories, project2)) == null && directories.length > 0) {
            defaultSelection = directories[0];
        }
        int selectionIndex = -1;
        for (int i = 0; i < directories.length; ++i) {
            PsiDirectory directory = directories[i];
            if (!directory.equals(defaultSelection)) continue;
            selectionIndex = i;
            break;
        }
        if (selectionIndex < 0 && directories.length == 1) {
            selectionIndex = 0;
        }
        if (selectionIndex < 0) {
            VirtualFile[] sourceRoots;
            PsiManager manager = PsiManager.getInstance((Project)project2);
            for (VirtualFile sourceRoot : sourceRoots = ProjectRootManager.getInstance((Project)project2).getContentSourceRoots()) {
                PsiDirectory directory;
                if (!sourceRoot.isDirectory() || (directory = manager.findDirectory(sourceRoot)) == null || !DirectoryChooser.isParent(defaultSelection, directory)) continue;
                defaultSelection = directory;
                break;
            }
        }
        int existingIdx = 0;
        for (int i = 0; i < directories.length; ++i) {
            PsiDirectory directory = directories[i];
            String postfixForDirectory = postfixes == null ? postfixToShow : postfixes.get(directory);
            ItemWrapper itemWrapper = new ItemWrapper(directory, postfixForDirectory);
            this.myItems.add(itemWrapper);
            if (this.myFilterExisting) {
                if (selectionIndex == i) {
                    selectionIndex = -1;
                }
                if (postfixForDirectory != null && directory.getVirtualFile().findFileByRelativePath(StringUtil.trimStart((String)postfixForDirectory, (String)File.separator)) == null) {
                    if (!DirectoryChooser.isParent(directory, defaultSelection)) continue;
                    this.myDefaultSelection = directory;
                    continue;
                }
            }
            this.myView.addItem(itemWrapper);
            if (selectionIndex < 0 && DirectoryChooser.isParent(directory, defaultSelection)) {
                selectionIndex = existingIdx;
            }
            ++existingIdx;
        }
        this.buildFragments();
        this.myView.listFilled();
        if (this.myView.getItemsSize() > 0) {
            if (selectionIndex != -1) {
                this.myView.selectItemByIndex(selectionIndex);
            } else {
                this.myView.selectItemByIndex(0);
            }
        } else {
            this.myView.clearSelection();
        }
        this.enableButtons();
        this.myView.getComponent().repaint();
    }

    @Nullable
    private static PsiDirectory getDefaultSelection(PsiDirectory[] directories, Project project2) {
        VirtualFile directoryByDefault;
        String defaultSelectionPath = PropertiesComponent.getInstance((Project)project2).getValue(DEFAULT_SELECTION);
        if (defaultSelectionPath != null && (directoryByDefault = LocalFileSystem.getInstance().findFileByPath(defaultSelectionPath)) != null) {
            PsiDirectory directory = PsiManager.getInstance((Project)project2).findDirectory(directoryByDefault);
            return directory != null && ArrayUtil.find((Object[])directories, (Object)directory) > -1 ? directory : null;
        }
        return null;
    }

    private static boolean isParent(PsiDirectory directory, PsiDirectory parentCandidate) {
        while (directory != null) {
            if (directory.equals(parentCandidate)) {
                return true;
            }
            directory = directory.getParentDirectory();
        }
        return false;
    }

    private void enableButtons() {
        this.setOKActionEnabled(this.myView.getSelectedItem() != null);
    }

    @Nullable
    public PsiDirectory getSelectedDirectory() {
        PsiFile file2;
        if (this.mySelection != null && (file2 = this.mySelection.getContainingFile()) != null) {
            return file2.getContainingDirectory();
        }
        ItemWrapper wrapper = this.myView.getSelectedItem();
        if (wrapper == null) {
            return null;
        }
        return wrapper.myDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "view";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/util/DirectoryChooser";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class FilterExistentAction
    extends ToggleAction {
        public FilterExistentAction() {
            super(RefactoringBundle.message((String)"directory.chooser.hide.non.existent.checkBox.text"), UIUtil.removeMnemonic((String)RefactoringBundle.message((String)"directory.chooser.hide.non.existent.checkBox.text")), AllIcons.General.Filter);
        }

        public boolean isSelected(AnActionEvent e) {
            return DirectoryChooser.this.myFilterExisting;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            PsiDirectory directory;
            DirectoryChooser.this.myFilterExisting = state;
            ItemWrapper selectedItem = DirectoryChooser.this.myView.getSelectedItem();
            PsiDirectory psiDirectory = directory = selectedItem != null ? selectedItem.getDirectory() : null;
            if (directory == null && DirectoryChooser.this.myDefaultSelection != null) {
                directory = DirectoryChooser.this.myDefaultSelection;
            }
            DirectoryChooser.this.myView.clearItems();
            int idx = 0;
            int selectionId = -1;
            for (ItemWrapper item : DirectoryChooser.this.myItems) {
                if (DirectoryChooser.this.myFilterExisting && item.myPostfix != null && item.getDirectory().getVirtualFile().findFileByRelativePath(StringUtil.trimStart((String)item.myPostfix, (String)File.separator)) == null) continue;
                if (item.getDirectory() == directory) {
                    selectionId = idx;
                }
                ++idx;
                DirectoryChooser.this.myView.addItem(item);
            }
            DirectoryChooser.this.buildFragments();
            DirectoryChooser.this.myView.listFilled();
            if (selectionId < 0) {
                DirectoryChooser.this.myView.clearSelection();
                if (DirectoryChooser.this.myView.getItemsSize() > 0) {
                    DirectoryChooser.this.myView.selectItemByIndex(0);
                }
            } else {
                DirectoryChooser.this.myView.selectItemByIndex(selectionId);
            }
            DirectoryChooser.this.enableButtons();
            DirectoryChooser.this.myView.getComponent().repaint();
        }
    }

    public static class PathFragment {
        private final String myText;
        private final boolean myCommon;

        public PathFragment(String text2, boolean isCommon) {
            this.myText = text2;
            this.myCommon = isCommon;
        }

        public String getText() {
            return this.myText;
        }

        public boolean isCommon() {
            return this.myCommon;
        }
    }

    public static class ItemWrapper {
        final PsiDirectory myDirectory;
        private PathFragment[] myFragments;
        private final String myPostfix;
        private String myRelativeToProjectPath = null;

        public ItemWrapper(PsiDirectory directory, String postfix) {
            this.myDirectory = directory;
            this.myPostfix = postfix != null && postfix.length() > 0 ? postfix : null;
        }

        public PathFragment[] getFragments() {
            return this.myFragments;
        }

        public void setFragments(PathFragment[] fragments) {
            this.myFragments = fragments;
        }

        public Icon getIcon(FileIndex fileIndex) {
            if (this.myDirectory != null) {
                VirtualFile virtualFile = this.myDirectory.getVirtualFile();
                if (fileIndex.isInTestSourceContent(virtualFile)) {
                    return PlatformIcons.MODULES_TEST_SOURCE_FOLDER;
                }
                if (fileIndex.isInSourceContent(virtualFile)) {
                    return PlatformIcons.MODULES_SOURCE_FOLDERS_ICON;
                }
            }
            return PlatformIcons.FOLDER_ICON;
        }

        public String getPresentableUrl() {
            String directoryUrl;
            if (this.myDirectory != null) {
                String projectHomeUrl;
                directoryUrl = this.myDirectory.getVirtualFile().getPresentableUrl();
                VirtualFile baseDir = this.myDirectory.getProject().getBaseDir();
                if (baseDir != null && directoryUrl.startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
                    directoryUrl = "..." + directoryUrl.substring(projectHomeUrl.length());
                }
            } else {
                directoryUrl = "";
            }
            return this.myPostfix != null ? directoryUrl + this.myPostfix : directoryUrl;
        }

        public PsiDirectory getDirectory() {
            return this.myDirectory;
        }

        public String getRelativeToProjectPath() {
            if (this.myRelativeToProjectPath == null) {
                PsiDirectory directory = this.getDirectory();
                VirtualFile virtualFile = directory != null ? directory.getVirtualFile() : null;
                this.myRelativeToProjectPath = virtualFile != null ? ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)directory.getProject(), (boolean)true, (boolean)false, (boolean)true) : this.getPresentableUrl();
            }
            return this.myRelativeToProjectPath;
        }
    }

    private static abstract class FragmentBuilder {
        private final ArrayList<String[]> myPaths;
        private final StringBuffer myBuffer = new StringBuffer();
        private int myIndex;
        protected String mySeparator = "";

        public FragmentBuilder(ArrayList<String[]> pathes) {
            this.myPaths = pathes;
            this.myIndex = 0;
        }

        public int getIndex() {
            return this.myIndex;
        }

        @Nullable
        public String execute() {
            String commonHead;
            while ((commonHead = this.getCommonFragment(this.myIndex)) != null) {
                this.append(commonHead, this.myBuffer);
                this.mySeparator = File.separator;
                ++this.myIndex;
            }
            return this.myIndex > 0 ? this.myBuffer.toString() : null;
        }

        protected abstract void append(String var1, StringBuffer var2);

        @Nullable
        private String getCommonFragment(int count) {
            String commonFragment = null;
            for (String[] path : this.myPaths) {
                int index = this.getFragmentIndex(path, count);
                if (index == -1) {
                    return null;
                }
                if (commonFragment == null) {
                    commonFragment = path[index];
                    continue;
                }
                if (Comparing.strEqual((String)commonFragment, (String)path[index], (boolean)SystemInfo.isFileSystemCaseSensitive)) continue;
                return null;
            }
            return commonFragment;
        }

        protected abstract int getFragmentIndex(String[] var1, int var2);
    }
}

