/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.ide.util.SuperMethodWarningDialog;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class SuperMethodWarningUtil {
    public static Key<PsiMethod[]> SIBLINGS = Key.create((String)"MULTIPLE_INHERITANCE");

    private SuperMethodWarningUtil() {
    }

    @NotNull
    public static PsiMethod[] checkSuperMethods(@NotNull PsiMethod method, @NotNull String actionString) {
        if (method == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(0);
        }
        if (actionString == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(1);
        }
        PsiMethod[] psiMethodArray = SuperMethodWarningUtil.checkSuperMethods(method, actionString, Collections.emptyList());
        if (psiMethodArray == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(2);
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] checkSuperMethods(@NotNull PsiMethod method, @NotNull String actionString, @NotNull Collection<PsiElement> ignore) {
        PsiClass aClass;
        if (method == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(3);
        }
        if (actionString == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(4);
        }
        if (ignore == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(5);
        }
        if ((aClass = method.getContainingClass()) == null) {
            PsiMethod[] psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) {
                SuperMethodWarningUtil.$$$reportNull$$$0(6);
            }
            return psiMethodArray;
        }
        Collection<PsiMethod> superMethods = SuperMethodWarningUtil.getSuperMethods(method, aClass, ignore);
        if (superMethods.isEmpty()) {
            PsiMethod[] psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) {
                SuperMethodWarningUtil.$$$reportNull$$$0(7);
            }
            return psiMethodArray;
        }
        HashSet<String> superClasses = new HashSet<String>();
        boolean superAbstract = false;
        boolean parentInterface = false;
        for (PsiMethod superMethod : superMethods) {
            PsiClass containingClass = superMethod.getContainingClass();
            superClasses.add(containingClass.getQualifiedName());
            boolean isInterface = containingClass.isInterface();
            superAbstract |= isInterface || superMethod.hasModifierProperty("abstract");
            parentInterface |= isInterface;
        }
        SuperMethodWarningDialog dialog2 = new SuperMethodWarningDialog(method.getProject(), DescriptiveNameUtil.getDescriptiveName((PsiElement)method), actionString, superAbstract, parentInterface, aClass.isInterface(), ArrayUtil.toStringArray(superClasses));
        dialog2.show();
        if (dialog2.getExitCode() == 0) {
            PsiMethod[] psiMethodArray = superMethods.toArray(new PsiMethod[superMethods.size()]);
            if (psiMethodArray == null) {
                SuperMethodWarningUtil.$$$reportNull$$$0(8);
            }
            return psiMethodArray;
        }
        if (dialog2.getExitCode() == 3) {
            PsiMethod[] psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) {
                SuperMethodWarningUtil.$$$reportNull$$$0(9);
            }
            return psiMethodArray;
        }
        if (PsiMethod.EMPTY_ARRAY == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(10);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public static Collection<PsiMethod> getSuperMethods(@NotNull PsiMethod method, PsiClass aClass, @NotNull Collection<PsiElement> ignore) {
        PsiMethod siblingSuperMethod;
        VirtualFile virtualFile;
        if (method == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(11);
        }
        if (ignore == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(12);
        }
        Collection superMethods = DeepestSuperMethodsSearch.search((PsiMethod)method).findAll();
        superMethods.removeAll(ignore);
        if (superMethods.isEmpty() && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)aClass)) != null && ProjectRootManager.getInstance((Project)aClass.getProject()).getFileIndex().isInSourceContent(virtualFile) && (siblingSuperMethod = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method)) != null) {
            superMethods.add(siblingSuperMethod);
        }
        Collection collection = superMethods;
        if (collection == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(13);
        }
        return collection;
    }

    public static PsiMethod checkSuperMethod(@NotNull PsiMethod method, @NotNull String actionString) {
        PsiClass aClass;
        if (method == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(14);
        }
        if (actionString == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(15);
        }
        if ((aClass = method.getContainingClass()) == null) {
            return method;
        }
        PsiMethod superMethod = method.findDeepestSuperMethod();
        if (superMethod == null) {
            return method;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return superMethod;
        }
        PsiClass containingClass = superMethod.getContainingClass();
        SuperMethodWarningDialog dialog2 = new SuperMethodWarningDialog(method.getProject(), DescriptiveNameUtil.getDescriptiveName((PsiElement)method), actionString, containingClass.isInterface() || superMethod.hasModifierProperty("abstract"), containingClass.isInterface(), aClass.isInterface(), containingClass.getQualifiedName());
        dialog2.show();
        if (dialog2.getExitCode() == 0) {
            return superMethod;
        }
        if (dialog2.getExitCode() == 3) {
            return method;
        }
        return null;
    }

    public static void checkSuperMethod(@NotNull PsiMethod method, @NotNull String actionString, @NotNull PsiElementProcessor<PsiMethod> processor2, @NotNull Editor editor) {
        PsiClass aClass;
        if (method == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(16);
        }
        if (actionString == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(17);
        }
        if (processor2 == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(18);
        }
        if (editor == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(19);
        }
        if ((aClass = method.getContainingClass()) == null) {
            processor2.execute((PsiElement)method);
            return;
        }
        PsiMethod[] superMethods = method.findDeepestSuperMethods();
        if (superMethods.length == 0) {
            processor2.execute((PsiElement)method);
            return;
        }
        PsiClass containingClass = superMethods[0].getContainingClass();
        if (containingClass == null) {
            processor2.execute((PsiElement)method);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            processor2.execute((PsiElement)superMethods[0]);
            return;
        }
        PsiMethod[] methods = new PsiMethod[]{superMethods[0], method};
        String renameBase = actionString + " base method" + (superMethods.length > 1 ? "s" : "");
        String renameCurrent = actionString + " only current method";
        JBList list2 = new JBList((Object[])new String[]{renameBase, renameCurrent});
        String title = method.getName() + (superMethods.length > 1 ? " has super methods" : (containingClass.isInterface() && !aClass.isInterface() ? " implements" : " overrides") + " method of " + SymbolPresentationUtil.getSymbolPresentableText((PsiElement)containingClass));
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
            Object value2;
            if (processor2 == null) {
                SuperMethodWarningUtil.$$$reportNull$$$0(22);
            }
            if ((value2 = list2.getSelectedValue()) != null) {
                if (value2.equals(renameBase)) {
                    try {
                        methods[0].putUserData(SIBLINGS, (Object)superMethods);
                        processor2.execute((PsiElement)methods[0]);
                    }
                    finally {
                        methods[0].putUserData(SIBLINGS, null);
                    }
                } else {
                    processor2.execute((PsiElement)methods[1]);
                }
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    @Messages.YesNoCancelResult
    public static int askWhetherShouldAnnotateBaseMethod(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(20);
        }
        if (superMethod == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(21);
        }
        String implement = !method.hasModifierProperty("abstract") && superMethod.hasModifierProperty("abstract") ? InspectionsBundle.message((String)"inspection.annotate.quickfix.implements", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.annotate.quickfix.overrides", (Object[])new Object[0]);
        String message2 = InspectionsBundle.message((String)"inspection.annotate.quickfix.overridden.method.messages", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)method), implement, DescriptiveNameUtil.getDescriptiveName((PsiElement)superMethod)});
        String title = InspectionsBundle.message((String)"inspection.annotate.quickfix.overridden.method.warning", (Object[])new Object[0]);
        return Messages.showYesNoCancelDialog((Project)method.getProject(), (String)message2, (String)title, (Icon)Messages.getQuestionIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 4: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionString";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/SuperMethodWarningUtil";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignore";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/SuperMethodWarningUtil";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "checkSuperMethods";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperMethods";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSuperMethods";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperMethod";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "askWhetherShouldAnnotateBaseMethod";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkSuperMethod$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

