/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import java.util.Comparator;

public class SourceComparator
implements Comparator<NodeDescriptor> {
    public static final SourceComparator INSTANCE = new SourceComparator();

    private SourceComparator() {
    }

    @Override
    public int compare(NodeDescriptor nodeDescriptor1, NodeDescriptor nodeDescriptor2) {
        int weight2;
        int weight1 = SourceComparator.getWeight(nodeDescriptor1);
        if (weight1 != (weight2 = SourceComparator.getWeight(nodeDescriptor2))) {
            return weight1 - weight2;
        }
        if (!(nodeDescriptor1.getParentDescriptor() instanceof ProjectViewProjectNode)) {
            if (nodeDescriptor1 instanceof PsiDirectoryNode || nodeDescriptor1 instanceof PsiFileNode) {
                return nodeDescriptor1.toString().compareToIgnoreCase(nodeDescriptor2.toString());
            }
            if (nodeDescriptor1 instanceof ClassTreeNode && nodeDescriptor2 instanceof ClassTreeNode && ((ClassTreeNode)nodeDescriptor1).isTopLevel()) {
                return nodeDescriptor1.toString().compareToIgnoreCase(nodeDescriptor2.toString());
            }
        }
        return Integer.compare(nodeDescriptor1.getIndex(), nodeDescriptor2.getIndex());
    }

    private static int getWeight(NodeDescriptor descriptor2) {
        if (descriptor2 instanceof PsiDirectoryNode) {
            return ((PsiDirectoryNode)descriptor2).isFQNameShown() ? 7 : 0;
        }
        return 2;
    }
}

