/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.google.common.base.MoreObjects;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.StripeTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.UI;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.TwoColorsIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiInspectorAction
extends ToggleAction
implements DumbAware {
    private static final String CLICK_INFO = "CLICK_INFO";
    private static final String RENDERER_BOUNDS = "clicked renderer";
    private UiInspector myInspector;

    public UiInspectorAction() {
        if (Boolean.getBoolean("idea.ui.debug.mode")) {
            ApplicationManager.getApplication().invokeLater(() -> this.setSelected(null, true));
        }
    }

    public boolean isSelected(AnActionEvent e) {
        return this.myInspector != null;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        if (state) {
            UiInspectorNotification[] existing;
            if (this.myInspector == null) {
                this.myInspector = new UiInspector();
            }
            if ((existing = (UiInspectorNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UiInspectorNotification.class, null)).length == 0) {
                Notifications.Bus.notify((Notification)new UiInspectorNotification(), null);
            }
        } else {
            UiInspector inspector = this.myInspector;
            this.myInspector = null;
            if (inspector != null) {
                Disposer.dispose((Disposable)inspector);
            }
        }
    }

    @NotNull
    private static String getComponentName(Component component) {
        String name2 = UiInspectorAction.getClassName(component);
        String componentName = component.getName();
        if (StringUtil.isNotEmpty((String)componentName)) {
            name2 = name2 + " \"" + componentName + "\"";
        }
        String string = name2;
        if (string == null) {
            UiInspectorAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static TreeModel buildModel(Component c) {
        Container parent = c.getParent();
        while (parent != null) {
            c = parent;
            parent = c.getParent();
        }
        return new DefaultTreeModel(new HierarchyTree.ComponentNode(c));
    }

    private static void drawCenteredString(Graphics2D g2d, FontMetrics fm, int fontHeight, String text2, int x, int y) {
        int width = fm.stringWidth(text2);
        UIUtil.drawCenteredString((Graphics2D)g2d, (Rectangle)new Rectangle(x - width / 2, y - fontHeight / 2, width, fontHeight), (String)text2);
    }

    @NotNull
    private static String getToStringValue(@NotNull Object value2) {
        if (value2 == null) {
            UiInspectorAction.$$$reportNull$$$0(1);
        }
        String toString = StringUtil.notNullize((String)String.valueOf(value2), (String)"toString()==null");
        String string = toString.replace('\n', ' ');
        if (string == null) {
            UiInspectorAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getClassName(Object value2) {
        Class<?> clazz0 = value2.getClass();
        Class<?> clazz = clazz0.isAnonymousClass() ? clazz0.getSuperclass() : clazz0;
        String string = clazz.getSimpleName();
        if (string == null) {
            UiInspectorAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static ColorIcon createColorIcon(Color color) {
        return (ColorIcon)JBUI.scale((JBUI.JBIcon)new ColorIcon(13, 11, color, true));
    }

    private static Icon createColorIcon(Color color1, Color color2) {
        return JBUI.scale((JBUI.JBIcon)new TwoColorsIcon(11, color1, color2));
    }

    private static Object fromObject(Object o, Class<?> type2) {
        if (o == null) {
            return null;
        }
        if (type2.isAssignableFrom(o.getClass())) {
            return o;
        }
        if ("null".equals(o)) {
            return null;
        }
        String value2 = String.valueOf(o).trim();
        if (type2 == Integer.TYPE) {
            return Integer.parseInt(value2);
        }
        if (type2 == Boolean.TYPE) {
            return "yes".equalsIgnoreCase(value2) || "true".equalsIgnoreCase(value2);
        }
        if (type2 == Byte.TYPE) {
            return Byte.parseByte(value2);
        }
        if (type2 == Short.TYPE) {
            return Short.parseShort(value2);
        }
        if (type2 == Double.TYPE) {
            return Double.parseDouble(value2);
        }
        if (type2 == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value2));
        }
        String[] s = value2.split("(?i)\\s*(?:[x@:]|[a-z]+:)\\s*", 6);
        if (type2 == Dimension.class) {
            if (s.length == 2) {
                return new Dimension(Integer.parseInt(s[0]), Integer.parseInt(s[1]));
            }
        } else if (type2 == Point.class) {
            if (s.length == 2) {
                return new Point(Integer.parseInt(s[0]), Integer.parseInt(s[1]));
            }
        } else if (type2 == Rectangle.class) {
            if (s.length >= 5) {
                return new Rectangle(Integer.parseInt(s[3]), Integer.parseInt(s[4]), Integer.parseInt(s[1]), Integer.parseInt(s[2]));
            }
        } else if (type2 == Insets.class) {
            if (s.length >= 5) {
                return new Insets(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[4]), Integer.parseInt(s[4]));
            }
        } else if (type2 == Color.class && s.length >= 5) {
            return new ColorUIResource(new Color(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[3]), Integer.parseInt(s[4])));
        }
        throw new UnsupportedOperationException(type2.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToStringValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getToStringValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UiInspector
    implements AWTEventListener,
    Disposable {
        public UiInspector() {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 18L);
        }

        public void dispose() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            for (Window window : Window.getWindows()) {
                if (!(window instanceof InspectorWindow)) continue;
                ((InspectorWindow)window).close();
            }
        }

        public void showInspector(@NotNull Component c) {
            if (c == null) {
                UiInspector.$$$reportNull$$$0(0);
            }
            InspectorWindow window = new InspectorWindow(c);
            window.pack();
            ((Window)window).setVisible(true);
            window.toFront();
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof MouseEvent) {
                this.processMouseEvent((MouseEvent)event);
            } else if (event instanceof ContainerEvent) {
                UiInspector.processContainerEvent((ContainerEvent)event);
            }
        }

        private void processMouseEvent(MouseEvent me) {
            if (!me.isAltDown() || !me.isControlDown()) {
                return;
            }
            if (me.getClickCount() != 1 || me.isPopupTrigger()) {
                return;
            }
            me.consume();
            if (me.getID() != 502) {
                return;
            }
            Component component = me.getComponent();
            if (component instanceof Container) {
                component = ((Container)component).findComponentAt(me.getPoint());
            } else if (component == null) {
                component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            }
            if (component != null) {
                if (component instanceof JComponent) {
                    ((JComponent)component).putClientProperty(UiInspectorAction.CLICK_INFO, UiInspector.getClickInfo(me, component));
                }
                this.showInspector(component);
            }
        }

        private static List<PropertyBean> getClickInfo(MouseEvent me, Component component) {
            JTree tree;
            TreePath path;
            JList list2;
            int row;
            if (me.getComponent() == null) {
                return null;
            }
            me = SwingUtilities.convertMouseEvent(me.getComponent(), me, component);
            ArrayList<PropertyBean> clickInfo = new ArrayList<PropertyBean>();
            if (component instanceof JList && (row = (list2 = (JList)component).getUI().locationToIndex(list2, me.getPoint())) != -1) {
                Component rendererComponent = list2.getCellRenderer().getListCellRendererComponent(list2, list2.getModel().getElementAt(row), row, list2.getSelectionModel().isSelectedIndex(row), list2.hasFocus());
                clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, list2.getUI().getCellBounds(list2, row, row)));
                clickInfo.addAll(new InspectorTableModel((Component)rendererComponent).myProperties);
                return clickInfo;
            }
            if (component instanceof JTable) {
                JTable table = (JTable)component;
                row = table.rowAtPoint(me.getPoint());
                int column = table.columnAtPoint(me.getPoint());
                if (row != -1 && column != -1) {
                    Component rendererComponent = table.getCellRenderer(row, column).getTableCellRendererComponent(table, table.getValueAt(row, column), table.getSelectionModel().isSelectedIndex(row), table.hasFocus(), row, column);
                    clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, table.getCellRect(row, column, true)));
                    clickInfo.addAll(new InspectorTableModel((Component)rendererComponent).myProperties);
                    return clickInfo;
                }
            }
            if (component instanceof JTree && (path = (tree = (JTree)component).getClosestPathForLocation(me.getX(), me.getY())) != null) {
                Object object = path.getLastPathComponent();
                Component rendererComponent = tree.getCellRenderer().getTreeCellRendererComponent(tree, object, tree.getSelectionModel().isPathSelected(path), tree.isExpanded(path), tree.getModel().isLeaf(object), tree.getRowForPath(path), tree.hasFocus());
                clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, tree.getPathBounds(path)));
                clickInfo.addAll(new InspectorTableModel((Component)rendererComponent).myProperties);
                return clickInfo;
            }
            return null;
        }

        private static void processContainerEvent(ContainerEvent event) {
            Component child;
            Component component = child = event.getID() == 300 ? event.getChild() : null;
            if (child instanceof JComponent && !(event.getSource() instanceof CellRendererPane)) {
                String text2 = ExceptionUtil.getThrowableText((Throwable)new Throwable());
                int first = text2.indexOf("at com.intellij", text2.indexOf("at java.awt"));
                int last = text2.indexOf("at java.awt.EventQueue");
                if (last == -1) {
                    last = text2.length();
                }
                String val = last > first && first > 0 ? text2.substring(first, last) : null;
                ((JComponent)child).putClientProperty("uiInspector.addedAt", val);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/internal/inspector/UiInspectorAction$UiInspector", "showInspector"));
        }
    }

    private static class InspectorTableModel
    extends AbstractTableModel {
        final List<String> PROPERTIES;
        final List<String> CHECKERS;
        final List<String> ACCESSIBLE_CONTEXT_PROPERTIES;
        final Component myComponent;
        final List<PropertyBean> myProperties;

        InspectorTableModel(@NotNull List<PropertyBean> clickInfo) {
            if (clickInfo == null) {
                InspectorTableModel.$$$reportNull$$$0(0);
            }
            this.PROPERTIES = Arrays.asList("ui", "getLocation", "getLocationOnScreen", "getSize", "isOpaque", "getBorder", "getForeground", "getBackground", "getFont", "getCellRenderer", "getCellEditor", "getMinimumSize", "getMaximumSize", "getPreferredSize", "getText", "isEditable", "getIcon", "getVisibleRect", "getLayout", "getAlignmentX", "getAlignmentY", "getTooltipText", "getToolTipText", "isShowing", "isEnabled", "isVisible", "isDoubleBuffered", "isFocusable", "isFocusCycleRoot", "isFocusOwner", "isValid", "isDisplayable", "isLightweight");
            this.CHECKERS = Arrays.asList("isForegroundSet", "isBackgroundSet", "isFontSet", "isMinimumSizeSet", "isMaximumSizeSet", "isPreferredSizeSet");
            this.ACCESSIBLE_CONTEXT_PROPERTIES = Arrays.asList("getAccessibleRole", "getAccessibleName", "getAccessibleDescription", "getAccessibleAction", "getAccessibleChildrenCount", "getAccessibleIndexInParent", "getAccessibleRelationSet", "getAccessibleStateSet", "getAccessibleEditableText", "getAccessibleTable", "getAccessibleText", "getAccessibleValue", "accessibleChangeSupport");
            this.myProperties = ContainerUtil.newArrayList();
            this.myComponent = null;
            this.myProperties.addAll(clickInfo);
        }

        InspectorTableModel(@NotNull Component c) {
            if (c == null) {
                InspectorTableModel.$$$reportNull$$$0(1);
            }
            this.PROPERTIES = Arrays.asList("ui", "getLocation", "getLocationOnScreen", "getSize", "isOpaque", "getBorder", "getForeground", "getBackground", "getFont", "getCellRenderer", "getCellEditor", "getMinimumSize", "getMaximumSize", "getPreferredSize", "getText", "isEditable", "getIcon", "getVisibleRect", "getLayout", "getAlignmentX", "getAlignmentY", "getTooltipText", "getToolTipText", "isShowing", "isEnabled", "isVisible", "isDoubleBuffered", "isFocusable", "isFocusCycleRoot", "isFocusOwner", "isValid", "isDisplayable", "isLightweight");
            this.CHECKERS = Arrays.asList("isForegroundSet", "isBackgroundSet", "isFontSet", "isMinimumSizeSet", "isMaximumSizeSet", "isPreferredSizeSet");
            this.ACCESSIBLE_CONTEXT_PROPERTIES = Arrays.asList("getAccessibleRole", "getAccessibleName", "getAccessibleDescription", "getAccessibleAction", "getAccessibleChildrenCount", "getAccessibleIndexInParent", "getAccessibleRelationSet", "getAccessibleStateSet", "getAccessibleEditableText", "getAccessibleTable", "getAccessibleText", "getAccessibleValue", "accessibleChangeSupport");
            this.myProperties = ContainerUtil.newArrayList();
            this.myComponent = c;
            this.fillTable();
        }

        void fillTable() {
            this.addProperties("", this.myComponent, this.PROPERTIES);
            Object addedAt = this.myComponent instanceof JComponent ? ((JComponent)this.myComponent).getClientProperty("uiInspector.addedAt") : null;
            this.myProperties.add(new PropertyBean("added-at", addedAt));
            boolean isAccessible = this.myComponent instanceof Accessible;
            this.myProperties.add(new PropertyBean("accessible", isAccessible));
            AccessibleContext context = this.myComponent.getAccessibleContext();
            this.myProperties.add(new PropertyBean("accessibleContext", context));
            if (isAccessible) {
                this.addProperties("  ", this.myComponent.getAccessibleContext(), this.ACCESSIBLE_CONTEXT_PROPERTIES);
            }
            if (this.myComponent instanceof Container) {
                this.addLayoutProperties((Container)this.myComponent);
            }
        }

        private void addProperties(@NotNull String prefix, @NotNull Object component, @NotNull List<String> methodNames) {
            Class<?> clazz0;
            if (prefix == null) {
                InspectorTableModel.$$$reportNull$$$0(2);
            }
            if (component == null) {
                InspectorTableModel.$$$reportNull$$$0(3);
            }
            if (methodNames == null) {
                InspectorTableModel.$$$reportNull$$$0(4);
            }
            Class<?> clazz = (clazz0 = component.getClass()).isAnonymousClass() ? clazz0.getSuperclass() : clazz0;
            this.myProperties.add(new PropertyBean(prefix + "class", clazz.getName()));
            StringBuilder classHierarchy = new StringBuilder();
            for (Class<?> cl = clazz.getSuperclass(); cl != null; cl = cl.getSuperclass()) {
                if (classHierarchy.length() > 0) {
                    classHierarchy.append(" -> ");
                }
                classHierarchy.append(cl.getName());
                if (JComponent.class.getName().equals(cl.getName())) break;
            }
            this.myProperties.add(new PropertyBean(prefix + "hierarchy", classHierarchy.toString()));
            for (String name2 : methodNames) {
                String propertyName = (String)ObjectUtils.notNull((Object)StringUtil.getPropertyName((String)name2), (Object)name2);
                try {
                    Object propertyValue;
                    try {
                        propertyValue = ReflectionUtil.findMethod(Arrays.asList(clazz.getMethods()), (String)name2, (Class[])new Class[0]).invoke(component, new Object[0]);
                    }
                    catch (Exception e) {
                        propertyValue = ReflectionUtil.findField(clazz, null, (String)name2).get(component);
                    }
                    boolean changed = false;
                    try {
                        Object value2;
                        String checkerMethodName = "is" + StringUtil.capitalize((String)propertyName) + "Set";
                        if (this.CHECKERS.contains(checkerMethodName) && (value2 = ReflectionUtil.findMethod(Arrays.asList(clazz.getMethods()), (String)checkerMethodName, (Class[])new Class[0]).invoke(component, new Object[0])) instanceof Boolean) {
                            changed = (Boolean)value2;
                        }
                    }
                    catch (Exception e) {
                        changed = false;
                    }
                    this.myProperties.add(new PropertyBean(prefix + propertyName, propertyValue, changed));
                }
                catch (Exception exception) {}
            }
        }

        private void addLayoutProperties(@NotNull Container component) {
            block12: {
                LayoutManager layout;
                String prefix;
                block14: {
                    block13: {
                        block11: {
                            if (component == null) {
                                InspectorTableModel.$$$reportNull$$$0(5);
                            }
                            prefix = "  ";
                            layout = component.getLayout();
                            if (!(layout instanceof GridBagLayout)) break block11;
                            GridBagLayout bagLayout = (GridBagLayout)layout;
                            GridBagConstraints defaultConstraints = (GridBagConstraints)ReflectionUtil.getField(GridBagLayout.class, (Object)bagLayout, GridBagConstraints.class, (String)"defaultConstraints");
                            this.myProperties.add(new PropertyBean("GridBagLayout constraints", String.format("defaultConstraints - %s", InspectorTableModel.toString(defaultConstraints))));
                            if (bagLayout.columnWidths != null) {
                                this.myProperties.add(new PropertyBean(prefix + "columnWidths", Arrays.toString(bagLayout.columnWidths)));
                            }
                            if (bagLayout.rowHeights != null) {
                                this.myProperties.add(new PropertyBean(prefix + "rowHeights", Arrays.toString(bagLayout.rowHeights)));
                            }
                            if (bagLayout.columnWeights != null) {
                                this.myProperties.add(new PropertyBean(prefix + "columnWeights", Arrays.toString(bagLayout.columnWeights)));
                            }
                            if (bagLayout.rowWeights != null) {
                                this.myProperties.add(new PropertyBean(prefix + "rowWeights", Arrays.toString(bagLayout.rowWeights)));
                            }
                            for (Component child : component.getComponents()) {
                                this.myProperties.add(new PropertyBean(prefix + UiInspectorAction.getComponentName(child), InspectorTableModel.toString(bagLayout.getConstraints(child))));
                            }
                            break block12;
                        }
                        if (!(layout instanceof BorderLayout)) break block13;
                        BorderLayout borderLayout = (BorderLayout)layout;
                        this.myProperties.add(new PropertyBean("BorderLayout constraints", String.format("hgap - %s, vgap - %s", borderLayout.getHgap(), borderLayout.getVgap())));
                        for (Component child : component.getComponents()) {
                            this.myProperties.add(new PropertyBean(prefix + UiInspectorAction.getComponentName(child), borderLayout.getConstraints(child)));
                        }
                        break block12;
                    }
                    if (!(layout instanceof CardLayout)) break block14;
                    CardLayout cardLayout = (CardLayout)layout;
                    Integer currentCard = (Integer)ReflectionUtil.getField(CardLayout.class, (Object)cardLayout, null, (String)"currentCard");
                    Vector vector = (Vector)ReflectionUtil.getField(CardLayout.class, (Object)cardLayout, Vector.class, (String)"vector");
                    String cardDescription = "???";
                    if (vector != null && currentCard != null) {
                        Object card = vector.get(currentCard);
                        cardDescription = (String)ReflectionUtil.getField(card.getClass(), card, String.class, (String)"name");
                    }
                    this.myProperties.add(new PropertyBean("CardLayout constraints", String.format("card - %s, hgap - %s, vgap - %s", cardDescription, cardLayout.getHgap(), cardLayout.getVgap())));
                    if (vector == null) break block12;
                    for (Object card : vector) {
                        String cardName = (String)ReflectionUtil.getField(card.getClass(), card, String.class, (String)"name");
                        Component child = (Component)ReflectionUtil.getField(card.getClass(), card, Component.class, (String)"comp");
                        this.myProperties.add(new PropertyBean(prefix + UiInspectorAction.getComponentName(child), cardName));
                    }
                    break block12;
                }
                if (layout instanceof MigLayout) {
                    MigLayout migLayout = (MigLayout)layout;
                    this.myProperties.add(new PropertyBean("MigLayout constraints", migLayout.getColumnConstraints()));
                    for (Component child : component.getComponents()) {
                        this.myProperties.add(new PropertyBean(prefix + UiInspectorAction.getComponentName(child), migLayout.getComponentConstraints(child)));
                    }
                }
            }
        }

        @NotNull
        private static String toString(@Nullable GridBagConstraints constraints) {
            if (constraints == null) {
                if ("null" == null) {
                    InspectorTableModel.$$$reportNull$$$0(6);
                }
                return "null";
            }
            MoreObjects.ToStringHelper h = MoreObjects.toStringHelper((String)"");
            InspectorTableModel.appendFieldValue(h, constraints, "gridx");
            InspectorTableModel.appendFieldValue(h, constraints, "gridy");
            InspectorTableModel.appendFieldValue(h, constraints, "gridwidth");
            InspectorTableModel.appendFieldValue(h, constraints, "gridheight");
            InspectorTableModel.appendFieldValue(h, constraints, "weightx");
            InspectorTableModel.appendFieldValue(h, constraints, "weighty");
            InspectorTableModel.appendFieldValue(h, constraints, "anchor");
            InspectorTableModel.appendFieldValue(h, constraints, "fill");
            InspectorTableModel.appendFieldValue(h, constraints, "insets");
            InspectorTableModel.appendFieldValue(h, constraints, "ipadx");
            InspectorTableModel.appendFieldValue(h, constraints, "ipady");
            String string = h.toString();
            if (string == null) {
                InspectorTableModel.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static void appendFieldValue(@NotNull MoreObjects.ToStringHelper h, @NotNull GridBagConstraints constraints, @NotNull String field) {
            Object defaultValue;
            Object value2;
            if (h == null) {
                InspectorTableModel.$$$reportNull$$$0(8);
            }
            if (constraints == null) {
                InspectorTableModel.$$$reportNull$$$0(9);
            }
            if (field == null) {
                InspectorTableModel.$$$reportNull$$$0(10);
            }
            if (!Comparing.equal((Object)(value2 = ReflectionUtil.getField(GridBagConstraints.class, (Object)constraints, null, (String)field)), (Object)(defaultValue = ReflectionUtil.getField(GridBagConstraints.class, (Object)new GridBagConstraints(), null, (String)field)))) {
                h.add(field, value2);
            }
        }

        @Override
        @Nullable
        public Object getValueAt(int row, int column) {
            PropertyBean bean = this.myProperties.get(row);
            if (bean != null) {
                switch (column) {
                    case 0: {
                        return bean.propertyName;
                    }
                }
                return bean.propertyValue;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1 && this.updater(this.myProperties.get(row)) != null;
        }

        @Override
        public void setValueAt(Object value2, int row, int col) {
            PropertyBean bean = this.myProperties.get(row);
            try {
                this.myProperties.set(row, new PropertyBean(bean.propertyName, ((Function)ObjectUtils.notNull(this.updater(bean))).fun(value2)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Nullable
        public Function<Object, Object> updater(PropertyBean bean) {
            if (this.myComponent == null) {
                return null;
            }
            String name2 = bean.propertyName.trim();
            try {
                Method getter;
                try {
                    getter = this.myComponent.getClass().getMethod("get" + StringUtil.capitalize((String)name2), new Class[0]);
                }
                catch (Exception e) {
                    getter = this.myComponent.getClass().getMethod("is" + StringUtil.capitalize((String)name2), new Class[0]);
                }
                Method finalGetter = getter;
                Method setter = this.myComponent.getClass().getMethod("set" + StringUtil.capitalize((String)name2), getter.getReturnType());
                setter.setAccessible(true);
                return o -> {
                    try {
                        setter.invoke((Object)this.myComponent, UiInspectorAction.fromObject(o, finalGetter.getReturnType()));
                        return finalGetter.invoke((Object)this.myComponent, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (Exception e) {
                try {
                    Field field = ReflectionUtil.findField(this.myComponent.getClass(), null, (String)name2);
                    if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                        return null;
                    }
                    return o -> {
                        try {
                            field.set(this.myComponent, UiInspectorAction.fromObject(o, field.getType()));
                            return field.get(this.myComponent);
                        }
                        catch (Exception e1) {
                            throw new RuntimeException(e1);
                        }
                    };
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myProperties.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? "Property" : "Value";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : Object.class;
        }

        public void refresh() {
            this.myProperties.clear();
            this.fillTable();
            this.fireTableDataChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clickInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNames";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction$InspectorTableModel";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "h";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constraints";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorTableModel";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addProperties";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addLayoutProperties";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "appendFieldValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PropertyBean {
        final String propertyName;
        final Object propertyValue;
        final boolean changed;

        PropertyBean(String name2, Object value2) {
            this(name2, value2, false);
        }

        PropertyBean(String name2, Object value2, boolean changed) {
            this.propertyName = name2;
            this.propertyValue = value2;
            this.changed = changed;
        }
    }

    private static class ObjectRenderer
    extends JLabel
    implements Renderer<Object> {
        private ObjectRenderer() {
            this.putClientProperty("html.disable", Boolean.TRUE);
        }

        @Override
        public JComponent setValue(@NotNull Object value2) {
            if (value2 == null) {
                ObjectRenderer.$$$reportNull$$$0(0);
            }
            this.setText(UiInspectorAction.getToStringValue(value2));
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$ObjectRenderer", "setValue"));
        }
    }

    private static class BorderRenderer
    extends JLabel
    implements Renderer<Border> {
        private BorderRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Border value2) {
            if (value2 == null) {
                BorderRenderer.$$$reportNull$$$0(0);
            }
            this.setText(BorderRenderer.getTextDescription(value2));
            if (value2 instanceof CompoundBorder) {
                Color insideColor = BorderRenderer.getBorderColor(((CompoundBorder)value2).getInsideBorder());
                Color outsideColor = BorderRenderer.getBorderColor(((CompoundBorder)value2).getOutsideBorder());
                if (insideColor != null && outsideColor != null) {
                    this.setIcon(UiInspectorAction.createColorIcon(outsideColor, insideColor));
                } else if (insideColor != null) {
                    this.setIcon((Icon)UiInspectorAction.createColorIcon(insideColor));
                } else if (outsideColor != null) {
                    this.setIcon((Icon)UiInspectorAction.createColorIcon(outsideColor));
                } else {
                    this.setIcon(null);
                }
            } else {
                Color color = BorderRenderer.getBorderColor(value2);
                this.setIcon((Icon)(color != null ? UiInspectorAction.createColorIcon(color) : null));
            }
            return this;
        }

        @Nullable
        private static Color getBorderColor(@NotNull Border value2) {
            if (value2 == null) {
                BorderRenderer.$$$reportNull$$$0(1);
            }
            if (value2 instanceof LineBorder) {
                return ((LineBorder)value2).getLineColor();
            }
            if (value2 instanceof CustomLineBorder) {
                try {
                    return (Color)ReflectionUtil.findField(CustomLineBorder.class, Color.class, (String)"myColor").get(value2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        @NotNull
        private static String getTextDescription(@NotNull Border value2) {
            if (value2 == null) {
                BorderRenderer.$$$reportNull$$$0(2);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(UiInspectorAction.getClassName(value2));
            Color color = BorderRenderer.getBorderColor(value2);
            if (color != null) {
                sb.append(" color=").append(color.toString());
            }
            if (value2 instanceof LineBorder && ((LineBorder)value2).getRoundedCorners()) {
                sb.append(" roundedCorners=true");
            }
            if (value2 instanceof TitledBorder) {
                sb.append(" title='").append(((TitledBorder)value2).getTitle()).append("'");
            }
            if (value2 instanceof CompoundBorder) {
                sb.append(" inside={").append(BorderRenderer.getTextDescription(((CompoundBorder)value2).getInsideBorder())).append("}");
                sb.append(" outside={").append(BorderRenderer.getTextDescription(((CompoundBorder)value2).getOutsideBorder())).append("}");
            }
            if (value2 instanceof UIResource) {
                sb.append(" UIResource");
            }
            sb.append(" (").append(UiInspectorAction.getToStringValue(value2)).append(")");
            String string = sb.toString();
            if (string == null) {
                BorderRenderer.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction$BorderRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$BorderRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getBorderColor";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getTextDescription";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IconRenderer
    extends JLabel
    implements Renderer<Icon> {
        private IconRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Icon value2) {
            if (value2 == null) {
                IconRenderer.$$$reportNull$$$0(0);
            }
            this.setIcon(value2);
            this.setText(UiInspectorAction.getToStringValue(value2));
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$IconRenderer", "setValue"));
        }
    }

    private static class BooleanRenderer
    extends JLabel
    implements Renderer<Boolean> {
        private BooleanRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Boolean value2) {
            if (value2 == null) {
                BooleanRenderer.$$$reportNull$$$0(0);
            }
            this.setText(value2 != false ? "Yes" : "No");
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$BooleanRenderer", "setValue"));
        }
    }

    private static class FontRenderer
    extends JLabel
    implements Renderer<Font> {
        private FontRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Font value2) {
            if (value2 == null) {
                FontRenderer.$$$reportNull$$$0(0);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(value2.getFontName()).append(" (").append(value2.getFamily()).append("), ").append(value2.getSize()).append("px");
            if (1 == (1 & value2.getStyle())) {
                sb.append(" bold");
            }
            if (2 == (2 & value2.getStyle())) {
                sb.append(" italic");
            }
            if (value2 instanceof UIResource) {
                sb.append(" UIResource");
            }
            this.setText(sb.toString());
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$FontRenderer", "setValue"));
        }
    }

    private static class ColorRenderer
    extends JLabel
    implements Renderer<Color> {
        private ColorRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Color value2) {
            if (value2 == null) {
                ColorRenderer.$$$reportNull$$$0(0);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(" r:").append(value2.getRed());
            sb.append(" g:").append(value2.getGreen());
            sb.append(" b:").append(value2.getBlue());
            sb.append(" a:").append(value2.getAlpha());
            sb.append(" argb:0x");
            String hex = Integer.toHexString(value2.getRGB());
            for (int i = hex.length(); i < 8; ++i) {
                sb.append('0');
            }
            sb.append(hex.toUpperCase(Locale.ENGLISH));
            if (value2 instanceof UIResource) {
                sb.append(" UIResource");
            }
            this.setText(sb.toString());
            this.setIcon((Icon)UiInspectorAction.createColorIcon(value2));
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$ColorRenderer", "setValue"));
        }
    }

    private static class RectangleRenderer
    extends JLabel
    implements Renderer<Rectangle> {
        private RectangleRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Rectangle value2) {
            if (value2 == null) {
                RectangleRenderer.$$$reportNull$$$0(0);
            }
            this.setText(RectangleRenderer.toString(value2));
            return this;
        }

        @NotNull
        static String toString(@NotNull Rectangle r) {
            if (r == null) {
                RectangleRenderer.$$$reportNull$$$0(1);
            }
            String string = r.width + "x" + r.height + " @ " + r.x + ":" + r.y;
            if (string == null) {
                RectangleRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction$RectangleRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$RectangleRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InsetsRenderer
    extends JLabel
    implements Renderer<Insets> {
        private InsetsRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Insets value2) {
            if (value2 == null) {
                InsetsRenderer.$$$reportNull$$$0(0);
            }
            this.setText("top: " + value2.top + " left:" + value2.left + " bottom:" + value2.bottom + " right:" + value2.right);
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$InsetsRenderer", "setValue"));
        }
    }

    private static class DimensionRenderer
    extends JLabel
    implements Renderer<Dimension> {
        private DimensionRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Dimension value2) {
            if (value2 == null) {
                DimensionRenderer.$$$reportNull$$$0(0);
            }
            this.setText(String.valueOf(value2.width) + "x" + value2.height);
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$DimensionRenderer", "setValue"));
        }
    }

    private static class PointRenderer
    extends JLabel
    implements Renderer<Point> {
        private PointRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Point value2) {
            if (value2 == null) {
                PointRenderer.$$$reportNull$$$0(0);
            }
            this.setText(String.valueOf(value2.x) + ':' + value2.y);
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$PointRenderer", "setValue"));
        }
    }

    private static interface Renderer<T> {
        public JComponent setValue(@NotNull T var1);
    }

    private static class ValueCellRenderer
    implements TableCellRenderer {
        private static final Map<Class, Renderer> RENDERERS = ContainerUtil.newHashMap();
        private static final Renderer<Object> DEFAULT_RENDERER;
        private static final JLabel NULL_RENDERER;

        private ValueCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value2 == null) {
                NULL_RENDERER.setOpaque(isSelected);
                NULL_RENDERER.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                NULL_RENDERER.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return NULL_RENDERER;
            }
            Renderer renderer = (Renderer)ObjectUtils.notNull(ValueCellRenderer.getRenderer(value2.getClass()), DEFAULT_RENDERER);
            JComponent result2 = renderer.setValue(value2);
            result2.setOpaque(isSelected);
            result2.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            result2.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            return result2;
        }

        @Nullable
        private static Renderer<Object> getRenderer(Class clazz) {
            Class<?>[] interfaces;
            if (clazz == null) {
                return null;
            }
            Renderer<Object> renderer = RENDERERS.get(clazz);
            if (renderer != null) {
                return renderer;
            }
            for (Class<?> aClass : interfaces = clazz.getInterfaces()) {
                renderer = ValueCellRenderer.getRenderer(aClass);
                if (renderer == null) continue;
                return renderer;
            }
            if ((clazz = clazz.getSuperclass()) != null) {
                return ValueCellRenderer.getRenderer(clazz);
            }
            return null;
        }

        static {
            RENDERERS.put(Point.class, new PointRenderer());
            RENDERERS.put(Dimension.class, new DimensionRenderer());
            RENDERERS.put(Insets.class, new InsetsRenderer());
            RENDERERS.put(Rectangle.class, new RectangleRenderer());
            RENDERERS.put(Color.class, new ColorRenderer());
            RENDERERS.put(Font.class, new FontRenderer());
            RENDERERS.put(Boolean.class, new BooleanRenderer());
            RENDERERS.put(Icon.class, new IconRenderer());
            RENDERERS.put(Border.class, new BorderRenderer());
            DEFAULT_RENDERER = new ObjectRenderer();
            NULL_RENDERER = new JLabel("-");
        }
    }

    private static class DimensionsComponent
    extends JComponent {
        Component myComponent;
        int myWidth;
        int myHeight;
        Border myBorder;
        Insets myInsets;

        private DimensionsComponent(@NotNull Component component) {
            if (component == null) {
                DimensionsComponent.$$$reportNull$$$0(0);
            }
            this.myComponent = component;
            this.setOpaque(true);
            this.setBackground((Color)JBColor.WHITE);
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
            this.setFont((Font)JBUI.Fonts.label((float)9.0f));
            this.update();
        }

        public void update() {
            this.myWidth = this.myComponent.getWidth();
            this.myHeight = this.myComponent.getHeight();
            if (this.myComponent instanceof JComponent) {
                this.myBorder = ((JComponent)this.myComponent).getBorder();
                this.myInsets = ((JComponent)this.myComponent).getInsets();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            GraphicsConfig config = new GraphicsConfig(g).setAntialiasing(UISettings.getShadowInstance().getIdeAAType() != AntialiasingType.OFF);
            Rectangle bounds = this.getBounds();
            g2d.setColor(this.getBackground());
            Insets insets = this.getInsets();
            g2d.fillRect(insets.left, insets.top, bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
            String sizeString = String.format("%d x %d", this.myWidth, this.myHeight);
            FontMetrics fm = g2d.getFontMetrics();
            int sizeWidth = fm.stringWidth(sizeString);
            int fontHeight = fm.getHeight();
            int innerBoxWidthGap = JBUI.scale((int)20);
            int innerBoxHeightGap = JBUI.scale((int)5);
            int boxSize = JBUI.scale((int)15);
            int centerX = bounds.width / 2;
            int centerY = bounds.height / 2;
            int innerX = centerX - sizeWidth / 2 - innerBoxWidthGap;
            int innerY = centerY - fontHeight / 2 - innerBoxHeightGap;
            int innerWidth = sizeWidth + innerBoxWidthGap * 2;
            int innerHeight = fontHeight + innerBoxHeightGap * 2;
            g2d.setColor(this.getForeground());
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, sizeString, centerX, centerY);
            g2d.setColor((Color)JBColor.GRAY);
            g2d.drawRect(innerX, innerY, innerWidth, innerHeight);
            Insets borderInsets = null;
            if (this.myBorder != null) {
                borderInsets = this.myBorder.getBorderInsets(this.myComponent);
            }
            UIUtil.drawDottedRectangle((Graphics)g2d, (int)(innerX - boxSize), (int)(innerY - boxSize), (int)(innerX + innerWidth + boxSize), (int)(innerY + innerHeight + boxSize));
            DimensionsComponent.drawInsets(g2d, fm, "border", borderInsets, boxSize, fontHeight, innerX, innerY, innerWidth, innerHeight);
            g2d.drawRect(innerX - boxSize * 2, innerY - boxSize * 2, innerWidth + boxSize * 4, innerHeight + boxSize * 4);
            DimensionsComponent.drawInsets(g2d, fm, "insets", this.myInsets, boxSize * 2, fontHeight, innerX, innerY, innerWidth, innerHeight);
            config.restore();
        }

        private static void drawInsets(Graphics2D g2d, FontMetrics fm, String name2, Insets insets, int offset, int fontHeight, int innerX, int innerY, int innerWidth, int innerHeight) {
            g2d.setColor((Color)JBColor.BLACK);
            g2d.drawString(name2, innerX - offset + JBUI.scale((int)5), innerY - offset + fontHeight);
            g2d.setColor((Color)JBColor.GRAY);
            int outerX = innerX - offset;
            int outerWidth = innerWidth + offset * 2;
            int outerY = innerY - offset;
            int outerHeight = innerHeight + offset * 2;
            String top = insets != null ? Integer.toString(insets.top) : "-";
            String bottom = insets != null ? Integer.toString(insets.bottom) : "-";
            String left = insets != null ? Integer.toString(insets.left) : "-";
            String right = insets != null ? Integer.toString(insets.right) : "-";
            int shift = JBUI.scale((int)7);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, top, outerX + outerWidth / 2, outerY + shift);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, bottom, outerX + outerWidth / 2, outerY + outerHeight - shift);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, left, outerX + shift, outerY + outerHeight / 2);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, right, outerX + outerWidth - shift, outerY + outerHeight / 2);
        }

        @Override
        public Dimension getMinimumSize() {
            return JBUI.size((int)120);
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)150);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/UiInspectorAction$DimensionsComponent", "<init>"));
        }
    }

    private static class InspectorTable
    extends JPanel {
        InspectorTableModel myModel;
        DimensionsComponent myDimensionComponent;

        private InspectorTable(@NotNull List<PropertyBean> clickInfo) {
            if (clickInfo == null) {
                InspectorTable.$$$reportNull$$$0(0);
            }
            this.myModel = new InspectorTableModel(clickInfo);
            this.init(null);
        }

        private InspectorTable(@NotNull Component component) {
            if (component == null) {
                InspectorTable.$$$reportNull$$$0(1);
            }
            this.myModel = new InspectorTableModel(component);
            this.init(component);
        }

        private void init(@Nullable Component component) {
            this.setLayout(new BorderLayout());
            StripeTable table = new StripeTable((TableModel)this.myModel);
            new TableSpeedSearch((JTable)table);
            TableColumnModel columnModel = table.getColumnModel();
            TableColumn propertyColumn = columnModel.getColumn(0);
            propertyColumn.setMinWidth(JBUI.scale((int)200));
            propertyColumn.setMaxWidth(JBUI.scale((int)200));
            propertyColumn.setResizable(false);
            propertyColumn.setCellRenderer(new PropertyNameRenderer());
            TableColumn valueColumn = columnModel.getColumn(1);
            valueColumn.setMinWidth(JBUI.scale((int)200));
            valueColumn.setResizable(false);
            valueColumn.setCellRenderer(new ValueCellRenderer());
            valueColumn.setCellEditor(new DefaultCellEditor((JTextField)new JBTextField()){

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
                    Component comp = table.getCellRenderer(row, column).getTableCellRendererComponent(table, value2, false, false, row, column);
                    if (comp instanceof JLabel) {
                        value2 = ((JLabel)comp).getText();
                    }
                    Component result2 = super.getTableCellEditorComponent(table, value2, isSelected, row, column);
                    ((JComponent)result2).setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY, 1));
                    return result2;
                }

                @Override
                public Object getCellEditorValue() {
                    return super.getCellEditorValue();
                }
            });
            table.setAutoResizeMode(3);
            this.add((Component)new JBScrollPane((Component)table), "Center");
            if (component != null) {
                this.myDimensionComponent = new DimensionsComponent(component);
                this.add((Component)this.myDimensionComponent, "South");
            }
        }

        public void refresh() {
            this.myModel.refresh();
            this.myDimensionComponent.update();
            this.myDimensionComponent.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clickInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorTable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class PropertyNameRenderer
        extends DefaultTableCellRenderer {
            private PropertyNameRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                TableModel model = table.getModel();
                boolean changed = false;
                if (model instanceof InspectorTableModel) {
                    changed = ((InspectorTableModel)model).myProperties.get((int)row).changed;
                }
                Color fg = isSelected ? table.getSelectionForeground() : (changed ? UI.getColor((String)"link.foreground") : table.getForeground());
                JBFont font = JBUI.Fonts.label();
                this.setFont((Font)(changed ? font.asBold() : font));
                this.setForeground(fg);
                return this;
            }
        }
    }

    private static class HighlightComponent
    extends JComponent {
        Color myColor;

        private HighlightComponent(@NotNull Color c) {
            if (c == null) {
                HighlightComponent.$$$reportNull$$$0(0);
            }
            this.myColor = c;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            g2d.setColor(this.myColor);
            Composite old = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
            Rectangle r = this.getBounds();
            g2d.fillRect(0, 0, r.width, r.height);
            g2d.setColor(this.myColor.darker());
            g2d.drawRect(0, 0, r.width - 1, r.height - 1);
            g2d.setComposite(old);
            g2d.setColor(oldColor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/internal/inspector/UiInspectorAction$HighlightComponent", "<init>"));
        }
    }

    private static abstract class HierarchyTree
    extends JTree
    implements TreeSelectionListener {
        final Component myComponent;

        private HierarchyTree(Component c) {
            this.myComponent = c;
            this.setModel(UiInspectorAction.buildModel(c));
            this.setCellRenderer((TreeCellRenderer)((Object)new ComponentTreeCellRenderer(c)));
            this.getSelectionModel().addTreeSelectionListener(this);
            new TreeSpeedSearch(this);
            if (((JComponent)c).getClientProperty(UiInspectorAction.CLICK_INFO) != null) {
                SwingUtilities.invokeLater(() -> this.getSelectionModel().setSelectionPath(this.getPathForRow(this.getLeadSelectionRow() + 1)));
            }
        }

        public void expandPath() {
            TreeUtil.expandAll((JTree)this);
            int count = this.getRowCount();
            ComponentNode node = new ComponentNode(this.myComponent);
            for (int i = 0; i < count; ++i) {
                TreePath row = this.getPathForRow(i);
                if (!row.getLastPathComponent().equals(node)) continue;
                this.setSelectionPath(row);
                this.scrollPathToVisible(this.getSelectionPath());
                break;
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getNewLeadSelectionPath();
            if (path == null) {
                this.onComponentChanged((Component)null);
                return;
            }
            Object component = path.getLastPathComponent();
            if (component instanceof ComponentNode) {
                Component c = ((ComponentNode)component).getComponent();
                this.onComponentChanged(c);
            }
            if (component instanceof ClickInfoNode) {
                this.onComponentChanged(((ClickInfoNode)component).getInfo());
            }
        }

        public abstract void onComponentChanged(List<PropertyBean> var1);

        public abstract void onComponentChanged(Component var1);

        private static class ClickInfoNode
        extends DefaultMutableTreeNode {
            private final List<PropertyBean> myInfo;

            public ClickInfoNode(List<PropertyBean> info) {
                this.myInfo = info;
            }

            @Override
            public String toString() {
                return "Clicked Info";
            }

            public List<PropertyBean> getInfo() {
                return this.myInfo;
            }

            @Override
            public boolean isLeaf() {
                return true;
            }
        }

        private static class ComponentNode
        extends DefaultMutableTreeNode {
            private final Component myComponent;
            String myText;

            private ComponentNode(@NotNull Component component) {
                if (component == null) {
                    ComponentNode.$$$reportNull$$$0(0);
                }
                super(component);
                this.myComponent = component;
                this.children = ComponentNode.prepareChildren(this.myComponent);
            }

            Component getComponent() {
                return this.myComponent;
            }

            @Override
            public String toString() {
                return this.myText != null ? this.myText : this.myComponent.getClass().getName();
            }

            public void setText(String value2) {
                this.myText = value2;
            }

            public boolean equals(Object obj) {
                return obj instanceof ComponentNode && ((ComponentNode)obj).getComponent() == this.getComponent();
            }

            private static Vector prepareChildren(Component parent) {
                Component[] o;
                Vector<DefaultMutableTreeNode> result2 = new Vector<DefaultMutableTreeNode>();
                if (parent instanceof JComponent && (o = ((JComponent)parent).getClientProperty(UiInspectorAction.CLICK_INFO)) instanceof List) {
                    result2.add(new ClickInfoNode((List)o));
                }
                if (parent instanceof Container) {
                    for (Component component : ((Container)parent).getComponents()) {
                        result2.add(new ComponentNode(component));
                    }
                }
                if (parent instanceof Window) {
                    Window[] children2;
                    for (Window child : children2 = ((Window)parent).getOwnedWindows()) {
                        if (child instanceof InspectorWindow) continue;
                        result2.add(new ComponentNode(child));
                    }
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/UiInspectorAction$HierarchyTree$ComponentNode", "<init>"));
            }
        }
    }

    private static class ComponentTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final Component myInitialSelection;

        ComponentTreeCellRenderer(Component initialSelection) {
            this.myInitialSelection = initialSelection;
            this.setFont((Font)JBUI.Fonts.label((float)11.0f));
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color background;
            if (tree == null) {
                ComponentTreeCellRenderer.$$$reportNull$$$0(0);
            }
            Color foreground = selected ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeForeground();
            Color color = background = selected ? UIUtil.getTreeSelectionBackground() : null;
            if (value2 instanceof HierarchyTree.ComponentNode) {
                HierarchyTree.ComponentNode componentNode = (HierarchyTree.ComponentNode)value2;
                Component component = componentNode.getComponent();
                if (!selected) {
                    if (!component.isVisible()) {
                        foreground = JBColor.GRAY;
                    } else if (component.getWidth() == 0 || component.getHeight() == 0) {
                        foreground = new JBColor(new Color(128, 10, 0), (Color)JBColor.BLUE);
                    } else if (component.getPreferredSize() != null && (component.getSize().width < component.getPreferredSize().width || component.getSize().height < component.getPreferredSize().height)) {
                        foreground = PlatformColors.BLUE;
                    }
                    if (this.myInitialSelection == componentNode.getComponent()) {
                        background = new Color(31, 128, 8, 58);
                    }
                }
                this.append(UiInspectorAction.getComponentName(component));
                this.append(": " + RectangleRenderer.toString(component.getBounds()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                if (component.isOpaque()) {
                    this.append(", opaque", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                if (component.isDoubleBuffered()) {
                    this.append(", double-buffered", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                componentNode.setText(this.toString());
                this.setIcon(UiInspectorAction.createColorIcon(component.getForeground(), component.getBackground()));
            }
            if (value2 instanceof HierarchyTree.ClickInfoNode) {
                this.append(value2.toString());
                this.setIcon(AllIcons.Ide.Rating);
            }
            this.setForeground(foreground);
            this.setBackground(background);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/internal/inspector/UiInspectorAction$ComponentTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private static class InspectorWindow
    extends JDialog {
        private InspectorTable myInspectorTable;
        private Component myComponent;
        private List<PropertyBean> myInfo;
        private Component myInitialComponent;
        private HighlightComponent myHighlightComponent;
        private HierarchyTree myHierarchyTree;
        private final JPanel myWrapperPanel;

        private InspectorWindow(@NotNull Component component) throws HeadlessException {
            if (component == null) {
                InspectorWindow.$$$reportNull$$$0(0);
            }
            super(InspectorWindow.findWindow(component));
            Window window = InspectorWindow.findWindow(component);
            this.setModal(window instanceof JDialog && ((JDialog)window).isModal());
            this.myComponent = component;
            this.myInitialComponent = component;
            this.getRootPane().setBorder(JBUI.Borders.empty((int)5));
            this.setDefaultCloseOperation(2);
            this.setLayout(new BorderLayout());
            this.setTitle(component.getClass().getName());
            DefaultActionGroup actions = new DefaultActionGroup();
            actions.addAction((AnAction)new IconWithTextAction("Highlight"){

                public void actionPerformed(AnActionEvent e) {
                    this.setHighlightingEnabled(myHighlightComponent == null);
                }

                public void update(AnActionEvent e) {
                    e.getPresentation().setEnabled(myInfo != null || myComponent != null && myComponent.isVisible());
                }
            });
            actions.addSeparator();
            actions.add((AnAction)new IconWithTextAction("Refresh"){

                public void actionPerformed(AnActionEvent e) {
                    this.getCurrentTable().refresh();
                }

                public void update(AnActionEvent e) {
                    e.getPresentation().setEnabled(myComponent != null && myComponent.isVisible());
                }
            });
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ContextToolbar", (ActionGroup)actions, true);
            this.add((Component)toolbar.getComponent(), "North");
            this.myWrapperPanel = new JPanel(new BorderLayout());
            this.myInspectorTable = new InspectorTable(component);
            this.myHierarchyTree = new HierarchyTree(component){

                @Override
                public void onComponentChanged(Component c) {
                    boolean wasHighlighted = myHighlightComponent != null;
                    this.setHighlightingEnabled(false);
                    this.switchInfo(c);
                    this.setHighlightingEnabled(wasHighlighted);
                }

                @Override
                public void onComponentChanged(List<PropertyBean> info) {
                    boolean wasHighlighted = myHighlightComponent != null;
                    this.setHighlightingEnabled(false);
                    this.switchInfo(info);
                    this.setHighlightingEnabled(wasHighlighted);
                }
            };
            this.myWrapperPanel.add((Component)this.myInspectorTable, "Center");
            JBSplitter splitPane = new JBSplitter(false, "UiInspector.splitter.proportion", 0.5f);
            splitPane.setSecondComponent((JComponent)this.myWrapperPanel);
            splitPane.setFirstComponent((JComponent)new JBScrollPane((Component)this.myHierarchyTree));
            this.add((Component)splitPane, "Center");
            this.myHierarchyTree.expandPath();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    this.close();
                }
            });
            this.getRootPane().getActionMap().put("CLOSE", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.close();
                }
            });
            this.setHighlightingEnabled(true);
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CLOSE");
        }

        private static Window findWindow(Component component) {
            DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)component);
            if (dialogWrapper != null) {
                return dialogWrapper.getPeer().getWindow();
            }
            return null;
        }

        private InspectorTable getCurrentTable() {
            return this.myInspectorTable;
        }

        private void switchInfo(@Nullable Component c) {
            if (c == null) {
                return;
            }
            this.myComponent = c;
            this.myInfo = null;
            this.setTitle(this.myComponent.getClass().getName());
            this.myWrapperPanel.removeAll();
            this.myInspectorTable = new InspectorTable(c);
            this.myWrapperPanel.add((Component)this.myInspectorTable, "Center");
            this.myWrapperPanel.revalidate();
            this.myWrapperPanel.repaint();
        }

        private void switchInfo(@NotNull List<PropertyBean> clickInfo) {
            if (clickInfo == null) {
                InspectorWindow.$$$reportNull$$$0(1);
            }
            this.myComponent = null;
            this.myInfo = clickInfo;
            this.setTitle("Click Info");
            this.myWrapperPanel.removeAll();
            this.myInspectorTable = new InspectorTable(clickInfo);
            this.myWrapperPanel.add((Component)this.myInspectorTable, "Center");
            this.myWrapperPanel.revalidate();
            this.myWrapperPanel.repaint();
        }

        @Override
        public void dispose() {
            super.dispose();
            DialogWrapper.cleanupRootPane((JRootPane)this.rootPane);
            DialogWrapper.cleanupWindowListeners((Window)this);
        }

        public void close() {
            if (this.myInitialComponent instanceof JComponent) {
                ((JComponent)this.myInitialComponent).putClientProperty(UiInspectorAction.CLICK_INFO, null);
            }
            this.myInfo = null;
            this.setHighlightingEnabled(false);
            if (this.myComponent == null) {
                return;
            }
            this.myComponent = null;
            this.setVisible(false);
            this.dispose();
        }

        private void setHighlightingEnabled(boolean enable) {
            JComponent glassPane;
            if (this.myHighlightComponent != null) {
                glassPane = InspectorWindow.getGlassPane(this.myHighlightComponent);
                if (glassPane != null) {
                    glassPane.remove(this.myHighlightComponent);
                    glassPane.revalidate();
                    glassPane.repaint();
                }
                this.myHighlightComponent = null;
            }
            if (enable && this.myComponent != null && (glassPane = InspectorWindow.getGlassPane(this.myComponent)) != null) {
                this.myHighlightComponent = new HighlightComponent((Color)new JBColor((Color)JBColor.GREEN, (Color)JBColor.RED));
                Point pt = SwingUtilities.convertPoint(this.myComponent, new Point(0, 0), glassPane);
                this.myHighlightComponent.setBounds(pt.x, pt.y, this.myComponent.getWidth(), this.myComponent.getHeight());
                glassPane.add(this.myHighlightComponent);
                glassPane.revalidate();
                glassPane.repaint();
            }
            if (enable & this.myInfo != null && this.myInitialComponent != null) {
                JComponent glassPane2;
                Rectangle bounds = null;
                for (PropertyBean bean : this.myInfo) {
                    if (!UiInspectorAction.RENDERER_BOUNDS.equals(bean.propertyName)) continue;
                    bounds = (Rectangle)bean.propertyValue;
                    break;
                }
                if (bounds != null && (glassPane2 = InspectorWindow.getGlassPane(this.myInitialComponent)) != null) {
                    this.myHighlightComponent = new HighlightComponent((Color)new JBColor((Color)JBColor.GREEN, (Color)JBColor.RED));
                    bounds = SwingUtilities.convertRectangle(this.myInitialComponent, bounds, glassPane2);
                    this.myHighlightComponent.setBounds(bounds);
                    glassPane2.add(this.myHighlightComponent);
                    glassPane2.revalidate();
                    glassPane2.repaint();
                }
            }
        }

        @Nullable
        private static JComponent getGlassPane(@NotNull Component component) {
            JRootPane rootPane;
            if (component == null) {
                InspectorWindow.$$$reportNull$$$0(2);
            }
            return (rootPane = SwingUtilities.getRootPane(component)) == null ? null : (JComponent)rootPane.getGlassPane();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clickInfo";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorWindow";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "switchInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getGlassPane";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UiInspectorNotification
    extends Notification {
        private UiInspectorNotification() {
            super("System Messages", "UI Inspector", "Control-Alt-Click to view component info!", NotificationType.INFORMATION);
        }
    }
}

