/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.ApplicationStatisticsPersistenceComponent;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.persistence.ApplicationStatisticsPersistence;
import com.intellij.internal.statistic.persistence.CollectedUsages;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ObjectIntHashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractProjectsUsagesCollector
extends UsagesCollector {
    private static final Logger LOG = Logger.getInstance(AbstractProjectsUsagesCollector.class);

    @NotNull
    public abstract Set<UsageDescriptor> getProjectUsages(@NotNull Project var1) throws CollectUsagesException;

    void persistProjectUsages(@NotNull Project project2) {
        if (project2 == null) {
            AbstractProjectsUsagesCollector.$$$reportNull$$$0(0);
        }
        try {
            this.persistProjectUsages(project2, new CollectedUsages(this.getProjectUsages(project2), System.currentTimeMillis()));
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    private void persistProjectUsages(@NotNull Project project2, @NotNull CollectedUsages usages) {
        if (project2 == null) {
            AbstractProjectsUsagesCollector.$$$reportNull$$$0(1);
        }
        if (usages == null) {
            AbstractProjectsUsagesCollector.$$$reportNull$$$0(2);
        }
        this.persistProjectUsages(project2, usages, ApplicationStatisticsPersistenceComponent.getInstance());
    }

    private void persistProjectUsages(@NotNull Project project2, @NotNull CollectedUsages usages, @NotNull ApplicationStatisticsPersistence persistence) {
        if (project2 == null) {
            AbstractProjectsUsagesCollector.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            AbstractProjectsUsagesCollector.$$$reportNull$$$0(4);
        }
        if (persistence == null) {
            AbstractProjectsUsagesCollector.$$$reportNull$$$0(5);
        }
        persistence.persistUsages(this.getGroupId(), project2, usages);
    }

    @NotNull
    private Set<UsageDescriptor> getApplicationUsages() {
        Set<UsageDescriptor> set2 = this.mergeUsagesPostProcess(this.getApplicationUsages(ApplicationStatisticsPersistenceComponent.getInstance()));
        if (set2 == null) {
            AbstractProjectsUsagesCollector.$$$reportNull$$$0(6);
        }
        return set2;
    }

    @Deprecated
    @NotNull
    protected Set<UsageDescriptor> mergeUsagesPostProcess(@NotNull Set<UsageDescriptor> usagesFromAllProjects) {
        if (usagesFromAllProjects == null) {
            AbstractProjectsUsagesCollector.$$$reportNull$$$0(7);
        }
        Set<UsageDescriptor> set2 = usagesFromAllProjects;
        if (set2 == null) {
            AbstractProjectsUsagesCollector.$$$reportNull$$$0(8);
        }
        return set2;
    }

    @NotNull
    private Set<UsageDescriptor> getApplicationUsages(@NotNull ApplicationStatisticsPersistence persistence) {
        if (persistence == null) {
            AbstractProjectsUsagesCollector.$$$reportNull$$$0(9);
        }
        ObjectIntHashMap result2 = new ObjectIntHashMap();
        long lastTimeSent = UsageStatisticsPersistenceComponent.getInstance().getLastTimeSent();
        for (CollectedUsages usageDescriptors : persistence.getApplicationData(this.getGroupId()).values()) {
            if (usageDescriptors.usages.isEmpty() || usageDescriptors.collectionTime <= lastTimeSent) continue;
            result2.ensureCapacity(usageDescriptors.usages.size());
            for (UsageDescriptor usageDescriptor : usageDescriptors.usages) {
                String key2 = usageDescriptor.getKey();
                result2.put((Object)key2, result2.get((Object)key2, 0) + usageDescriptor.getValue());
            }
        }
        Set<UsageDescriptor> set2 = StatisticsUtilKt.toUsageDescriptors((ObjectIntHashMap<String>)result2);
        if (set2 == null) {
            AbstractProjectsUsagesCollector.$$$reportNull$$$0(10);
        }
        return set2;
    }

    @Override
    @NotNull
    public final Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        Set<UsageDescriptor> set2 = this.getApplicationUsages();
        if (set2 == null) {
            AbstractProjectsUsagesCollector.$$$reportNull$$$0(11);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistence";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/AbstractProjectsUsagesCollector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesFromAllProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/AbstractProjectsUsagesCollector";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationUsages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeUsagesPostProcess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "persistProjectUsages";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeUsagesPostProcess";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

